/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings.recoverablekeystore;

import android.app.PendingIntent;
import android.content.Context;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.os.UserHandle;
import android.security.KeyStore;
import android.security.keystore.recovery.KeyChainProtectionParams;
import android.security.keystore.recovery.KeyChainSnapshot;
import android.security.keystore.recovery.WrappedApplicationKey;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.HexDump;
import com.android.server.locksettings.recoverablekeystore.InsecureUserException;
import com.android.server.locksettings.recoverablekeystore.KeySyncTask;
import com.android.server.locksettings.recoverablekeystore.KeySyncUtils;
import com.android.server.locksettings.recoverablekeystore.PlatformEncryptionKey;
import com.android.server.locksettings.recoverablekeystore.PlatformKeyManager;
import com.android.server.locksettings.recoverablekeystore.RecoverableKeyGenerator;
import com.android.server.locksettings.recoverablekeystore.RecoverableKeyStorageException;
import com.android.server.locksettings.recoverablekeystore.RecoverySnapshotListenersStorage;
import com.android.server.locksettings.recoverablekeystore.SecureBox;
import com.android.server.locksettings.recoverablekeystore.storage.ApplicationKeyStorage;
import com.android.server.locksettings.recoverablekeystore.storage.RecoverableKeyStoreDb;
import com.android.server.locksettings.recoverablekeystore.storage.RecoverySessionStorage;
import com.android.server.locksettings.recoverablekeystore.storage.RecoverySnapshotStorage;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.AEADBadTagException;

public class RecoverableKeyStoreManager {
    private static final String TAG = "RecoverableKeyStoreMgr";
    private static RecoverableKeyStoreManager mInstance;
    private final Context mContext;
    private final RecoverableKeyStoreDb mDatabase;
    private final RecoverySessionStorage mRecoverySessionStorage;
    private final ExecutorService mExecutorService;
    private final RecoverySnapshotListenersStorage mListenersStorage;
    private final RecoverableKeyGenerator mRecoverableKeyGenerator;
    private final RecoverySnapshotStorage mSnapshotStorage;
    private final PlatformKeyManager mPlatformKeyManager;
    private final KeyStore mKeyStore;
    private final ApplicationKeyStorage mApplicationKeyStorage;

    public static synchronized RecoverableKeyStoreManager getInstance(Context context, KeyStore keystore) {
        if (mInstance == null) {
            ApplicationKeyStorage applicationKeyStorage;
            PlatformKeyManager platformKeyManager;
            RecoverableKeyStoreDb db = RecoverableKeyStoreDb.newInstance(context);
            try {
                platformKeyManager = PlatformKeyManager.getInstance(context, db);
                applicationKeyStorage = ApplicationKeyStorage.getInstance(keystore);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (KeyStoreException e) {
                throw new ServiceSpecificException(22, e.getMessage());
            }
            mInstance = new RecoverableKeyStoreManager(context.getApplicationContext(), keystore, db, new RecoverySessionStorage(), Executors.newSingleThreadExecutor(), new RecoverySnapshotStorage(), new RecoverySnapshotListenersStorage(), platformKeyManager, applicationKeyStorage);
        }
        return mInstance;
    }

    @VisibleForTesting
    RecoverableKeyStoreManager(Context context, KeyStore keystore, RecoverableKeyStoreDb recoverableKeyStoreDb, RecoverySessionStorage recoverySessionStorage, ExecutorService executorService, RecoverySnapshotStorage snapshotStorage, RecoverySnapshotListenersStorage listenersStorage, PlatformKeyManager platformKeyManager, ApplicationKeyStorage applicationKeyStorage) {
        this.mContext = context;
        this.mKeyStore = keystore;
        this.mDatabase = recoverableKeyStoreDb;
        this.mRecoverySessionStorage = recoverySessionStorage;
        this.mExecutorService = executorService;
        this.mListenersStorage = listenersStorage;
        this.mSnapshotStorage = snapshotStorage;
        this.mPlatformKeyManager = platformKeyManager;
        this.mApplicationKeyStorage = applicationKeyStorage;
        try {
            this.mRecoverableKeyGenerator = RecoverableKeyGenerator.newInstance(this.mDatabase);
        }
        catch (NoSuchAlgorithmException e) {
            Log.wtf(TAG, "AES keygen algorithm not available. AOSP must support this.", e);
            throw new ServiceSpecificException(22, e.getMessage());
        }
    }

    public void initRecoveryService(String rootCertificateAlias, byte[] signedPublicKeyList) throws RemoteException {
        PublicKey publicKey;
        this.checkRecoverKeyStorePermission();
        int userId = UserHandle.getCallingUserId();
        int uid = Binder.getCallingUid();
        try {
            KeyFactory kf = KeyFactory.getInstance("EC");
            X509EncodedKeySpec pkSpec = new X509EncodedKeySpec(signedPublicKeyList);
            publicKey = kf.generatePublic(pkSpec);
        }
        catch (NoSuchAlgorithmException e) {
            Log.wtf(TAG, "EC algorithm not available. AOSP must support this.", e);
            throw new ServiceSpecificException(22, e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            throw new ServiceSpecificException(25, "Not a valid X509 certificate.");
        }
        long updatedRows = this.mDatabase.setRecoveryServicePublicKey(userId, uid, publicKey);
        if (updatedRows > 0L) {
            this.mDatabase.setShouldCreateSnapshot(userId, uid, true);
        }
    }

    public KeyChainSnapshot getKeyChainSnapshot() throws RemoteException {
        this.checkRecoverKeyStorePermission();
        int uid = Binder.getCallingUid();
        KeyChainSnapshot snapshot = this.mSnapshotStorage.get(uid);
        if (snapshot == null) {
            throw new ServiceSpecificException(21);
        }
        return snapshot;
    }

    public void setSnapshotCreatedPendingIntent(PendingIntent intent) throws RemoteException {
        this.checkRecoverKeyStorePermission();
        int uid = Binder.getCallingUid();
        this.mListenersStorage.setSnapshotListener(uid, intent);
    }

    public Map<byte[], Integer> getRecoverySnapshotVersions() throws RemoteException {
        this.checkRecoverKeyStorePermission();
        throw new UnsupportedOperationException();
    }

    public void setServerParams(byte[] serverParams) throws RemoteException {
        this.checkRecoverKeyStorePermission();
        int userId = UserHandle.getCallingUserId();
        int uid = Binder.getCallingUid();
        long updatedRows = this.mDatabase.setServerParams(userId, uid, serverParams);
        if (updatedRows > 0L) {
            this.mDatabase.setShouldCreateSnapshot(userId, uid, true);
        }
    }

    public void setRecoveryStatus(String packageName, String[] aliases, int status) throws RemoteException {
        this.checkRecoverKeyStorePermission();
        int uid = Binder.getCallingUid();
        if (packageName != null) {
            // empty if block
        }
        if (aliases == null) {
            Map<String, Integer> allKeys = this.mDatabase.getStatusForAllKeys(uid);
            aliases = new String[allKeys.size()];
            allKeys.keySet().toArray(aliases);
        }
        for (String alias : aliases) {
            this.mDatabase.setRecoveryStatus(uid, alias, status);
        }
    }

    public Map<String, Integer> getRecoveryStatus(String packageName) throws RemoteException {
        return this.mDatabase.getStatusForAllKeys(Binder.getCallingUid());
    }

    public void setRecoverySecretTypes(int[] secretTypes) throws RemoteException {
        this.checkRecoverKeyStorePermission();
        int userId = UserHandle.getCallingUserId();
        int uid = Binder.getCallingUid();
        long updatedRows = this.mDatabase.setRecoverySecretTypes(userId, uid, secretTypes);
        if (updatedRows > 0L) {
            this.mDatabase.setShouldCreateSnapshot(userId, uid, true);
        }
    }

    public int[] getRecoverySecretTypes() throws RemoteException {
        this.checkRecoverKeyStorePermission();
        return this.mDatabase.getRecoverySecretTypes(UserHandle.getCallingUserId(), Binder.getCallingUid());
    }

    public int[] getPendingRecoverySecretTypes() throws RemoteException {
        this.checkRecoverKeyStorePermission();
        throw new UnsupportedOperationException();
    }

    public void recoverySecretAvailable(KeyChainProtectionParams recoverySecret) throws RemoteException {
        int uid = Binder.getCallingUid();
        if (recoverySecret.getLockScreenUiFormat() == 100) {
            throw new SecurityException("Caller " + uid + " is not allowed to set lock screen secret");
        }
        this.checkRecoverKeyStorePermission();
        throw new UnsupportedOperationException();
    }

    public byte[] startRecoverySession(String sessionId, byte[] verifierPublicKey, byte[] vaultParams, byte[] vaultChallenge, List<KeyChainProtectionParams> secrets) throws RemoteException {
        PublicKey publicKey;
        this.checkRecoverKeyStorePermission();
        int uid = Binder.getCallingUid();
        if (secrets.size() != 1) {
            throw new UnsupportedOperationException("Only a single KeyChainProtectionParams is supported");
        }
        try {
            publicKey = KeySyncUtils.deserializePublicKey(verifierPublicKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new ServiceSpecificException(25, "Not a valid X509 key");
        }
        if (!this.publicKeysMatch(publicKey, vaultParams)) {
            throw new ServiceSpecificException(25, "The public keys given in verifierPublicKey and vaultParams do not match.");
        }
        byte[] keyClaimant = KeySyncUtils.generateKeyClaimant();
        byte[] kfHash = secrets.get(0).getSecret();
        this.mRecoverySessionStorage.add(uid, new RecoverySessionStorage.Entry(sessionId, kfHash, keyClaimant, vaultParams));
        try {
            byte[] thmKfHash = KeySyncUtils.calculateThmKfHash(kfHash);
            return KeySyncUtils.encryptRecoveryClaim(publicKey, vaultParams, vaultChallenge, thmKfHash, keyClaimant);
        }
        catch (NoSuchAlgorithmException e) {
            Log.wtf(TAG, "SecureBox algorithm missing. AOSP must support this.", e);
            throw new ServiceSpecificException(22, e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new ServiceSpecificException(25, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, byte[]> recoverKeys(String sessionId, byte[] encryptedRecoveryKey, List<WrappedApplicationKey> applicationKeys) throws RemoteException {
        this.checkRecoverKeyStorePermission();
        int uid = Binder.getCallingUid();
        RecoverySessionStorage.Entry sessionEntry = this.mRecoverySessionStorage.get(uid, sessionId);
        if (sessionEntry == null) {
            throw new ServiceSpecificException(24, String.format(Locale.US, "Application uid=%d does not have pending session '%s'", uid, sessionId));
        }
        try {
            byte[] recoveryKey = this.decryptRecoveryKey(sessionEntry, encryptedRecoveryKey);
            Map<String, byte[]> map = this.recoverApplicationKeys(recoveryKey, applicationKeys);
            return map;
        }
        finally {
            sessionEntry.destroy();
            this.mRecoverySessionStorage.remove(uid);
        }
    }

    public byte[] generateAndStoreKey(String alias) throws RemoteException {
        PlatformEncryptionKey encryptionKey;
        int uid = Binder.getCallingUid();
        int userId = UserHandle.getCallingUserId();
        try {
            encryptionKey = this.mPlatformKeyManager.getEncryptKey(userId);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException | UnrecoverableKeyException e) {
            throw new ServiceSpecificException(22, e.getMessage());
        }
        catch (InsecureUserException e) {
            throw new ServiceSpecificException(23, e.getMessage());
        }
        try {
            return this.mRecoverableKeyGenerator.generateAndStoreKey(encryptionKey, userId, uid, alias);
        }
        catch (RecoverableKeyStorageException | InvalidKeyException | KeyStoreException e) {
            throw new ServiceSpecificException(22, e.getMessage());
        }
    }

    public void closeSession(String sessionId) throws RemoteException {
        this.mRecoverySessionStorage.remove(Binder.getCallingUid(), sessionId);
    }

    public void removeKey(String alias) throws RemoteException {
        int uid = Binder.getCallingUid();
        int userId = UserHandle.getCallingUserId();
        boolean wasRemoved = this.mDatabase.removeKey(uid, alias);
        if (wasRemoved) {
            this.mDatabase.setShouldCreateSnapshot(userId, uid, true);
            this.mApplicationKeyStorage.deleteEntry(userId, uid, alias);
        }
    }

    public String generateKey(String alias, byte[] account) throws RemoteException {
        PlatformEncryptionKey encryptionKey;
        int uid = Binder.getCallingUid();
        int userId = UserHandle.getCallingUserId();
        try {
            encryptionKey = this.mPlatformKeyManager.getEncryptKey(userId);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException | UnrecoverableKeyException e) {
            throw new ServiceSpecificException(22, e.getMessage());
        }
        catch (InsecureUserException e) {
            throw new ServiceSpecificException(23, e.getMessage());
        }
        try {
            byte[] secretKey = this.mRecoverableKeyGenerator.generateAndStoreKey(encryptionKey, userId, uid, alias);
            this.mApplicationKeyStorage.setSymmetricKeyEntry(userId, uid, alias, secretKey);
            String grantAlias = this.mApplicationKeyStorage.getGrantAlias(userId, uid, alias);
            return grantAlias;
        }
        catch (RecoverableKeyStorageException | InvalidKeyException | KeyStoreException e) {
            throw new ServiceSpecificException(22, e.getMessage());
        }
    }

    public String getKey(String alias) throws RemoteException {
        int uid = Binder.getCallingUid();
        int userId = UserHandle.getCallingUserId();
        String grantAlias = this.mApplicationKeyStorage.getGrantAlias(userId, uid, alias);
        return grantAlias;
    }

    private byte[] decryptRecoveryKey(RecoverySessionStorage.Entry sessionEntry, byte[] encryptedClaimResponse) throws RemoteException, ServiceSpecificException {
        byte[] locallyEncryptedKey;
        try {
            Log.d(TAG, this.constructLoggingMessage("sessionEntry.getKeyClaimant()", sessionEntry.getKeyClaimant()));
            Log.d(TAG, this.constructLoggingMessage("sessionEntry.getVaultParams()", sessionEntry.getVaultParams()));
            Log.d(TAG, this.constructLoggingMessage("encryptedClaimResponse", encryptedClaimResponse));
            locallyEncryptedKey = KeySyncUtils.decryptRecoveryClaimResponse(sessionEntry.getKeyClaimant(), sessionEntry.getVaultParams(), encryptedClaimResponse);
        }
        catch (InvalidKeyException e) {
            Log.e(TAG, "Got InvalidKeyException during decrypting recovery claim response", e);
            throw new ServiceSpecificException(26, "Failed to decrypt recovery key " + e.getMessage());
        }
        catch (AEADBadTagException e) {
            Log.e(TAG, "Got AEADBadTagException during decrypting recovery claim response", e);
            throw new ServiceSpecificException(26, "Failed to decrypt recovery key " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceSpecificException(22, e.getMessage());
        }
        try {
            Log.d(TAG, this.constructLoggingMessage("sessionEntry.getLskfHash()", sessionEntry.getLskfHash()));
            Log.d(TAG, this.constructLoggingMessage("locallyEncryptedKey", locallyEncryptedKey));
            return KeySyncUtils.decryptRecoveryKey(sessionEntry.getLskfHash(), locallyEncryptedKey);
        }
        catch (InvalidKeyException e) {
            Log.e(TAG, "Got InvalidKeyException during decrypting recovery key", e);
            throw new ServiceSpecificException(26, "Failed to decrypt recovery key " + e.getMessage());
        }
        catch (AEADBadTagException e) {
            Log.e(TAG, "Got AEADBadTagException during decrypting recovery key", e);
            throw new ServiceSpecificException(26, "Failed to decrypt recovery key " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceSpecificException(22, e.getMessage());
        }
    }

    private String constructLoggingMessage(String key, byte[] value) {
        if (value == null) {
            return key + " is null";
        }
        return key + ": " + HexDump.toHexString(value);
    }

    private Map<String, byte[]> recoverApplicationKeys(byte[] recoveryKey, List<WrappedApplicationKey> applicationKeys) throws RemoteException {
        HashMap<String, byte[]> keyMaterialByAlias = new HashMap<String, byte[]>();
        for (WrappedApplicationKey applicationKey : applicationKeys) {
            String alias = applicationKey.getAlias();
            byte[] encryptedKeyMaterial = applicationKey.getEncryptedKeyMaterial();
            try {
                Log.d(TAG, this.constructLoggingMessage("recoveryKey", recoveryKey));
                Log.d(TAG, this.constructLoggingMessage("encryptedKeyMaterial", encryptedKeyMaterial));
                byte[] keyMaterial = KeySyncUtils.decryptApplicationKey(recoveryKey, encryptedKeyMaterial);
                keyMaterialByAlias.put(alias, keyMaterial);
            }
            catch (NoSuchAlgorithmException e) {
                Log.wtf(TAG, "Missing SecureBox algorithm. AOSP required to support this.", e);
                throw new ServiceSpecificException(22, e.getMessage());
            }
            catch (InvalidKeyException e) {
                Log.e(TAG, "Got InvalidKeyException during decrypting application key with alias: " + alias, e);
                throw new ServiceSpecificException(26, "Failed to recover key with alias '" + alias + "': " + e.getMessage());
            }
            catch (AEADBadTagException e) {
                Log.e(TAG, "Got AEADBadTagException during decrypting application key with alias: " + alias, e);
            }
        }
        if (keyMaterialByAlias.isEmpty()) {
            Log.e(TAG, "Failed to recover any of the application keys.");
            throw new ServiceSpecificException(26, "Failed to recover any of the application keys.");
        }
        return keyMaterialByAlias;
    }

    public void lockScreenSecretAvailable(int storedHashType, String credential, int userId) {
        try {
            this.mExecutorService.execute(KeySyncTask.newInstance(this.mContext, this.mDatabase, this.mSnapshotStorage, this.mListenersStorage, userId, storedHashType, credential, false));
        }
        catch (NoSuchAlgorithmException e) {
            Log.wtf(TAG, "Should never happen - algorithm unavailable for KeySync", e);
        }
        catch (KeyStoreException e) {
            Log.e(TAG, "Key store error encountered during recoverable key sync", e);
        }
        catch (InsecureUserException e) {
            Log.wtf(TAG, "Impossible - insecure user, but user just entered lock screen", e);
        }
    }

    public void lockScreenSecretChanged(int storedHashType, String credential, int userId) {
        try {
            this.mExecutorService.execute(KeySyncTask.newInstance(this.mContext, this.mDatabase, this.mSnapshotStorage, this.mListenersStorage, userId, storedHashType, credential, true));
        }
        catch (NoSuchAlgorithmException e) {
            Log.wtf(TAG, "Should never happen - algorithm unavailable for KeySync", e);
        }
        catch (KeyStoreException e) {
            Log.e(TAG, "Key store error encountered during recoverable key sync", e);
        }
        catch (InsecureUserException e) {
            Log.e(TAG, "InsecureUserException during lock screen secret update", e);
        }
    }

    private void checkRecoverKeyStorePermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.RECOVER_KEYSTORE", "Caller " + Binder.getCallingUid() + " doesn't have RecoverKeyStore permission.");
    }

    private boolean publicKeysMatch(PublicKey publicKey, byte[] vaultParams) {
        byte[] encodedPublicKey = SecureBox.encodePublicKey(publicKey);
        return Arrays.equals(encodedPublicKey, Arrays.copyOf(vaultParams, encodedPublicKey.length));
    }
}

