/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings.recoverablekeystore;

import android.app.PendingIntent;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;

public class RecoverySnapshotListenersStorage {
    private static final String TAG = "RecoverySnapshotLstnrs";
    @GuardedBy(value="this")
    private SparseArray<PendingIntent> mAgentIntents = new SparseArray();

    public synchronized void setSnapshotListener(int recoveryAgentUid, PendingIntent intent) {
        Log.i(TAG, "Registered listener for agent with uid " + recoveryAgentUid);
        this.mAgentIntents.put(recoveryAgentUid, intent);
    }

    public synchronized boolean hasListener(int recoveryAgentUid) {
        return this.mAgentIntents.get(recoveryAgentUid) != null;
    }

    public synchronized void recoverySnapshotAvailable(int recoveryAgentUid) {
        PendingIntent intent = this.mAgentIntents.get(recoveryAgentUid);
        if (intent != null) {
            try {
                intent.send();
            }
            catch (PendingIntent.CanceledException e) {
                Log.e(TAG, "Failed to trigger PendingIntent for " + recoveryAgentUid, e);
            }
        }
    }
}

