/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings.recoverablekeystore.storage;

import android.security.keystore.recovery.KeyChainProtectionParams;
import android.security.keystore.recovery.KeyChainSnapshot;
import android.security.keystore.recovery.KeyDerivationParams;
import android.security.keystore.recovery.WrappedApplicationKey;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PersistentKeyChainSnapshot {
    private static final int VERSION = 1;
    private static final int NULL_LIST_LENGTH = -1;
    private DataInputStream mInput;
    private DataOutputStream mOut;
    private ByteArrayOutputStream mOutStream;

    @VisibleForTesting
    PersistentKeyChainSnapshot() {
    }

    @VisibleForTesting
    void initReader(byte[] input) {
        this.mInput = new DataInputStream(new ByteArrayInputStream(input));
    }

    @VisibleForTesting
    void initWriter() {
        this.mOutStream = new ByteArrayOutputStream();
        this.mOut = new DataOutputStream(this.mOutStream);
    }

    @VisibleForTesting
    byte[] getOutput() {
        return this.mOutStream.toByteArray();
    }

    public static byte[] serialize(KeyChainSnapshot snapshot) throws IOException {
        PersistentKeyChainSnapshot writer = new PersistentKeyChainSnapshot();
        writer.initWriter();
        writer.writeInt(1);
        writer.writeKeyChainSnapshot(snapshot);
        return writer.getOutput();
    }

    public static KeyChainSnapshot deserialize(byte[] input) throws IOException {
        PersistentKeyChainSnapshot reader = new PersistentKeyChainSnapshot();
        reader.initReader(input);
        try {
            int version = reader.readInt();
            if (version != 1) {
                throw new IOException("Unsupported version " + version);
            }
            return reader.readKeyChainSnapshot();
        }
        catch (IOException e) {
            throw new IOException("Malformed KeyChainSnapshot", e);
        }
    }

    @VisibleForTesting
    void writeKeyChainSnapshot(KeyChainSnapshot snapshot) throws IOException {
        this.writeInt(snapshot.getSnapshotVersion());
        this.writeProtectionParamsList(snapshot.getKeyChainProtectionParams());
        this.writeBytes(snapshot.getEncryptedRecoveryKeyBlob());
        this.writeKeysList(snapshot.getWrappedApplicationKeys());
        this.writeInt(snapshot.getMaxAttempts());
        this.writeLong(snapshot.getCounterId());
        this.writeBytes(snapshot.getServerParams());
        this.writeBytes(snapshot.getTrustedHardwarePublicKey());
    }

    @VisibleForTesting
    KeyChainSnapshot readKeyChainSnapshot() throws IOException {
        int snapshotVersion = this.readInt();
        List<KeyChainProtectionParams> protectionParams = this.readProtectionParamsList();
        byte[] encryptedRecoveryKey = this.readBytes();
        List<WrappedApplicationKey> keysList = this.readKeysList();
        int maxAttempts = this.readInt();
        long conterId = this.readLong();
        byte[] serverParams = this.readBytes();
        byte[] trustedHardwarePublicKey = this.readBytes();
        return new KeyChainSnapshot.Builder().setSnapshotVersion(snapshotVersion).setKeyChainProtectionParams(protectionParams).setEncryptedRecoveryKeyBlob(encryptedRecoveryKey).setWrappedApplicationKeys(keysList).setMaxAttempts(maxAttempts).setCounterId(conterId).setServerParams(serverParams).setTrustedHardwarePublicKey(trustedHardwarePublicKey).build();
    }

    @VisibleForTesting
    void writeProtectionParamsList(List<KeyChainProtectionParams> ProtectionParamsList) throws IOException {
        this.writeInt(ProtectionParamsList.size());
        for (KeyChainProtectionParams protectionParams : ProtectionParamsList) {
            this.writeProtectionParams(protectionParams);
        }
    }

    @VisibleForTesting
    List<KeyChainProtectionParams> readProtectionParamsList() throws IOException {
        int length = this.readInt();
        ArrayList<KeyChainProtectionParams> result = new ArrayList<KeyChainProtectionParams>(length);
        for (int i = 0; i < length; ++i) {
            result.add(this.readProtectionParams());
        }
        return result;
    }

    @VisibleForTesting
    void writeProtectionParams(KeyChainProtectionParams protectionParams) throws IOException {
        if (!ArrayUtils.isEmpty(protectionParams.getSecret())) {
            throw new RuntimeException("User generated secret should not be stored");
        }
        this.writeInt(protectionParams.getUserSecretType());
        this.writeInt(protectionParams.getLockScreenUiFormat());
        this.writeKeyDerivationParams(protectionParams.getKeyDerivationParams());
        this.writeBytes(protectionParams.getSecret());
    }

    @VisibleForTesting
    KeyChainProtectionParams readProtectionParams() throws IOException {
        int userSecretType = this.readInt();
        int lockScreenUiFormat = this.readInt();
        KeyDerivationParams derivationParams = this.readKeyDerivationParams();
        byte[] secret = this.readBytes();
        return new KeyChainProtectionParams.Builder().setUserSecretType(userSecretType).setLockScreenUiFormat(lockScreenUiFormat).setKeyDerivationParams(derivationParams).setSecret(secret).build();
    }

    @VisibleForTesting
    void writeKeyDerivationParams(KeyDerivationParams Params) throws IOException {
        this.writeInt(Params.getAlgorithm());
        this.writeBytes(Params.getSalt());
    }

    @VisibleForTesting
    KeyDerivationParams readKeyDerivationParams() throws IOException {
        int algorithm = this.readInt();
        byte[] salt = this.readBytes();
        return KeyDerivationParams.createSha256Params(salt);
    }

    @VisibleForTesting
    void writeKeysList(List<WrappedApplicationKey> applicationKeys) throws IOException {
        this.writeInt(applicationKeys.size());
        for (WrappedApplicationKey keyEntry : applicationKeys) {
            this.writeKeyEntry(keyEntry);
        }
    }

    @VisibleForTesting
    List<WrappedApplicationKey> readKeysList() throws IOException {
        int length = this.readInt();
        ArrayList<WrappedApplicationKey> result = new ArrayList<WrappedApplicationKey>(length);
        for (int i = 0; i < length; ++i) {
            result.add(this.readKeyEntry());
        }
        return result;
    }

    @VisibleForTesting
    void writeKeyEntry(WrappedApplicationKey keyEntry) throws IOException {
        this.mOut.writeUTF(keyEntry.getAlias());
        this.writeBytes(keyEntry.getEncryptedKeyMaterial());
        this.writeBytes(keyEntry.getAccount());
    }

    @VisibleForTesting
    WrappedApplicationKey readKeyEntry() throws IOException {
        String alias = this.mInput.readUTF();
        byte[] keyMaterial = this.readBytes();
        byte[] account = this.readBytes();
        return new WrappedApplicationKey.Builder().setAlias(alias).setEncryptedKeyMaterial(keyMaterial).setAccount(account).build();
    }

    @VisibleForTesting
    void writeInt(int value) throws IOException {
        this.mOut.writeInt(value);
    }

    @VisibleForTesting
    int readInt() throws IOException {
        return this.mInput.readInt();
    }

    @VisibleForTesting
    void writeLong(long value) throws IOException {
        this.mOut.writeLong(value);
    }

    @VisibleForTesting
    long readLong() throws IOException {
        return this.mInput.readLong();
    }

    @VisibleForTesting
    void writeBytes(byte[] value) throws IOException {
        if (value == null) {
            this.writeInt(-1);
            return;
        }
        this.writeInt(value.length);
        this.mOut.write(value, 0, value.length);
    }

    @VisibleForTesting
    byte[] readBytes() throws IOException {
        int length = this.readInt();
        if (length == -1) {
            return new byte[0];
        }
        byte[] result = new byte[length];
        this.mInput.read(result, 0, result.length);
        return result;
    }
}

