/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings.recoverablekeystore.storage;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.Log;
import com.android.server.locksettings.recoverablekeystore.WrappedKey;
import com.android.server.locksettings.recoverablekeystore.storage.RecoverableKeyStoreDbHelper;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;

public class RecoverableKeyStoreDb {
    private static final String TAG = "RecoverableKeyStoreDb";
    private static final int IDLE_TIMEOUT_SECONDS = 30;
    private static final int LAST_SYNCED_AT_UNSYNCED = -1;
    private final RecoverableKeyStoreDbHelper mKeyStoreDbHelper;

    public static RecoverableKeyStoreDb newInstance(Context context) {
        RecoverableKeyStoreDbHelper helper = new RecoverableKeyStoreDbHelper(context);
        helper.setWriteAheadLoggingEnabled(true);
        helper.setIdleConnectionTimeout(30L);
        return new RecoverableKeyStoreDb(helper);
    }

    private RecoverableKeyStoreDb(RecoverableKeyStoreDbHelper keyStoreDbHelper) {
        this.mKeyStoreDbHelper = keyStoreDbHelper;
    }

    public long insertKey(int userId, int uid, String alias, WrappedKey wrappedKey) {
        SQLiteDatabase db = this.mKeyStoreDbHelper.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("user_id", userId);
        values.put("uid", uid);
        values.put("alias", alias);
        values.put("nonce", wrappedKey.getNonce());
        values.put("wrapped_key", wrappedKey.getKeyMaterial());
        values.put("last_synced_at", -1);
        values.put("platform_key_generation_id", wrappedKey.getPlatformKeyGenerationId());
        values.put("recovery_status", wrappedKey.getRecoveryStatus());
        return db.replace("keys", null, values);
    }

    public WrappedKey getKey(int uid, String alias) {
        SQLiteDatabase db = this.mKeyStoreDbHelper.getReadableDatabase();
        String[] projection = new String[]{"_id", "nonce", "wrapped_key", "platform_key_generation_id", "recovery_status"};
        String selection = "uid = ? AND alias = ?";
        String[] selectionArguments = new String[]{Integer.toString(uid), alias};
        try (Cursor cursor = db.query("keys", projection, selection, selectionArguments, null, null, null);){
            int count = cursor.getCount();
            if (count == 0) {
                WrappedKey wrappedKey = null;
                return wrappedKey;
            }
            if (count > 1) {
                Log.wtf(TAG, String.format(Locale.US, "%d WrappedKey entries found for uid=%d alias='%s'. Should only ever be 0 or 1.", count, uid, alias));
                WrappedKey wrappedKey = null;
                return wrappedKey;
            }
            cursor.moveToFirst();
            byte[] nonce = cursor.getBlob(cursor.getColumnIndexOrThrow("nonce"));
            byte[] keyMaterial = cursor.getBlob(cursor.getColumnIndexOrThrow("wrapped_key"));
            int generationId = cursor.getInt(cursor.getColumnIndexOrThrow("platform_key_generation_id"));
            int recoveryStatus = cursor.getInt(cursor.getColumnIndexOrThrow("recovery_status"));
            WrappedKey wrappedKey = new WrappedKey(nonce, keyMaterial, generationId, recoveryStatus);
            return wrappedKey;
        }
    }

    public boolean removeKey(int uid, String alias) {
        SQLiteDatabase db = this.mKeyStoreDbHelper.getWritableDatabase();
        String selection = "uid = ? AND alias = ?";
        String[] selectionArgs = new String[]{Integer.toString(uid), alias};
        return db.delete("keys", selection, selectionArgs) > 0;
    }

    public Map<String, Integer> getStatusForAllKeys(int uid) {
        SQLiteDatabase db = this.mKeyStoreDbHelper.getReadableDatabase();
        String[] projection = new String[]{"_id", "alias", "recovery_status"};
        String selection = "uid = ?";
        String[] selectionArguments = new String[]{Integer.toString(uid)};
        try (Cursor cursor = db.query("keys", projection, selection, selectionArguments, null, null, null);){
            HashMap<String, Integer> statuses = new HashMap<String, Integer>();
            while (cursor.moveToNext()) {
                String alias = cursor.getString(cursor.getColumnIndexOrThrow("alias"));
                int recoveryStatus = cursor.getInt(cursor.getColumnIndexOrThrow("recovery_status"));
                statuses.put(alias, recoveryStatus);
            }
            HashMap<String, Integer> hashMap = statuses;
            return hashMap;
        }
    }

    public int setRecoveryStatus(int uid, String alias, int status) {
        SQLiteDatabase db = this.mKeyStoreDbHelper.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("recovery_status", status);
        String selection = "uid = ? AND alias = ?";
        return db.update("keys", values, selection, new String[]{String.valueOf(uid), alias});
    }

    public Map<String, WrappedKey> getAllKeys(int userId, int recoveryAgentUid, int platformKeyGenerationId) {
        SQLiteDatabase db = this.mKeyStoreDbHelper.getReadableDatabase();
        String[] projection = new String[]{"_id", "nonce", "wrapped_key", "alias", "recovery_status"};
        String selection = "user_id = ? AND uid = ? AND platform_key_generation_id = ?";
        String[] selectionArguments = new String[]{Integer.toString(userId), Integer.toString(recoveryAgentUid), Integer.toString(platformKeyGenerationId)};
        try (Cursor cursor = db.query("keys", projection, selection, selectionArguments, null, null, null);){
            HashMap<String, WrappedKey> keys = new HashMap<String, WrappedKey>();
            while (cursor.moveToNext()) {
                byte[] nonce = cursor.getBlob(cursor.getColumnIndexOrThrow("nonce"));
                byte[] keyMaterial = cursor.getBlob(cursor.getColumnIndexOrThrow("wrapped_key"));
                String alias = cursor.getString(cursor.getColumnIndexOrThrow("alias"));
                int recoveryStatus = cursor.getInt(cursor.getColumnIndexOrThrow("recovery_status"));
                keys.put(alias, new WrappedKey(nonce, keyMaterial, platformKeyGenerationId, recoveryStatus));
            }
            HashMap<String, WrappedKey> hashMap = keys;
            return hashMap;
        }
    }

    public long setPlatformKeyGenerationId(int userId, int generationId) {
        SQLiteDatabase db = this.mKeyStoreDbHelper.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("user_id", userId);
        values.put("platform_key_generation_id", generationId);
        long result = db.replace("user_metadata", null, values);
        if (result != -1L) {
            this.invalidateKeysWithOldGenerationId(userId, generationId);
        }
        return result;
    }

    public void invalidateKeysWithOldGenerationId(int userId, int newGenerationId) {
        SQLiteDatabase db = this.mKeyStoreDbHelper.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("recovery_status", 3);
        String selection = "user_id = ? AND platform_key_generation_id < ?";
        db.update("keys", values, selection, new String[]{String.valueOf(userId), String.valueOf(newGenerationId)});
    }

    public int getPlatformKeyGenerationId(int userId) {
        SQLiteDatabase db = this.mKeyStoreDbHelper.getReadableDatabase();
        String[] projection = new String[]{"platform_key_generation_id"};
        String selection = "user_id = ?";
        String[] selectionArguments = new String[]{Integer.toString(userId)};
        try (Cursor cursor = db.query("user_metadata", projection, selection, selectionArguments, null, null, null);){
            if (cursor.getCount() == 0) {
                int n = -1;
                return n;
            }
            cursor.moveToFirst();
            int n = cursor.getInt(cursor.getColumnIndexOrThrow("platform_key_generation_id"));
            return n;
        }
    }

    public long setRecoveryServicePublicKey(int userId, int uid, PublicKey publicKey) {
        return this.setBytes(userId, uid, "public_key", publicKey.getEncoded());
    }

    public List<Integer> getRecoveryAgents(int userId) {
        SQLiteDatabase db = this.mKeyStoreDbHelper.getReadableDatabase();
        String[] projection = new String[]{"uid"};
        String selection = "user_id = ?";
        String[] selectionArguments = new String[]{Integer.toString(userId)};
        try (Cursor cursor = db.query("recovery_service_metadata", projection, selection, selectionArguments, null, null, null);){
            int count = cursor.getCount();
            ArrayList<Integer> result = new ArrayList<Integer>(count);
            while (cursor.moveToNext()) {
                int uid = cursor.getInt(cursor.getColumnIndexOrThrow("uid"));
                result.add(uid);
            }
            ArrayList<Integer> arrayList = result;
            return arrayList;
        }
    }

    public PublicKey getRecoveryServicePublicKey(int userId, int uid) {
        byte[] keyBytes = this.getBytes(userId, uid, "public_key");
        if (keyBytes == null) {
            return null;
        }
        try {
            return RecoverableKeyStoreDb.decodeX509Key(keyBytes);
        }
        catch (InvalidKeySpecException e) {
            Log.wtf(TAG, String.format(Locale.US, "Recovery service public key entry cannot be decoded for userId=%d uid=%d.", userId, uid));
            return null;
        }
    }

    public long setRecoverySecretTypes(int userId, int uid, int[] secretTypes) {
        SQLiteDatabase db = this.mKeyStoreDbHelper.getWritableDatabase();
        ContentValues values = new ContentValues();
        StringJoiner joiner = new StringJoiner(",");
        Arrays.stream(secretTypes).forEach(i -> joiner.add(Integer.toString(i)));
        String typesAsCsv = joiner.toString();
        values.put("secret_types", typesAsCsv);
        String selection = "user_id = ? AND uid = ?";
        this.ensureRecoveryServiceMetadataEntryExists(userId, uid);
        return db.update("recovery_service_metadata", values, selection, new String[]{String.valueOf(userId), String.valueOf(uid)});
    }

    public int[] getRecoverySecretTypes(int userId, int uid) {
        SQLiteDatabase db = this.mKeyStoreDbHelper.getReadableDatabase();
        String[] projection = new String[]{"_id", "user_id", "uid", "secret_types"};
        String selection = "user_id = ? AND uid = ?";
        String[] selectionArguments = new String[]{Integer.toString(userId), Integer.toString(uid)};
        try (Cursor cursor = db.query("recovery_service_metadata", projection, selection, selectionArguments, null, null, null);){
            int count = cursor.getCount();
            if (count == 0) {
                int[] nArray = new int[]{};
                return nArray;
            }
            if (count > 1) {
                Log.wtf(TAG, String.format(Locale.US, "%d deviceId entries found for userId=%d uid=%d. Should only ever be 0 or 1.", count, userId, uid));
                int[] nArray = new int[]{};
                return nArray;
            }
            cursor.moveToFirst();
            int idx = cursor.getColumnIndexOrThrow("secret_types");
            if (cursor.isNull(idx)) {
                int[] nArray = new int[]{};
                return nArray;
            }
            String csv = cursor.getString(idx);
            if (TextUtils.isEmpty(csv)) {
                int[] nArray = new int[]{};
                return nArray;
            }
            String[] types = csv.split(",");
            int[] result = new int[types.length];
            for (int i = 0; i < types.length; ++i) {
                try {
                    result[i] = Integer.parseInt(types[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    Log.wtf(TAG, "String format error " + e);
                }
            }
            int[] nArray = result;
            return nArray;
        }
    }

    public PublicKey getRecoveryServicePublicKey(int userId) {
        SQLiteDatabase db = this.mKeyStoreDbHelper.getReadableDatabase();
        String[] projection = new String[]{"public_key"};
        String selection = "user_id = ?";
        String[] selectionArguments = new String[]{Integer.toString(userId)};
        Throwable throwable = null;
        try (Cursor cursor = db.query("recovery_service_metadata", projection, selection, selectionArguments, null, null, null);){
            if (cursor.getCount() < 1) {
                PublicKey publicKey = null;
                return publicKey;
            }
            cursor.moveToFirst();
            byte[] keyBytes = cursor.getBlob(cursor.getColumnIndexOrThrow("public_key"));
            try {
                PublicKey publicKey = RecoverableKeyStoreDb.decodeX509Key(keyBytes);
                return publicKey;
            }
            catch (InvalidKeySpecException e) {
                PublicKey publicKey;
                block11: {
                    try {
                        Log.wtf(TAG, "Could not decode public key for " + userId);
                        publicKey = null;
                        if (cursor == null) break block11;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                    RecoverableKeyStoreDb.$closeResource(throwable, cursor);
                }
                return publicKey;
            }
        }
    }

    public long setCounterId(int userId, int uid, long counterId) {
        return this.setLong(userId, uid, "counter_id", counterId);
    }

    public Long getCounterId(int userId, int uid) {
        return this.getLong(userId, uid, "counter_id");
    }

    public long setServerParams(int userId, int uid, byte[] serverParams) {
        return this.setBytes(userId, uid, "server_params", serverParams);
    }

    public byte[] getServerParams(int userId, int uid) {
        return this.getBytes(userId, uid, "server_params");
    }

    public long setSnapshotVersion(int userId, int uid, long snapshotVersion) {
        return this.setLong(userId, uid, "snapshot_version", snapshotVersion);
    }

    public Long getSnapshotVersion(int userId, int uid) {
        return this.getLong(userId, uid, "snapshot_version");
    }

    public long setShouldCreateSnapshot(int userId, int uid, boolean pending) {
        return this.setLong(userId, uid, "should_create_snapshot", pending ? 1L : 0L);
    }

    public boolean getShouldCreateSnapshot(int userId, int uid) {
        Long res = this.getLong(userId, uid, "should_create_snapshot");
        return res != null && res != 0L;
    }

    private Long getLong(int userId, int uid, String key) {
        SQLiteDatabase db = this.mKeyStoreDbHelper.getReadableDatabase();
        String[] projection = new String[]{"_id", "user_id", "uid", key};
        String selection = "user_id = ? AND uid = ?";
        String[] selectionArguments = new String[]{Integer.toString(userId), Integer.toString(uid)};
        try (Cursor cursor = db.query("recovery_service_metadata", projection, selection, selectionArguments, null, null, null);){
            int count = cursor.getCount();
            if (count == 0) {
                Long l = null;
                return l;
            }
            if (count > 1) {
                Log.wtf(TAG, String.format(Locale.US, "%d entries found for userId=%d uid=%d. Should only ever be 0 or 1.", count, userId, uid));
                Long l = null;
                return l;
            }
            cursor.moveToFirst();
            int idx = cursor.getColumnIndexOrThrow(key);
            if (cursor.isNull(idx)) {
                Long l = null;
                return l;
            }
            Long l = cursor.getLong(idx);
            return l;
        }
    }

    private long setLong(int userId, int uid, String key, long value) {
        SQLiteDatabase db = this.mKeyStoreDbHelper.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put(key, value);
        String selection = "user_id = ? AND uid = ?";
        String[] selectionArguments = new String[]{Integer.toString(userId), Integer.toString(uid)};
        this.ensureRecoveryServiceMetadataEntryExists(userId, uid);
        return db.update("recovery_service_metadata", values, selection, selectionArguments);
    }

    private byte[] getBytes(int userId, int uid, String key) {
        SQLiteDatabase db = this.mKeyStoreDbHelper.getReadableDatabase();
        String[] projection = new String[]{"_id", "user_id", "uid", key};
        String selection = "user_id = ? AND uid = ?";
        String[] selectionArguments = new String[]{Integer.toString(userId), Integer.toString(uid)};
        try (Cursor cursor = db.query("recovery_service_metadata", projection, selection, selectionArguments, null, null, null);){
            int count = cursor.getCount();
            if (count == 0) {
                byte[] byArray = null;
                return byArray;
            }
            if (count > 1) {
                Log.wtf(TAG, String.format(Locale.US, "%d entries found for userId=%d uid=%d. Should only ever be 0 or 1.", count, userId, uid));
                byte[] byArray = null;
                return byArray;
            }
            cursor.moveToFirst();
            int idx = cursor.getColumnIndexOrThrow(key);
            if (cursor.isNull(idx)) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = cursor.getBlob(idx);
            return byArray;
        }
    }

    private long setBytes(int userId, int uid, String key, byte[] value) {
        SQLiteDatabase db = this.mKeyStoreDbHelper.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put(key, value);
        String selection = "user_id = ? AND uid = ?";
        String[] selectionArguments = new String[]{Integer.toString(userId), Integer.toString(uid)};
        this.ensureRecoveryServiceMetadataEntryExists(userId, uid);
        return db.update("recovery_service_metadata", values, selection, selectionArguments);
    }

    private void ensureRecoveryServiceMetadataEntryExists(int userId, int uid) {
        SQLiteDatabase db = this.mKeyStoreDbHelper.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("user_id", userId);
        values.put("uid", uid);
        db.insertWithOnConflict("recovery_service_metadata", null, values, 4);
    }

    public void close() {
        this.mKeyStoreDbHelper.close();
    }

    private static PublicKey decodeX509Key(byte[] keyBytes) throws InvalidKeySpecException {
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(keyBytes);
        try {
            return KeyFactory.getInstance("EC").generatePublic(publicKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

