/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.media;

import android.content.Context;
import android.media.AudioPlaybackConfiguration;
import android.media.IAudioService;
import android.media.IPlaybackConfigDispatcher;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.IntArray;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.server.media.MediaSessionService;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AudioPlayerStateMonitor
extends IPlaybackConfigDispatcher.Stub {
    private static boolean DEBUG = MediaSessionService.DEBUG;
    private static String TAG = "AudioPlayerStateMonitor";
    private static AudioPlayerStateMonitor sInstance = new AudioPlayerStateMonitor();
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private final Map<OnAudioPlayerActiveStateChangedListener, MessageHandler> mListenerMap = new ArrayMap<OnAudioPlayerActiveStateChangedListener, MessageHandler>();
    @GuardedBy(value="mLock")
    private final Set<Integer> mActiveAudioUids = new ArraySet<Integer>();
    @GuardedBy(value="mLock")
    private ArrayMap<Integer, AudioPlaybackConfiguration> mPrevActiveAudioPlaybackConfigs = new ArrayMap();
    @GuardedBy(value="mLock")
    private final IntArray mSortedAudioPlaybackClientUids = new IntArray();
    @GuardedBy(value="mLock")
    private boolean mRegisteredToAudioService;

    static AudioPlayerStateMonitor getInstance() {
        return sInstance;
    }

    private AudioPlayerStateMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchPlaybackConfigChange(List<AudioPlaybackConfiguration> configs, boolean flush) {
        if (flush) {
            Binder.flushPendingCommands();
        }
        long token = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.mActiveAudioUids.clear();
                ArrayMap<Integer, AudioPlaybackConfiguration> activeAudioPlaybackConfigs = new ArrayMap<Integer, AudioPlaybackConfiguration>();
                for (AudioPlaybackConfiguration config : configs) {
                    if (!config.isActive()) continue;
                    this.mActiveAudioUids.add(config.getClientUid());
                    activeAudioPlaybackConfigs.put(config.getPlayerInterfaceId(), config);
                }
                for (int i = 0; i < activeAudioPlaybackConfigs.size(); ++i) {
                    int index;
                    AudioPlaybackConfiguration config;
                    config = (AudioPlaybackConfiguration)activeAudioPlaybackConfigs.valueAt(i);
                    int uid = config.getClientUid();
                    if (this.mPrevActiveAudioPlaybackConfigs.containsKey(config.getPlayerInterfaceId())) continue;
                    if (DEBUG) {
                        Log.d(TAG, "Found a new active media playback. " + AudioPlaybackConfiguration.toLogFriendlyString(config));
                    }
                    if ((index = this.mSortedAudioPlaybackClientUids.indexOf(uid)) == 0) continue;
                    if (index > 0) {
                        this.mSortedAudioPlaybackClientUids.remove(index);
                    }
                    this.mSortedAudioPlaybackClientUids.add(0, uid);
                }
                for (AudioPlaybackConfiguration config : configs) {
                    int pii = config.getPlayerInterfaceId();
                    boolean wasActive = this.mPrevActiveAudioPlaybackConfigs.remove(pii) != null;
                    if (wasActive == config.isActive()) continue;
                    this.sendAudioPlayerActiveStateChangedMessageLocked(config, false);
                }
                for (AudioPlaybackConfiguration config : this.mPrevActiveAudioPlaybackConfigs.values()) {
                    this.sendAudioPlayerActiveStateChangedMessageLocked(config, true);
                }
                this.mPrevActiveAudioPlaybackConfigs = activeAudioPlaybackConfigs;
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(OnAudioPlayerActiveStateChangedListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListenerMap.put(listener, new MessageHandler(handler == null ? Looper.myLooper() : handler.getLooper(), listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(OnAudioPlayerActiveStateChangedListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListenerMap.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntArray getSortedAudioPlaybackClientUids() {
        IntArray sortedAudioPlaybackClientUids = new IntArray();
        Object object = this.mLock;
        synchronized (object) {
            sortedAudioPlaybackClientUids.addAll(this.mSortedAudioPlaybackClientUids);
        }
        return sortedAudioPlaybackClientUids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlaybackActive(int uid) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mActiveAudioUids.contains(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpAudioPlaybackUids(int mediaButtonSessionUid) {
        Object object = this.mLock;
        synchronized (object) {
            int userId = UserHandle.getUserId(mediaButtonSessionUid);
            for (int i = this.mSortedAudioPlaybackClientUids.size() - 1; i >= 0 && this.mSortedAudioPlaybackClientUids.get(i) != mediaButtonSessionUid; --i) {
                int uid = this.mSortedAudioPlaybackClientUids.get(i);
                if (userId != UserHandle.getUserId(uid) || this.isPlaybackActive(uid)) continue;
                this.mSortedAudioPlaybackClientUids.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(Context context, PrintWriter pw, String prefix) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println(prefix + "Audio playback (lastly played comes first)");
            String indent = prefix + "  ";
            for (int i = 0; i < this.mSortedAudioPlaybackClientUids.size(); ++i) {
                int uid = this.mSortedAudioPlaybackClientUids.get(i);
                pw.print(indent + "uid=" + uid + " packages=");
                String[] packages = context.getPackageManager().getPackagesForUid(uid);
                if (packages != null && packages.length > 0) {
                    for (int j = 0; j < packages.length; ++j) {
                        pw.print(packages[j] + " ");
                    }
                }
                pw.println();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSelfIntoAudioServiceIfNeeded(IAudioService audioService) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (!this.mRegisteredToAudioService) {
                    audioService.registerPlaybackCallback(this);
                    this.mRegisteredToAudioService = true;
                }
            }
            catch (RemoteException e) {
                Log.wtf(TAG, "Failed to register playback callback", e);
                this.mRegisteredToAudioService = false;
            }
        }
    }

    private void sendAudioPlayerActiveStateChangedMessageLocked(AudioPlaybackConfiguration config, boolean isRemoved) {
        for (MessageHandler messageHandler : this.mListenerMap.values()) {
            messageHandler.sendAudioPlayerActiveStateChangedMessage(config, isRemoved);
        }
    }

    private static final class MessageHandler
    extends Handler {
        private static final int MSG_AUDIO_PLAYER_ACTIVE_STATE_CHANGED = 1;
        private final OnAudioPlayerActiveStateChangedListener mListener;

        MessageHandler(Looper looper, OnAudioPlayerActiveStateChangedListener listener) {
            super(looper);
            this.mListener = listener;
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.mListener.onAudioPlayerActiveStateChanged((AudioPlaybackConfiguration)msg.obj, msg.arg1 != 0);
                }
            }
        }

        void sendAudioPlayerActiveStateChangedMessage(AudioPlaybackConfiguration config, boolean isRemoved) {
            this.obtainMessage(1, isRemoved ? 1 : 0, 0, config).sendToTarget();
        }
    }

    static interface OnAudioPlayerActiveStateChangedListener {
        public void onAudioPlayerActiveStateChanged(AudioPlaybackConfiguration var1, boolean var2);
    }
}

