/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.media;

import android.app.ActivityManager;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioPlaybackConfiguration;
import android.media.AudioRoutesInfo;
import android.media.IAudioRoutesObserver;
import android.media.IAudioService;
import android.media.IMediaRouterClient;
import android.media.IMediaRouterService;
import android.media.MediaRouterClientState;
import android.media.RemoteDisplayState;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.IntArray;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import com.android.internal.util.DumpUtils;
import com.android.server.Watchdog;
import com.android.server.media.AudioPlayerStateMonitor;
import com.android.server.media.RemoteDisplayProviderProxy;
import com.android.server.media.RemoteDisplayProviderWatcher;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;

public final class MediaRouterService
extends IMediaRouterService.Stub
implements Watchdog.Monitor {
    private static final String TAG = "MediaRouterService";
    private static final boolean DEBUG = Log.isLoggable("MediaRouterService", 3);
    static final long CONNECTING_TIMEOUT = 5000L;
    static final long CONNECTED_TIMEOUT = 60000L;
    private final Context mContext;
    private final Object mLock = new Object();
    private final SparseArray<UserRecord> mUserRecords = new SparseArray();
    private final ArrayMap<IBinder, ClientRecord> mAllClientRecords = new ArrayMap();
    private int mCurrentUserId = -1;
    private final IAudioService mAudioService;
    private final AudioPlayerStateMonitor mAudioPlayerStateMonitor;
    private final Handler mHandler = new Handler();
    private final IntArray mActivePlayerMinPriorityQueue = new IntArray();
    private final IntArray mActivePlayerUidMinPriorityQueue = new IntArray();
    private final BroadcastReceiver mReceiver = new MediaRouterServiceBroadcastReceiver();
    BluetoothDevice mBluetoothDevice;
    int mAudioRouteMainType = 0;
    boolean mGlobalBluetoothA2dpOn = false;

    public MediaRouterService(Context context) {
        this.mContext = context;
        Watchdog.getInstance().addMonitor(this);
        this.mAudioService = IAudioService.Stub.asInterface(ServiceManager.getService("audio"));
        this.mAudioPlayerStateMonitor = AudioPlayerStateMonitor.getInstance();
        this.mAudioPlayerStateMonitor.registerListener(new AudioPlayerStateMonitor.OnAudioPlayerActiveStateChangedListener(){
            static final long WAIT_MS = 500L;
            final Runnable mRestoreBluetoothA2dpRunnable = new Runnable(){

                @Override
                public void run() {
                    MediaRouterService.this.restoreBluetoothA2dp();
                }
            };

            @Override
            public void onAudioPlayerActiveStateChanged(AudioPlaybackConfiguration config, boolean isRemoved) {
                boolean active = !isRemoved && config.isActive();
                int pii = config.getPlayerInterfaceId();
                int uid = config.getClientUid();
                int idx = MediaRouterService.this.mActivePlayerMinPriorityQueue.indexOf(pii);
                if (idx >= 0) {
                    MediaRouterService.this.mActivePlayerMinPriorityQueue.remove(idx);
                    MediaRouterService.this.mActivePlayerUidMinPriorityQueue.remove(idx);
                }
                int restoreUid = -1;
                if (active) {
                    MediaRouterService.this.mActivePlayerMinPriorityQueue.add(config.getPlayerInterfaceId());
                    MediaRouterService.this.mActivePlayerUidMinPriorityQueue.add(uid);
                    restoreUid = uid;
                } else if (MediaRouterService.this.mActivePlayerUidMinPriorityQueue.size() > 0) {
                    restoreUid = MediaRouterService.this.mActivePlayerUidMinPriorityQueue.get(MediaRouterService.this.mActivePlayerUidMinPriorityQueue.size() - 1);
                }
                MediaRouterService.this.mHandler.removeCallbacks(this.mRestoreBluetoothA2dpRunnable);
                if (restoreUid >= 0) {
                    MediaRouterService.this.restoreRoute(restoreUid);
                    if (DEBUG) {
                        Slog.d(MediaRouterService.TAG, "onAudioPlayerActiveStateChanged: uid=" + uid + ", active=" + active + ", restoreUid=" + restoreUid);
                    }
                } else {
                    MediaRouterService.this.mHandler.postDelayed(this.mRestoreBluetoothA2dpRunnable, 500L);
                    if (DEBUG) {
                        Slog.d(MediaRouterService.TAG, "onAudioPlayerActiveStateChanged: uid=" + uid + ", active=" + active + ", delaying");
                    }
                }
            }
        }, this.mHandler);
        this.mAudioPlayerStateMonitor.registerSelfIntoAudioServiceIfNeeded(this.mAudioService);
        AudioRoutesInfo audioRoutes = null;
        try {
            audioRoutes = this.mAudioService.startWatchingRoutes(new IAudioRoutesObserver.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void dispatchAudioRoutesChanged(AudioRoutesInfo newRoutes) {
                    Object object = MediaRouterService.this.mLock;
                    synchronized (object) {
                        if (newRoutes.mainType != MediaRouterService.this.mAudioRouteMainType) {
                            MediaRouterService.this.mGlobalBluetoothA2dpOn = (newRoutes.mainType & 0x13) == 0 ? MediaRouterService.this.mBluetoothDevice != null : false;
                            MediaRouterService.this.mAudioRouteMainType = newRoutes.mainType;
                        }
                    }
                }
            });
        }
        catch (RemoteException e) {
            Slog.w(TAG, "RemoteException in the audio service.");
        }
        IntentFilter intentFilter = new IntentFilter("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED");
        context.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, intentFilter, null, null);
    }

    public void systemRunning() {
        IntentFilter filter = new IntentFilter("android.intent.action.USER_SWITCHED");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.USER_SWITCHED")) {
                    MediaRouterService.this.switchUser();
                }
            }
        }, filter);
        this.switchUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        Object object = this.mLock;
        synchronized (object) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerClientAsUser(IMediaRouterClient client, String packageName, int userId) {
        if (client == null) {
            throw new IllegalArgumentException("client must not be null");
        }
        int uid = Binder.getCallingUid();
        if (!this.validatePackageName(uid, packageName)) {
            throw new SecurityException("packageName must match the calling uid");
        }
        int pid = Binder.getCallingPid();
        int resolvedUserId = ActivityManager.handleIncomingUser(pid, uid, userId, false, true, "registerClientAsUser", packageName);
        boolean trusted = this.mContext.checkCallingOrSelfPermission("android.permission.CONFIGURE_WIFI_DISPLAY") == 0;
        long token = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.registerClientLocked(client, uid, pid, packageName, resolvedUserId, trusted);
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterClient(IMediaRouterClient client) {
        if (client == null) {
            throw new IllegalArgumentException("client must not be null");
        }
        long token = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.unregisterClientLocked(client, false);
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaRouterClientState getState(IMediaRouterClient client) {
        if (client == null) {
            throw new IllegalArgumentException("client must not be null");
        }
        long token = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                MediaRouterClientState mediaRouterClientState = this.getStateLocked(client);
                return mediaRouterClientState;
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPlaybackActive(IMediaRouterClient client) {
        if (client == null) {
            throw new IllegalArgumentException("client must not be null");
        }
        long token = Binder.clearCallingIdentity();
        try {
            ClientRecord clientRecord;
            Object object = this.mLock;
            synchronized (object) {
                clientRecord = this.mAllClientRecords.get(client.asBinder());
            }
            if (clientRecord != null) {
                boolean bl = this.mAudioPlayerStateMonitor.isPlaybackActive(clientRecord.mUid);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDiscoveryRequest(IMediaRouterClient client, int routeTypes, boolean activeScan) {
        if (client == null) {
            throw new IllegalArgumentException("client must not be null");
        }
        long token = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.setDiscoveryRequestLocked(client, routeTypes, activeScan);
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedRoute(IMediaRouterClient client, String routeId, boolean explicit) {
        if (client == null) {
            throw new IllegalArgumentException("client must not be null");
        }
        long token = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.setSelectedRouteLocked(client, routeId, explicit);
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestSetVolume(IMediaRouterClient client, String routeId, int volume) {
        if (client == null) {
            throw new IllegalArgumentException("client must not be null");
        }
        if (routeId == null) {
            throw new IllegalArgumentException("routeId must not be null");
        }
        long token = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.requestSetVolumeLocked(client, routeId, volume);
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestUpdateVolume(IMediaRouterClient client, String routeId, int direction) {
        if (client == null) {
            throw new IllegalArgumentException("client must not be null");
        }
        if (routeId == null) {
            throw new IllegalArgumentException("routeId must not be null");
        }
        long token = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.requestUpdateVolumeLocked(client, routeId, direction);
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        pw.println("MEDIA ROUTER SERVICE (dumpsys media_router)");
        pw.println();
        pw.println("Global state");
        pw.println("  mCurrentUserId=" + this.mCurrentUserId);
        Object object = this.mLock;
        synchronized (object) {
            int count = this.mUserRecords.size();
            for (int i = 0; i < count; ++i) {
                UserRecord userRecord = this.mUserRecords.valueAt(i);
                pw.println();
                userRecord.dump(pw, "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreBluetoothA2dp() {
        try {
            boolean a2dpOn = false;
            Object object = this.mLock;
            synchronized (object) {
                a2dpOn = this.mGlobalBluetoothA2dpOn;
            }
            if (this.mBluetoothDevice != null) {
                Slog.v(TAG, "restoreBluetoothA2dp(" + a2dpOn + ")");
                this.mAudioService.setBluetoothA2dpOn(a2dpOn);
            }
        }
        catch (RemoteException e) {
            Slog.w(TAG, "RemoteException while calling setBluetoothA2dpOn.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreRoute(int uid) {
        ClientRecord clientRecord = null;
        Object object = this.mLock;
        synchronized (object) {
            UserRecord userRecord = this.mUserRecords.get(UserHandle.getUserId(uid));
            if (userRecord != null && userRecord.mClientRecords != null) {
                for (ClientRecord cr : userRecord.mClientRecords) {
                    if (!this.validatePackageName(uid, cr.mPackageName)) continue;
                    clientRecord = cr;
                    break;
                }
            }
        }
        if (clientRecord != null) {
            try {
                clientRecord.mClient.onRestoreRoute();
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failed to call onRestoreRoute. Client probably died.");
            }
        } else {
            this.restoreBluetoothA2dp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchUser() {
        Object object = this.mLock;
        synchronized (object) {
            int userId = ActivityManager.getCurrentUser();
            if (this.mCurrentUserId != userId) {
                UserRecord newUser;
                int oldUserId = this.mCurrentUserId;
                this.mCurrentUserId = userId;
                UserRecord oldUser = this.mUserRecords.get(oldUserId);
                if (oldUser != null) {
                    oldUser.mHandler.sendEmptyMessage(2);
                    this.disposeUserIfNeededLocked(oldUser);
                }
                if ((newUser = this.mUserRecords.get(userId)) != null) {
                    newUser.mHandler.sendEmptyMessage(1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clientDied(ClientRecord clientRecord) {
        Object object = this.mLock;
        synchronized (object) {
            this.unregisterClientLocked(clientRecord.mClient, true);
        }
    }

    private void registerClientLocked(IMediaRouterClient client, int uid, int pid, String packageName, int userId, boolean trusted) {
        IBinder binder = client.asBinder();
        ClientRecord clientRecord = this.mAllClientRecords.get(binder);
        if (clientRecord == null) {
            boolean newUser = false;
            UserRecord userRecord = this.mUserRecords.get(userId);
            if (userRecord == null) {
                userRecord = new UserRecord(userId);
                newUser = true;
            }
            clientRecord = new ClientRecord(userRecord, client, uid, pid, packageName, trusted);
            try {
                binder.linkToDeath(clientRecord, 0);
            }
            catch (RemoteException ex) {
                throw new RuntimeException("Media router client died prematurely.", ex);
            }
            if (newUser) {
                this.mUserRecords.put(userId, userRecord);
                this.initializeUserLocked(userRecord);
            }
            userRecord.mClientRecords.add(clientRecord);
            this.mAllClientRecords.put(binder, clientRecord);
            this.initializeClientLocked(clientRecord);
        }
    }

    private void unregisterClientLocked(IMediaRouterClient client, boolean died) {
        ClientRecord clientRecord = this.mAllClientRecords.remove(client.asBinder());
        if (clientRecord != null) {
            UserRecord userRecord = clientRecord.mUserRecord;
            userRecord.mClientRecords.remove(clientRecord);
            this.disposeClientLocked(clientRecord, died);
            this.disposeUserIfNeededLocked(userRecord);
        }
    }

    private MediaRouterClientState getStateLocked(IMediaRouterClient client) {
        ClientRecord clientRecord = this.mAllClientRecords.get(client.asBinder());
        if (clientRecord != null) {
            return clientRecord.getState();
        }
        return null;
    }

    private void setDiscoveryRequestLocked(IMediaRouterClient client, int routeTypes, boolean activeScan) {
        IBinder binder = client.asBinder();
        ClientRecord clientRecord = this.mAllClientRecords.get(binder);
        if (clientRecord != null) {
            if (!clientRecord.mTrusted) {
                routeTypes &= 0xFFFFFFFB;
            }
            if (clientRecord.mRouteTypes != routeTypes || clientRecord.mActiveScan != activeScan) {
                if (DEBUG) {
                    Slog.d(TAG, clientRecord + ": Set discovery request, routeTypes=0x" + Integer.toHexString(routeTypes) + ", activeScan=" + activeScan);
                }
                clientRecord.mRouteTypes = routeTypes;
                clientRecord.mActiveScan = activeScan;
                clientRecord.mUserRecord.mHandler.sendEmptyMessage(3);
            }
        }
    }

    private void setSelectedRouteLocked(IMediaRouterClient client, String routeId, boolean explicit) {
        String oldRouteId;
        ClientRecord clientRecord = this.mAllClientRecords.get(client.asBinder());
        if (clientRecord != null && !Objects.equals(routeId, oldRouteId = clientRecord.mSelectedRouteId)) {
            if (DEBUG) {
                Slog.d(TAG, clientRecord + ": Set selected route, routeId=" + routeId + ", oldRouteId=" + oldRouteId + ", explicit=" + explicit);
            }
            clientRecord.mSelectedRouteId = routeId;
            if (explicit && clientRecord.mTrusted) {
                if (oldRouteId != null) {
                    clientRecord.mUserRecord.mHandler.obtainMessage(5, oldRouteId).sendToTarget();
                }
                if (routeId != null) {
                    clientRecord.mUserRecord.mHandler.obtainMessage(4, routeId).sendToTarget();
                }
            }
        }
    }

    private void requestSetVolumeLocked(IMediaRouterClient client, String routeId, int volume) {
        IBinder binder = client.asBinder();
        ClientRecord clientRecord = this.mAllClientRecords.get(binder);
        if (clientRecord != null) {
            clientRecord.mUserRecord.mHandler.obtainMessage(6, volume, 0, routeId).sendToTarget();
        }
    }

    private void requestUpdateVolumeLocked(IMediaRouterClient client, String routeId, int direction) {
        IBinder binder = client.asBinder();
        ClientRecord clientRecord = this.mAllClientRecords.get(binder);
        if (clientRecord != null) {
            clientRecord.mUserRecord.mHandler.obtainMessage(7, direction, 0, routeId).sendToTarget();
        }
    }

    private void initializeUserLocked(UserRecord userRecord) {
        if (DEBUG) {
            Slog.d(TAG, userRecord + ": Initialized");
        }
        if (userRecord.mUserId == this.mCurrentUserId) {
            userRecord.mHandler.sendEmptyMessage(1);
        }
    }

    private void disposeUserIfNeededLocked(UserRecord userRecord) {
        if (userRecord.mUserId != this.mCurrentUserId && userRecord.mClientRecords.isEmpty()) {
            if (DEBUG) {
                Slog.d(TAG, userRecord + ": Disposed");
            }
            this.mUserRecords.remove(userRecord.mUserId);
        }
    }

    private void initializeClientLocked(ClientRecord clientRecord) {
        if (DEBUG) {
            Slog.d(TAG, clientRecord + ": Registered");
        }
    }

    private void disposeClientLocked(ClientRecord clientRecord, boolean died) {
        if (DEBUG) {
            if (died) {
                Slog.d(TAG, clientRecord + ": Died!");
            } else {
                Slog.d(TAG, clientRecord + ": Unregistered");
            }
        }
        if (clientRecord.mRouteTypes != 0 || clientRecord.mActiveScan) {
            clientRecord.mUserRecord.mHandler.sendEmptyMessage(3);
        }
        clientRecord.dispose();
    }

    private boolean validatePackageName(int uid, String packageName) {
        String[] packageNames;
        if (packageName != null && (packageNames = this.mContext.getPackageManager().getPackagesForUid(uid)) != null) {
            for (String n : packageNames) {
                if (!n.equals(packageName)) continue;
                return true;
            }
        }
        return false;
    }

    static final class UserHandler
    extends Handler
    implements RemoteDisplayProviderWatcher.Callback,
    RemoteDisplayProviderProxy.Callback {
        public static final int MSG_START = 1;
        public static final int MSG_STOP = 2;
        public static final int MSG_UPDATE_DISCOVERY_REQUEST = 3;
        public static final int MSG_SELECT_ROUTE = 4;
        public static final int MSG_UNSELECT_ROUTE = 5;
        public static final int MSG_REQUEST_SET_VOLUME = 6;
        public static final int MSG_REQUEST_UPDATE_VOLUME = 7;
        private static final int MSG_UPDATE_CLIENT_STATE = 8;
        private static final int MSG_CONNECTION_TIMED_OUT = 9;
        private static final int TIMEOUT_REASON_NOT_AVAILABLE = 1;
        private static final int TIMEOUT_REASON_CONNECTION_LOST = 2;
        private static final int TIMEOUT_REASON_WAITING_FOR_CONNECTING = 3;
        private static final int TIMEOUT_REASON_WAITING_FOR_CONNECTED = 4;
        private static final int PHASE_NOT_AVAILABLE = -1;
        private static final int PHASE_NOT_CONNECTED = 0;
        private static final int PHASE_CONNECTING = 1;
        private static final int PHASE_CONNECTED = 2;
        private final MediaRouterService mService;
        private final UserRecord mUserRecord;
        private final RemoteDisplayProviderWatcher mWatcher;
        private final ArrayList<ProviderRecord> mProviderRecords = new ArrayList();
        private final ArrayList<IMediaRouterClient> mTempClients = new ArrayList();
        private boolean mRunning;
        private int mDiscoveryMode = 0;
        private RouteRecord mSelectedRouteRecord;
        private int mConnectionPhase = -1;
        private int mConnectionTimeoutReason;
        private long mConnectionTimeoutStartTime;
        private boolean mClientStateUpdateScheduled;

        public UserHandler(MediaRouterService service, UserRecord userRecord) {
            super(Looper.getMainLooper(), null, true);
            this.mService = service;
            this.mUserRecord = userRecord;
            this.mWatcher = new RemoteDisplayProviderWatcher(service.mContext, this, this, this.mUserRecord.mUserId);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.start();
                    break;
                }
                case 2: {
                    this.stop();
                    break;
                }
                case 3: {
                    this.updateDiscoveryRequest();
                    break;
                }
                case 4: {
                    this.selectRoute((String)msg.obj);
                    break;
                }
                case 5: {
                    this.unselectRoute((String)msg.obj);
                    break;
                }
                case 6: {
                    this.requestSetVolume((String)msg.obj, msg.arg1);
                    break;
                }
                case 7: {
                    this.requestUpdateVolume((String)msg.obj, msg.arg1);
                    break;
                }
                case 8: {
                    this.updateClientState();
                    break;
                }
                case 9: {
                    this.connectionTimedOut();
                }
            }
        }

        public void dump(PrintWriter pw, String prefix) {
            pw.println(prefix + "Handler");
            String indent = prefix + "  ";
            pw.println(indent + "mRunning=" + this.mRunning);
            pw.println(indent + "mDiscoveryMode=" + this.mDiscoveryMode);
            pw.println(indent + "mSelectedRouteRecord=" + this.mSelectedRouteRecord);
            pw.println(indent + "mConnectionPhase=" + this.mConnectionPhase);
            pw.println(indent + "mConnectionTimeoutReason=" + this.mConnectionTimeoutReason);
            pw.println(indent + "mConnectionTimeoutStartTime=" + (this.mConnectionTimeoutReason != 0 ? TimeUtils.formatUptime(this.mConnectionTimeoutStartTime) : "<n/a>"));
            this.mWatcher.dump(pw, prefix);
            int providerCount = this.mProviderRecords.size();
            if (providerCount != 0) {
                for (int i = 0; i < providerCount; ++i) {
                    this.mProviderRecords.get(i).dump(pw, prefix);
                }
            } else {
                pw.println(indent + "<no providers>");
            }
        }

        private void start() {
            if (!this.mRunning) {
                this.mRunning = true;
                this.mWatcher.start();
            }
        }

        private void stop() {
            if (this.mRunning) {
                this.mRunning = false;
                this.unselectSelectedRoute();
                this.mWatcher.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateDiscoveryRequest() {
            int i;
            int count;
            int routeTypes = 0;
            boolean activeScan = false;
            Object object = this.mService.mLock;
            synchronized (object) {
                count = this.mUserRecord.mClientRecords.size();
                for (i = 0; i < count; ++i) {
                    ClientRecord clientRecord = this.mUserRecord.mClientRecords.get(i);
                    routeTypes |= clientRecord.mRouteTypes;
                    activeScan |= clientRecord.mActiveScan;
                }
            }
            int newDiscoveryMode = (routeTypes & 4) != 0 ? (activeScan ? 2 : 1) : 0;
            if (this.mDiscoveryMode != newDiscoveryMode) {
                this.mDiscoveryMode = newDiscoveryMode;
                count = this.mProviderRecords.size();
                for (i = 0; i < count; ++i) {
                    this.mProviderRecords.get(i).getProvider().setDiscoveryMode(this.mDiscoveryMode);
                }
            }
        }

        private void selectRoute(String routeId) {
            RouteRecord routeRecord;
            if (!(routeId == null || this.mSelectedRouteRecord != null && routeId.equals(this.mSelectedRouteRecord.getUniqueId()) || (routeRecord = this.findRouteRecord(routeId)) == null)) {
                this.unselectSelectedRoute();
                Slog.i(MediaRouterService.TAG, "Selected route:" + routeRecord);
                this.mSelectedRouteRecord = routeRecord;
                this.checkSelectedRouteState();
                routeRecord.getProvider().setSelectedDisplay(routeRecord.getDescriptorId());
                this.scheduleUpdateClientState();
            }
        }

        private void unselectRoute(String routeId) {
            if (routeId != null && this.mSelectedRouteRecord != null && routeId.equals(this.mSelectedRouteRecord.getUniqueId())) {
                this.unselectSelectedRoute();
            }
        }

        private void unselectSelectedRoute() {
            if (this.mSelectedRouteRecord != null) {
                Slog.i(MediaRouterService.TAG, "Unselected route:" + this.mSelectedRouteRecord);
                this.mSelectedRouteRecord.getProvider().setSelectedDisplay(null);
                this.mSelectedRouteRecord = null;
                this.checkSelectedRouteState();
                this.scheduleUpdateClientState();
            }
        }

        private void requestSetVolume(String routeId, int volume) {
            if (this.mSelectedRouteRecord != null && routeId.equals(this.mSelectedRouteRecord.getUniqueId())) {
                this.mSelectedRouteRecord.getProvider().setDisplayVolume(volume);
            }
        }

        private void requestUpdateVolume(String routeId, int direction) {
            if (this.mSelectedRouteRecord != null && routeId.equals(this.mSelectedRouteRecord.getUniqueId())) {
                this.mSelectedRouteRecord.getProvider().adjustDisplayVolume(direction);
            }
        }

        @Override
        public void addProvider(RemoteDisplayProviderProxy provider) {
            provider.setCallback(this);
            provider.setDiscoveryMode(this.mDiscoveryMode);
            provider.setSelectedDisplay(null);
            ProviderRecord providerRecord = new ProviderRecord(provider);
            this.mProviderRecords.add(providerRecord);
            providerRecord.updateDescriptor(provider.getDisplayState());
            this.scheduleUpdateClientState();
        }

        @Override
        public void removeProvider(RemoteDisplayProviderProxy provider) {
            int index = this.findProviderRecord(provider);
            if (index >= 0) {
                ProviderRecord providerRecord = this.mProviderRecords.remove(index);
                providerRecord.updateDescriptor(null);
                provider.setCallback(null);
                provider.setDiscoveryMode(0);
                this.checkSelectedRouteState();
                this.scheduleUpdateClientState();
            }
        }

        @Override
        public void onDisplayStateChanged(RemoteDisplayProviderProxy provider, RemoteDisplayState state) {
            this.updateProvider(provider, state);
        }

        private void updateProvider(RemoteDisplayProviderProxy provider, RemoteDisplayState state) {
            ProviderRecord providerRecord;
            int index = this.findProviderRecord(provider);
            if (index >= 0 && (providerRecord = this.mProviderRecords.get(index)).updateDescriptor(state)) {
                this.checkSelectedRouteState();
                this.scheduleUpdateClientState();
            }
        }

        private void checkSelectedRouteState() {
            if (this.mSelectedRouteRecord == null) {
                this.mConnectionPhase = -1;
                this.updateConnectionTimeout(0);
                return;
            }
            if (!this.mSelectedRouteRecord.isValid() || !this.mSelectedRouteRecord.isEnabled()) {
                this.updateConnectionTimeout(1);
                return;
            }
            int oldPhase = this.mConnectionPhase;
            this.mConnectionPhase = UserHandler.getConnectionPhase(this.mSelectedRouteRecord.getStatus());
            if (oldPhase >= 1 && this.mConnectionPhase < 1) {
                this.updateConnectionTimeout(2);
                return;
            }
            switch (this.mConnectionPhase) {
                case 2: {
                    if (oldPhase != 2) {
                        Slog.i(MediaRouterService.TAG, "Connected to route: " + this.mSelectedRouteRecord);
                    }
                    this.updateConnectionTimeout(0);
                    break;
                }
                case 1: {
                    if (oldPhase != 1) {
                        Slog.i(MediaRouterService.TAG, "Connecting to route: " + this.mSelectedRouteRecord);
                    }
                    this.updateConnectionTimeout(4);
                    break;
                }
                case 0: {
                    this.updateConnectionTimeout(3);
                    break;
                }
                default: {
                    this.updateConnectionTimeout(1);
                }
            }
        }

        private void updateConnectionTimeout(int reason) {
            if (reason != this.mConnectionTimeoutReason) {
                if (this.mConnectionTimeoutReason != 0) {
                    this.removeMessages(9);
                }
                this.mConnectionTimeoutReason = reason;
                this.mConnectionTimeoutStartTime = SystemClock.uptimeMillis();
                switch (reason) {
                    case 1: 
                    case 2: {
                        this.sendEmptyMessage(9);
                        break;
                    }
                    case 3: {
                        this.sendEmptyMessageDelayed(9, 5000L);
                        break;
                    }
                    case 4: {
                        this.sendEmptyMessageDelayed(9, 60000L);
                    }
                }
            }
        }

        private void connectionTimedOut() {
            if (this.mConnectionTimeoutReason == 0 || this.mSelectedRouteRecord == null) {
                Log.wtf(MediaRouterService.TAG, "Handled connection timeout for no reason.");
                return;
            }
            switch (this.mConnectionTimeoutReason) {
                case 1: {
                    Slog.i(MediaRouterService.TAG, "Selected route no longer available: " + this.mSelectedRouteRecord);
                    break;
                }
                case 2: {
                    Slog.i(MediaRouterService.TAG, "Selected route connection lost: " + this.mSelectedRouteRecord);
                    break;
                }
                case 3: {
                    Slog.i(MediaRouterService.TAG, "Selected route timed out while waiting for connection attempt to begin after " + (SystemClock.uptimeMillis() - this.mConnectionTimeoutStartTime) + " ms: " + this.mSelectedRouteRecord);
                    break;
                }
                case 4: {
                    Slog.i(MediaRouterService.TAG, "Selected route timed out while connecting after " + (SystemClock.uptimeMillis() - this.mConnectionTimeoutStartTime) + " ms: " + this.mSelectedRouteRecord);
                }
            }
            this.mConnectionTimeoutReason = 0;
            this.unselectSelectedRoute();
        }

        private void scheduleUpdateClientState() {
            if (!this.mClientStateUpdateScheduled) {
                this.mClientStateUpdateScheduled = true;
                this.sendEmptyMessage(8);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateClientState() {
            this.mClientStateUpdateScheduled = false;
            MediaRouterClientState routerState = new MediaRouterClientState();
            int providerCount = this.mProviderRecords.size();
            for (int i = 0; i < providerCount; ++i) {
                this.mProviderRecords.get(i).appendClientState(routerState);
            }
            try {
                Object i = this.mService.mLock;
                synchronized (i) {
                    this.mUserRecord.mRouterState = routerState;
                    int count = this.mUserRecord.mClientRecords.size();
                    for (int i2 = 0; i2 < count; ++i2) {
                        this.mTempClients.add(this.mUserRecord.mClientRecords.get((int)i2).mClient);
                    }
                }
                int count = this.mTempClients.size();
                for (int i3 = 0; i3 < count; ++i3) {
                    try {
                        this.mTempClients.get(i3).onStateChanged();
                        continue;
                    }
                    catch (RemoteException ex) {
                        Slog.w(MediaRouterService.TAG, "Failed to call onStateChanged. Client probably died.");
                    }
                }
            }
            finally {
                this.mTempClients.clear();
            }
        }

        private int findProviderRecord(RemoteDisplayProviderProxy provider) {
            int count = this.mProviderRecords.size();
            for (int i = 0; i < count; ++i) {
                ProviderRecord record = this.mProviderRecords.get(i);
                if (record.getProvider() != provider) continue;
                return i;
            }
            return -1;
        }

        private RouteRecord findRouteRecord(String uniqueId) {
            int count = this.mProviderRecords.size();
            for (int i = 0; i < count; ++i) {
                RouteRecord record = this.mProviderRecords.get(i).findRouteByUniqueId(uniqueId);
                if (record == null) continue;
                return record;
            }
            return null;
        }

        private static int getConnectionPhase(int status) {
            switch (status) {
                case 0: 
                case 6: {
                    return 2;
                }
                case 2: {
                    return 1;
                }
                case 1: 
                case 3: {
                    return 0;
                }
            }
            return -1;
        }

        static final class RouteRecord {
            private final ProviderRecord mProviderRecord;
            private final String mDescriptorId;
            private final MediaRouterClientState.RouteInfo mMutableInfo;
            private MediaRouterClientState.RouteInfo mImmutableInfo;
            private RemoteDisplayState.RemoteDisplayInfo mDescriptor;

            public RouteRecord(ProviderRecord providerRecord, String descriptorId, String uniqueId) {
                this.mProviderRecord = providerRecord;
                this.mDescriptorId = descriptorId;
                this.mMutableInfo = new MediaRouterClientState.RouteInfo(uniqueId);
            }

            public RemoteDisplayProviderProxy getProvider() {
                return this.mProviderRecord.getProvider();
            }

            public ProviderRecord getProviderRecord() {
                return this.mProviderRecord;
            }

            public String getDescriptorId() {
                return this.mDescriptorId;
            }

            public String getUniqueId() {
                return this.mMutableInfo.id;
            }

            public MediaRouterClientState.RouteInfo getInfo() {
                if (this.mImmutableInfo == null) {
                    this.mImmutableInfo = new MediaRouterClientState.RouteInfo(this.mMutableInfo);
                }
                return this.mImmutableInfo;
            }

            public boolean isValid() {
                return this.mDescriptor != null;
            }

            public boolean isEnabled() {
                return this.mMutableInfo.enabled;
            }

            public int getStatus() {
                return this.mMutableInfo.statusCode;
            }

            public boolean updateDescriptor(RemoteDisplayState.RemoteDisplayInfo descriptor) {
                boolean changed = false;
                if (this.mDescriptor != descriptor) {
                    this.mDescriptor = descriptor;
                    if (descriptor != null) {
                        int presentationDisplayId;
                        int volumeHandling;
                        int volumeMax;
                        int volume;
                        int playbackStream;
                        int playbackType;
                        int statusCode;
                        boolean enabled;
                        int supportedTypes;
                        String description;
                        String name = RouteRecord.computeName(descriptor);
                        if (!Objects.equals(this.mMutableInfo.name, name)) {
                            this.mMutableInfo.name = name;
                            changed = true;
                        }
                        if (!Objects.equals(this.mMutableInfo.description, description = RouteRecord.computeDescription(descriptor))) {
                            this.mMutableInfo.description = description;
                            changed = true;
                        }
                        if (this.mMutableInfo.supportedTypes != (supportedTypes = RouteRecord.computeSupportedTypes(descriptor))) {
                            this.mMutableInfo.supportedTypes = supportedTypes;
                            changed = true;
                        }
                        if (this.mMutableInfo.enabled != (enabled = RouteRecord.computeEnabled(descriptor))) {
                            this.mMutableInfo.enabled = enabled;
                            changed = true;
                        }
                        if (this.mMutableInfo.statusCode != (statusCode = RouteRecord.computeStatusCode(descriptor))) {
                            this.mMutableInfo.statusCode = statusCode;
                            changed = true;
                        }
                        if (this.mMutableInfo.playbackType != (playbackType = RouteRecord.computePlaybackType(descriptor))) {
                            this.mMutableInfo.playbackType = playbackType;
                            changed = true;
                        }
                        if (this.mMutableInfo.playbackStream != (playbackStream = RouteRecord.computePlaybackStream(descriptor))) {
                            this.mMutableInfo.playbackStream = playbackStream;
                            changed = true;
                        }
                        if (this.mMutableInfo.volume != (volume = RouteRecord.computeVolume(descriptor))) {
                            this.mMutableInfo.volume = volume;
                            changed = true;
                        }
                        if (this.mMutableInfo.volumeMax != (volumeMax = RouteRecord.computeVolumeMax(descriptor))) {
                            this.mMutableInfo.volumeMax = volumeMax;
                            changed = true;
                        }
                        if (this.mMutableInfo.volumeHandling != (volumeHandling = RouteRecord.computeVolumeHandling(descriptor))) {
                            this.mMutableInfo.volumeHandling = volumeHandling;
                            changed = true;
                        }
                        if (this.mMutableInfo.presentationDisplayId != (presentationDisplayId = RouteRecord.computePresentationDisplayId(descriptor))) {
                            this.mMutableInfo.presentationDisplayId = presentationDisplayId;
                            changed = true;
                        }
                    }
                }
                if (changed) {
                    this.mImmutableInfo = null;
                }
                return changed;
            }

            public void dump(PrintWriter pw, String prefix) {
                pw.println(prefix + this);
                String indent = prefix + "  ";
                pw.println(indent + "mMutableInfo=" + this.mMutableInfo);
                pw.println(indent + "mDescriptorId=" + this.mDescriptorId);
                pw.println(indent + "mDescriptor=" + this.mDescriptor);
            }

            public String toString() {
                return "Route " + this.mMutableInfo.name + " (" + this.mMutableInfo.id + ")";
            }

            private static String computeName(RemoteDisplayState.RemoteDisplayInfo descriptor) {
                return descriptor.name;
            }

            private static String computeDescription(RemoteDisplayState.RemoteDisplayInfo descriptor) {
                String description = descriptor.description;
                return TextUtils.isEmpty(description) ? null : description;
            }

            private static int computeSupportedTypes(RemoteDisplayState.RemoteDisplayInfo descriptor) {
                return 7;
            }

            private static boolean computeEnabled(RemoteDisplayState.RemoteDisplayInfo descriptor) {
                switch (descriptor.status) {
                    case 2: 
                    case 3: 
                    case 4: {
                        return true;
                    }
                }
                return false;
            }

            private static int computeStatusCode(RemoteDisplayState.RemoteDisplayInfo descriptor) {
                switch (descriptor.status) {
                    case 0: {
                        return 4;
                    }
                    case 2: {
                        return 3;
                    }
                    case 1: {
                        return 5;
                    }
                    case 3: {
                        return 2;
                    }
                    case 4: {
                        return 6;
                    }
                }
                return 0;
            }

            private static int computePlaybackType(RemoteDisplayState.RemoteDisplayInfo descriptor) {
                return 1;
            }

            private static int computePlaybackStream(RemoteDisplayState.RemoteDisplayInfo descriptor) {
                return 3;
            }

            private static int computeVolume(RemoteDisplayState.RemoteDisplayInfo descriptor) {
                int volume = descriptor.volume;
                int volumeMax = descriptor.volumeMax;
                if (volume < 0) {
                    return 0;
                }
                if (volume > volumeMax) {
                    return volumeMax;
                }
                return volume;
            }

            private static int computeVolumeMax(RemoteDisplayState.RemoteDisplayInfo descriptor) {
                int volumeMax = descriptor.volumeMax;
                return volumeMax > 0 ? volumeMax : 0;
            }

            private static int computeVolumeHandling(RemoteDisplayState.RemoteDisplayInfo descriptor) {
                int volumeHandling = descriptor.volumeHandling;
                switch (volumeHandling) {
                    case 1: {
                        return 1;
                    }
                }
                return 0;
            }

            private static int computePresentationDisplayId(RemoteDisplayState.RemoteDisplayInfo descriptor) {
                int displayId = descriptor.presentationDisplayId;
                return displayId < 0 ? -1 : displayId;
            }
        }

        static final class ProviderRecord {
            private final RemoteDisplayProviderProxy mProvider;
            private final String mUniquePrefix;
            private final ArrayList<RouteRecord> mRoutes = new ArrayList();
            private RemoteDisplayState mDescriptor;

            public ProviderRecord(RemoteDisplayProviderProxy provider) {
                this.mProvider = provider;
                this.mUniquePrefix = provider.getFlattenedComponentName() + ":";
            }

            public RemoteDisplayProviderProxy getProvider() {
                return this.mProvider;
            }

            public String getUniquePrefix() {
                return this.mUniquePrefix;
            }

            public boolean updateDescriptor(RemoteDisplayState descriptor) {
                boolean changed = false;
                if (this.mDescriptor != descriptor) {
                    this.mDescriptor = descriptor;
                    int targetIndex = 0;
                    if (descriptor != null) {
                        if (descriptor.isValid()) {
                            ArrayList<RemoteDisplayState.RemoteDisplayInfo> routeDescriptors = descriptor.displays;
                            int routeCount = routeDescriptors.size();
                            for (int i = 0; i < routeCount; ++i) {
                                RemoteDisplayState.RemoteDisplayInfo routeDescriptor = (RemoteDisplayState.RemoteDisplayInfo)routeDescriptors.get(i);
                                String descriptorId = routeDescriptor.id;
                                int sourceIndex = this.findRouteByDescriptorId(descriptorId);
                                if (sourceIndex < 0) {
                                    String uniqueId = this.assignRouteUniqueId(descriptorId);
                                    RouteRecord route = new RouteRecord(this, descriptorId, uniqueId);
                                    this.mRoutes.add(targetIndex++, route);
                                    route.updateDescriptor(routeDescriptor);
                                    changed = true;
                                    continue;
                                }
                                if (sourceIndex < targetIndex) {
                                    Slog.w(MediaRouterService.TAG, "Ignoring route descriptor with duplicate id: " + routeDescriptor);
                                    continue;
                                }
                                RouteRecord route = this.mRoutes.get(sourceIndex);
                                Collections.swap(this.mRoutes, sourceIndex, targetIndex++);
                                changed |= route.updateDescriptor(routeDescriptor);
                            }
                        } else {
                            Slog.w(MediaRouterService.TAG, "Ignoring invalid descriptor from media route provider: " + this.mProvider.getFlattenedComponentName());
                        }
                    }
                    for (int i = this.mRoutes.size() - 1; i >= targetIndex; --i) {
                        RouteRecord route = this.mRoutes.remove(i);
                        route.updateDescriptor(null);
                        changed = true;
                    }
                }
                return changed;
            }

            public void appendClientState(MediaRouterClientState state) {
                int routeCount = this.mRoutes.size();
                for (int i = 0; i < routeCount; ++i) {
                    state.routes.add(this.mRoutes.get(i).getInfo());
                }
            }

            public RouteRecord findRouteByUniqueId(String uniqueId) {
                int routeCount = this.mRoutes.size();
                for (int i = 0; i < routeCount; ++i) {
                    RouteRecord route = this.mRoutes.get(i);
                    if (!route.getUniqueId().equals(uniqueId)) continue;
                    return route;
                }
                return null;
            }

            private int findRouteByDescriptorId(String descriptorId) {
                int routeCount = this.mRoutes.size();
                for (int i = 0; i < routeCount; ++i) {
                    RouteRecord route = this.mRoutes.get(i);
                    if (!route.getDescriptorId().equals(descriptorId)) continue;
                    return i;
                }
                return -1;
            }

            public void dump(PrintWriter pw, String prefix) {
                pw.println(prefix + this);
                String indent = prefix + "  ";
                this.mProvider.dump(pw, indent);
                int routeCount = this.mRoutes.size();
                if (routeCount != 0) {
                    for (int i = 0; i < routeCount; ++i) {
                        this.mRoutes.get(i).dump(pw, indent);
                    }
                } else {
                    pw.println(indent + "<no routes>");
                }
            }

            public String toString() {
                return "Provider " + this.mProvider.getFlattenedComponentName();
            }

            private String assignRouteUniqueId(String descriptorId) {
                return this.mUniquePrefix + descriptorId;
            }
        }
    }

    final class UserRecord {
        public final int mUserId;
        public final ArrayList<ClientRecord> mClientRecords = new ArrayList();
        public final UserHandler mHandler;
        public MediaRouterClientState mRouterState;

        public UserRecord(int userId) {
            this.mUserId = userId;
            this.mHandler = new UserHandler(MediaRouterService.this, this);
        }

        public void dump(final PrintWriter pw, String prefix) {
            pw.println(prefix + this);
            final String indent = prefix + "  ";
            int clientCount = this.mClientRecords.size();
            if (clientCount != 0) {
                for (int i = 0; i < clientCount; ++i) {
                    this.mClientRecords.get(i).dump(pw, indent);
                }
            } else {
                pw.println(indent + "<no clients>");
            }
            pw.println(indent + "State");
            pw.println(indent + "mRouterState=" + this.mRouterState);
            if (!this.mHandler.runWithScissors(new Runnable(){

                @Override
                public void run() {
                    UserRecord.this.mHandler.dump(pw, indent);
                }
            }, 1000L)) {
                pw.println(indent + "<could not dump handler state>");
            }
        }

        public String toString() {
            return "User " + this.mUserId;
        }
    }

    final class ClientRecord
    implements IBinder.DeathRecipient {
        public final UserRecord mUserRecord;
        public final IMediaRouterClient mClient;
        public final int mUid;
        public final int mPid;
        public final String mPackageName;
        public final boolean mTrusted;
        public int mRouteTypes;
        public boolean mActiveScan;
        public String mSelectedRouteId;

        public ClientRecord(UserRecord userRecord, IMediaRouterClient client, int uid, int pid, String packageName, boolean trusted) {
            this.mUserRecord = userRecord;
            this.mClient = client;
            this.mUid = uid;
            this.mPid = pid;
            this.mPackageName = packageName;
            this.mTrusted = trusted;
        }

        public void dispose() {
            this.mClient.asBinder().unlinkToDeath(this, 0);
        }

        @Override
        public void binderDied() {
            MediaRouterService.this.clientDied(this);
        }

        MediaRouterClientState getState() {
            return this.mTrusted ? this.mUserRecord.mRouterState : null;
        }

        public void dump(PrintWriter pw, String prefix) {
            pw.println(prefix + this);
            String indent = prefix + "  ";
            pw.println(indent + "mTrusted=" + this.mTrusted);
            pw.println(indent + "mRouteTypes=0x" + Integer.toHexString(this.mRouteTypes));
            pw.println(indent + "mActiveScan=" + this.mActiveScan);
            pw.println(indent + "mSelectedRouteId=" + this.mSelectedRouteId);
        }

        public String toString() {
            return "Client " + this.mPackageName + " (pid " + this.mPid + ")";
        }
    }

    final class MediaRouterServiceBroadcastReceiver
    extends BroadcastReceiver {
        MediaRouterServiceBroadcastReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                if (state == 0) {
                    MediaRouterService.this.mGlobalBluetoothA2dpOn = false;
                    MediaRouterService.this.mBluetoothDevice = null;
                } else if (state == 2) {
                    MediaRouterService.this.mGlobalBluetoothA2dpOn = true;
                    MediaRouterService.this.mBluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    MediaRouterService.this.restoreBluetoothA2dp();
                }
            }
        }
    }
}

