/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.media;

import android.content.Context;
import android.media.MediaController2;
import android.media.SessionToken2;
import android.util.Log;
import java.util.concurrent.Executor;

class MediaSession2Record {
    private static final String TAG = "Session2Record";
    private static final boolean DEBUG = true;
    private final Context mContext;
    private final SessionToken2 mSessionToken;
    private final SessionDestroyedListener mSessionDestroyedListener;
    private final Executor mMainExecutor;
    private MediaController2 mController;

    public MediaSession2Record(Context context, SessionToken2 token, SessionDestroyedListener listener) {
        this.mContext = context;
        this.mSessionToken = token;
        this.mSessionDestroyedListener = listener;
        this.mMainExecutor = runnable -> runnable.run();
    }

    public Context getContext() {
        return this.mContext;
    }

    public void onSessionDestroyed() {
        if (this.mController != null) {
            this.mController.close();
            this.mController = null;
        }
    }

    public boolean onSessionCreated(SessionToken2 token) {
        if (this.mController != null) {
            Log.w(TAG, "Cannot create a new session with the id=" + token.getId() + " in the pkg=" + token.getPackageName() + ". ID should be unique in a package");
            return false;
        }
        this.mController = new MediaController2(this.mContext, token, this.mMainExecutor, new ControllerCallback());
        return true;
    }

    public SessionToken2 getToken() {
        return this.mSessionToken;
    }

    public MediaController2 getController() {
        return this.mController;
    }

    public String toString() {
        return this.getToken() == null ? "Token {null}" : "SessionRecord {" + this.getToken().toString() + "}";
    }

    private class ControllerCallback
    extends MediaController2.ControllerCallback {
        private ControllerCallback() {
        }

        @Override
        public void onDisconnected() {
            Log.d(MediaSession2Record.TAG, "onDisconnected, token=" + MediaSession2Record.this.getToken());
            MediaSession2Record.this.mSessionDestroyedListener.onSessionDestroyed(MediaSession2Record.this);
        }
    }

    static interface SessionDestroyedListener {
        public void onSessionDestroyed(MediaSession2Record var1);
    }
}

