/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.media;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.media.IMediaExtractorUpdateService;
import android.os.Build;
import android.os.IBinder;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.util.Log;
import android.util.Slog;
import com.android.server.SystemService;

public class MediaUpdateService
extends SystemService {
    private static final String TAG = "MediaUpdateService";
    private static final boolean DEBUG = Log.isLoggable("MediaUpdateService", 3);
    private static final String MEDIA_UPDATE_PACKAGE_NAME = "com.android.media.update";
    private static final String EXTRACTOR_UPDATE_SERVICE_NAME = "media.extractor.update";
    private IMediaExtractorUpdateService mMediaExtractorUpdateService;

    public MediaUpdateService(Context context) {
        super(context);
    }

    @Override
    public void onStart() {
        if ("userdebug".equals(Build.TYPE) || "eng".equals(Build.TYPE)) {
            this.connect();
            this.registerBroadcastReceiver();
        }
    }

    private void connect() {
        IBinder binder = ServiceManager.getService(EXTRACTOR_UPDATE_SERVICE_NAME);
        if (binder != null) {
            try {
                binder.linkToDeath(new IBinder.DeathRecipient(){

                    @Override
                    public void binderDied() {
                        Slog.w(MediaUpdateService.TAG, "mediaextractor died; reconnecting");
                        MediaUpdateService.this.mMediaExtractorUpdateService = null;
                        MediaUpdateService.this.connect();
                    }
                }, 0);
            }
            catch (Exception e) {
                binder = null;
            }
        }
        if (binder != null) {
            this.mMediaExtractorUpdateService = IMediaExtractorUpdateService.Stub.asInterface(binder);
            this.packageStateChanged();
        } else {
            Slog.w(TAG, "media.extractor.update not found.");
        }
    }

    private void registerBroadcastReceiver() {
        BroadcastReceiver updateReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent.getIntExtra("android.intent.extra.user_handle", 0) != 0) {
                    return;
                }
                switch (intent.getAction()) {
                    case "android.intent.action.PACKAGE_REMOVED": {
                        if (intent.getExtras().getBoolean("android.intent.extra.REPLACING")) {
                            return;
                        }
                        MediaUpdateService.this.packageStateChanged();
                        break;
                    }
                    case "android.intent.action.PACKAGE_CHANGED": {
                        MediaUpdateService.this.packageStateChanged();
                        break;
                    }
                    case "android.intent.action.PACKAGE_ADDED": {
                        MediaUpdateService.this.packageStateChanged();
                    }
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_ADDED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addAction("android.intent.action.PACKAGE_CHANGED");
        filter.addDataScheme("package");
        filter.addDataSchemeSpecificPart(MEDIA_UPDATE_PACKAGE_NAME, 0);
        this.getContext().registerReceiverAsUser(updateReceiver, UserHandle.ALL, filter, null, null);
    }

    private void packageStateChanged() {
        ApplicationInfo packageInfo = null;
        boolean pluginsAvailable = false;
        try {
            packageInfo = this.getContext().getPackageManager().getApplicationInfo(MEDIA_UPDATE_PACKAGE_NAME, 0x100000);
            pluginsAvailable = packageInfo.enabled;
        }
        catch (Exception e) {
            Slog.v(TAG, "package 'com.android.media.update' not installed");
        }
        this.loadExtractorPlugins(packageInfo != null && pluginsAvailable ? packageInfo.sourceDir : "");
    }

    private void loadExtractorPlugins(String apkPath) {
        try {
            if (this.mMediaExtractorUpdateService != null) {
                this.mMediaExtractorUpdateService.loadPlugins(apkPath);
            }
        }
        catch (Exception e) {
            Slog.w(TAG, "Error in loadPlugins", e);
        }
    }
}

