/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.net.NetworkIdentity;
import android.net.NetworkStats;
import android.net.NetworkStatsHistory;
import android.net.NetworkTemplate;
import android.os.Binder;
import android.telephony.SubscriptionPlan;
import android.util.ArrayMap;
import android.util.AtomicFile;
import android.util.IntArray;
import android.util.Pair;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FileRotator;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.net.NetworkIdentitySet;
import com.android.server.net.NetworkStatsAccess;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.ProtocolException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import libcore.io.IoUtils;

public class NetworkStatsCollection
implements FileRotator.Reader {
    private static final int FILE_MAGIC = 1095648596;
    private static final int VERSION_NETWORK_INIT = 1;
    private static final int VERSION_UID_INIT = 1;
    private static final int VERSION_UID_WITH_IDENT = 2;
    private static final int VERSION_UID_WITH_TAG = 3;
    private static final int VERSION_UID_WITH_SET = 4;
    private static final int VERSION_UNIFIED_INIT = 16;
    private ArrayMap<Key, NetworkStatsHistory> mStats = new ArrayMap();
    private final long mBucketDuration;
    private long mStartMillis;
    private long mEndMillis;
    private long mTotalBytes;
    private boolean mDirty;

    public NetworkStatsCollection(long bucketDuration) {
        this.mBucketDuration = bucketDuration;
        this.reset();
    }

    public void reset() {
        this.mStats.clear();
        this.mStartMillis = Long.MAX_VALUE;
        this.mEndMillis = Long.MIN_VALUE;
        this.mTotalBytes = 0L;
        this.mDirty = false;
    }

    public long getStartMillis() {
        return this.mStartMillis;
    }

    public long getFirstAtomicBucketMillis() {
        if (this.mStartMillis == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.mStartMillis + this.mBucketDuration;
    }

    public long getEndMillis() {
        return this.mEndMillis;
    }

    public long getTotalBytes() {
        return this.mTotalBytes;
    }

    public boolean isDirty() {
        return this.mDirty;
    }

    public void clearDirty() {
        this.mDirty = false;
    }

    public boolean isEmpty() {
        return this.mStartMillis == Long.MAX_VALUE && this.mEndMillis == Long.MIN_VALUE;
    }

    @VisibleForTesting
    public long roundUp(long time) {
        if (time == Long.MIN_VALUE || time == Long.MAX_VALUE || time == -1L) {
            return time;
        }
        long mod = time % this.mBucketDuration;
        if (mod > 0L) {
            time -= mod;
            time += this.mBucketDuration;
        }
        return time;
    }

    @VisibleForTesting
    public long roundDown(long time) {
        if (time == Long.MIN_VALUE || time == Long.MAX_VALUE || time == -1L) {
            return time;
        }
        long mod = time % this.mBucketDuration;
        if (mod > 0L) {
            time -= mod;
        }
        return time;
    }

    @VisibleForTesting
    public static long multiplySafe(long value, long num, long den) {
        long ay;
        if (den == 0L) {
            den = 1L;
        }
        long x = value;
        long y = num;
        long r = x * y;
        long ax = Math.abs(x);
        if ((ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
            return (long)((double)num / (double)den * (double)value);
        }
        return r / den;
    }

    public int[] getRelevantUids(int accessLevel) {
        return this.getRelevantUids(accessLevel, Binder.getCallingUid());
    }

    public int[] getRelevantUids(int accessLevel, int callerUid) {
        IntArray uids = new IntArray();
        for (int i = 0; i < this.mStats.size(); ++i) {
            int j;
            Key key = this.mStats.keyAt(i);
            if (!NetworkStatsAccess.isAccessibleToUser(key.uid, callerUid, accessLevel) || (j = uids.binarySearch(key.uid)) >= 0) continue;
            uids.add(j ^= 0xFFFFFFFF, key.uid);
        }
        return uids.toArray();
    }

    public NetworkStatsHistory getHistory(NetworkTemplate template, SubscriptionPlan augmentPlan, int uid, int set, int tag, int fields, long start, long end, int accessLevel, int callerUid) {
        if (!NetworkStatsAccess.isAccessibleToUser(uid, callerUid, accessLevel)) {
            throw new SecurityException("Network stats history of uid " + uid + " is forbidden for caller " + callerUid);
        }
        int bucketEstimate = (int)((end - start) / this.mBucketDuration);
        NetworkStatsHistory combined = new NetworkStatsHistory(this.mBucketDuration, bucketEstimate, fields);
        if (start == end) {
            return combined;
        }
        long augmentStart = -1L;
        long augmentEnd = augmentPlan != null ? augmentPlan.getDataUsageTime() : -1L;
        long collectStart = start;
        long collectEnd = end;
        if (augmentEnd != -1L) {
            Iterator<Pair<ZonedDateTime, ZonedDateTime>> it = augmentPlan.cycleIterator();
            while (it.hasNext()) {
                Pair<ZonedDateTime, ZonedDateTime> cycle = it.next();
                long cycleStart = ((ZonedDateTime)cycle.first).toInstant().toEpochMilli();
                long cycleEnd = ((ZonedDateTime)cycle.second).toInstant().toEpochMilli();
                if (cycleStart > augmentEnd || augmentEnd >= cycleEnd) continue;
                augmentStart = cycleStart;
                collectStart = Long.min(collectStart, augmentStart);
                collectEnd = Long.max(collectEnd, augmentEnd);
                break;
            }
        }
        if (augmentStart != -1L) {
            augmentStart = this.roundUp(augmentStart);
            augmentEnd = this.roundDown(augmentEnd);
            collectStart = this.roundDown(collectStart);
            collectEnd = this.roundUp(collectEnd);
        }
        for (int i = 0; i < this.mStats.size(); ++i) {
            Key key = this.mStats.keyAt(i);
            if (key.uid != uid || !NetworkStats.setMatches(set, key.set) || key.tag != tag || !NetworkStatsCollection.templateMatches(template, key.ident)) continue;
            NetworkStatsHistory value = this.mStats.valueAt(i);
            combined.recordHistory(value, collectStart, collectEnd);
        }
        if (augmentStart != -1L) {
            NetworkStatsHistory.Entry entry = combined.getValues(augmentStart, augmentEnd, null);
            if (entry.rxBytes == 0L || entry.txBytes == 0L) {
                combined.recordData(augmentStart, augmentEnd, new NetworkStats.Entry(1L, 0L, 1L, 0L, 0L));
                combined.getValues(augmentStart, augmentEnd, entry);
            }
            long rawBytes = entry.rxBytes + entry.txBytes;
            long rawRxBytes = entry.rxBytes;
            long rawTxBytes = entry.txBytes;
            long targetBytes = augmentPlan.getDataUsageBytes();
            long targetRxBytes = NetworkStatsCollection.multiplySafe(targetBytes, rawRxBytes, rawBytes);
            long targetTxBytes = NetworkStatsCollection.multiplySafe(targetBytes, rawTxBytes, rawBytes);
            long beforeTotal = combined.getTotalBytes();
            for (int i = 0; i < combined.size(); ++i) {
                combined.getValues(i, entry);
                if (entry.bucketStart < augmentStart || entry.bucketStart + entry.bucketDuration > augmentEnd) continue;
                entry.rxBytes = NetworkStatsCollection.multiplySafe(targetRxBytes, entry.rxBytes, rawRxBytes);
                entry.txBytes = NetworkStatsCollection.multiplySafe(targetTxBytes, entry.txBytes, rawTxBytes);
                entry.rxPackets = 0L;
                entry.txPackets = 0L;
                combined.setValues(i, entry);
            }
            long deltaTotal = combined.getTotalBytes() - beforeTotal;
            if (deltaTotal != 0L) {
                Slog.d("NetworkStats", "Augmented network usage by " + deltaTotal + " bytes");
            }
            NetworkStatsHistory sliced = new NetworkStatsHistory(this.mBucketDuration, bucketEstimate, fields);
            sliced.recordHistory(combined, start, end);
            return sliced;
        }
        return combined;
    }

    public NetworkStats getSummary(NetworkTemplate template, long start, long end, int accessLevel, int callerUid) {
        long now = System.currentTimeMillis();
        NetworkStats stats = new NetworkStats(end - start, 24);
        if (start == end) {
            return stats;
        }
        NetworkStats.Entry entry = new NetworkStats.Entry();
        NetworkStatsHistory.Entry historyEntry = null;
        for (int i = 0; i < this.mStats.size(); ++i) {
            Key key = this.mStats.keyAt(i);
            if (!NetworkStatsCollection.templateMatches(template, key.ident) || !NetworkStatsAccess.isAccessibleToUser(key.uid, callerUid, accessLevel) || key.set >= 1000) continue;
            NetworkStatsHistory value = this.mStats.valueAt(i);
            historyEntry = value.getValues(start, end, now, historyEntry);
            entry.iface = NetworkStats.IFACE_ALL;
            entry.uid = key.uid;
            entry.set = key.set;
            entry.tag = key.tag;
            entry.defaultNetwork = key.ident.areAllMembersOnDefaultNetwork() ? 1 : 0;
            entry.metered = key.ident.isAnyMemberMetered() ? 1 : 0;
            entry.roaming = key.ident.isAnyMemberRoaming() ? 1 : 0;
            entry.rxBytes = historyEntry.rxBytes;
            entry.rxPackets = historyEntry.rxPackets;
            entry.txBytes = historyEntry.txBytes;
            entry.txPackets = historyEntry.txPackets;
            entry.operations = historyEntry.operations;
            if (entry.isEmpty()) continue;
            stats.combineValues(entry);
        }
        return stats;
    }

    public void recordData(NetworkIdentitySet ident, int uid, int set, int tag, long start, long end, NetworkStats.Entry entry) {
        NetworkStatsHistory history = this.findOrCreateHistory(ident, uid, set, tag);
        history.recordData(start, end, entry);
        this.noteRecordedHistory(history.getStart(), history.getEnd(), entry.rxBytes + entry.txBytes);
    }

    private void recordHistory(Key key, NetworkStatsHistory history) {
        if (history.size() == 0) {
            return;
        }
        this.noteRecordedHistory(history.getStart(), history.getEnd(), history.getTotalBytes());
        NetworkStatsHistory target = this.mStats.get(key);
        if (target == null) {
            target = new NetworkStatsHistory(history.getBucketDuration());
            this.mStats.put(key, target);
        }
        target.recordEntireHistory(history);
    }

    public void recordCollection(NetworkStatsCollection another) {
        for (int i = 0; i < another.mStats.size(); ++i) {
            Key key = another.mStats.keyAt(i);
            NetworkStatsHistory value = another.mStats.valueAt(i);
            this.recordHistory(key, value);
        }
    }

    private NetworkStatsHistory findOrCreateHistory(NetworkIdentitySet ident, int uid, int set, int tag) {
        Key key = new Key(ident, uid, set, tag);
        NetworkStatsHistory existing = this.mStats.get(key);
        NetworkStatsHistory updated = null;
        if (existing == null) {
            updated = new NetworkStatsHistory(this.mBucketDuration, 10);
        } else if (existing.getBucketDuration() != this.mBucketDuration) {
            updated = new NetworkStatsHistory(existing, this.mBucketDuration);
        }
        if (updated != null) {
            this.mStats.put(key, updated);
            return updated;
        }
        return existing;
    }

    @Override
    public void read(InputStream in) throws IOException {
        this.read(new DataInputStream(in));
    }

    public void read(DataInputStream in) throws IOException {
        int magic = in.readInt();
        if (magic != 1095648596) {
            throw new ProtocolException("unexpected magic: " + magic);
        }
        int version = in.readInt();
        switch (version) {
            case 16: {
                int identSize = in.readInt();
                for (int i = 0; i < identSize; ++i) {
                    NetworkIdentitySet ident = new NetworkIdentitySet(in);
                    int size = in.readInt();
                    for (int j = 0; j < size; ++j) {
                        int uid = in.readInt();
                        int set = in.readInt();
                        int tag = in.readInt();
                        Key key = new Key(ident, uid, set, tag);
                        NetworkStatsHistory history = new NetworkStatsHistory(in);
                        this.recordHistory(key, history);
                    }
                }
                break;
            }
            default: {
                throw new ProtocolException("unexpected version: " + version);
            }
        }
    }

    public void write(DataOutputStream out) throws IOException {
        ArrayList keys;
        HashMap<NetworkIdentitySet, ArrayList> keysByIdent = Maps.newHashMap();
        for (Key key : this.mStats.keySet()) {
            keys = (ArrayList)keysByIdent.get(key.ident);
            if (keys == null) {
                keys = Lists.newArrayList();
                keysByIdent.put(key.ident, keys);
            }
            keys.add(key);
        }
        out.writeInt(1095648596);
        out.writeInt(16);
        out.writeInt(keysByIdent.size());
        for (NetworkIdentitySet ident : keysByIdent.keySet()) {
            keys = (ArrayList)keysByIdent.get(ident);
            ident.writeToStream(out);
            out.writeInt(keys.size());
            for (Key key : keys) {
                NetworkStatsHistory history = this.mStats.get(key);
                out.writeInt(key.uid);
                out.writeInt(key.set);
                out.writeInt(key.tag);
                history.writeToStream(out);
            }
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Deprecated
    public void readLegacyNetwork(File file) throws IOException {
        AtomicFile inputFile = new AtomicFile(file);
        DataInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(inputFile.openRead()));
            int magic = in.readInt();
            if (magic != 1095648596) {
                throw new ProtocolException("unexpected magic: " + magic);
            }
            int version = in.readInt();
            switch (version) {
                case 1: {
                    int size = in.readInt();
                    for (int i = 0; i < size; ++i) {
                        NetworkIdentitySet ident = new NetworkIdentitySet(in);
                        NetworkStatsHistory history = new NetworkStatsHistory(in);
                        Key key = new Key(ident, -1, -1, 0);
                        this.recordHistory(key, history);
                    }
                    break;
                }
                default: {
                    throw new ProtocolException("unexpected version: " + version);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            IoUtils.closeQuietly(in);
            catch (Throwable throwable) {
                IoUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public void readLegacyUid(File file, boolean onlyTags) throws IOException {
        AtomicFile inputFile = new AtomicFile(file);
        DataInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(inputFile.openRead()));
            int magic = in.readInt();
            if (magic != 1095648596) {
                throw new ProtocolException("unexpected magic: " + magic);
            }
            int version = in.readInt();
            switch (version) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    int identSize = in.readInt();
                    for (int i = 0; i < identSize; ++i) {
                        NetworkIdentitySet ident = new NetworkIdentitySet(in);
                        int size = in.readInt();
                        for (int j = 0; j < size; ++j) {
                            int uid = in.readInt();
                            int set = version >= 4 ? in.readInt() : 0;
                            int tag = in.readInt();
                            Key key = new Key(ident, uid, set, tag);
                            NetworkStatsHistory history = new NetworkStatsHistory(in);
                            if (tag == 0 == onlyTags) continue;
                            this.recordHistory(key, history);
                        }
                    }
                    break;
                }
                default: {
                    throw new ProtocolException("unexpected version: " + version);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            IoUtils.closeQuietly(in);
            return;
            catch (Throwable throwable) {
                IoUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(in);
    }

    public void removeUids(int[] uids) {
        ArrayList<Key> knownKeys = Lists.newArrayList();
        knownKeys.addAll(this.mStats.keySet());
        for (Key key : knownKeys) {
            if (!ArrayUtils.contains(uids, key.uid)) continue;
            if (key.tag == 0) {
                NetworkStatsHistory uidHistory = this.mStats.get(key);
                NetworkStatsHistory removedHistory = this.findOrCreateHistory(key.ident, -4, 0, 0);
                removedHistory.recordEntireHistory(uidHistory);
            }
            this.mStats.remove(key);
            this.mDirty = true;
        }
    }

    private void noteRecordedHistory(long startMillis, long endMillis, long totalBytes) {
        if (startMillis < this.mStartMillis) {
            this.mStartMillis = startMillis;
        }
        if (endMillis > this.mEndMillis) {
            this.mEndMillis = endMillis;
        }
        this.mTotalBytes += totalBytes;
        this.mDirty = true;
    }

    private int estimateBuckets() {
        return (int)(Math.min(this.mEndMillis - this.mStartMillis, 3024000000L) / this.mBucketDuration);
    }

    private ArrayList<Key> getSortedKeys() {
        ArrayList<Key> keys = Lists.newArrayList();
        keys.addAll(this.mStats.keySet());
        Collections.sort(keys);
        return keys;
    }

    public void dump(IndentingPrintWriter pw) {
        for (Key key : this.getSortedKeys()) {
            pw.print("ident=");
            pw.print(key.ident.toString());
            pw.print(" uid=");
            pw.print(key.uid);
            pw.print(" set=");
            pw.print(NetworkStats.setToString(key.set));
            pw.print(" tag=");
            pw.println(NetworkStats.tagToString(key.tag));
            NetworkStatsHistory history = this.mStats.get(key);
            pw.increaseIndent();
            history.dump(pw, true);
            pw.decreaseIndent();
        }
    }

    public void writeToProto(ProtoOutputStream proto, long tag) {
        long start = proto.start(tag);
        for (Key key : this.getSortedKeys()) {
            long startStats = proto.start(2246267895809L);
            long startKey = proto.start(0x10B00000001L);
            key.ident.writeToProto(proto, 0x10B00000001L);
            proto.write(1120986464258L, key.uid);
            proto.write(1120986464259L, key.set);
            proto.write(1120986464260L, key.tag);
            proto.end(startKey);
            NetworkStatsHistory history = this.mStats.get(key);
            history.writeToProto(proto, 1146756268034L);
            proto.end(startStats);
        }
        proto.end(start);
    }

    public void dumpCheckin(PrintWriter pw, long start, long end) {
        this.dumpCheckin(pw, start, end, NetworkTemplate.buildTemplateMobileWildcard(), "cell");
        this.dumpCheckin(pw, start, end, NetworkTemplate.buildTemplateWifiWildcard(), "wifi");
        this.dumpCheckin(pw, start, end, NetworkTemplate.buildTemplateEthernet(), "eth");
        this.dumpCheckin(pw, start, end, NetworkTemplate.buildTemplateBluetooth(), "bt");
    }

    private void dumpCheckin(PrintWriter pw, long start, long end, NetworkTemplate groupTemplate, String groupPrefix) {
        NetworkStatsHistory value;
        Key key;
        int i;
        ArrayMap<Key, NetworkStatsHistory> grouped = new ArrayMap<Key, NetworkStatsHistory>();
        for (i = 0; i < this.mStats.size(); ++i) {
            key = this.mStats.keyAt(i);
            value = this.mStats.valueAt(i);
            if (!NetworkStatsCollection.templateMatches(groupTemplate, key.ident) || key.set >= 1000) continue;
            Key groupKey = new Key(null, key.uid, key.set, key.tag);
            NetworkStatsHistory groupHistory = (NetworkStatsHistory)grouped.get(groupKey);
            if (groupHistory == null) {
                groupHistory = new NetworkStatsHistory(value.getBucketDuration());
                grouped.put(groupKey, groupHistory);
            }
            groupHistory.recordHistory(value, start, end);
        }
        for (i = 0; i < grouped.size(); ++i) {
            key = (Key)grouped.keyAt(i);
            value = (NetworkStatsHistory)grouped.valueAt(i);
            if (value.size() == 0) continue;
            pw.print("c,");
            pw.print(groupPrefix);
            pw.print(',');
            pw.print(key.uid);
            pw.print(',');
            pw.print(NetworkStats.setToCheckinString(key.set));
            pw.print(',');
            pw.print(key.tag);
            pw.println();
            value.dumpCheckin(pw);
        }
    }

    private static boolean templateMatches(NetworkTemplate template, NetworkIdentitySet identSet) {
        for (NetworkIdentity ident : identSet) {
            if (!template.matches(ident)) continue;
            return true;
        }
        return false;
    }

    private static class Key
    implements Comparable<Key> {
        public final NetworkIdentitySet ident;
        public final int uid;
        public final int set;
        public final int tag;
        private final int hashCode;

        public Key(NetworkIdentitySet ident, int uid, int set, int tag) {
            this.ident = ident;
            this.uid = uid;
            this.set = set;
            this.tag = tag;
            this.hashCode = Objects.hash(ident, uid, set, tag);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key key = (Key)obj;
                return this.uid == key.uid && this.set == key.set && this.tag == key.tag && Objects.equals(this.ident, key.ident);
            }
            return false;
        }

        @Override
        public int compareTo(Key another) {
            int res = 0;
            if (this.ident != null && another.ident != null) {
                res = this.ident.compareTo(another.ident);
            }
            if (res == 0) {
                res = Integer.compare(this.uid, another.uid);
            }
            if (res == 0) {
                res = Integer.compare(this.set, another.set);
            }
            if (res == 0) {
                res = Integer.compare(this.tag, another.tag);
            }
            return res;
        }
    }
}

