/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net.watchlist;

import android.content.Context;
import android.content.Intent;
import android.net.NetworkWatchlistManager;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ShellCommand;
import com.android.server.net.watchlist.WatchlistConfig;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;

class NetworkWatchlistShellCommand
extends ShellCommand {
    final NetworkWatchlistManager mNetworkWatchlistManager;

    NetworkWatchlistShellCommand(Context context) {
        this.mNetworkWatchlistManager = new NetworkWatchlistManager(context);
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        PrintWriter pw = this.getOutPrintWriter();
        try {
            switch (cmd) {
                case "set-test-config": {
                    return this.runSetTestConfig();
                }
            }
            return this.handleDefaultCommands(cmd);
        }
        catch (RemoteException e) {
            pw.println("Remote exception: " + e);
            return -1;
        }
    }

    private int runSetTestConfig() throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        try {
            String configXmlPath = this.getNextArgRequired();
            ParcelFileDescriptor pfd = this.openFileForSystem(configXmlPath, "r");
            if (pfd != null) {
                FileInputStream fileStream = new FileInputStream(pfd.getFileDescriptor());
                WatchlistConfig.getInstance().setTestMode(fileStream);
            }
            pw.println("Success!");
        }
        catch (IOException | RuntimeException ex) {
            pw.println("Error: " + ex.toString());
            return -1;
        }
        return 0;
    }

    @Override
    public void onHelp() {
        PrintWriter pw = this.getOutPrintWriter();
        pw.println("Network watchlist manager commands:");
        pw.println("  help");
        pw.println("    Print this help text.");
        pw.println("");
        pw.println("  set-test-config your_watchlist_config.xml");
        pw.println();
        Intent.printIntentArgsHelp(pw, "");
    }
}

