/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net.watchlist;

import android.os.FileUtils;
import android.util.Log;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.HexDump;
import com.android.internal.util.XmlUtils;
import com.android.server.net.watchlist.DigestUtils;
import com.android.server.net.watchlist.HarmfulDigests;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class WatchlistConfig {
    private static final String TAG = "WatchlistConfig";
    private static final String NETWORK_WATCHLIST_DB_PATH = "/data/misc/network_watchlist/network_watchlist.xml";
    private static final String NETWORK_WATCHLIST_DB_FOR_TEST_PATH = "/data/misc/network_watchlist/network_watchlist_for_test.xml";
    private static final byte[] UNKNOWN_CONFIG_HASH = new byte[32];
    private boolean mIsSecureConfig = true;
    private static final WatchlistConfig sInstance = new WatchlistConfig();
    private File mXmlFile;
    private volatile CrcShaDigests mDomainDigests;
    private volatile CrcShaDigests mIpDigests;

    public static WatchlistConfig getInstance() {
        return sInstance;
    }

    private WatchlistConfig() {
        this(new File(NETWORK_WATCHLIST_DB_PATH));
    }

    @VisibleForTesting
    protected WatchlistConfig(File xmlFile) {
        this.mXmlFile = xmlFile;
        this.reloadConfig();
    }

    public void reloadConfig() {
        try (FileInputStream stream = new FileInputStream(this.mXmlFile);){
            ArrayList<byte[]> crc32DomainList = new ArrayList<byte[]>();
            ArrayList<byte[]> sha256DomainList = new ArrayList<byte[]>();
            ArrayList<byte[]> crc32IpList = new ArrayList<byte[]>();
            ArrayList<byte[]> sha256IpList = new ArrayList<byte[]>();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            parser.nextTag();
            parser.require(2, null, "watchlist-config");
            block23: while (parser.nextTag() == 2) {
                String tagName;
                switch (tagName = parser.getName()) {
                    case "crc32-domain": {
                        this.parseHashes(parser, tagName, crc32DomainList);
                        continue block23;
                    }
                    case "crc32-ip": {
                        this.parseHashes(parser, tagName, crc32IpList);
                        continue block23;
                    }
                    case "sha256-domain": {
                        this.parseHashes(parser, tagName, sha256DomainList);
                        continue block23;
                    }
                    case "sha256-ip": {
                        this.parseHashes(parser, tagName, sha256IpList);
                        continue block23;
                    }
                }
                Log.w(TAG, "Unknown element: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
            parser.require(3, null, "watchlist-config");
            this.mDomainDigests = new CrcShaDigests(new HarmfulDigests(crc32DomainList), new HarmfulDigests(sha256DomainList));
            this.mIpDigests = new CrcShaDigests(new HarmfulDigests(crc32IpList), new HarmfulDigests(sha256IpList));
            Log.i(TAG, "Reload watchlist done");
        }
        catch (IOException | IllegalStateException | IndexOutOfBoundsException | NullPointerException | NumberFormatException | XmlPullParserException e) {
            Slog.e(TAG, "Failed parsing xml", e);
        }
    }

    private void parseHashes(XmlPullParser parser, String tagName, List<byte[]> hashList) throws IOException, XmlPullParserException {
        parser.require(2, null, tagName);
        while (parser.nextTag() == 2) {
            parser.require(2, null, "hash");
            byte[] hash = HexDump.hexStringToByteArray(parser.nextText());
            parser.require(3, null, "hash");
            hashList.add(hash);
        }
        parser.require(3, null, tagName);
    }

    public boolean containsDomain(String domain) {
        CrcShaDigests domainDigests = this.mDomainDigests;
        if (domainDigests == null) {
            return false;
        }
        byte[] crc32 = this.getCrc32(domain);
        if (!domainDigests.crc32Digests.contains(crc32)) {
            return false;
        }
        byte[] sha256 = this.getSha256(domain);
        return domainDigests.sha256Digests.contains(sha256);
    }

    public boolean containsIp(String ip) {
        CrcShaDigests ipDigests = this.mIpDigests;
        if (ipDigests == null) {
            return false;
        }
        byte[] crc32 = this.getCrc32(ip);
        if (!ipDigests.crc32Digests.contains(crc32)) {
            return false;
        }
        byte[] sha256 = this.getSha256(ip);
        return ipDigests.sha256Digests.contains(sha256);
    }

    private byte[] getCrc32(String str) {
        CRC32 crc = new CRC32();
        crc.update(str.getBytes());
        long tmp = crc.getValue();
        return new byte[]{(byte)(tmp >> 24 & 0xFFL), (byte)(tmp >> 16 & 0xFFL), (byte)(tmp >> 8 & 0xFFL), (byte)(tmp & 0xFFL)};
    }

    private byte[] getSha256(String str) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA256");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        messageDigest.update(str.getBytes());
        return messageDigest.digest();
    }

    public boolean isConfigSecure() {
        return this.mIsSecureConfig;
    }

    public byte[] getWatchlistConfigHash() {
        if (!this.mXmlFile.exists()) {
            return UNKNOWN_CONFIG_HASH;
        }
        try {
            return DigestUtils.getSha256Hash(this.mXmlFile);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            Log.e(TAG, "Unable to get watchlist config hash", e);
            return UNKNOWN_CONFIG_HASH;
        }
    }

    public void setTestMode(InputStream testConfigInputStream) throws IOException {
        Log.i(TAG, "Setting watchlist testing config");
        FileUtils.copyToFileOrThrow(testConfigInputStream, new File(NETWORK_WATCHLIST_DB_FOR_TEST_PATH));
        this.mIsSecureConfig = false;
        this.mXmlFile = new File(NETWORK_WATCHLIST_DB_FOR_TEST_PATH);
        this.reloadConfig();
    }

    public void removeTestModeConfig() {
        try {
            File f = new File(NETWORK_WATCHLIST_DB_FOR_TEST_PATH);
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception e) {
            Log.e(TAG, "Unable to delete test config");
        }
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("Watchlist config hash: " + HexDump.toHexString(this.getWatchlistConfigHash()));
        pw.println("Domain CRC32 digest list:");
        if (this.mDomainDigests != null) {
            this.mDomainDigests.crc32Digests.dump(fd, pw, args);
        }
        pw.println("Domain SHA256 digest list:");
        if (this.mDomainDigests != null) {
            this.mDomainDigests.sha256Digests.dump(fd, pw, args);
        }
        pw.println("Ip CRC32 digest list:");
        if (this.mIpDigests != null) {
            this.mIpDigests.crc32Digests.dump(fd, pw, args);
        }
        pw.println("Ip SHA256 digest list:");
        if (this.mIpDigests != null) {
            this.mIpDigests.sha256Digests.dump(fd, pw, args);
        }
    }

    private static class CrcShaDigests {
        final HarmfulDigests crc32Digests;
        final HarmfulDigests sha256Digests;

        public CrcShaDigests(HarmfulDigests crc32Digests, HarmfulDigests sha256Digests) {
            this.crc32Digests = crc32Digests;
            this.sha256Digests = sha256Digests;
        }
    }

    private static class XmlTags {
        private static final String WATCHLIST_CONFIG = "watchlist-config";
        private static final String SHA256_DOMAIN = "sha256-domain";
        private static final String CRC32_DOMAIN = "crc32-domain";
        private static final String SHA256_IP = "sha256-ip";
        private static final String CRC32_IP = "crc32-ip";
        private static final String HASH = "hash";

        private XmlTags() {
        }
    }
}

