/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.content.ComponentName;
import android.content.Context;
import android.media.AudioAttributes;
import android.os.Bundle;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.notification.ZenModeConfig;
import android.telecom.TelecomManager;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.ValidateNotificationPeople;
import com.android.server.notification.ZenLog;
import com.android.server.notification.ZenModeHelper;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Objects;

public class ZenModeFiltering {
    private static final String TAG = "ZenModeHelper";
    private static final boolean DEBUG = ZenModeHelper.DEBUG;
    static final RepeatCallers REPEAT_CALLERS = new RepeatCallers();
    private final Context mContext;
    private ComponentName mDefaultPhoneApp;

    public ZenModeFiltering(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("mDefaultPhoneApp=");
        pw.println(this.mDefaultPhoneApp);
        pw.print(prefix);
        pw.print("RepeatCallers.mThresholdMinutes=");
        pw.println(REPEAT_CALLERS.mThresholdMinutes);
        RepeatCallers repeatCallers = REPEAT_CALLERS;
        synchronized (repeatCallers) {
            if (!REPEAT_CALLERS.mCalls.isEmpty()) {
                pw.print(prefix);
                pw.println("RepeatCallers.mCalls=");
                for (int i = 0; i < REPEAT_CALLERS.mCalls.size(); ++i) {
                    pw.print(prefix);
                    pw.print("  ");
                    pw.print((String)REPEAT_CALLERS.mCalls.keyAt(i));
                    pw.print(" at ");
                    pw.println(ZenModeFiltering.ts((Long)REPEAT_CALLERS.mCalls.valueAt(i)));
                }
            }
        }
    }

    private static String ts(long time) {
        return new Date(time) + " (" + time + ")";
    }

    public static boolean matchesCallFilter(Context context, int zen, ZenModeConfig config, UserHandle userHandle, Bundle extras, ValidateNotificationPeople validator, int contactsTimeoutMs, float timeoutAffinity) {
        if (zen == 2) {
            return false;
        }
        if (zen == 3) {
            return false;
        }
        if (zen == 1) {
            if (config.allowRepeatCallers && ZenModeFiltering.REPEAT_CALLERS.isRepeat(context, extras)) {
                return true;
            }
            if (!config.allowCalls) {
                return false;
            }
            if (validator != null) {
                float contactAffinity = validator.getContactAffinity(userHandle, extras, contactsTimeoutMs, timeoutAffinity);
                return ZenModeFiltering.audienceMatches(config.allowCallsFrom, contactAffinity);
            }
        }
        return true;
    }

    private static Bundle extras(NotificationRecord record) {
        return record != null && record.sbn != null && record.sbn.getNotification() != null ? record.sbn.getNotification().extras : null;
    }

    protected void recordCall(NotificationRecord record) {
        ZenModeFiltering.REPEAT_CALLERS.recordCall(this.mContext, ZenModeFiltering.extras(record));
    }

    public boolean shouldIntercept(int zen, ZenModeConfig config, NotificationRecord record) {
        switch (zen) {
            case 2: {
                ZenLog.traceIntercepted(record, "none");
                return true;
            }
            case 3: {
                if (ZenModeFiltering.isAlarm(record)) {
                    return false;
                }
                ZenLog.traceIntercepted(record, "alarmsOnly");
                return true;
            }
            case 1: {
                if (record.getPackagePriority() == 2) {
                    ZenLog.traceNotIntercepted(record, "priorityApp");
                    return false;
                }
                if (ZenModeFiltering.isAlarm(record)) {
                    if (!config.allowAlarms) {
                        ZenLog.traceIntercepted(record, "!allowAlarms");
                        return true;
                    }
                    return false;
                }
                if (this.isCall(record)) {
                    if (config.allowRepeatCallers && ZenModeFiltering.REPEAT_CALLERS.isRepeat(this.mContext, ZenModeFiltering.extras(record))) {
                        ZenLog.traceNotIntercepted(record, "repeatCaller");
                        return false;
                    }
                    if (!config.allowCalls) {
                        ZenLog.traceIntercepted(record, "!allowCalls");
                        return true;
                    }
                    return ZenModeFiltering.shouldInterceptAudience(config.allowCallsFrom, record);
                }
                if (this.isMessage(record)) {
                    if (!config.allowMessages) {
                        ZenLog.traceIntercepted(record, "!allowMessages");
                        return true;
                    }
                    return ZenModeFiltering.shouldInterceptAudience(config.allowMessagesFrom, record);
                }
                if (ZenModeFiltering.isEvent(record)) {
                    if (!config.allowEvents) {
                        ZenLog.traceIntercepted(record, "!allowEvents");
                        return true;
                    }
                    return false;
                }
                if (ZenModeFiltering.isReminder(record)) {
                    if (!config.allowReminders) {
                        ZenLog.traceIntercepted(record, "!allowReminders");
                        return true;
                    }
                    return false;
                }
                AudioAttributes aa = record.getAudioAttributes();
                if (aa != null && AudioAttributes.SUPPRESSIBLE_USAGES.get(aa.getUsage()) == 5) {
                    if (!config.allowMediaSystemOther) {
                        ZenLog.traceIntercepted(record, "!allowMediaSystemOther");
                        return true;
                    }
                    return false;
                }
                ZenLog.traceIntercepted(record, "!priority");
                return true;
            }
        }
        return false;
    }

    private static boolean shouldInterceptAudience(int source, NotificationRecord record) {
        if (!ZenModeFiltering.audienceMatches(source, record.getContactAffinity())) {
            ZenLog.traceIntercepted(record, "!audienceMatches");
            return true;
        }
        return false;
    }

    private static boolean isAlarm(NotificationRecord record) {
        return record.isCategory("alarm") || record.isAudioStream(4) || record.isAudioAttributesUsage(4);
    }

    private static boolean isEvent(NotificationRecord record) {
        return record.isCategory("event");
    }

    private static boolean isReminder(NotificationRecord record) {
        return record.isCategory("reminder");
    }

    public boolean isCall(NotificationRecord record) {
        return record != null && (this.isDefaultPhoneApp(record.sbn.getPackageName()) || record.isCategory("call"));
    }

    private boolean isDefaultPhoneApp(String pkg) {
        if (this.mDefaultPhoneApp == null) {
            TelecomManager telecomm = (TelecomManager)this.mContext.getSystemService("telecom");
            ComponentName componentName = this.mDefaultPhoneApp = telecomm != null ? telecomm.getDefaultPhoneApp() : null;
            if (DEBUG) {
                Slog.d(TAG, "Default phone app: " + this.mDefaultPhoneApp);
            }
        }
        return pkg != null && this.mDefaultPhoneApp != null && pkg.equals(this.mDefaultPhoneApp.getPackageName());
    }

    private boolean isDefaultMessagingApp(NotificationRecord record) {
        int userId = record.getUserId();
        if (userId == -10000 || userId == -1) {
            return false;
        }
        String defaultApp = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "sms_default_application", userId);
        return Objects.equals(defaultApp, record.sbn.getPackageName());
    }

    private boolean isMessage(NotificationRecord record) {
        return record.isCategory("msg") || this.isDefaultMessagingApp(record);
    }

    private static boolean audienceMatches(int source, float contactAffinity) {
        switch (source) {
            case 0: {
                return true;
            }
            case 1: {
                return contactAffinity >= 0.5f;
            }
            case 2: {
                return contactAffinity >= 1.0f;
            }
        }
        Slog.w(TAG, "Encountered unknown source: " + source);
        return true;
    }

    private static class RepeatCallers {
        private final ArrayMap<String, Long> mCalls = new ArrayMap();
        private int mThresholdMinutes;

        private RepeatCallers() {
        }

        private synchronized void recordCall(Context context, Bundle extras) {
            this.setThresholdMinutes(context);
            if (this.mThresholdMinutes <= 0 || extras == null) {
                return;
            }
            String peopleString = RepeatCallers.peopleString(extras);
            if (peopleString == null) {
                return;
            }
            long now = System.currentTimeMillis();
            this.cleanUp(this.mCalls, now);
            this.mCalls.put(peopleString, now);
        }

        private synchronized boolean isRepeat(Context context, Bundle extras) {
            this.setThresholdMinutes(context);
            if (this.mThresholdMinutes <= 0 || extras == null) {
                return false;
            }
            String peopleString = RepeatCallers.peopleString(extras);
            if (peopleString == null) {
                return false;
            }
            long now = System.currentTimeMillis();
            this.cleanUp(this.mCalls, now);
            return this.mCalls.containsKey(peopleString);
        }

        private synchronized void cleanUp(ArrayMap<String, Long> calls, long now) {
            int N = calls.size();
            for (int i = N - 1; i >= 0; --i) {
                long time = this.mCalls.valueAt(i);
                if (time <= now && now - time <= (long)(this.mThresholdMinutes * 1000 * 60)) continue;
                calls.removeAt(i);
            }
        }

        private void setThresholdMinutes(Context context) {
            if (this.mThresholdMinutes <= 0) {
                this.mThresholdMinutes = context.getResources().getInteger(17694925);
            }
        }

        private static String peopleString(Bundle extras) {
            String[] extraPeople = ValidateNotificationPeople.getExtraPeople(extras);
            if (extraPeople == null || extraPeople.length == 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < extraPeople.length; ++i) {
                String extraPerson = extraPeople[i];
                if (extraPerson == null || (extraPerson = extraPerson.trim()).isEmpty()) continue;
                if (sb.length() > 0) {
                    sb.append('|');
                }
                sb.append(extraPerson);
            }
            return sb.length() == 0 ? null : sb.toString();
        }
    }
}

