/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.os.Environment;
import android.os.SystemClock;
import android.util.AtomicFile;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractStatsBase<T> {
    private static final int WRITE_INTERVAL_MS = 1800000;
    private final Object mFileLock = new Object();
    private final AtomicLong mLastTimeWritten = new AtomicLong(0L);
    private final AtomicBoolean mBackgroundWriteRunning = new AtomicBoolean(false);
    private final String mFileName;
    private final String mBackgroundThreadName;
    private final boolean mLock;

    protected AbstractStatsBase(String fileName, String threadName, boolean lock) {
        this.mFileName = fileName;
        this.mBackgroundThreadName = threadName;
        this.mLock = lock;
    }

    protected AtomicFile getFile() {
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        File fname = new File(systemDir, this.mFileName);
        return new AtomicFile(fname);
    }

    protected void writeNow(T data) {
        this.writeImpl(data);
        this.mLastTimeWritten.set(SystemClock.elapsedRealtime());
    }

    protected boolean maybeWriteAsync(final T data) {
        if (SystemClock.elapsedRealtime() - this.mLastTimeWritten.get() < 1800000L) {
            return false;
        }
        if (this.mBackgroundWriteRunning.compareAndSet(false, true)) {
            new Thread(this.mBackgroundThreadName){

                @Override
                public void run() {
                    try {
                        AbstractStatsBase.this.writeImpl(data);
                        AbstractStatsBase.this.mLastTimeWritten.set(SystemClock.elapsedRealtime());
                    }
                    finally {
                        AbstractStatsBase.this.mBackgroundWriteRunning.set(false);
                    }
                }
            }.start();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeImpl(T data) {
        if (this.mLock) {
            T t = data;
            synchronized (t) {
                Object object = this.mFileLock;
                synchronized (object) {
                    this.writeInternal(data);
                }
            }
        }
        Object object = this.mFileLock;
        synchronized (object) {
            this.writeInternal(data);
        }
    }

    protected abstract void writeInternal(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(T data) {
        if (this.mLock) {
            T t = data;
            synchronized (t) {
                Object object = this.mFileLock;
                synchronized (object) {
                    this.readInternal(data);
                }
            }
        }
        Object object = this.mFileLock;
        synchronized (object) {
            this.readInternal(data);
        }
        this.mLastTimeWritten.set(SystemClock.elapsedRealtime());
    }

    protected abstract void readInternal(T var1);
}

