/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.accounts.IAccountManager;
import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.content.ComponentName;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageManager;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.pm.ParceledListSlice;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.pm.VersionedPackage;
import android.content.pm.dex.DexMetadataHelper;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IUserManager;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.PrintWriterPrinter;
import com.android.internal.content.PackageHelper;
import com.android.internal.util.ArrayUtils;
import com.android.server.LocalServices;
import com.android.server.SystemConfig;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.PackageManagerServiceCompilerMapping;
import dalvik.system.DexFile;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import libcore.io.IoUtils;

class PackageManagerShellCommand
extends ShellCommand {
    private static final String STDIN_PATH = "-";
    final IPackageManager mInterface;
    private final WeakHashMap<String, Resources> mResourceCache = new WeakHashMap();
    int mTargetUser;
    boolean mBrief;
    boolean mComponents;

    PackageManagerShellCommand(PackageManagerService service) {
        this.mInterface = service;
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        PrintWriter pw = this.getOutPrintWriter();
        try {
            switch (cmd) {
                case "path": {
                    return this.runPath();
                }
                case "dump": {
                    return this.runDump();
                }
                case "list": {
                    return this.runList();
                }
                case "resolve-activity": {
                    return this.runResolveActivity();
                }
                case "query-activities": {
                    return this.runQueryIntentActivities();
                }
                case "query-services": {
                    return this.runQueryIntentServices();
                }
                case "query-receivers": {
                    return this.runQueryIntentReceivers();
                }
                case "install": {
                    return this.runInstall();
                }
                case "install-abandon": 
                case "install-destroy": {
                    return this.runInstallAbandon();
                }
                case "install-commit": {
                    return this.runInstallCommit();
                }
                case "install-create": {
                    return this.runInstallCreate();
                }
                case "install-remove": {
                    return this.runInstallRemove();
                }
                case "install-write": {
                    return this.runInstallWrite();
                }
                case "install-existing": {
                    return this.runInstallExisting();
                }
                case "set-install-location": {
                    return this.runSetInstallLocation();
                }
                case "get-install-location": {
                    return this.runGetInstallLocation();
                }
                case "move-package": {
                    return this.runMovePackage();
                }
                case "move-primary-storage": {
                    return this.runMovePrimaryStorage();
                }
                case "compile": {
                    return this.runCompile();
                }
                case "reconcile-secondary-dex-files": {
                    return this.runreconcileSecondaryDexFiles();
                }
                case "force-dex-opt": {
                    return this.runForceDexOpt();
                }
                case "bg-dexopt-job": {
                    return this.runDexoptJob();
                }
                case "dump-profiles": {
                    return this.runDumpProfiles();
                }
                case "uninstall": {
                    return this.runUninstall();
                }
                case "clear": {
                    return this.runClear();
                }
                case "enable": {
                    return this.runSetEnabledSetting(1);
                }
                case "disable": {
                    return this.runSetEnabledSetting(2);
                }
                case "disable-user": {
                    return this.runSetEnabledSetting(3);
                }
                case "disable-until-used": {
                    return this.runSetEnabledSetting(4);
                }
                case "default-state": {
                    return this.runSetEnabledSetting(0);
                }
                case "hide": {
                    return this.runSetHiddenSetting(true);
                }
                case "unhide": {
                    return this.runSetHiddenSetting(false);
                }
                case "suspend": {
                    return this.runSuspend(true);
                }
                case "unsuspend": {
                    return this.runSuspend(false);
                }
                case "grant": {
                    return this.runGrantRevokePermission(true);
                }
                case "revoke": {
                    return this.runGrantRevokePermission(false);
                }
                case "reset-permissions": {
                    return this.runResetPermissions();
                }
                case "set-permission-enforced": {
                    return this.runSetPermissionEnforced();
                }
                case "get-privapp-permissions": {
                    return this.runGetPrivappPermissions();
                }
                case "get-privapp-deny-permissions": {
                    return this.runGetPrivappDenyPermissions();
                }
                case "get-oem-permissions": {
                    return this.runGetOemPermissions();
                }
                case "set-app-link": {
                    return this.runSetAppLink();
                }
                case "get-app-link": {
                    return this.runGetAppLink();
                }
                case "trim-caches": {
                    return this.runTrimCaches();
                }
                case "create-user": {
                    return this.runCreateUser();
                }
                case "remove-user": {
                    return this.runRemoveUser();
                }
                case "set-user-restriction": {
                    return this.runSetUserRestriction();
                }
                case "get-max-users": {
                    return this.runGetMaxUsers();
                }
                case "get-max-running-users": {
                    return this.runGetMaxRunningUsers();
                }
                case "set-home-activity": {
                    return this.runSetHomeActivity();
                }
                case "set-installer": {
                    return this.runSetInstaller();
                }
                case "get-instantapp-resolver": {
                    return this.runGetInstantAppResolver();
                }
                case "has-feature": {
                    return this.runHasFeature();
                }
                case "set-harmful-app-warning": {
                    return this.runSetHarmfulAppWarning();
                }
                case "get-harmful-app-warning": {
                    return this.runGetHarmfulAppWarning();
                }
            }
            String nextArg = this.getNextArg();
            if (nextArg == null) {
                if (cmd.equalsIgnoreCase("-l")) {
                    return this.runListPackages(false);
                }
                if (cmd.equalsIgnoreCase("-lf")) {
                    return this.runListPackages(true);
                }
            } else if (this.getNextArg() == null && cmd.equalsIgnoreCase("-p")) {
                return this.displayPackageFilePath(nextArg, 0);
            }
            return this.handleDefaultCommands(cmd);
        }
        catch (RemoteException e) {
            pw.println("Remote exception: " + e);
            return -1;
        }
    }

    private void setParamsSize(InstallParams params, String inPath) {
        if (params.sessionParams.sizeBytes == -1L && !STDIN_PATH.equals(inPath)) {
            ParcelFileDescriptor fd = this.openFileForSystem(inPath, "r");
            if (fd == null) {
                this.getErrPrintWriter().println("Error: Can't open file: " + inPath);
                throw new IllegalArgumentException("Error: Can't open file: " + inPath);
            }
            try {
                PackageParser.ApkLite baseApk = PackageParser.parseApkLite(fd.getFileDescriptor(), inPath, 0);
                PackageParser.PackageLite pkgLite = new PackageParser.PackageLite(null, baseApk, null, null, null, null, null, null);
                params.sessionParams.setSize(PackageHelper.calculateInstalledSize(pkgLite, params.sessionParams.abiOverride, fd.getFileDescriptor()));
            }
            catch (PackageParser.PackageParserException | IOException e) {
                this.getErrPrintWriter().println("Error: Failed to parse APK file: " + inPath);
                throw new IllegalArgumentException("Error: Failed to parse APK file: " + inPath, e);
            }
            finally {
                try {
                    fd.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private int displayPackageFilePath(String pckg, int userId) throws RemoteException {
        PackageInfo info = this.mInterface.getPackageInfo(pckg, 0, userId);
        if (info != null && info.applicationInfo != null) {
            PrintWriter pw = this.getOutPrintWriter();
            pw.print("package:");
            pw.println(info.applicationInfo.sourceDir);
            if (!ArrayUtils.isEmpty(info.applicationInfo.splitSourceDirs)) {
                for (String splitSourceDir : info.applicationInfo.splitSourceDirs) {
                    pw.print("package:");
                    pw.println(splitSourceDir);
                }
            }
            return 0;
        }
        return 1;
    }

    private int runPath() throws RemoteException {
        String pkg;
        int userId = 0;
        String option = this.getNextOption();
        if (option != null && option.equals("--user")) {
            userId = UserHandle.parseUserArg(this.getNextArgRequired());
        }
        if ((pkg = this.getNextArgRequired()) == null) {
            this.getErrPrintWriter().println("Error: no package specified");
            return 1;
        }
        return this.displayPackageFilePath(pkg, userId);
    }

    private int runList() throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        String type = this.getNextArg();
        if (type == null) {
            pw.println("Error: didn't specify type of data to list");
            return -1;
        }
        switch (type) {
            case "features": {
                return this.runListFeatures();
            }
            case "instrumentation": {
                return this.runListInstrumentation();
            }
            case "libraries": {
                return this.runListLibraries();
            }
            case "package": 
            case "packages": {
                return this.runListPackages(false);
            }
            case "permission-groups": {
                return this.runListPermissionGroups();
            }
            case "permissions": {
                return this.runListPermissions();
            }
            case "users": {
                ServiceManager.getService("user").shellCommand(this.getInFileDescriptor(), this.getOutFileDescriptor(), this.getErrFileDescriptor(), new String[]{"list"}, this.getShellCallback(), this.adoptResultReceiver());
                return 0;
            }
        }
        pw.println("Error: unknown list type '" + type + "'");
        return -1;
    }

    private int runListFeatures() throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        List list = this.mInterface.getSystemAvailableFeatures().getList();
        Collections.sort(list, new Comparator<FeatureInfo>(){

            @Override
            public int compare(FeatureInfo o1, FeatureInfo o2) {
                if (o1.name == o2.name) {
                    return 0;
                }
                if (o1.name == null) {
                    return -1;
                }
                if (o2.name == null) {
                    return 1;
                }
                return o1.name.compareTo(o2.name);
            }
        });
        int count = list != null ? list.size() : 0;
        for (int p = 0; p < count; ++p) {
            FeatureInfo fi = (FeatureInfo)list.get(p);
            pw.print("feature:");
            if (fi.name != null) {
                pw.print(fi.name);
                if (fi.version > 0) {
                    pw.print("=");
                    pw.print(fi.version);
                }
                pw.println();
                continue;
            }
            pw.println("reqGlEsVersion=0x" + Integer.toHexString(fi.reqGlEsVersion));
        }
        return 0;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int runListInstrumentation() throws RemoteException {
        String opt;
        PrintWriter pw = this.getOutPrintWriter();
        boolean showSourceDir = false;
        String targetPackage = null;
        while ((opt = this.getNextArg()) != null) {
            switch (opt) {
                case "-f": {
                    showSourceDir = true;
                    break;
                }
                default: {
                    if (opt.charAt(0) == '-') {
                        pw.println("Error: Unknown option: " + opt);
                        return -1;
                    }
                    targetPackage = opt;
                    break;
                }
            }
        }
        {
            catch (RuntimeException ex) {}
            pw.println("Error: " + ex.toString());
            return -1;
            List list = this.mInterface.queryInstrumentation(targetPackage, 0).getList();
            Collections.sort(list, new Comparator<InstrumentationInfo>(){

                @Override
                public int compare(InstrumentationInfo o1, InstrumentationInfo o2) {
                    return o1.targetPackage.compareTo(o2.targetPackage);
                }
            });
            if (list == null) return 0;
            int n = list.size();
            int count = n;
            int p = 0;
            while (p < count) {
                InstrumentationInfo ii = (InstrumentationInfo)list.get(p);
                pw.print("instrumentation:");
                if (showSourceDir) {
                    pw.print(ii.sourceDir);
                    pw.print("=");
                }
                ComponentName cn = new ComponentName(ii.packageName, ii.name);
                pw.print(cn.flattenToShortString());
                pw.print(" (target=");
                pw.print(ii.targetPackage);
                pw.println(")");
                ++p;
            }
            return 0;
        }
    }

    private int runListLibraries() throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        ArrayList<String> list = new ArrayList<String>();
        String[] rawList = this.mInterface.getSystemSharedLibraryNames();
        for (int i = 0; i < rawList.length; ++i) {
            list.add(rawList[i]);
        }
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        });
        int count = list != null ? list.size() : 0;
        for (int p = 0; p < count; ++p) {
            String lib = (String)list.get(p);
            pw.print("library:");
            pw.println(lib);
        }
        return 0;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int runListPackages(boolean showSourceDir) throws RemoteException {
        int p;
        int count;
        List packages;
        String filter;
        int uid;
        boolean showVersionCode;
        boolean showUid;
        boolean listInstaller;
        boolean listThirdParty;
        boolean listSystem;
        boolean listEnabled;
        boolean listDisabled;
        PrintWriter pw;
        block40: {
            String opt;
            pw = this.getOutPrintWriter();
            int getFlags = 0;
            listDisabled = false;
            listEnabled = false;
            listSystem = false;
            listThirdParty = false;
            listInstaller = false;
            showUid = false;
            showVersionCode = false;
            uid = -1;
            int userId = 0;
            while ((opt = this.getNextOption()) != null) {
                switch (opt) {
                    case "-d": {
                        listDisabled = true;
                        break;
                    }
                    case "-e": {
                        listEnabled = true;
                        break;
                    }
                    case "-f": {
                        showSourceDir = true;
                        break;
                    }
                    case "-i": {
                        listInstaller = true;
                        break;
                    }
                    case "-l": {
                        break;
                    }
                    case "-s": {
                        listSystem = true;
                        break;
                    }
                    case "-U": {
                        showUid = true;
                        break;
                    }
                    case "-u": {
                        getFlags |= 0x2000;
                        break;
                    }
                    case "-3": {
                        listThirdParty = true;
                        break;
                    }
                    case "--show-versioncode": {
                        showVersionCode = true;
                        break;
                    }
                    case "--user": {
                        userId = UserHandle.parseUserArg(this.getNextArgRequired());
                        break;
                    }
                    case "--uid": {
                        showUid = true;
                        uid = Integer.parseInt(this.getNextArgRequired());
                        break;
                    }
                    default: {
                        pw.println("Error: Unknown option: " + opt);
                        return -1;
                    }
                }
            }
            {
                filter = this.getNextArg();
                ParceledListSlice slice = this.mInterface.getInstalledPackages(getFlags, userId);
                packages = slice.getList();
                count = packages.size();
                p = 0;
                break block40;
                catch (RuntimeException ex) {}
                pw.println("Error: " + ex.toString());
                return -1;
            }
        }
        while (p < count) {
            PackageInfo info = (PackageInfo)packages.get(p);
            if (!(filter != null && !info.packageName.contains(filter) || uid != -1 && info.applicationInfo.uid != uid)) {
                boolean isSystem;
                boolean bl = isSystem = (info.applicationInfo.flags & 1) != 0;
                if (!(listDisabled && info.applicationInfo.enabled || listEnabled && !info.applicationInfo.enabled || listSystem && !isSystem || listThirdParty && isSystem)) {
                    pw.print("package:");
                    if (showSourceDir) {
                        pw.print(info.applicationInfo.sourceDir);
                        pw.print("=");
                    }
                    pw.print(info.packageName);
                    if (showVersionCode) {
                        pw.print(" versionCode:");
                        pw.print(info.applicationInfo.versionCode);
                    }
                    if (listInstaller) {
                        pw.print("  installer=");
                        pw.print(this.mInterface.getInstallerPackageName(info.packageName));
                    }
                    if (showUid) {
                        pw.print(" uid:");
                        pw.print(info.applicationInfo.uid);
                    }
                    pw.println();
                }
            }
            ++p;
        }
        return 0;
    }

    private int runListPermissionGroups() throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        List pgs = this.mInterface.getAllPermissionGroups(0).getList();
        int count = pgs.size();
        for (int p = 0; p < count; ++p) {
            PermissionGroupInfo pgi = (PermissionGroupInfo)pgs.get(p);
            pw.print("permission group:");
            pw.println(pgi.name);
        }
        return 0;
    }

    private int runListPermissions() throws RemoteException {
        String opt;
        PrintWriter pw = this.getOutPrintWriter();
        boolean labels = false;
        boolean groups = false;
        boolean userOnly = false;
        boolean summary = false;
        boolean dangerousOnly = false;
        block14: while ((opt = this.getNextOption()) != null) {
            switch (opt) {
                case "-d": {
                    dangerousOnly = true;
                    continue block14;
                }
                case "-f": {
                    labels = true;
                    continue block14;
                }
                case "-g": {
                    groups = true;
                    continue block14;
                }
                case "-s": {
                    groups = true;
                    labels = true;
                    summary = true;
                    continue block14;
                }
                case "-u": {
                    userOnly = true;
                    continue block14;
                }
            }
            pw.println("Error: Unknown option: " + opt);
            return 1;
        }
        ArrayList<String> groupList = new ArrayList<String>();
        if (groups) {
            List infos = this.mInterface.getAllPermissionGroups(0).getList();
            int count = infos.size();
            for (int i = 0; i < count; ++i) {
                groupList.add(((PermissionGroupInfo)infos.get((int)i)).name);
            }
            groupList.add(null);
        } else {
            String grp = this.getNextArg();
            groupList.add(grp);
        }
        if (dangerousOnly) {
            pw.println("Dangerous Permissions:");
            pw.println("");
            this.doListPermissions(groupList, groups, labels, summary, 1, 1);
            if (userOnly) {
                pw.println("Normal Permissions:");
                pw.println("");
                this.doListPermissions(groupList, groups, labels, summary, 0, 0);
            }
        } else if (userOnly) {
            pw.println("Dangerous and Normal Permissions:");
            pw.println("");
            this.doListPermissions(groupList, groups, labels, summary, 0, 1);
        } else {
            pw.println("All Permissions:");
            pw.println("");
            this.doListPermissions(groupList, groups, labels, summary, -10000, 10000);
        }
        return 0;
    }

    private Intent parseIntentAndUser() throws URISyntaxException {
        this.mTargetUser = -2;
        this.mBrief = false;
        this.mComponents = false;
        Intent intent = Intent.parseCommandArgs(this, new Intent.CommandOptionHandler(){

            @Override
            public boolean handleOption(String opt, ShellCommand cmd) {
                if ("--user".equals(opt)) {
                    PackageManagerShellCommand.this.mTargetUser = UserHandle.parseUserArg(cmd.getNextArgRequired());
                    return true;
                }
                if ("--brief".equals(opt)) {
                    PackageManagerShellCommand.this.mBrief = true;
                    return true;
                }
                if ("--components".equals(opt)) {
                    PackageManagerShellCommand.this.mComponents = true;
                    return true;
                }
                return false;
            }
        });
        this.mTargetUser = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), this.mTargetUser, false, false, null, null);
        return intent;
    }

    private void printResolveInfo(PrintWriterPrinter pr, String prefix, ResolveInfo ri, boolean brief, boolean components) {
        ComponentName comp;
        if ((brief || components) && (comp = ri.activityInfo != null ? new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name) : (ri.serviceInfo != null ? new ComponentName(ri.serviceInfo.packageName, ri.serviceInfo.name) : (ri.providerInfo != null ? new ComponentName(ri.providerInfo.packageName, ri.providerInfo.name) : null))) != null) {
            if (!components) {
                pr.println(prefix + "priority=" + ri.priority + " preferredOrder=" + ri.preferredOrder + " match=0x" + Integer.toHexString(ri.match) + " specificIndex=" + ri.specificIndex + " isDefault=" + ri.isDefault);
            }
            pr.println(prefix + comp.flattenToShortString());
            return;
        }
        ri.dump(pr, prefix);
    }

    private int runResolveActivity() {
        Intent intent;
        try {
            intent = this.parseIntentAndUser();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            ResolveInfo ri = this.mInterface.resolveIntent(intent, intent.getType(), 0, this.mTargetUser);
            PrintWriter pw = this.getOutPrintWriter();
            if (ri == null) {
                pw.println("No activity found");
            } else {
                PrintWriterPrinter pr = new PrintWriterPrinter(pw);
                this.printResolveInfo(pr, "", ri, this.mBrief, this.mComponents);
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failed calling service", e);
        }
        return 0;
    }

    private int runQueryIntentActivities() {
        Intent intent;
        try {
            intent = this.parseIntentAndUser();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            List result = this.mInterface.queryIntentActivities(intent, intent.getType(), 0, this.mTargetUser).getList();
            PrintWriter pw = this.getOutPrintWriter();
            if (result == null || result.size() <= 0) {
                pw.println("No activities found");
            } else if (!this.mComponents) {
                pw.print(result.size());
                pw.println(" activities found:");
                PrintWriterPrinter pr = new PrintWriterPrinter(pw);
                for (int i = 0; i < result.size(); ++i) {
                    pw.print("  Activity #");
                    pw.print(i);
                    pw.println(":");
                    this.printResolveInfo(pr, "    ", (ResolveInfo)result.get(i), this.mBrief, this.mComponents);
                }
            } else {
                PrintWriterPrinter pr = new PrintWriterPrinter(pw);
                for (int i = 0; i < result.size(); ++i) {
                    this.printResolveInfo(pr, "", (ResolveInfo)result.get(i), this.mBrief, this.mComponents);
                }
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failed calling service", e);
        }
        return 0;
    }

    private int runQueryIntentServices() {
        Intent intent;
        try {
            intent = this.parseIntentAndUser();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            List result = this.mInterface.queryIntentServices(intent, intent.getType(), 0, this.mTargetUser).getList();
            PrintWriter pw = this.getOutPrintWriter();
            if (result == null || result.size() <= 0) {
                pw.println("No services found");
            } else if (!this.mComponents) {
                pw.print(result.size());
                pw.println(" services found:");
                PrintWriterPrinter pr = new PrintWriterPrinter(pw);
                for (int i = 0; i < result.size(); ++i) {
                    pw.print("  Service #");
                    pw.print(i);
                    pw.println(":");
                    this.printResolveInfo(pr, "    ", (ResolveInfo)result.get(i), this.mBrief, this.mComponents);
                }
            } else {
                PrintWriterPrinter pr = new PrintWriterPrinter(pw);
                for (int i = 0; i < result.size(); ++i) {
                    this.printResolveInfo(pr, "", (ResolveInfo)result.get(i), this.mBrief, this.mComponents);
                }
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failed calling service", e);
        }
        return 0;
    }

    private int runQueryIntentReceivers() {
        Intent intent;
        try {
            intent = this.parseIntentAndUser();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            List result = this.mInterface.queryIntentReceivers(intent, intent.getType(), 0, this.mTargetUser).getList();
            PrintWriter pw = this.getOutPrintWriter();
            if (result == null || result.size() <= 0) {
                pw.println("No receivers found");
            } else if (!this.mComponents) {
                pw.print(result.size());
                pw.println(" receivers found:");
                PrintWriterPrinter pr = new PrintWriterPrinter(pw);
                for (int i = 0; i < result.size(); ++i) {
                    pw.print("  Receiver #");
                    pw.print(i);
                    pw.println(":");
                    this.printResolveInfo(pr, "    ", (ResolveInfo)result.get(i), this.mBrief, this.mComponents);
                }
            } else {
                PrintWriterPrinter pr = new PrintWriterPrinter(pw);
                for (int i = 0; i < result.size(); ++i) {
                    this.printResolveInfo(pr, "", (ResolveInfo)result.get(i), this.mBrief, this.mComponents);
                }
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failed calling service", e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runInstall() throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        InstallParams params = this.makeInstallParams();
        String inPath = this.getNextArg();
        this.setParamsSize(params, inPath);
        int sessionId = this.doCreateSession(params.sessionParams, params.installerPackageName, params.userId);
        boolean abandonSession = true;
        try {
            if (inPath == null && params.sessionParams.sizeBytes == -1L) {
                pw.println("Error: must either specify a package size or an APK file");
                int n = 1;
                return n;
            }
            if (this.doWriteSplit(sessionId, inPath, params.sessionParams.sizeBytes, "base.apk", false) != 0) {
                int n = 1;
                return n;
            }
            if (this.doCommitSession(sessionId, false) != 0) {
                int n = 1;
                return n;
            }
            abandonSession = false;
            pw.println("Success");
            int n = 0;
            return n;
        }
        finally {
            if (abandonSession) {
                try {
                    this.doAbandonSession(sessionId, false);
                }
                catch (Exception exception) {}
            }
        }
    }

    private int runInstallAbandon() throws RemoteException {
        int sessionId = Integer.parseInt(this.getNextArg());
        return this.doAbandonSession(sessionId, true);
    }

    private int runInstallCommit() throws RemoteException {
        int sessionId = Integer.parseInt(this.getNextArg());
        return this.doCommitSession(sessionId, true);
    }

    private int runInstallCreate() throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        InstallParams installParams = this.makeInstallParams();
        int sessionId = this.doCreateSession(installParams.sessionParams, installParams.installerPackageName, installParams.userId);
        pw.println("Success: created install session [" + sessionId + "]");
        return 0;
    }

    private int runInstallWrite() throws RemoteException {
        String opt;
        long sizeBytes = -1L;
        while ((opt = this.getNextOption()) != null) {
            if (opt.equals("-S")) {
                sizeBytes = Long.parseLong(this.getNextArg());
                continue;
            }
            throw new IllegalArgumentException("Unknown option: " + opt);
        }
        int sessionId = Integer.parseInt(this.getNextArg());
        String splitName = this.getNextArg();
        String path = this.getNextArg();
        return this.doWriteSplit(sessionId, path, sizeBytes, splitName, true);
    }

    private int runInstallRemove() throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        int sessionId = Integer.parseInt(this.getNextArg());
        String splitName = this.getNextArg();
        if (splitName == null) {
            pw.println("Error: split name not specified");
            return 1;
        }
        return this.doRemoveSplit(sessionId, splitName, true);
    }

    private int runInstallExisting() throws RemoteException {
        String opt;
        PrintWriter pw = this.getOutPrintWriter();
        int userId = 0;
        int installFlags = 0;
        block13: while ((opt = this.getNextOption()) != null) {
            switch (opt) {
                case "--user": {
                    userId = UserHandle.parseUserArg(this.getNextArgRequired());
                    continue block13;
                }
                case "--ephemeral": 
                case "--instant": {
                    installFlags |= 0x800;
                    installFlags &= 0xFFFFBFFF;
                    continue block13;
                }
                case "--full": {
                    installFlags &= 0xFFFFF7FF;
                    installFlags |= 0x4000;
                    continue block13;
                }
            }
            pw.println("Error: Unknown option: " + opt);
            return 1;
        }
        String packageName = this.getNextArg();
        if (packageName == null) {
            pw.println("Error: package name not specified");
            return 1;
        }
        try {
            int res = this.mInterface.installExistingPackageAsUser(packageName, userId, installFlags, 0);
            if (res == -3) {
                throw new PackageManager.NameNotFoundException("Package " + packageName + " doesn't exist");
            }
            pw.println("Package " + packageName + " installed for user: " + userId);
            return 0;
        }
        catch (PackageManager.NameNotFoundException | RemoteException e) {
            pw.println(e.toString());
            return 1;
        }
    }

    private int runSetInstallLocation() throws RemoteException {
        int loc;
        String arg = this.getNextArg();
        if (arg == null) {
            this.getErrPrintWriter().println("Error: no install location specified.");
            return 1;
        }
        try {
            loc = Integer.parseInt(arg);
        }
        catch (NumberFormatException e) {
            this.getErrPrintWriter().println("Error: install location has to be a number.");
            return 1;
        }
        if (!this.mInterface.setInstallLocation(loc)) {
            this.getErrPrintWriter().println("Error: install location has to be a number.");
            return 1;
        }
        return 0;
    }

    private int runGetInstallLocation() throws RemoteException {
        int loc = this.mInterface.getInstallLocation();
        String locStr = "invalid";
        if (loc == 0) {
            locStr = "auto";
        } else if (loc == 1) {
            locStr = "internal";
        } else if (loc == 2) {
            locStr = "external";
        }
        this.getOutPrintWriter().println(loc + "[" + locStr + "]");
        return 0;
    }

    public int runMovePackage() throws RemoteException {
        String packageName = this.getNextArg();
        if (packageName == null) {
            this.getErrPrintWriter().println("Error: package name not specified");
            return 1;
        }
        String volumeUuid = this.getNextArg();
        if ("internal".equals(volumeUuid)) {
            volumeUuid = null;
        }
        int moveId = this.mInterface.movePackage(packageName, volumeUuid);
        int status = this.mInterface.getMoveStatus(moveId);
        while (!PackageManager.isMoveStatusFinished(status)) {
            SystemClock.sleep(1000L);
            status = this.mInterface.getMoveStatus(moveId);
        }
        if (status == -100) {
            this.getOutPrintWriter().println("Success");
            return 0;
        }
        this.getErrPrintWriter().println("Failure [" + status + "]");
        return 1;
    }

    public int runMovePrimaryStorage() throws RemoteException {
        String volumeUuid = this.getNextArg();
        if ("internal".equals(volumeUuid)) {
            volumeUuid = null;
        }
        int moveId = this.mInterface.movePrimaryStorage(volumeUuid);
        int status = this.mInterface.getMoveStatus(moveId);
        while (!PackageManager.isMoveStatusFinished(status)) {
            SystemClock.sleep(1000L);
            status = this.mInterface.getMoveStatus(moveId);
        }
        if (status == -100) {
            this.getOutPrintWriter().println("Success");
            return 0;
        }
        this.getErrPrintWriter().println("Failure [" + status + "]");
        return 1;
    }

    private int runCompile() throws RemoteException {
        String targetCompilerFilter;
        String opt;
        PrintWriter pw = this.getOutPrintWriter();
        boolean checkProfiles = SystemProperties.getBoolean("dalvik.vm.usejitprofiles", false);
        boolean forceCompilation = false;
        boolean allPackages = false;
        boolean clearProfileData = false;
        String compilerFilter = null;
        String compilationReason = null;
        String checkProfilesRaw = null;
        boolean secondaryDex = false;
        String split = null;
        block22: while ((opt = this.getNextOption()) != null) {
            switch (opt) {
                case "-a": {
                    allPackages = true;
                    continue block22;
                }
                case "-c": {
                    clearProfileData = true;
                    continue block22;
                }
                case "-f": {
                    forceCompilation = true;
                    continue block22;
                }
                case "-m": {
                    compilerFilter = this.getNextArgRequired();
                    continue block22;
                }
                case "-r": {
                    compilationReason = this.getNextArgRequired();
                    continue block22;
                }
                case "--check-prof": {
                    checkProfilesRaw = this.getNextArgRequired();
                    continue block22;
                }
                case "--reset": {
                    forceCompilation = true;
                    clearProfileData = true;
                    compilationReason = "install";
                    continue block22;
                }
                case "--secondary-dex": {
                    secondaryDex = true;
                    continue block22;
                }
                case "--split": {
                    split = this.getNextArgRequired();
                    continue block22;
                }
            }
            pw.println("Error: Unknown option: " + opt);
            return 1;
        }
        if (checkProfilesRaw != null) {
            if ("true".equals(checkProfilesRaw)) {
                checkProfiles = true;
            } else if ("false".equals(checkProfilesRaw)) {
                checkProfiles = false;
            } else {
                pw.println("Invalid value for \"--check-prof\". Expected \"true\" or \"false\".");
                return 1;
            }
        }
        if (compilerFilter != null && compilationReason != null) {
            pw.println("Cannot use compilation filter (\"-m\") and compilation reason (\"-r\") at the same time");
            return 1;
        }
        if (compilerFilter == null && compilationReason == null) {
            pw.println("Cannot run without any of compilation filter (\"-m\") and compilation reason (\"-r\") at the same time");
            return 1;
        }
        if (allPackages && split != null) {
            pw.println("-a cannot be specified together with --split");
            return 1;
        }
        if (secondaryDex && split != null) {
            pw.println("--secondary-dex cannot be specified together with --split");
            return 1;
        }
        if (compilerFilter != null) {
            if (!DexFile.isValidCompilerFilter(compilerFilter)) {
                pw.println("Error: \"" + compilerFilter + "\" is not a valid compilation filter.");
                return 1;
            }
            targetCompilerFilter = compilerFilter;
        } else {
            int reason = -1;
            for (int i = 0; i < PackageManagerServiceCompilerMapping.REASON_STRINGS.length; ++i) {
                if (!PackageManagerServiceCompilerMapping.REASON_STRINGS[i].equals(compilationReason)) continue;
                reason = i;
                break;
            }
            if (reason == -1) {
                pw.println("Error: Unknown compilation reason: " + compilationReason);
                return 1;
            }
            targetCompilerFilter = PackageManagerServiceCompilerMapping.getCompilerFilterForReason(reason);
        }
        List<String> packageNames = null;
        if (allPackages) {
            packageNames = this.mInterface.getAllPackages();
        } else {
            String packageName = this.getNextArg();
            if (packageName == null) {
                pw.println("Error: package name not specified");
                return 1;
            }
            packageNames = Collections.singletonList(packageName);
        }
        ArrayList<String> failedPackages = new ArrayList<String>();
        int index = 0;
        for (String packageName : packageNames) {
            boolean result;
            if (clearProfileData) {
                this.mInterface.clearApplicationProfileData(packageName);
            }
            if (allPackages) {
                pw.println(++index + "/" + packageNames.size() + ": " + packageName);
                pw.flush();
            }
            if (result = secondaryDex ? this.mInterface.performDexOptSecondary(packageName, targetCompilerFilter, forceCompilation) : this.mInterface.performDexOptMode(packageName, checkProfiles, targetCompilerFilter, forceCompilation, true, split)) continue;
            failedPackages.add(packageName);
        }
        if (failedPackages.isEmpty()) {
            pw.println("Success");
            return 0;
        }
        if (failedPackages.size() == 1) {
            pw.println("Failure: package " + (String)failedPackages.get(0) + " could not be compiled");
            return 1;
        }
        pw.print("Failure: the following packages could not be compiled: ");
        boolean is_first = true;
        for (String packageName : failedPackages) {
            if (is_first) {
                is_first = false;
            } else {
                pw.print(", ");
            }
            pw.print(packageName);
        }
        pw.println();
        return 1;
    }

    private int runreconcileSecondaryDexFiles() throws RemoteException {
        String packageName = this.getNextArg();
        this.mInterface.reconcileSecondaryDexFiles(packageName);
        return 0;
    }

    public int runForceDexOpt() throws RemoteException {
        this.mInterface.forceDexOpt(this.getNextArgRequired());
        return 0;
    }

    private int runDexoptJob() throws RemoteException {
        String arg;
        ArrayList<String> packageNames = new ArrayList<String>();
        while ((arg = this.getNextArg()) != null) {
            packageNames.add(arg);
        }
        boolean result = this.mInterface.runBackgroundDexoptJob(packageNames.isEmpty() ? null : packageNames);
        return result ? 0 : -1;
    }

    private int runDumpProfiles() throws RemoteException {
        String packageName = this.getNextArg();
        this.mInterface.dumpProfiles(packageName);
        return 0;
    }

    private int runUninstall() throws RemoteException {
        String opt;
        PrintWriter pw = this.getOutPrintWriter();
        int flags = 0;
        int userId = -1;
        long versionCode = -1L;
        block10: while ((opt = this.getNextOption()) != null) {
            switch (opt) {
                case "-k": {
                    flags |= 1;
                    continue block10;
                }
                case "--user": {
                    userId = UserHandle.parseUserArg(this.getNextArgRequired());
                    continue block10;
                }
                case "--versionCode": {
                    versionCode = Long.parseLong(this.getNextArgRequired());
                    continue block10;
                }
            }
            pw.println("Error: Unknown option: " + opt);
            return 1;
        }
        String packageName = this.getNextArg();
        if (packageName == null) {
            pw.println("Error: package name not specified");
            return 1;
        }
        String splitName = this.getNextArg();
        if (splitName != null) {
            return this.runRemoveSplit(packageName, splitName);
        }
        if ((userId = this.translateUserId(userId, true, "runUninstall")) == -1) {
            userId = 0;
            flags |= 2;
        } else {
            boolean isSystem;
            PackageInfo info = this.mInterface.getPackageInfo(packageName, 0x4000000, userId);
            if (info == null) {
                pw.println("Failure [not installed for " + userId + "]");
                return 1;
            }
            boolean bl = isSystem = (info.applicationInfo.flags & 1) != 0;
            if (isSystem) {
                flags |= 4;
            }
        }
        LocalIntentReceiver receiver = new LocalIntentReceiver();
        this.mInterface.getPackageInstaller().uninstall(new VersionedPackage(packageName, versionCode), null, flags, receiver.getIntentSender(), userId);
        Intent result = receiver.getResult();
        int status = result.getIntExtra("android.content.pm.extra.STATUS", 1);
        if (status == 0) {
            pw.println("Success");
            return 0;
        }
        pw.println("Failure [" + result.getStringExtra("android.content.pm.extra.STATUS_MESSAGE") + "]");
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runRemoveSplit(String packageName, String splitName) throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        PackageInstaller.SessionParams sessionParams = new PackageInstaller.SessionParams(2);
        sessionParams.installFlags |= 2;
        sessionParams.appPackageName = packageName;
        int sessionId = this.doCreateSession(sessionParams, null, -1);
        boolean abandonSession = true;
        try {
            if (this.doRemoveSplit(sessionId, splitName, false) != 0) {
                int n = 1;
                return n;
            }
            if (this.doCommitSession(sessionId, false) != 0) {
                int n = 1;
                return n;
            }
            abandonSession = false;
            pw.println("Success");
            int n = 0;
            return n;
        }
        finally {
            if (abandonSession) {
                try {
                    this.doAbandonSession(sessionId, false);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runClear() throws RemoteException {
        String pkg;
        int userId = 0;
        String option = this.getNextOption();
        if (option != null && option.equals("--user")) {
            userId = UserHandle.parseUserArg(this.getNextArgRequired());
        }
        if ((pkg = this.getNextArg()) == null) {
            this.getErrPrintWriter().println("Error: no package specified");
            return 1;
        }
        ClearDataObserver obs = new ClearDataObserver();
        ActivityManager.getService().clearApplicationUserData(pkg, false, obs, userId);
        ClearDataObserver clearDataObserver = obs;
        synchronized (clearDataObserver) {
            while (!obs.finished) {
                try {
                    obs.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (obs.result) {
            this.getOutPrintWriter().println("Success");
            return 0;
        }
        this.getErrPrintWriter().println("Failed");
        return 1;
    }

    private static String enabledSettingToString(int state) {
        switch (state) {
            case 0: {
                return "default";
            }
            case 1: {
                return "enabled";
            }
            case 2: {
                return "disabled";
            }
            case 3: {
                return "disabled-user";
            }
            case 4: {
                return "disabled-until-used";
            }
        }
        return "unknown";
    }

    private int runSetEnabledSetting(int state) throws RemoteException {
        String pkg;
        int userId = 0;
        String option = this.getNextOption();
        if (option != null && option.equals("--user")) {
            userId = UserHandle.parseUserArg(this.getNextArgRequired());
        }
        if ((pkg = this.getNextArg()) == null) {
            this.getErrPrintWriter().println("Error: no package or component specified");
            return 1;
        }
        ComponentName cn = ComponentName.unflattenFromString(pkg);
        if (cn == null) {
            this.mInterface.setApplicationEnabledSetting(pkg, state, 0, userId, "shell:" + Process.myUid());
            this.getOutPrintWriter().println("Package " + pkg + " new state: " + PackageManagerShellCommand.enabledSettingToString(this.mInterface.getApplicationEnabledSetting(pkg, userId)));
            return 0;
        }
        this.mInterface.setComponentEnabledSetting(cn, state, 0, userId);
        this.getOutPrintWriter().println("Component " + cn.toShortString() + " new state: " + PackageManagerShellCommand.enabledSettingToString(this.mInterface.getComponentEnabledSetting(cn, userId)));
        return 0;
    }

    private int runSetHiddenSetting(boolean state) throws RemoteException {
        String pkg;
        int userId = 0;
        String option = this.getNextOption();
        if (option != null && option.equals("--user")) {
            userId = UserHandle.parseUserArg(this.getNextArgRequired());
        }
        if ((pkg = this.getNextArg()) == null) {
            this.getErrPrintWriter().println("Error: no package or component specified");
            return 1;
        }
        this.mInterface.setApplicationHiddenSettingAsUser(pkg, state, userId);
        this.getOutPrintWriter().println("Package " + pkg + " new hidden state: " + this.mInterface.getApplicationHiddenSettingAsUser(pkg, userId));
        return 0;
    }

    private int runSuspend(boolean suspendedState) {
        String opt;
        PrintWriter pw = this.getOutPrintWriter();
        int userId = 0;
        block8: while ((opt = this.getNextOption()) != null) {
            switch (opt) {
                case "--user": {
                    userId = UserHandle.parseUserArg(this.getNextArgRequired());
                    continue block8;
                }
            }
            pw.println("Error: Unknown option: " + opt);
            return 1;
        }
        String packageName = this.getNextArg();
        if (packageName == null) {
            pw.println("Error: package name not specified");
            return 1;
        }
        try {
            this.mInterface.setPackagesSuspendedAsUser(new String[]{packageName}, suspendedState, userId);
            pw.println("Package " + packageName + " new suspended state: " + this.mInterface.isPackageSuspendedForUser(packageName, userId));
            return 0;
        }
        catch (RemoteException | IllegalArgumentException e) {
            pw.println(e.toString());
            return 1;
        }
    }

    private int runGrantRevokePermission(boolean grant) throws RemoteException {
        int userId = 0;
        String opt = null;
        while ((opt = this.getNextOption()) != null) {
            if (!opt.equals("--user")) continue;
            userId = UserHandle.parseUserArg(this.getNextArgRequired());
        }
        String pkg = this.getNextArg();
        if (pkg == null) {
            this.getErrPrintWriter().println("Error: no package specified");
            return 1;
        }
        String perm = this.getNextArg();
        if (perm == null) {
            this.getErrPrintWriter().println("Error: no permission specified");
            return 1;
        }
        if (grant) {
            this.mInterface.grantRuntimePermission(pkg, perm, userId);
        } else {
            this.mInterface.revokeRuntimePermission(pkg, perm, userId);
        }
        return 0;
    }

    private int runResetPermissions() throws RemoteException {
        this.mInterface.resetRuntimePermissions();
        return 0;
    }

    private int runSetPermissionEnforced() throws RemoteException {
        String permission2 = this.getNextArg();
        if (permission2 == null) {
            this.getErrPrintWriter().println("Error: no permission specified");
            return 1;
        }
        String enforcedRaw = this.getNextArg();
        if (enforcedRaw == null) {
            this.getErrPrintWriter().println("Error: no enforcement specified");
            return 1;
        }
        this.mInterface.setPermissionEnforced(permission2, Boolean.parseBoolean(enforcedRaw));
        return 0;
    }

    private boolean isVendorApp(String pkg) {
        try {
            PackageInfo info = this.mInterface.getPackageInfo(pkg, 0, 0);
            return info != null && info.applicationInfo.isVendor();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private boolean isProductApp(String pkg) {
        try {
            PackageInfo info = this.mInterface.getPackageInfo(pkg, 0, 0);
            return info != null && info.applicationInfo.isProduct();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private int runGetPrivappPermissions() {
        String pkg = this.getNextArg();
        if (pkg == null) {
            this.getErrPrintWriter().println("Error: no package specified.");
            return 1;
        }
        ArraySet<String> privAppPermissions = null;
        privAppPermissions = this.isVendorApp(pkg) ? SystemConfig.getInstance().getVendorPrivAppPermissions(pkg) : (this.isProductApp(pkg) ? SystemConfig.getInstance().getProductPrivAppPermissions(pkg) : SystemConfig.getInstance().getPrivAppPermissions(pkg));
        this.getOutPrintWriter().println(privAppPermissions == null ? "{}" : privAppPermissions.toString());
        return 0;
    }

    private int runGetPrivappDenyPermissions() {
        String pkg = this.getNextArg();
        if (pkg == null) {
            this.getErrPrintWriter().println("Error: no package specified.");
            return 1;
        }
        ArraySet<String> privAppPermissions = null;
        privAppPermissions = this.isVendorApp(pkg) ? SystemConfig.getInstance().getVendorPrivAppDenyPermissions(pkg) : (this.isProductApp(pkg) ? SystemConfig.getInstance().getProductPrivAppDenyPermissions(pkg) : SystemConfig.getInstance().getPrivAppDenyPermissions(pkg));
        this.getOutPrintWriter().println(privAppPermissions == null ? "{}" : privAppPermissions.toString());
        return 0;
    }

    private int runGetOemPermissions() {
        String pkg = this.getNextArg();
        if (pkg == null) {
            this.getErrPrintWriter().println("Error: no package specified.");
            return 1;
        }
        Map<String, Boolean> oemPermissions = SystemConfig.getInstance().getOemPermissions(pkg);
        if (oemPermissions == null || oemPermissions.isEmpty()) {
            this.getOutPrintWriter().println("{}");
        } else {
            oemPermissions.forEach((permission2, granted) -> this.getOutPrintWriter().println(permission2 + " granted:" + granted));
        }
        return 0;
    }

    private String linkStateToString(int state) {
        switch (state) {
            case 0: {
                return "undefined";
            }
            case 1: {
                return "ask";
            }
            case 2: {
                return "always";
            }
            case 3: {
                return "never";
            }
            case 4: {
                return "always ask";
            }
        }
        return "Unknown link state: " + state;
    }

    private int runSetAppLink() throws RemoteException {
        int newMode;
        String opt;
        int userId = 0;
        while ((opt = this.getNextOption()) != null) {
            if (opt.equals("--user")) {
                userId = UserHandle.parseUserArg(this.getNextArgRequired());
                continue;
            }
            this.getErrPrintWriter().println("Error: unknown option: " + opt);
            return 1;
        }
        String pkg = this.getNextArg();
        if (pkg == null) {
            this.getErrPrintWriter().println("Error: no package specified.");
            return 1;
        }
        String modeString = this.getNextArg();
        if (modeString == null) {
            this.getErrPrintWriter().println("Error: no app link state specified.");
            return 1;
        }
        switch (modeString.toLowerCase()) {
            case "undefined": {
                newMode = 0;
                break;
            }
            case "always": {
                newMode = 2;
                break;
            }
            case "ask": {
                newMode = 1;
                break;
            }
            case "always-ask": {
                newMode = 4;
                break;
            }
            case "never": {
                newMode = 3;
                break;
            }
            default: {
                this.getErrPrintWriter().println("Error: unknown app link state '" + modeString + "'");
                return 1;
            }
        }
        PackageInfo info = this.mInterface.getPackageInfo(pkg, 0, userId);
        if (info == null) {
            this.getErrPrintWriter().println("Error: package " + pkg + " not found.");
            return 1;
        }
        if ((info.applicationInfo.privateFlags & 0x10) == 0) {
            this.getErrPrintWriter().println("Error: package " + pkg + " does not handle web links.");
            return 1;
        }
        if (!this.mInterface.updateIntentVerificationStatus(pkg, newMode, userId)) {
            this.getErrPrintWriter().println("Error: unable to update app link status for " + pkg);
            return 1;
        }
        return 0;
    }

    private int runGetAppLink() throws RemoteException {
        String opt;
        int userId = 0;
        while ((opt = this.getNextOption()) != null) {
            if (opt.equals("--user")) {
                userId = UserHandle.parseUserArg(this.getNextArgRequired());
                continue;
            }
            this.getErrPrintWriter().println("Error: unknown option: " + opt);
            return 1;
        }
        String pkg = this.getNextArg();
        if (pkg == null) {
            this.getErrPrintWriter().println("Error: no package specified.");
            return 1;
        }
        PackageInfo info = this.mInterface.getPackageInfo(pkg, 0, userId);
        if (info == null) {
            this.getErrPrintWriter().println("Error: package " + pkg + " not found.");
            return 1;
        }
        if ((info.applicationInfo.privateFlags & 0x10) == 0) {
            this.getErrPrintWriter().println("Error: package " + pkg + " does not handle web links.");
            return 1;
        }
        this.getOutPrintWriter().println(this.linkStateToString(this.mInterface.getIntentVerificationStatus(pkg, userId)));
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runTrimCaches() throws RemoteException {
        long sizeVal;
        String size = this.getNextArg();
        if (size == null) {
            this.getErrPrintWriter().println("Error: no size specified");
            return 1;
        }
        long multiplier = 1L;
        int len = size.length();
        char c = size.charAt(len - 1);
        if (c < '0' || c > '9') {
            if (c == 'K' || c == 'k') {
                multiplier = 1024L;
            } else if (c == 'M' || c == 'm') {
                multiplier = 0x100000L;
            } else if (c == 'G' || c == 'g') {
                multiplier = 0x40000000L;
            } else {
                this.getErrPrintWriter().println("Invalid suffix: " + c);
                return 1;
            }
            size = size.substring(0, len - 1);
        }
        try {
            sizeVal = Long.parseLong(size) * multiplier;
        }
        catch (NumberFormatException e) {
            this.getErrPrintWriter().println("Error: expected number at: " + size);
            return 1;
        }
        String volumeUuid = this.getNextArg();
        if ("internal".equals(volumeUuid)) {
            volumeUuid = null;
        }
        ClearDataObserver obs = new ClearDataObserver();
        this.mInterface.freeStorageAndNotify(volumeUuid, sizeVal, 2, obs);
        ClearDataObserver clearDataObserver = obs;
        synchronized (clearDataObserver) {
            while (!obs.finished) {
                try {
                    obs.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return 0;
    }

    private static boolean isNumber(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public int runCreateUser() throws RemoteException {
        UserInfo info;
        String opt;
        int userId = -1;
        int flags = 0;
        while ((opt = this.getNextOption()) != null) {
            if ("--profileOf".equals(opt)) {
                userId = UserHandle.parseUserArg(this.getNextArgRequired());
                continue;
            }
            if ("--managed".equals(opt)) {
                flags |= 0x20;
                continue;
            }
            if ("--restricted".equals(opt)) {
                flags |= 8;
                continue;
            }
            if ("--ephemeral".equals(opt)) {
                flags |= 0x100;
                continue;
            }
            if ("--guest".equals(opt)) {
                flags |= 4;
                continue;
            }
            if ("--demo".equals(opt)) {
                flags |= 0x200;
                continue;
            }
            this.getErrPrintWriter().println("Error: unknown option " + opt);
            return 1;
        }
        String arg = this.getNextArg();
        if (arg == null) {
            this.getErrPrintWriter().println("Error: no user name specified.");
            return 1;
        }
        String name = arg;
        IUserManager um = IUserManager.Stub.asInterface(ServiceManager.getService("user"));
        IAccountManager accm = IAccountManager.Stub.asInterface(ServiceManager.getService("account"));
        if ((flags & 8) != 0) {
            int parentUserId = userId >= 0 ? userId : 0;
            info = um.createRestrictedProfile(name, parentUserId);
            accm.addSharedAccountsFromParentUser(parentUserId, userId, Process.myUid() == 0 ? "root" : "com.android.shell");
        } else {
            info = userId < 0 ? um.createUser(name, flags) : um.createProfileForUser(name, flags, userId, null);
        }
        if (info != null) {
            this.getOutPrintWriter().println("Success: created user id " + info.id);
            return 0;
        }
        this.getErrPrintWriter().println("Error: couldn't create User.");
        return 1;
    }

    public int runRemoveUser() throws RemoteException {
        String arg = this.getNextArg();
        if (arg == null) {
            this.getErrPrintWriter().println("Error: no user id specified.");
            return 1;
        }
        int userId = UserHandle.parseUserArg(arg);
        IUserManager um = IUserManager.Stub.asInterface(ServiceManager.getService("user"));
        if (um.removeUser(userId)) {
            this.getOutPrintWriter().println("Success: removed user");
            return 0;
        }
        this.getErrPrintWriter().println("Error: couldn't remove user id " + userId);
        return 1;
    }

    public int runSetUserRestriction() throws RemoteException {
        boolean value;
        int userId = 0;
        String opt = this.getNextOption();
        if (opt != null && "--user".equals(opt)) {
            userId = UserHandle.parseUserArg(this.getNextArgRequired());
        }
        String restriction = this.getNextArg();
        String arg = this.getNextArg();
        if ("1".equals(arg)) {
            value = true;
        } else if ("0".equals(arg)) {
            value = false;
        } else {
            this.getErrPrintWriter().println("Error: valid value not specified");
            return 1;
        }
        IUserManager um = IUserManager.Stub.asInterface(ServiceManager.getService("user"));
        um.setUserRestriction(restriction, value, userId);
        return 0;
    }

    public int runGetMaxUsers() {
        this.getOutPrintWriter().println("Maximum supported users: " + UserManager.getMaxSupportedUsers());
        return 0;
    }

    public int runGetMaxRunningUsers() {
        ActivityManagerInternal activityManagerInternal = LocalServices.getService(ActivityManagerInternal.class);
        this.getOutPrintWriter().println("Maximum supported running users: " + activityManagerInternal.getMaxRunningUsers());
        return 0;
    }

    private InstallParams makeInstallParams() {
        String opt;
        PackageInstaller.SessionParams sessionParams = new PackageInstaller.SessionParams(1);
        InstallParams params = new InstallParams();
        params.sessionParams = sessionParams;
        boolean replaceExisting = true;
        while ((opt = this.getNextOption()) != null) {
            switch (opt) {
                case "-l": {
                    sessionParams.installFlags |= 1;
                    break;
                }
                case "-r": {
                    break;
                }
                case "-R": {
                    replaceExisting = false;
                    break;
                }
                case "-i": {
                    params.installerPackageName = this.getNextArg();
                    if (params.installerPackageName != null) break;
                    throw new IllegalArgumentException("Missing installer package");
                }
                case "-t": {
                    sessionParams.installFlags |= 4;
                    break;
                }
                case "-s": {
                    sessionParams.installFlags |= 8;
                    break;
                }
                case "-f": {
                    sessionParams.installFlags |= 0x10;
                    break;
                }
                case "-d": {
                    sessionParams.installFlags |= 0x80;
                    break;
                }
                case "-g": {
                    sessionParams.installFlags |= 0x100;
                    break;
                }
                case "--dont-kill": {
                    sessionParams.installFlags |= 0x1000;
                    break;
                }
                case "--originating-uri": {
                    sessionParams.originatingUri = Uri.parse(this.getNextArg());
                    break;
                }
                case "--referrer": {
                    sessionParams.referrerUri = Uri.parse(this.getNextArg());
                    break;
                }
                case "-p": {
                    sessionParams.mode = 2;
                    sessionParams.appPackageName = this.getNextArg();
                    if (sessionParams.appPackageName != null) break;
                    throw new IllegalArgumentException("Missing inherit package name");
                }
                case "--pkg": {
                    sessionParams.appPackageName = this.getNextArg();
                    if (sessionParams.appPackageName != null) break;
                    throw new IllegalArgumentException("Missing package name");
                }
                case "-S": {
                    long sizeBytes = Long.parseLong(this.getNextArg());
                    if (sizeBytes <= 0L) {
                        throw new IllegalArgumentException("Size must be positive");
                    }
                    sessionParams.setSize(sizeBytes);
                    break;
                }
                case "--abi": {
                    sessionParams.abiOverride = PackageManagerShellCommand.checkAbiArgument(this.getNextArg());
                    break;
                }
                case "--ephemeral": 
                case "--instant": 
                case "--instantapp": {
                    sessionParams.setInstallAsInstantApp(true);
                    break;
                }
                case "--full": {
                    sessionParams.setInstallAsInstantApp(false);
                    break;
                }
                case "--preload": {
                    sessionParams.setInstallAsVirtualPreload();
                    break;
                }
                case "--user": {
                    params.userId = UserHandle.parseUserArg(this.getNextArgRequired());
                    break;
                }
                case "--install-location": {
                    sessionParams.installLocation = Integer.parseInt(this.getNextArg());
                    break;
                }
                case "--force-uuid": {
                    sessionParams.installFlags |= 0x200;
                    sessionParams.volumeUuid = this.getNextArg();
                    if (!"internal".equals(sessionParams.volumeUuid)) break;
                    sessionParams.volumeUuid = null;
                    break;
                }
                case "--force-sdk": {
                    sessionParams.installFlags |= 0x2000;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown option " + opt);
                }
            }
            if (!replaceExisting) continue;
            sessionParams.installFlags |= 2;
        }
        return params;
    }

    private int runSetHomeActivity() {
        ComponentName componentName;
        String opt;
        PrintWriter pw = this.getOutPrintWriter();
        int userId = 0;
        block8: while ((opt = this.getNextOption()) != null) {
            switch (opt) {
                case "--user": {
                    userId = UserHandle.parseUserArg(this.getNextArgRequired());
                    continue block8;
                }
            }
            pw.println("Error: Unknown option: " + opt);
            return 1;
        }
        String component = this.getNextArg();
        ComponentName componentName2 = componentName = component != null ? ComponentName.unflattenFromString(component) : null;
        if (componentName == null) {
            pw.println("Error: component name not specified or invalid");
            return 1;
        }
        try {
            this.mInterface.setHomeActivity(componentName, userId);
            pw.println("Success");
            return 0;
        }
        catch (Exception e) {
            pw.println(e.toString());
            return 1;
        }
    }

    private int runSetInstaller() throws RemoteException {
        String targetPackage = this.getNextArg();
        String installerPackageName = this.getNextArg();
        if (targetPackage == null || installerPackageName == null) {
            this.getErrPrintWriter().println("Must provide both target and installer package names");
            return 1;
        }
        this.mInterface.setInstallerPackageName(targetPackage, installerPackageName);
        this.getOutPrintWriter().println("Success");
        return 0;
    }

    private int runGetInstantAppResolver() {
        PrintWriter pw = this.getOutPrintWriter();
        try {
            ComponentName instantAppsResolver = this.mInterface.getInstantAppResolverComponent();
            if (instantAppsResolver == null) {
                return 1;
            }
            pw.println(instantAppsResolver.flattenToString());
            return 0;
        }
        catch (Exception e) {
            pw.println(e.toString());
            return 1;
        }
    }

    private int runHasFeature() {
        PrintWriter err = this.getErrPrintWriter();
        String featureName = this.getNextArg();
        if (featureName == null) {
            err.println("Error: expected FEATURE name");
            return 1;
        }
        String versionString = this.getNextArg();
        try {
            int version = versionString == null ? 0 : Integer.parseInt(versionString);
            boolean hasFeature = this.mInterface.hasSystemFeature(featureName, version);
            this.getOutPrintWriter().println(hasFeature);
            return hasFeature ? 0 : 1;
        }
        catch (NumberFormatException e) {
            err.println("Error: illegal version number " + versionString);
            return 1;
        }
        catch (RemoteException e) {
            err.println(e.toString());
            return 1;
        }
    }

    private int runDump() {
        String pkg = this.getNextArg();
        if (pkg == null) {
            this.getErrPrintWriter().println("Error: no package specified");
            return 1;
        }
        ActivityManager.dumpPackageStateStatic(this.getOutFileDescriptor(), pkg);
        return 0;
    }

    private int runSetHarmfulAppWarning() throws RemoteException {
        String opt;
        int userId = -2;
        while ((opt = this.getNextOption()) != null) {
            if (opt.equals("--user")) {
                userId = UserHandle.parseUserArg(this.getNextArgRequired());
                continue;
            }
            this.getErrPrintWriter().println("Error: Unknown option: " + opt);
            return -1;
        }
        userId = this.translateUserId(userId, false, "runSetHarmfulAppWarning");
        String packageName = this.getNextArgRequired();
        String warning = this.getNextArg();
        this.mInterface.setHarmfulAppWarning(packageName, warning, userId);
        return 0;
    }

    private int runGetHarmfulAppWarning() throws RemoteException {
        String opt;
        int userId = -2;
        while ((opt = this.getNextOption()) != null) {
            if (opt.equals("--user")) {
                userId = UserHandle.parseUserArg(this.getNextArgRequired());
                continue;
            }
            this.getErrPrintWriter().println("Error: Unknown option: " + opt);
            return -1;
        }
        userId = this.translateUserId(userId, false, "runGetHarmfulAppWarning");
        String packageName = this.getNextArgRequired();
        CharSequence warning = this.mInterface.getHarmfulAppWarning(packageName, userId);
        if (!TextUtils.isEmpty(warning)) {
            this.getOutPrintWriter().println(warning);
            return 0;
        }
        return 1;
    }

    private static String checkAbiArgument(String abi) {
        String[] supportedAbis;
        if (TextUtils.isEmpty(abi)) {
            throw new IllegalArgumentException("Missing ABI argument");
        }
        if (STDIN_PATH.equals(abi)) {
            return abi;
        }
        for (String supportedAbi : supportedAbis = Build.SUPPORTED_ABIS) {
            if (!supportedAbi.equals(abi)) continue;
            return abi;
        }
        throw new IllegalArgumentException("ABI " + abi + " not supported on this device");
    }

    private int translateUserId(int userId, boolean allowAll, String logContext) {
        return ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, allowAll, true, logContext, "pm command");
    }

    private int doCreateSession(PackageInstaller.SessionParams params, String installerPackageName, int userId) throws RemoteException {
        if ((userId = this.translateUserId(userId, true, "runInstallCreate")) == -1) {
            userId = 0;
            params.installFlags |= 0x40;
        }
        int sessionId = this.mInterface.getPackageInstaller().createSession(params, installerPackageName, userId);
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doWriteSplit(int sessionId, String inPath, long sizeBytes, String splitName, boolean logSuccess) throws RemoteException {
        int n;
        ParcelFileDescriptor fd;
        PrintWriter pw = this.getOutPrintWriter();
        if (STDIN_PATH.equals(inPath)) {
            fd = new ParcelFileDescriptor(this.getInFileDescriptor());
        } else if (inPath != null) {
            fd = this.openFileForSystem(inPath, "r");
            if (fd == null) {
                return -1;
            }
            sizeBytes = fd.getStatSize();
            if (sizeBytes < 0L) {
                this.getErrPrintWriter().println("Unable to get size of: " + inPath);
                return -1;
            }
        } else {
            fd = new ParcelFileDescriptor(this.getInFileDescriptor());
        }
        if (sizeBytes <= 0L) {
            this.getErrPrintWriter().println("Error: must specify a APK size");
            return 1;
        }
        PackageInstaller.Session session = null;
        try {
            session = new PackageInstaller.Session(this.mInterface.getPackageInstaller().openSession(sessionId));
            session.write(splitName, 0L, sizeBytes, fd);
            if (logSuccess) {
                pw.println("Success: streamed " + sizeBytes + " bytes");
            }
            n = 0;
        }
        catch (IOException e) {
            int n2;
            try {
                this.getErrPrintWriter().println("Error: failed to write; " + e.getMessage());
                n2 = 1;
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(session);
                throw throwable;
            }
            IoUtils.closeQuietly(session);
            return n2;
        }
        IoUtils.closeQuietly(session);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRemoveSplit(int sessionId, String splitName, boolean logSuccess) throws RemoteException {
        int n;
        PrintWriter pw = this.getOutPrintWriter();
        PackageInstaller.Session session = null;
        try {
            session = new PackageInstaller.Session(this.mInterface.getPackageInstaller().openSession(sessionId));
            session.removeSplit(splitName);
            if (logSuccess) {
                pw.println("Success");
            }
            n = 0;
        }
        catch (IOException e) {
            int n2;
            try {
                pw.println("Error: failed to remove split; " + e.getMessage());
                n2 = 1;
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(session);
                throw throwable;
            }
            IoUtils.closeQuietly(session);
            return n2;
        }
        IoUtils.closeQuietly(session);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doCommitSession(int sessionId, boolean logSuccess) throws RemoteException {
        int n;
        PrintWriter pw = this.getOutPrintWriter();
        PackageInstaller.Session session = null;
        try {
            session = new PackageInstaller.Session(this.mInterface.getPackageInstaller().openSession(sessionId));
            try {
                DexMetadataHelper.validateDexPaths(session.getNames());
            }
            catch (IOException | IllegalStateException e) {
                pw.println("Warning [Could not validate the dex paths: " + e.getMessage() + "]");
            }
            LocalIntentReceiver receiver = new LocalIntentReceiver();
            session.commit(receiver.getIntentSender());
            Intent result = receiver.getResult();
            int status = result.getIntExtra("android.content.pm.extra.STATUS", 1);
            if (status == 0) {
                if (logSuccess) {
                    pw.println("Success");
                }
            } else {
                pw.println("Failure [" + result.getStringExtra("android.content.pm.extra.STATUS_MESSAGE") + "]");
            }
            n = status;
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(session);
            throw throwable;
        }
        IoUtils.closeQuietly(session);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doAbandonSession(int sessionId, boolean logSuccess) throws RemoteException {
        int n;
        PrintWriter pw = this.getOutPrintWriter();
        PackageInstaller.Session session = null;
        try {
            session = new PackageInstaller.Session(this.mInterface.getPackageInstaller().openSession(sessionId));
            session.abandon();
            if (logSuccess) {
                pw.println("Success");
            }
            n = 0;
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(session);
            throw throwable;
        }
        IoUtils.closeQuietly(session);
        return n;
    }

    private void doListPermissions(ArrayList<String> groupList, boolean groups, boolean labels, boolean summary, int startProtectionLevel, int endProtectionLevel) throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        int groupCount = groupList.size();
        for (int i = 0; i < groupCount; ++i) {
            String groupName = groupList.get(i);
            String prefix = "";
            if (groups) {
                if (i > 0) {
                    pw.println("");
                }
                if (groupName != null) {
                    PermissionGroupInfo pgi = this.mInterface.getPermissionGroupInfo(groupName, 0);
                    if (summary) {
                        Resources res = this.getResources(pgi);
                        if (res != null) {
                            pw.print(this.loadText(pgi, pgi.labelRes, pgi.nonLocalizedLabel) + ": ");
                        } else {
                            pw.print(pgi.name + ": ");
                        }
                    } else {
                        pw.println((labels ? "+ " : "") + "group:" + pgi.name);
                        if (labels) {
                            pw.println("  package:" + pgi.packageName);
                            Resources res = this.getResources(pgi);
                            if (res != null) {
                                pw.println("  label:" + this.loadText(pgi, pgi.labelRes, pgi.nonLocalizedLabel));
                                pw.println("  description:" + this.loadText(pgi, pgi.descriptionRes, pgi.nonLocalizedDescription));
                            }
                        }
                    }
                } else {
                    pw.println((labels && !summary ? "+ " : "") + "ungrouped:");
                }
                prefix = "  ";
            }
            List ps = this.mInterface.queryPermissionsByGroup(groupList.get(i), 0).getList();
            int count = ps.size();
            boolean first = true;
            for (int p = 0; p < count; ++p) {
                Resources res;
                int base;
                PermissionInfo pi = (PermissionInfo)ps.get(p);
                if (groups && groupName == null && pi.group != null || (base = pi.protectionLevel & 0xF) < startProtectionLevel || base > endProtectionLevel) continue;
                if (summary) {
                    if (first) {
                        first = false;
                    } else {
                        pw.print(", ");
                    }
                    res = this.getResources(pi);
                    if (res != null) {
                        pw.print(this.loadText(pi, pi.labelRes, pi.nonLocalizedLabel));
                        continue;
                    }
                    pw.print(pi.name);
                    continue;
                }
                pw.println(prefix + (labels ? "+ " : "") + "permission:" + pi.name);
                if (!labels) continue;
                pw.println(prefix + "  package:" + pi.packageName);
                res = this.getResources(pi);
                if (res != null) {
                    pw.println(prefix + "  label:" + this.loadText(pi, pi.labelRes, pi.nonLocalizedLabel));
                    pw.println(prefix + "  description:" + this.loadText(pi, pi.descriptionRes, pi.nonLocalizedDescription));
                }
                pw.println(prefix + "  protectionLevel:" + PermissionInfo.protectionToString(pi.protectionLevel));
            }
            if (!summary) continue;
            pw.println("");
        }
    }

    private String loadText(PackageItemInfo pii, int res, CharSequence nonLocalized) throws RemoteException {
        Resources r;
        if (nonLocalized != null) {
            return nonLocalized.toString();
        }
        if (res != 0 && (r = this.getResources(pii)) != null) {
            try {
                return r.getString(res);
            }
            catch (Resources.NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private Resources getResources(PackageItemInfo pii) throws RemoteException {
        Resources res = this.mResourceCache.get(pii.packageName);
        if (res != null) {
            return res;
        }
        ApplicationInfo ai = this.mInterface.getApplicationInfo(pii.packageName, 0, 0);
        AssetManager am = new AssetManager();
        am.addAssetPath(ai.publicSourceDir);
        res = new Resources(am, null, null);
        this.mResourceCache.put(pii.packageName, res);
        return res;
    }

    @Override
    public void onHelp() {
        PrintWriter pw = this.getOutPrintWriter();
        pw.println("Package manager (package) commands:");
        pw.println("  help");
        pw.println("    Print this help text.");
        pw.println("");
        pw.println("  path [--user USER_ID] PACKAGE");
        pw.println("    Print the path to the .apk of the given PACKAGE.");
        pw.println("");
        pw.println("  dump PACKAGE");
        pw.println("    Print various system state associated with the given PACKAGE.");
        pw.println("");
        pw.println("  list features");
        pw.println("    Prints all features of the system.");
        pw.println("");
        pw.println("  has-feature FEATURE_NAME [version]");
        pw.println("    Prints true and returns exit status 0 when system has a FEATURE_NAME,");
        pw.println("    otherwise prints false and returns exit status 1");
        pw.println("");
        pw.println("  list instrumentation [-f] [TARGET-PACKAGE]");
        pw.println("    Prints all test packages; optionally only those targeting TARGET-PACKAGE");
        pw.println("    Options:");
        pw.println("      -f: dump the name of the .apk file containing the test package");
        pw.println("");
        pw.println("  list libraries");
        pw.println("    Prints all system libraries.");
        pw.println("");
        pw.println("  list packages [-f] [-d] [-e] [-s] [-3] [-i] [-l] [-u] [-U] ");
        pw.println("      [--uid UID] [--user USER_ID] [FILTER]");
        pw.println("    Prints all packages; optionally only those whose name contains");
        pw.println("    the text in FILTER.  Options are:");
        pw.println("      -f: see their associated file");
        pw.println("      -d: filter to only show disabled packages");
        pw.println("      -e: filter to only show enabled packages");
        pw.println("      -s: filter to only show system packages");
        pw.println("      -3: filter to only show third party packages");
        pw.println("      -i: see the installer for the packages");
        pw.println("      -l: ignored (used for compatibility with older releases)");
        pw.println("      -U: also show the package UID");
        pw.println("      -u: also include uninstalled packages");
        pw.println("      --uid UID: filter to only show packages with the given UID");
        pw.println("      --user USER_ID: only list packages belonging to the given user");
        pw.println("");
        pw.println("  list permission-groups");
        pw.println("    Prints all known permission groups.");
        pw.println("");
        pw.println("  list permissions [-g] [-f] [-d] [-u] [GROUP]");
        pw.println("    Prints all known permissions; optionally only those in GROUP.  Options are:");
        pw.println("      -g: organize by group");
        pw.println("      -f: print all information");
        pw.println("      -s: short summary");
        pw.println("      -d: only list dangerous permissions");
        pw.println("      -u: list only the permissions users will see");
        pw.println("");
        pw.println("  resolve-activity [--brief] [--components] [--user USER_ID] INTENT");
        pw.println("    Prints the activity that resolves to the given INTENT.");
        pw.println("");
        pw.println("  query-activities [--brief] [--components] [--user USER_ID] INTENT");
        pw.println("    Prints all activities that can handle the given INTENT.");
        pw.println("");
        pw.println("  query-services [--brief] [--components] [--user USER_ID] INTENT");
        pw.println("    Prints all services that can handle the given INTENT.");
        pw.println("");
        pw.println("  query-receivers [--brief] [--components] [--user USER_ID] INTENT");
        pw.println("    Prints all broadcast receivers that can handle the given INTENT.");
        pw.println("");
        pw.println("  install [-lrtsfdg] [-i PACKAGE] [--user USER_ID|all|current]");
        pw.println("       [-p INHERIT_PACKAGE] [--install-location 0/1/2]");
        pw.println("       [--originating-uri URI] [---referrer URI]");
        pw.println("       [--abi ABI_NAME] [--force-sdk]");
        pw.println("       [--preload] [--instantapp] [--full] [--dont-kill]");
        pw.println("       [--force-uuid internal|UUID] [--pkg PACKAGE] [-S BYTES] [PATH|-]");
        pw.println("    Install an application.  Must provide the apk data to install, either as a");
        pw.println("    file path or '-' to read from stdin.  Options are:");
        pw.println("      -l: forward lock application");
        pw.println("      -R: disallow replacement of existing application");
        pw.println("      -t: allow test packages");
        pw.println("      -i: specify package name of installer owning the app");
        pw.println("      -s: install application on sdcard");
        pw.println("      -f: install application on internal flash");
        pw.println("      -d: allow version code downgrade (debuggable packages only)");
        pw.println("      -p: partial application install (new split on top of existing pkg)");
        pw.println("      -g: grant all runtime permissions");
        pw.println("      -S: size in bytes of package, required for stdin");
        pw.println("      --user: install under the given user.");
        pw.println("      --dont-kill: installing a new feature split, don't kill running app");
        pw.println("      --originating-uri: set URI where app was downloaded from");
        pw.println("      --referrer: set URI that instigated the install of the app");
        pw.println("      --pkg: specify expected package name of app being installed");
        pw.println("      --abi: override the default ABI of the platform");
        pw.println("      --instantapp: cause the app to be installed as an ephemeral install app");
        pw.println("      --full: cause the app to be installed as a non-ephemeral full app");
        pw.println("      --install-location: force the install location:");
        pw.println("          0=auto, 1=internal only, 2=prefer external");
        pw.println("      --force-uuid: force install on to disk volume with given UUID");
        pw.println("      --force-sdk: allow install even when existing app targets platform");
        pw.println("          codename but new one targets a final API level");
        pw.println("");
        pw.println("  install-create [-lrtsfdg] [-i PACKAGE] [--user USER_ID|all|current]");
        pw.println("       [-p INHERIT_PACKAGE] [--install-location 0/1/2]");
        pw.println("       [--originating-uri URI] [---referrer URI]");
        pw.println("       [--abi ABI_NAME] [--force-sdk]");
        pw.println("       [--preload] [--instantapp] [--full] [--dont-kill]");
        pw.println("       [--force-uuid internal|UUID] [--pkg PACKAGE] [-S BYTES]");
        pw.println("    Like \"install\", but starts an install session.  Use \"install-write\"");
        pw.println("    to push data into the session, and \"install-commit\" to finish.");
        pw.println("");
        pw.println("  install-write [-S BYTES] SESSION_ID SPLIT_NAME [PATH|-]");
        pw.println("    Write an apk into the given install session.  If the path is '-', data");
        pw.println("    will be read from stdin.  Options are:");
        pw.println("      -S: size in bytes of package, required for stdin");
        pw.println("");
        pw.println("  install-commit SESSION_ID");
        pw.println("    Commit the given active install session, installing the app.");
        pw.println("");
        pw.println("  install-abandon SESSION_ID");
        pw.println("    Delete the given active install session.");
        pw.println("");
        pw.println("  set-install-location LOCATION");
        pw.println("    Changes the default install location.  NOTE this is only intended for debugging;");
        pw.println("    using this can cause applications to break and other undersireable behavior.");
        pw.println("    LOCATION is one of:");
        pw.println("    0 [auto]: Let system decide the best location");
        pw.println("    1 [internal]: Install on internal device storage");
        pw.println("    2 [external]: Install on external media");
        pw.println("");
        pw.println("  get-install-location");
        pw.println("    Returns the current install location: 0, 1 or 2 as per set-install-location.");
        pw.println("");
        pw.println("  move-package PACKAGE [internal|UUID]");
        pw.println("");
        pw.println("  move-primary-storage [internal|UUID]");
        pw.println("");
        pw.println("  pm uninstall [-k] [--user USER_ID] [--versionCode VERSION_CODE] PACKAGE [SPLIT]");
        pw.println("    Remove the given package name from the system.  May remove an entire app");
        pw.println("    if no SPLIT name is specified, otherwise will remove only the split of the");
        pw.println("    given app.  Options are:");
        pw.println("      -k: keep the data and cache directories around after package removal.");
        pw.println("      --user: remove the app from the given user.");
        pw.println("      --versionCode: only uninstall if the app has the given version code.");
        pw.println("");
        pw.println("  clear [--user USER_ID] PACKAGE");
        pw.println("    Deletes all data associated with a package.");
        pw.println("");
        pw.println("  enable [--user USER_ID] PACKAGE_OR_COMPONENT");
        pw.println("  disable [--user USER_ID] PACKAGE_OR_COMPONENT");
        pw.println("  disable-user [--user USER_ID] PACKAGE_OR_COMPONENT");
        pw.println("  disable-until-used [--user USER_ID] PACKAGE_OR_COMPONENT");
        pw.println("  default-state [--user USER_ID] PACKAGE_OR_COMPONENT");
        pw.println("    These commands change the enabled state of a given package or");
        pw.println("    component (written as \"package/class\").");
        pw.println("");
        pw.println("  hide [--user USER_ID] PACKAGE_OR_COMPONENT");
        pw.println("  unhide [--user USER_ID] PACKAGE_OR_COMPONENT");
        pw.println("");
        pw.println("  suspend [--user USER_ID] TARGET-PACKAGE");
        pw.println("    Suspends the specified package (as user).");
        pw.println("");
        pw.println("  unsuspend [--user USER_ID] TARGET-PACKAGE");
        pw.println("    Unsuspends the specified package (as user).");
        pw.println("");
        pw.println("  grant [--user USER_ID] PACKAGE PERMISSION");
        pw.println("  revoke [--user USER_ID] PACKAGE PERMISSION");
        pw.println("    These commands either grant or revoke permissions to apps.  The permissions");
        pw.println("    must be declared as used in the app's manifest, be runtime permissions");
        pw.println("    (protection level dangerous), and the app targeting SDK greater than Lollipop MR1.");
        pw.println("");
        pw.println("  reset-permissions");
        pw.println("    Revert all runtime permissions to their default state.");
        pw.println("");
        pw.println("  set-permission-enforced PERMISSION [true|false]");
        pw.println("");
        pw.println("  get-privapp-permissions TARGET-PACKAGE");
        pw.println("    Prints all privileged permissions for a package.");
        pw.println("");
        pw.println("  get-privapp-deny-permissions TARGET-PACKAGE");
        pw.println("    Prints all privileged permissions that are denied for a package.");
        pw.println("");
        pw.println("  get-oem-permissions TARGET-PACKAGE");
        pw.println("    Prints all OEM permissions for a package.");
        pw.println("");
        pw.println("  set-app-link [--user USER_ID] PACKAGE {always|ask|never|undefined}");
        pw.println("  get-app-link [--user USER_ID] PACKAGE");
        pw.println("");
        pw.println("  trim-caches DESIRED_FREE_SPACE [internal|UUID]");
        pw.println("    Trim cache files to reach the given free space.");
        pw.println("");
        pw.println("  create-user [--profileOf USER_ID] [--managed] [--restricted] [--ephemeral]");
        pw.println("      [--guest] USER_NAME");
        pw.println("    Create a new user with the given USER_NAME, printing the new user identifier");
        pw.println("    of the user.");
        pw.println("");
        pw.println("  remove-user USER_ID");
        pw.println("    Remove the user with the given USER_IDENTIFIER, deleting all data");
        pw.println("    associated with that user");
        pw.println("");
        pw.println("  set-user-restriction [--user USER_ID] RESTRICTION VALUE");
        pw.println("");
        pw.println("  get-max-users");
        pw.println("");
        pw.println("  get-max-running-users");
        pw.println("");
        pw.println("  compile [-m MODE | -r REASON] [-f] [-c] [--split SPLIT_NAME]");
        pw.println("          [--reset] [--check-prof (true | false)] (-a | TARGET-PACKAGE)");
        pw.println("    Trigger compilation of TARGET-PACKAGE or all packages if \"-a\".  Options are:");
        pw.println("      -a: compile all packages");
        pw.println("      -c: clear profile data before compiling");
        pw.println("      -f: force compilation even if not needed");
        pw.println("      -m: select compilation mode");
        pw.println("          MODE is one of the dex2oat compiler filters:");
        pw.println("            assume-verified");
        pw.println("            extract");
        pw.println("            verify");
        pw.println("            quicken");
        pw.println("            space-profile");
        pw.println("            space");
        pw.println("            speed-profile");
        pw.println("            speed");
        pw.println("            everything");
        pw.println("      -r: select compilation reason");
        pw.println("          REASON is one of:");
        for (int i = 0; i < PackageManagerServiceCompilerMapping.REASON_STRINGS.length; ++i) {
            pw.println("            " + PackageManagerServiceCompilerMapping.REASON_STRINGS[i]);
        }
        pw.println("      --reset: restore package to its post-install state");
        pw.println("      --check-prof (true | false): look at profiles when doing dexopt?");
        pw.println("      --secondary-dex: compile app secondary dex files");
        pw.println("      --split SPLIT: compile only the given split name");
        pw.println("");
        pw.println("  force-dex-opt PACKAGE");
        pw.println("    Force immediate execution of dex opt for the given PACKAGE.");
        pw.println("");
        pw.println("  bg-dexopt-job");
        pw.println("    Execute the background optimizations immediately.");
        pw.println("    Note that the command only runs the background optimizer logic. It may");
        pw.println("    overlap with the actual job but the job scheduler will not be able to");
        pw.println("    cancel it. It will also run even if the device is not in the idle");
        pw.println("    maintenance mode.");
        pw.println("");
        pw.println("  reconcile-secondary-dex-files TARGET-PACKAGE");
        pw.println("    Reconciles the package secondary dex files with the generated oat files.");
        pw.println("");
        pw.println("  dump-profiles TARGET-PACKAGE");
        pw.println("    Dumps method/class profile files to");
        pw.println("    /data/misc/profman/TARGET-PACKAGE.txt");
        pw.println("");
        pw.println("  set-home-activity [--user USER_ID] TARGET-COMPONENT");
        pw.println("    Set the default home activity (aka launcher).");
        pw.println("");
        pw.println("  set-installer PACKAGE INSTALLER");
        pw.println("    Set installer package name");
        pw.println("");
        pw.println("  get-instantapp-resolver");
        pw.println("    Return the name of the component that is the current instant app installer.");
        pw.println("");
        pw.println("  set-harmful-app-warning [--user <USER_ID>] <PACKAGE> [<WARNING>]");
        pw.println("    Mark the app as harmful with the given warning message.");
        pw.println("");
        pw.println("  get-harmful-app-warning [--user <USER_ID>] <PACKAGE>");
        pw.println("    Return the harmful app warning message for the given app, if present");
        pw.println();
        Intent.printIntentArgsHelp(pw, "");
    }

    private static class LocalIntentReceiver {
        private final SynchronousQueue<Intent> mResult = new SynchronousQueue();
        private IIntentSender.Stub mLocalSender = new IIntentSender.Stub(){

            @Override
            public void send(int code, Intent intent, String resolvedType, IBinder whitelistToken, IIntentReceiver finishedReceiver, String requiredPermission, Bundle options) {
                try {
                    mResult.offer(intent, 5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };

        private LocalIntentReceiver() {
        }

        public IntentSender getIntentSender() {
            return new IntentSender(this.mLocalSender);
        }

        public Intent getResult() {
            try {
                return this.mResult.take();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class InstallParams {
        PackageInstaller.SessionParams sessionParams;
        String installerPackageName;
        int userId = -1;

        private InstallParams() {
        }
    }

    static class ClearDataObserver
    extends IPackageDataObserver.Stub {
        boolean finished;
        boolean result;

        ClearDataObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoveCompleted(String packageName, boolean succeeded) throws RemoteException {
            ClearDataObserver clearDataObserver = this;
            synchronized (clearDataObserver) {
                this.finished = true;
                this.result = succeeded;
                this.notifyAll();
            }
        }
    }
}

