/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageInfo;
import android.content.pm.ShortcutInfo;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.pm.ShortcutPackage;
import com.android.server.pm.ShortcutPackageInfo;
import com.android.server.pm.ShortcutPackageItem;
import com.android.server.pm.ShortcutService;
import com.android.server.pm.ShortcutUser;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class ShortcutLauncher
extends ShortcutPackageItem {
    private static final String TAG = "ShortcutService";
    static final String TAG_ROOT = "launcher-pins";
    private static final String TAG_PACKAGE = "package";
    private static final String TAG_PIN = "pin";
    private static final String ATTR_LAUNCHER_USER_ID = "launcher-user";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_PACKAGE_NAME = "package-name";
    private static final String ATTR_PACKAGE_USER_ID = "package-user";
    private final int mOwnerUserId;
    private final ArrayMap<ShortcutUser.PackageWithUser, ArraySet<String>> mPinnedShortcuts = new ArrayMap();

    private ShortcutLauncher(ShortcutUser shortcutUser, int ownerUserId, String packageName, int launcherUserId, ShortcutPackageInfo spi) {
        super(shortcutUser, launcherUserId, packageName, spi != null ? spi : ShortcutPackageInfo.newEmpty());
        this.mOwnerUserId = ownerUserId;
    }

    public ShortcutLauncher(ShortcutUser shortcutUser, int ownerUserId, String packageName, int launcherUserId) {
        this(shortcutUser, ownerUserId, packageName, launcherUserId, null);
    }

    @Override
    public int getOwnerUserId() {
        return this.mOwnerUserId;
    }

    @Override
    protected boolean canRestoreAnyVersion() {
        return true;
    }

    private void onRestoreBlocked() {
        ArrayList<ShortcutUser.PackageWithUser> pinnedPackages = new ArrayList<ShortcutUser.PackageWithUser>(this.mPinnedShortcuts.keySet());
        this.mPinnedShortcuts.clear();
        for (int i = pinnedPackages.size() - 1; i >= 0; --i) {
            ShortcutUser.PackageWithUser pu = pinnedPackages.get(i);
            ShortcutPackage p = this.mShortcutUser.getPackageShortcutsIfExists(pu.packageName);
            if (p == null) continue;
            p.refreshPinnedFlags();
        }
    }

    @Override
    protected void onRestored(int restoreBlockReason) {
        if (restoreBlockReason != 0) {
            this.onRestoreBlocked();
        }
    }

    public void pinShortcuts(int packageUserId, String packageName, List<String> ids, boolean forPinRequest) {
        ShortcutPackage packageShortcuts = this.mShortcutUser.getPackageShortcutsIfExists(packageName);
        if (packageShortcuts == null) {
            return;
        }
        ShortcutUser.PackageWithUser pu = ShortcutUser.PackageWithUser.of(packageUserId, packageName);
        int idSize = ids.size();
        if (idSize == 0) {
            this.mPinnedShortcuts.remove(pu);
        } else {
            ArraySet<String> prevSet = this.mPinnedShortcuts.get(pu);
            ArraySet<String> newSet = new ArraySet<String>();
            for (int i = 0; i < idSize; ++i) {
                String id2 = ids.get(i);
                ShortcutInfo si = packageShortcuts.findShortcutById(id2);
                if (si == null || !si.isDynamic() && !si.isManifestShortcut() && (prevSet == null || !prevSet.contains(id2)) && !forPinRequest) continue;
                newSet.add(id2);
            }
            this.mPinnedShortcuts.put(pu, newSet);
        }
        packageShortcuts.refreshPinnedFlags();
    }

    public ArraySet<String> getPinnedShortcutIds(String packageName, int packageUserId) {
        return this.mPinnedShortcuts.get(ShortcutUser.PackageWithUser.of(packageUserId, packageName));
    }

    public boolean hasPinned(ShortcutInfo shortcut) {
        ArraySet<String> pinned = this.getPinnedShortcutIds(shortcut.getPackage(), shortcut.getUserId());
        return pinned != null && pinned.contains(shortcut.getId());
    }

    public void addPinnedShortcut(String packageName, int packageUserId, String id2, boolean forPinRequest) {
        ArrayList<String> pinnedList;
        ArraySet<String> pinnedSet = this.getPinnedShortcutIds(packageName, packageUserId);
        if (pinnedSet != null) {
            pinnedList = new ArrayList(pinnedSet.size() + 1);
            pinnedList.addAll(pinnedSet);
        } else {
            pinnedList = new ArrayList<String>(1);
        }
        pinnedList.add(id2);
        this.pinShortcuts(packageUserId, packageName, pinnedList, forPinRequest);
    }

    boolean cleanUpPackage(String packageName, int packageUserId) {
        return this.mPinnedShortcuts.remove(ShortcutUser.PackageWithUser.of(packageUserId, packageName)) != null;
    }

    public void ensurePackageInfo() {
        PackageInfo pi = this.mShortcutUser.mService.getPackageInfoWithSignatures(this.getPackageName(), this.getPackageUserId());
        if (pi == null) {
            Slog.w(TAG, "Package not found: " + this.getPackageName());
            return;
        }
        this.getPackageInfo().updateFromPackageInfo(pi);
    }

    @Override
    public void saveToXml(XmlSerializer out, boolean forBackup) throws IOException {
        if (forBackup && !this.getPackageInfo().isBackupAllowed()) {
            return;
        }
        int size = this.mPinnedShortcuts.size();
        if (size == 0) {
            return;
        }
        out.startTag(null, TAG_ROOT);
        ShortcutService.writeAttr(out, ATTR_PACKAGE_NAME, this.getPackageName());
        ShortcutService.writeAttr(out, ATTR_LAUNCHER_USER_ID, this.getPackageUserId());
        this.getPackageInfo().saveToXml(out, forBackup);
        for (int i = 0; i < size; ++i) {
            ShortcutUser.PackageWithUser pu = this.mPinnedShortcuts.keyAt(i);
            if (forBackup && pu.userId != this.getOwnerUserId()) continue;
            out.startTag(null, TAG_PACKAGE);
            ShortcutService.writeAttr(out, ATTR_PACKAGE_NAME, pu.packageName);
            ShortcutService.writeAttr(out, ATTR_PACKAGE_USER_ID, pu.userId);
            ArraySet<String> ids = this.mPinnedShortcuts.valueAt(i);
            int idSize = ids.size();
            for (int j = 0; j < idSize; ++j) {
                ShortcutService.writeTagValue(out, TAG_PIN, ids.valueAt(j));
            }
            out.endTag(null, TAG_PACKAGE);
        }
        out.endTag(null, TAG_ROOT);
    }

    public static ShortcutLauncher loadFromXml(XmlPullParser parser, ShortcutUser shortcutUser, int ownerUserId, boolean fromBackup) throws IOException, XmlPullParserException {
        int type;
        String launcherPackageName = ShortcutService.parseStringAttribute(parser, ATTR_PACKAGE_NAME);
        int launcherUserId = fromBackup ? ownerUserId : ShortcutService.parseIntAttribute(parser, ATTR_LAUNCHER_USER_ID, ownerUserId);
        ShortcutLauncher ret = new ShortcutLauncher(shortcutUser, ownerUserId, launcherPackageName, launcherUserId);
        ArraySet<String> ids = null;
        int outerDepth = parser.getDepth();
        block14: while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type != 2) continue;
            int depth = parser.getDepth();
            String tag = parser.getName();
            if (depth == outerDepth + 1) {
                switch (tag) {
                    case "package-info": {
                        ret.getPackageInfo().loadFromXml(parser, fromBackup);
                        continue block14;
                    }
                    case "package": {
                        String packageName = ShortcutService.parseStringAttribute(parser, ATTR_PACKAGE_NAME);
                        int packageUserId = fromBackup ? ownerUserId : ShortcutService.parseIntAttribute(parser, ATTR_PACKAGE_USER_ID, ownerUserId);
                        ids = new ArraySet<String>();
                        ret.mPinnedShortcuts.put(ShortcutUser.PackageWithUser.of(packageUserId, packageName), ids);
                        continue block14;
                    }
                }
            }
            if (depth == outerDepth + 2) {
                switch (tag) {
                    case "pin": {
                        if (ids == null) {
                            Slog.w(TAG, "pin in invalid place");
                            continue block14;
                        }
                        ids.add(ShortcutService.parseStringAttribute(parser, ATTR_VALUE));
                        continue block14;
                    }
                }
            }
            ShortcutService.warnForInvalidTag(depth, tag);
        }
        return ret;
    }

    public void dump(PrintWriter pw, String prefix, ShortcutService.DumpFilter filter) {
        pw.println();
        pw.print(prefix);
        pw.print("Launcher: ");
        pw.print(this.getPackageName());
        pw.print("  Package user: ");
        pw.print(this.getPackageUserId());
        pw.print("  Owner user: ");
        pw.print(this.getOwnerUserId());
        pw.println();
        this.getPackageInfo().dump(pw, prefix + "  ");
        pw.println();
        int size = this.mPinnedShortcuts.size();
        for (int i = 0; i < size; ++i) {
            pw.println();
            ShortcutUser.PackageWithUser pu = this.mPinnedShortcuts.keyAt(i);
            pw.print(prefix);
            pw.print("  ");
            pw.print("Package: ");
            pw.print(pu.packageName);
            pw.print("  User: ");
            pw.println(pu.userId);
            ArraySet<String> ids = this.mPinnedShortcuts.valueAt(i);
            int idSize = ids.size();
            for (int j = 0; j < idSize; ++j) {
                pw.print(prefix);
                pw.print("    Pinned: ");
                pw.print(ids.valueAt(j));
                pw.println();
            }
        }
    }

    @Override
    public JSONObject dumpCheckin(boolean clear) throws JSONException {
        JSONObject result = super.dumpCheckin(clear);
        return result;
    }

    @VisibleForTesting
    ArraySet<String> getAllPinnedShortcutsForTest(String packageName, int packageUserId) {
        return new ArraySet<String>(this.mPinnedShortcuts.get(ShortcutUser.PackageWithUser.of(packageUserId, packageName)));
    }
}

