/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.Context;
import android.content.pm.UserInfo;
import android.os.Environment;
import android.os.FileUtils;
import android.os.storage.StorageManager;
import android.os.storage.VolumeInfo;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.pm.Installer;
import com.android.server.pm.PackageManagerServiceUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

class UserDataPreparer {
    private static final String TAG = "UserDataPreparer";
    private static final String XATTR_SERIAL = "user.serial";
    private final Object mInstallLock;
    private final Context mContext;
    private final boolean mOnlyCore;
    private final Installer mInstaller;

    UserDataPreparer(Installer installer, Object installLock, Context context, boolean onlyCore) {
        this.mInstallLock = installLock;
        this.mContext = context;
        this.mOnlyCore = onlyCore;
        this.mInstaller = installer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareUserData(int userId, int userSerial, int flags) {
        Object object = this.mInstallLock;
        synchronized (object) {
            StorageManager storage = this.mContext.getSystemService(StorageManager.class);
            for (VolumeInfo vol : storage.getWritablePrivateVolumes()) {
                String volumeUuid = vol.getFsUuid();
                this.prepareUserDataLI(volumeUuid, userId, userSerial, flags, true);
            }
        }
    }

    private void prepareUserDataLI(String volumeUuid, int userId, int userSerial, int flags, boolean allowRecover) {
        block6: {
            StorageManager storage = this.mContext.getSystemService(StorageManager.class);
            try {
                storage.prepareUserStorage(volumeUuid, userId, userSerial, flags);
                if ((flags & 1) != 0 && !this.mOnlyCore) {
                    this.enforceSerialNumber(this.getDataUserDeDirectory(volumeUuid, userId), userSerial);
                    if (Objects.equals(volumeUuid, StorageManager.UUID_PRIVATE_INTERNAL)) {
                        this.enforceSerialNumber(this.getDataSystemDeDirectory(userId), userSerial);
                    }
                }
                if ((flags & 2) != 0 && !this.mOnlyCore) {
                    this.enforceSerialNumber(this.getDataUserCeDirectory(volumeUuid, userId), userSerial);
                    if (Objects.equals(volumeUuid, StorageManager.UUID_PRIVATE_INTERNAL)) {
                        this.enforceSerialNumber(this.getDataSystemCeDirectory(userId), userSerial);
                    }
                }
                this.mInstaller.createUserData(volumeUuid, userId, userSerial, flags);
            }
            catch (Exception e) {
                PackageManagerServiceUtils.logCriticalInfo(5, "Destroying user " + userId + " on volume " + volumeUuid + " because we failed to prepare: " + e);
                this.destroyUserDataLI(volumeUuid, userId, flags);
                if (!allowRecover) break block6;
                this.prepareUserDataLI(volumeUuid, userId, userSerial, flags, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyUserData(int userId, int flags) {
        Object object = this.mInstallLock;
        synchronized (object) {
            StorageManager storage = this.mContext.getSystemService(StorageManager.class);
            for (VolumeInfo vol : storage.getWritablePrivateVolumes()) {
                String volumeUuid = vol.getFsUuid();
                this.destroyUserDataLI(volumeUuid, userId, flags);
            }
        }
    }

    void destroyUserDataLI(String volumeUuid, int userId, int flags) {
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        try {
            this.mInstaller.destroyUserData(volumeUuid, userId, flags);
            if (Objects.equals(volumeUuid, StorageManager.UUID_PRIVATE_INTERNAL)) {
                if ((flags & 1) != 0) {
                    FileUtils.deleteContentsAndDir(this.getUserSystemDirectory(userId));
                    FileUtils.deleteContentsAndDir(this.getDataSystemDeDirectory(userId));
                }
                if ((flags & 2) != 0) {
                    FileUtils.deleteContentsAndDir(this.getDataSystemCeDirectory(userId));
                }
            }
            storage.destroyUserStorage(volumeUuid, userId, flags);
        }
        catch (Exception e) {
            PackageManagerServiceUtils.logCriticalInfo(5, "Failed to destroy user " + userId + " on volume " + volumeUuid + ": " + e);
        }
    }

    void reconcileUsers(String volumeUuid, List<UserInfo> validUsersList) {
        ArrayList<File> files = new ArrayList<File>();
        Collections.addAll(files, FileUtils.listFilesOrEmpty(Environment.getDataUserDeDirectory(volumeUuid)));
        Collections.addAll(files, FileUtils.listFilesOrEmpty(Environment.getDataUserCeDirectory(volumeUuid)));
        Collections.addAll(files, FileUtils.listFilesOrEmpty(Environment.getDataSystemDeDirectory()));
        Collections.addAll(files, FileUtils.listFilesOrEmpty(Environment.getDataSystemCeDirectory()));
        Collections.addAll(files, FileUtils.listFilesOrEmpty(Environment.getDataMiscCeDirectory()));
        this.reconcileUsers(volumeUuid, validUsersList, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void reconcileUsers(String volumeUuid, List<UserInfo> validUsersList, List<File> files) {
        int userCount = validUsersList.size();
        SparseArray<UserInfo> users = new SparseArray<UserInfo>(userCount);
        for (int i = 0; i < userCount; ++i) {
            UserInfo user = validUsersList.get(i);
            users.put(user.id, user);
        }
        for (File file : files) {
            UserInfo info;
            int userId;
            if (!file.isDirectory()) continue;
            try {
                userId = Integer.parseInt(file.getName());
                info = (UserInfo)users.get(userId);
            }
            catch (NumberFormatException e) {
                Slog.w(TAG, "Invalid user directory " + file);
                continue;
            }
            boolean destroyUser = false;
            if (info == null) {
                PackageManagerServiceUtils.logCriticalInfo(5, "Destroying user directory " + file + " because no matching user was found");
                destroyUser = true;
            } else if (!this.mOnlyCore) {
                try {
                    this.enforceSerialNumber(file, info.serialNumber);
                }
                catch (IOException e) {
                    PackageManagerServiceUtils.logCriticalInfo(5, "Destroying user directory " + file + " because we failed to enforce serial number: " + e);
                    destroyUser = true;
                }
            }
            if (!destroyUser) continue;
            Object object = this.mInstallLock;
            synchronized (object) {
                this.destroyUserDataLI(volumeUuid, userId, 3);
            }
        }
    }

    @VisibleForTesting
    protected File getDataMiscCeDirectory(int userId) {
        return Environment.getDataMiscCeDirectory(userId);
    }

    @VisibleForTesting
    protected File getDataSystemCeDirectory(int userId) {
        return Environment.getDataSystemCeDirectory(userId);
    }

    @VisibleForTesting
    protected File getDataMiscDeDirectory(int userId) {
        return Environment.getDataMiscDeDirectory(userId);
    }

    @VisibleForTesting
    protected File getUserSystemDirectory(int userId) {
        return Environment.getUserSystemDirectory(userId);
    }

    @VisibleForTesting
    protected File getDataUserCeDirectory(String volumeUuid, int userId) {
        return Environment.getDataUserCeDirectory(volumeUuid, userId);
    }

    @VisibleForTesting
    protected File getDataSystemDeDirectory(int userId) {
        return Environment.getDataSystemDeDirectory(userId);
    }

    @VisibleForTesting
    protected File getDataUserDeDirectory(String volumeUuid, int userId) {
        return Environment.getDataUserDeDirectory(volumeUuid, userId);
    }

    @VisibleForTesting
    protected boolean isFileEncryptedEmulatedOnly() {
        return StorageManager.isFileEncryptedEmulatedOnly();
    }

    void enforceSerialNumber(File file, int serialNumber) throws IOException {
        if (this.isFileEncryptedEmulatedOnly()) {
            Slog.w(TAG, "Device is emulating FBE; assuming current serial number is valid");
            return;
        }
        int foundSerial = UserDataPreparer.getSerialNumber(file);
        Slog.v(TAG, "Found " + file + " with serial number " + foundSerial);
        if (foundSerial == -1) {
            Slog.d(TAG, "Serial number missing on " + file + "; assuming current is valid");
            try {
                UserDataPreparer.setSerialNumber(file, serialNumber);
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed to set serial number on " + file, e);
            }
        } else if (foundSerial != serialNumber) {
            throw new IOException("Found serial number " + foundSerial + " doesn't match expected " + serialNumber);
        }
    }

    private static void setSerialNumber(File file, int serialNumber) throws IOException {
        try {
            byte[] buf = Integer.toString(serialNumber).getBytes(StandardCharsets.UTF_8);
            Os.setxattr(file.getAbsolutePath(), XATTR_SERIAL, buf, OsConstants.XATTR_CREATE);
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    @VisibleForTesting
    static int getSerialNumber(File file) throws IOException {
        try {
            byte[] buf = Os.getxattr(file.getAbsolutePath(), XATTR_SERIAL);
            String serial = new String(buf);
            try {
                return Integer.parseInt(serial);
            }
            catch (NumberFormatException e) {
                throw new IOException("Bad serial number: " + serial);
            }
        }
        catch (ErrnoException e) {
            if (e.errno == OsConstants.ENODATA) {
                return -1;
            }
            throw e.rethrowAsIOException();
        }
    }
}

