/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm.dex;

import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageParser;
import android.content.pm.dex.ArtManager;
import android.content.pm.dex.DexMetadataHelper;
import android.content.pm.dex.IArtManager;
import android.content.pm.dex.ISnapshotRuntimeProfileCallback;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.system.Os;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import com.android.server.pm.Installer;
import java.io.File;
import java.io.FileNotFoundException;
import libcore.io.IoUtils;

public class ArtManagerService
extends IArtManager.Stub {
    private static final String TAG = "ArtManagerService";
    private static boolean DEBUG = false;
    private static boolean DEBUG_IGNORE_PERMISSIONS = false;
    private static final String BOOT_IMAGE_ANDROID_PACKAGE = "android";
    private static final String BOOT_IMAGE_PROFILE_NAME = "android.prof";
    private final IPackageManager mPackageManager;
    private final Object mInstallLock;
    @GuardedBy(value="mInstallLock")
    private final Installer mInstaller;
    private final Handler mHandler;

    public ArtManagerService(IPackageManager pm, Installer installer, Object installLock) {
        this.mPackageManager = pm;
        this.mInstaller = installer;
        this.mInstallLock = installLock;
        this.mHandler = new Handler(BackgroundThread.getHandler().getLooper());
    }

    @Override
    public void snapshotRuntimeProfile(int profileType, String packageName, String codePath, ISnapshotRuntimeProfileCallback callback) {
        boolean bootImageProfile;
        Preconditions.checkNotNull(callback);
        boolean bl = bootImageProfile = profileType == 1;
        if (!bootImageProfile) {
            Preconditions.checkStringNotEmpty(codePath);
            Preconditions.checkStringNotEmpty(packageName);
        }
        if (!this.isRuntimeProfilingEnabled(profileType)) {
            throw new IllegalStateException("Runtime profiling is not enabled for " + profileType);
        }
        if (DEBUG) {
            Slog.d(TAG, "Requested snapshot for " + packageName + ":" + codePath);
        }
        if (bootImageProfile) {
            this.snapshotBootImageProfile(callback);
        } else {
            this.snapshotAppProfile(packageName, codePath, callback);
        }
    }

    private void snapshotAppProfile(String packageName, String codePath, ISnapshotRuntimeProfileCallback callback) {
        PackageInfo info = null;
        try {
            info = this.mPackageManager.getPackageInfo(packageName, 0, 0);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (info == null) {
            this.postError(callback, packageName, 0);
            return;
        }
        boolean pathFound = info.applicationInfo.getBaseCodePath().equals(codePath);
        String splitName = null;
        String[] splitCodePaths = info.applicationInfo.getSplitCodePaths();
        if (!pathFound && splitCodePaths != null) {
            for (int i = splitCodePaths.length - 1; i >= 0; --i) {
                if (!splitCodePaths[i].equals(codePath)) continue;
                pathFound = true;
                splitName = info.applicationInfo.splitNames[i];
                break;
            }
        }
        if (!pathFound) {
            this.postError(callback, packageName, 1);
            return;
        }
        int appId = UserHandle.getAppId(info.applicationInfo.uid);
        if (appId < 0) {
            this.postError(callback, packageName, 2);
            Slog.wtf(TAG, "AppId is -1 for package: " + packageName);
            return;
        }
        this.createProfileSnapshot(packageName, ArtManager.getProfileName(splitName), codePath, appId, callback);
        this.destroyProfileSnapshot(packageName, ArtManager.getProfileName(splitName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createProfileSnapshot(String packageName, String profileName, String classpath, int appId, ISnapshotRuntimeProfileCallback callback) {
        Object object = this.mInstallLock;
        synchronized (object) {
            try {
                if (!this.mInstaller.createProfileSnapshot(appId, packageName, profileName, classpath)) {
                    this.postError(callback, packageName, 2);
                    return;
                }
            }
            catch (Installer.InstallerException e) {
                this.postError(callback, packageName, 2);
                return;
            }
        }
        File snapshotProfile = ArtManager.getProfileSnapshotFileForName(packageName, profileName);
        ParcelFileDescriptor fd = null;
        try {
            fd = ParcelFileDescriptor.open(snapshotProfile, 0x10000000);
            this.postSuccess(packageName, fd, callback);
            return;
        }
        catch (FileNotFoundException e) {
            Slog.w(TAG, "Could not open snapshot profile for " + packageName + ":" + snapshotProfile, e);
            this.postError(callback, packageName, 2);
            return;
        }
        finally {
            IoUtils.closeQuietly(fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyProfileSnapshot(String packageName, String profileName) {
        if (DEBUG) {
            Slog.d(TAG, "Destroying profile snapshot for" + packageName + ":" + profileName);
        }
        Object object = this.mInstallLock;
        synchronized (object) {
            try {
                this.mInstaller.destroyProfileSnapshot(packageName, profileName);
            }
            catch (Installer.InstallerException e) {
                Slog.e(TAG, "Failed to destroy profile snapshot for " + packageName + ":" + profileName, e);
            }
        }
    }

    @Override
    public boolean isRuntimeProfilingEnabled(int profileType) {
        this.checkReadRuntimeProfilePermission();
        switch (profileType) {
            case 0: {
                return SystemProperties.getBoolean("dalvik.vm.usejitprofiles", false);
            }
            case 1: {
                return (Build.IS_USERDEBUG || Build.IS_ENG) && SystemProperties.getBoolean("dalvik.vm.usejitprofiles", false) && SystemProperties.getBoolean("dalvik.vm.profilebootimage", false);
            }
        }
        throw new IllegalArgumentException("Invalid profile type:" + profileType);
    }

    private void snapshotBootImageProfile(ISnapshotRuntimeProfileCallback callback) {
        String classpath = String.join((CharSequence)":", Os.getenv("BOOTCLASSPATH"), Os.getenv("SYSTEMSERVERCLASSPATH"));
        this.createProfileSnapshot(BOOT_IMAGE_ANDROID_PACKAGE, BOOT_IMAGE_PROFILE_NAME, classpath, -1, callback);
        this.destroyProfileSnapshot(BOOT_IMAGE_ANDROID_PACKAGE, BOOT_IMAGE_PROFILE_NAME);
    }

    private void postError(ISnapshotRuntimeProfileCallback callback, String packageName, int errCode) {
        if (DEBUG) {
            Slog.d(TAG, "Failed to snapshot profile for " + packageName + " with error: " + errCode);
        }
        this.mHandler.post(() -> {
            try {
                callback.onError(errCode);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failed to callback after profile snapshot for " + packageName, e);
            }
        });
    }

    private void postSuccess(String packageName, ParcelFileDescriptor fd, ISnapshotRuntimeProfileCallback callback) {
        if (DEBUG) {
            Slog.d(TAG, "Successfully snapshot profile for " + packageName);
        }
        this.mHandler.post(() -> {
            try {
                callback.onSuccess(fd);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failed to call onSuccess after profile snapshot for " + packageName, e);
            }
        });
    }

    private void checkReadRuntimeProfilePermission() {
        if (DEBUG_IGNORE_PERMISSIONS) {
            return;
        }
        try {
            int result = this.mPackageManager.checkUidPermission("android.permission.READ_RUNTIME_PROFILES", Binder.getCallingUid());
            if (result != 0) {
                throw new SecurityException("You need android.permission.READ_RUNTIME_PROFILES permission to snapshot profiles.");
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareAppProfiles(PackageParser.Package pkg, int user) {
        int appId = UserHandle.getAppId(pkg.applicationInfo.uid);
        if (user < 0) {
            Slog.wtf(TAG, "Invalid user id: " + user);
            return;
        }
        if (appId < 0) {
            Slog.wtf(TAG, "Invalid app id: " + appId);
            return;
        }
        try {
            ArrayMap<String, String> codePathsProfileNames = this.getPackageProfileNames(pkg);
            for (int i = codePathsProfileNames.size() - 1; i >= 0; --i) {
                String codePath = codePathsProfileNames.keyAt(i);
                String profileName = codePathsProfileNames.valueAt(i);
                File dexMetadata = DexMetadataHelper.findDexMetadataForFile(new File(codePath));
                String dexMetadataPath = dexMetadata == null ? null : dexMetadata.getAbsolutePath();
                Installer installer = this.mInstaller;
                synchronized (installer) {
                    boolean result = this.mInstaller.prepareAppProfile(pkg.packageName, user, appId, profileName, codePath, dexMetadataPath);
                    if (!result) {
                        Slog.e(TAG, "Failed to prepare profile for " + pkg.packageName + ":" + codePath);
                    }
                    continue;
                }
            }
        }
        catch (Installer.InstallerException e) {
            Slog.e(TAG, "Failed to prepare profile for " + pkg.packageName, e);
        }
    }

    public void prepareAppProfiles(PackageParser.Package pkg, int[] user) {
        for (int i = 0; i < user.length; ++i) {
            this.prepareAppProfiles(pkg, user[i]);
        }
    }

    public void clearAppProfiles(PackageParser.Package pkg) {
        try {
            ArrayMap<String, String> packageProfileNames = this.getPackageProfileNames(pkg);
            for (int i = packageProfileNames.size() - 1; i >= 0; --i) {
                String profileName = packageProfileNames.valueAt(i);
                this.mInstaller.clearAppProfiles(pkg.packageName, profileName);
            }
        }
        catch (Installer.InstallerException e) {
            Slog.w(TAG, String.valueOf(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpProfiles(PackageParser.Package pkg) {
        int sharedGid = UserHandle.getSharedAppGid(pkg.applicationInfo.uid);
        try {
            ArrayMap<String, String> packageProfileNames = this.getPackageProfileNames(pkg);
            for (int i = packageProfileNames.size() - 1; i >= 0; --i) {
                String codePath = packageProfileNames.keyAt(i);
                String profileName = packageProfileNames.valueAt(i);
                Object object = this.mInstallLock;
                synchronized (object) {
                    this.mInstaller.dumpProfiles(sharedGid, pkg.packageName, profileName, codePath);
                    continue;
                }
            }
        }
        catch (Installer.InstallerException e) {
            Slog.w(TAG, "Failed to dump profiles", e);
        }
    }

    private ArrayMap<String, String> getPackageProfileNames(PackageParser.Package pkg) {
        ArrayMap<String, String> result = new ArrayMap<String, String>();
        if ((pkg.applicationInfo.flags & 4) != 0) {
            result.put(pkg.baseCodePath, ArtManager.getProfileName(null));
        }
        if (!ArrayUtils.isEmpty(pkg.splitCodePaths)) {
            for (int i = 0; i < pkg.splitCodePaths.length; ++i) {
                if ((pkg.splitFlags[i] & 4) == 0) continue;
                result.put(pkg.splitCodePaths[i], ArtManager.getProfileName(pkg.splitNames[i]));
            }
        }
        return result;
    }
}

