/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm.permission;

import android.content.Context;
import android.content.pm.PackageParser;
import android.util.ArrayMap;
import android.util.ArraySet;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.XmlUtils;
import com.android.server.pm.DumpState;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.permission.BasePermission;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class PermissionSettings {
    public final boolean mPermissionReviewRequired;
    @GuardedBy(value="mLock")
    final ArrayMap<String, BasePermission> mPermissions = new ArrayMap();
    @GuardedBy(value="mLock")
    final ArrayMap<String, BasePermission> mPermissionTrees = new ArrayMap();
    @GuardedBy(value="mLock")
    final ArrayMap<String, PackageParser.PermissionGroup> mPermissionGroups = new ArrayMap();
    @GuardedBy(value="mLock")
    final ArrayMap<String, ArraySet<String>> mAppOpPermissionPackages = new ArrayMap();
    private final Object mLock;

    PermissionSettings(Context context, Object lock) {
        this.mPermissionReviewRequired = context.getResources().getBoolean(17956995);
        this.mLock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasePermission getPermission(String permName) {
        Object object = this.mLock;
        synchronized (object) {
            return this.getPermissionLocked(permName);
        }
    }

    public void addAppOpPackage(String permName, String packageName) {
        ArraySet<String> pkgs = this.mAppOpPermissionPackages.get(permName);
        if (pkgs == null) {
            pkgs = new ArraySet();
            this.mAppOpPermissionPackages.put(permName, pkgs);
        }
        pkgs.add(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferPermissions(String origPackageName, String newPackageName) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < 2; ++i) {
                ArrayMap<String, BasePermission> permissions = i == 0 ? this.mPermissionTrees : this.mPermissions;
                for (BasePermission bp : permissions.values()) {
                    bp.transfer(origPackageName, newPackageName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canPropagatePermissionToInstantApp(String permName) {
        Object object = this.mLock;
        synchronized (object) {
            BasePermission bp = this.mPermissions.get(permName);
            return bp != null && (bp.isRuntime() || bp.isDevelopment()) && bp.isInstant();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPermissions(XmlPullParser parser) throws IOException, XmlPullParserException {
        Object object = this.mLock;
        synchronized (object) {
            PermissionSettings.readPermissions(this.mPermissions, parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPermissionTrees(XmlPullParser parser) throws IOException, XmlPullParserException {
        Object object = this.mLock;
        synchronized (object) {
            PermissionSettings.readPermissions(this.mPermissionTrees, parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePermissions(XmlSerializer serializer) throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            for (BasePermission bp : this.mPermissions.values()) {
                bp.writeLPr(serializer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePermissionTrees(XmlSerializer serializer) throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            for (BasePermission bp : this.mPermissionTrees.values()) {
                bp.writeLPr(serializer);
            }
        }
    }

    public static void readPermissions(ArrayMap<String, BasePermission> out, XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            if (!BasePermission.readLPw(out, parser)) {
                PackageManagerService.reportSettingsProblem(5, "Unknown element reading permissions: " + parser.getName() + " at " + parser.getPositionDescription());
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpPermissions(PrintWriter pw, String packageName, ArraySet<String> permissionNames, boolean externalStorageEnforced, DumpState dumpState) {
        Object object = this.mLock;
        synchronized (object) {
            boolean printedSomething = false;
            for (BasePermission bp : this.mPermissions.values()) {
                printedSomething = bp.dumpPermissionsLPr(pw, packageName, permissionNames, externalStorageEnforced, printedSomething, dumpState);
            }
            if (packageName == null && permissionNames == null) {
                for (int iperm = 0; iperm < this.mAppOpPermissionPackages.size(); ++iperm) {
                    if (iperm == 0) {
                        if (dumpState.onTitlePrinted()) {
                            pw.println();
                        }
                        pw.println("AppOp Permissions:");
                    }
                    pw.print("  AppOp Permission ");
                    pw.print(this.mAppOpPermissionPackages.keyAt(iperm));
                    pw.println(":");
                    ArraySet<String> pkgs = this.mAppOpPermissionPackages.valueAt(iperm);
                    for (int ipkg = 0; ipkg < pkgs.size(); ++ipkg) {
                        pw.print("    ");
                        pw.println(pkgs.valueAt(ipkg));
                    }
                }
            }
        }
    }

    BasePermission getPermissionLocked(String permName) {
        return this.mPermissions.get(permName);
    }

    BasePermission getPermissionTreeLocked(String permName) {
        return this.mPermissionTrees.get(permName);
    }

    void putPermissionLocked(String permName, BasePermission permission2) {
        this.mPermissions.put(permName, permission2);
    }

    void putPermissionTreeLocked(String permName, BasePermission permission2) {
        this.mPermissionTrees.put(permName, permission2);
    }

    void removePermissionLocked(String permName) {
        this.mPermissions.remove(permName);
    }

    void removePermissionTreeLocked(String permName) {
        this.mPermissionTrees.remove(permName);
    }

    Collection<BasePermission> getAllPermissionsLocked() {
        return this.mPermissions.values();
    }

    Collection<BasePermission> getAllPermissionTreesLocked() {
        return this.mPermissionTrees.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BasePermission enforcePermissionTree(String permName, int callingUid) {
        Object object = this.mLock;
        synchronized (object) {
            return BasePermission.enforcePermissionTree(this.mPermissionTrees.values(), permName, callingUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPermissionInstant(String permName) {
        Object object = this.mLock;
        synchronized (object) {
            BasePermission bp = this.mPermissions.get(permName);
            return bp != null && bp.isInstant();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isPermissionAppOp(String permName) {
        Object object = this.mLock;
        synchronized (object) {
            BasePermission bp = this.mPermissions.get(permName);
            return bp != null && bp.isAppOp();
        }
    }
}

