/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import android.view.Display;
import android.view.DisplayCutout;
import android.view.IApplicationToken;
import android.view.IWindowManager;
import android.view.InputEventReceiver;
import android.view.KeyEvent;
import android.view.WindowManager;
import android.view.WindowManagerPolicyConstants;
import android.view.animation.Animation;
import com.android.internal.policy.IKeyguardDismissCallback;
import com.android.internal.policy.IShortcutService;
import com.android.server.wm.DisplayFrames;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public interface WindowManagerPolicy
extends WindowManagerPolicyConstants {
    public static final int ACTION_PASS_TO_USER = 1;
    public static final int FINISH_LAYOUT_REDO_LAYOUT = 1;
    public static final int FINISH_LAYOUT_REDO_CONFIG = 2;
    public static final int FINISH_LAYOUT_REDO_WALLPAPER = 4;
    public static final int FINISH_LAYOUT_REDO_ANIM = 8;
    public static final int TRANSIT_ENTER = 1;
    public static final int TRANSIT_EXIT = 2;
    public static final int TRANSIT_SHOW = 3;
    public static final int TRANSIT_HIDE = 4;
    public static final int TRANSIT_PREVIEW_DONE = 5;
    public static final int USER_ROTATION_FREE = 0;
    public static final int USER_ROTATION_LOCKED = 1;

    public void registerShortcutKey(long var1, IShortcutService var3) throws RemoteException;

    public void onKeyguardOccludedChangedLw(boolean var1);

    default public void onOverlayChangedLw() {
    }

    public void init(Context var1, IWindowManager var2, WindowManagerFuncs var3);

    public boolean isDefaultOrientationForced();

    public void setInitialDisplaySize(Display var1, int var2, int var3, int var4);

    public int checkAddPermission(WindowManager.LayoutParams var1, int[] var2);

    public boolean checkShowToOwnerOnly(WindowManager.LayoutParams var1);

    public void adjustWindowParamsLw(WindowState var1, WindowManager.LayoutParams var2, boolean var3);

    public void adjustConfigurationLw(Configuration var1, int var2, int var3);

    default public int getWindowLayerLw(WindowState win) {
        return this.getWindowLayerFromTypeLw(win.getBaseType(), win.canAddInternalSystemWindow());
    }

    default public int getWindowLayerFromTypeLw(int type) {
        if (WindowManager.LayoutParams.isSystemAlertWindowType(type)) {
            throw new IllegalArgumentException("Use getWindowLayerFromTypeLw() or getWindowLayerLw() for alert window types");
        }
        return this.getWindowLayerFromTypeLw(type, false);
    }

    default public int getWindowLayerFromTypeLw(int type, boolean canAddInternalSystemWindow) {
        if (type >= 1 && type <= 99) {
            return 2;
        }
        switch (type) {
            case 2013: {
                return 1;
            }
            case 2030: 
            case 2037: {
                return 2;
            }
            case 2034: {
                return 2;
            }
            case 2035: {
                return 2;
            }
            case 2002: {
                return 3;
            }
            case 2001: 
            case 2033: {
                return 4;
            }
            case 2031: {
                return 5;
            }
            case 2022: {
                return 6;
            }
            case 2008: {
                return 7;
            }
            case 2005: {
                return 8;
            }
            case 2007: {
                return 9;
            }
            case 2003: {
                return canAddInternalSystemWindow ? 11 : 10;
            }
            case 2038: {
                return 12;
            }
            case 2023: {
                return 13;
            }
            case 2011: {
                return 14;
            }
            case 2012: {
                return 15;
            }
            case 2000: {
                return 17;
            }
            case 2014: {
                return 18;
            }
            case 2017: {
                return 19;
            }
            case 2009: {
                return 20;
            }
            case 2020: {
                return 21;
            }
            case 2006: {
                return canAddInternalSystemWindow ? 22 : 11;
            }
            case 2019: {
                return 23;
            }
            case 2024: {
                return 24;
            }
            case 2036: {
                return 25;
            }
            case 2010: {
                return canAddInternalSystemWindow ? 26 : 10;
            }
            case 2027: {
                return 27;
            }
            case 2026: {
                return 28;
            }
            case 2016: {
                return 29;
            }
            case 2032: {
                return 30;
            }
            case 2015: {
                return 31;
            }
            case 2021: {
                return 32;
            }
            case 2018: {
                return 33;
            }
        }
        Slog.e("WindowManager", "Unknown window type: " + type);
        return 2;
    }

    default public int getSubWindowLayerFromTypeLw(int type) {
        switch (type) {
            case 1000: 
            case 1003: {
                return 1;
            }
            case 1001: {
                return -2;
            }
            case 1004: {
                return -1;
            }
            case 1002: {
                return 2;
            }
            case 1005: {
                return 3;
            }
        }
        Slog.e("WindowManager", "Unknown sub-window type: " + type);
        return 0;
    }

    public int getMaxWallpaperLayer();

    public int getNonDecorDisplayWidth(int var1, int var2, int var3, int var4, int var5);

    public int getNonDecorDisplayHeight(int var1, int var2, int var3, int var4, int var5);

    public int getConfigDisplayWidth(int var1, int var2, int var3, int var4, int var5);

    public int getConfigDisplayHeight(int var1, int var2, int var3, int var4, int var5);

    public boolean isKeyguardHostWindow(WindowManager.LayoutParams var1);

    public boolean canBeHiddenByKeyguardLw(WindowState var1);

    public StartingSurface addSplashScreen(IBinder var1, String var2, int var3, CompatibilityInfo var4, CharSequence var5, int var6, int var7, int var8, int var9, Configuration var10, int var11);

    public int prepareAddWindowLw(WindowState var1, WindowManager.LayoutParams var2);

    public void removeWindowLw(WindowState var1);

    public int selectAnimationLw(WindowState var1, int var2);

    public void selectRotationAnimationLw(int[] var1);

    public boolean validateRotationAnimationLw(int var1, int var2, boolean var3);

    public Animation createHiddenByKeyguardExit(boolean var1, boolean var2);

    public Animation createKeyguardWallpaperExit(boolean var1);

    public int interceptKeyBeforeQueueing(KeyEvent var1, int var2);

    public int interceptMotionBeforeQueueingNonInteractive(long var1, int var3);

    public long interceptKeyBeforeDispatching(WindowState var1, KeyEvent var2, int var3);

    public KeyEvent dispatchUnhandledKey(WindowState var1, KeyEvent var2, int var3);

    default public void beginLayoutLw(DisplayFrames displayFrames, int uiMode) {
    }

    public int getSystemDecorLayerLw();

    default public void layoutWindowLw(WindowState win, WindowState attached, DisplayFrames displayFrames) {
    }

    default public boolean getInsetHintLw(WindowManager.LayoutParams attrs, Rect taskBounds, DisplayFrames displayFrames, Rect outContentInsets, Rect outStableInsets, Rect outOutsets, DisplayCutout.ParcelableWrapper outDisplayCutout) {
        return false;
    }

    public void beginPostLayoutPolicyLw(int var1, int var2);

    public void applyPostLayoutPolicyLw(WindowState var1, WindowManager.LayoutParams var2, WindowState var3, WindowState var4);

    public int finishPostLayoutPolicyLw();

    public boolean allowAppAnimationsLw();

    public int focusChangedLw(WindowState var1, WindowState var2);

    public void startedWakingUp();

    public void finishedWakingUp();

    public void startedGoingToSleep(int var1);

    public void finishedGoingToSleep(int var1);

    public void screenTurningOn(ScreenOnListener var1);

    public void screenTurnedOn();

    public void screenTurningOff(ScreenOffListener var1);

    public void screenTurnedOff();

    public boolean isScreenOn();

    public boolean okToAnimate();

    public void notifyLidSwitchChanged(long var1, boolean var3);

    public void notifyCameraLensCoverSwitchChanged(long var1, boolean var3);

    public void enableKeyguard(boolean var1);

    public void exitKeyguardSecurely(OnKeyguardExitResult var1);

    public boolean isKeyguardLocked();

    public boolean isKeyguardSecure(int var1);

    public boolean isKeyguardOccluded();

    public boolean isKeyguardShowingAndNotOccluded();

    public boolean isKeyguardTrustedLw();

    public boolean inKeyguardRestrictedKeyInputMode();

    public void dismissKeyguardLw(IKeyguardDismissCallback var1, CharSequence var2);

    public boolean isKeyguardDrawnLw();

    public boolean isShowingDreamLw();

    public int rotationForOrientationLw(int var1, int var2);

    public boolean rotationHasCompatibleMetricsLw(int var1, int var2);

    public void setRotationLw(int var1);

    public void setSafeMode(boolean var1);

    public void systemReady();

    public void systemBooted();

    public void showBootMessage(CharSequence var1, boolean var2);

    public void hideBootMessages();

    public void userActivity();

    public void enableScreenAfterBoot();

    public void setCurrentOrientationLw(int var1);

    public boolean performHapticFeedbackLw(WindowState var1, int var2, boolean var3);

    public void keepScreenOnStartedLw();

    public void keepScreenOnStoppedLw();

    public int getUserRotationMode();

    public void setUserRotationMode(int var1, int var2);

    public int adjustSystemUiVisibilityLw(int var1);

    public void setRecentsVisibilityLw(boolean var1);

    public void setPipVisibilityLw(boolean var1);

    public boolean hasNavigationBar();

    public void lockNow(Bundle var1);

    public void setLastInputMethodWindowLw(WindowState var1, WindowState var2);

    default public void setDismissImeOnBackKeyPressed(boolean newValue) {
    }

    public void showRecentApps();

    public void showGlobalActions();

    public void setCurrentUserLw(int var1);

    public void setSwitchingUser(boolean var1);

    public void dump(String var1, PrintWriter var2, String[] var3);

    public void writeToProto(ProtoOutputStream var1, long var2);

    public boolean isTopLevelWindow(int var1);

    public void startKeyguardExitAnimation(long var1, long var3);

    public void getStableInsetsLw(int var1, int var2, int var3, Rect var4);

    public boolean isNavBarForcedShownLw(WindowState var1);

    public int getNavBarPosition();

    public void getNonDecorInsetsLw(int var1, int var2, int var3, Rect var4);

    public boolean isDockSideAllowed(int var1);

    public void onConfigurationChanged();

    public boolean shouldRotateSeamlessly(int var1, int var2);

    public void onSystemUiStarted();

    public boolean canDismissBootAnimation();

    public static String userRotationModeToString(int mode) {
        switch (mode) {
            case 0: {
                return "USER_ROTATION_FREE";
            }
            case 1: {
                return "USER_ROTATION_LOCKED";
            }
        }
        return Integer.toString(mode);
    }

    public static interface OnKeyguardExitResult {
        public void onKeyguardExitResult(boolean var1);
    }

    public static interface ScreenOffListener {
        public void onScreenOff();
    }

    public static interface ScreenOnListener {
        public void onScreenOn();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserRotationMode {
    }

    public static interface WindowManagerFuncs {
        public static final int LID_ABSENT = -1;
        public static final int LID_CLOSED = 0;
        public static final int LID_OPEN = 1;
        public static final int CAMERA_LENS_COVER_ABSENT = -1;
        public static final int CAMERA_LENS_UNCOVERED = 0;
        public static final int CAMERA_LENS_COVERED = 1;

        public void reevaluateStatusBarVisibility();

        public InputConsumer createInputConsumer(Looper var1, String var2, InputEventReceiver.Factory var3);

        public int getLidState();

        public void lockDeviceNow();

        public int getCameraLensCoverState();

        public void switchInputMethod(boolean var1);

        public void shutdown(boolean var1);

        public void reboot(boolean var1);

        public void rebootSafeMode(boolean var1);

        public Object getWindowManagerLock();

        public void registerPointerEventListener(WindowManagerPolicyConstants.PointerEventListener var1);

        public void unregisterPointerEventListener(WindowManagerPolicyConstants.PointerEventListener var1);

        public int getDockedDividerInsetsLw();

        public void getStackBounds(int var1, int var2, Rect var3);

        public void notifyShowingDreamChanged();

        public WindowState getInputMethodWindowLw();

        public void notifyKeyguardTrustedChanged();

        public void screenTurningOff(ScreenOffListener var1);

        public static String lidStateToString(int lid) {
            switch (lid) {
                case -1: {
                    return "LID_ABSENT";
                }
                case 0: {
                    return "LID_CLOSED";
                }
                case 1: {
                    return "LID_OPEN";
                }
            }
            return Integer.toString(lid);
        }

        public static String cameraLensStateToString(int lens) {
            switch (lens) {
                case -1: {
                    return "CAMERA_LENS_COVER_ABSENT";
                }
                case 0: {
                    return "CAMERA_LENS_UNCOVERED";
                }
                case 1: {
                    return "CAMERA_LENS_COVERED";
                }
            }
            return Integer.toString(lens);
        }
    }

    public static interface StartingSurface {
        public void remove();
    }

    public static interface InputConsumer {
        public void dismiss();
    }

    public static interface WindowState {
        public int getOwningUid();

        public String getOwningPackage();

        public void computeFrameLw(Rect var1, Rect var2, Rect var3, Rect var4, Rect var5, Rect var6, Rect var7, Rect var8, DisplayCutout var9);

        public Rect getFrameLw();

        public Point getShownPositionLw();

        public Rect getDisplayFrameLw();

        public Rect getOverscanFrameLw();

        public Rect getContentFrameLw();

        public Rect getVisibleFrameLw();

        public boolean getGivenInsetsPendingLw();

        public Rect getGivenContentInsetsLw();

        public Rect getGivenVisibleInsetsLw();

        public WindowManager.LayoutParams getAttrs();

        public boolean getNeedsMenuLw(WindowState var1);

        public int getSystemUiVisibility();

        public int getSurfaceLayer();

        public int getBaseType();

        public IApplicationToken getAppToken();

        public boolean isVoiceInteraction();

        public boolean hasAppShownWindows();

        public boolean isVisibleLw();

        public boolean isDisplayedLw();

        public boolean isAnimatingLw();

        public boolean canAffectSystemUiFlags();

        public boolean isGoneForLayoutLw();

        public boolean isDrawnLw();

        public boolean hasDrawnLw();

        public boolean hideLw(boolean var1);

        public boolean showLw(boolean var1);

        public boolean isAlive();

        public boolean isDefaultDisplay();

        public boolean isDimming();

        default public boolean isLetterboxedForDisplayCutoutLw() {
            return false;
        }

        public int getWindowingMode();

        public boolean isInMultiWindowMode();

        public int getRotationAnimationHint();

        public boolean isInputMethodWindow();

        public int getDisplayId();

        default public boolean canAddInternalSystemWindow() {
            return false;
        }

        public boolean canAcquireSleepToken();

        public void writeIdentifierToProto(ProtoOutputStream var1, long var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NavigationBarPosition {
    }
}

