/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power;

import android.app.ActivityManagerInternal;
import android.app.AppOpsManager;
import android.app.trust.TrustManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.hardware.input.InputManagerInternal;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.metrics.LogMaker;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManagerInternal;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.WorkSource;
import android.provider.Settings;
import android.util.EventLog;
import android.view.inputmethod.InputMethodManagerInternal;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.IBatteryStats;
import com.android.internal.logging.MetricsLogger;
import com.android.server.EventLogTags;
import com.android.server.LocalServices;
import com.android.server.policy.WindowManagerPolicy;
import com.android.server.power.SuspendBlocker;
import com.android.server.statusbar.StatusBarManagerInternal;

final class Notifier {
    private static final String TAG = "PowerManagerNotifier";
    private static final boolean DEBUG = false;
    private static final int INTERACTIVE_STATE_UNKNOWN = 0;
    private static final int INTERACTIVE_STATE_AWAKE = 1;
    private static final int INTERACTIVE_STATE_ASLEEP = 2;
    private static final int MSG_USER_ACTIVITY = 1;
    private static final int MSG_BROADCAST = 2;
    private static final int MSG_WIRELESS_CHARGING_STARTED = 3;
    private static final int MSG_SCREEN_BRIGHTNESS_BOOST_CHANGED = 4;
    private static final int MSG_PROFILE_TIMED_OUT = 5;
    private static final int MSG_WIRED_CHARGING_STARTED = 6;
    private final Object mLock = new Object();
    private final Context mContext;
    private final IBatteryStats mBatteryStats;
    private final IAppOpsService mAppOps;
    private final SuspendBlocker mSuspendBlocker;
    private final WindowManagerPolicy mPolicy;
    private final ActivityManagerInternal mActivityManagerInternal;
    private final InputManagerInternal mInputManagerInternal;
    private final InputMethodManagerInternal mInputMethodManagerInternal;
    private final StatusBarManagerInternal mStatusBarManagerInternal;
    private final TrustManager mTrustManager;
    private final NotifierHandler mHandler;
    private final Intent mScreenOnIntent;
    private final Intent mScreenOffIntent;
    private final Intent mScreenBrightnessBoostIntent;
    private final boolean mSuspendWhenScreenOffDueToProximityConfig;
    private boolean mInteractive = true;
    private int mInteractiveChangeReason;
    private boolean mInteractiveChanging;
    private int mPendingInteractiveState;
    private boolean mPendingWakeUpBroadcast;
    private boolean mPendingGoToSleepBroadcast;
    private int mBroadcastedInteractiveState;
    private boolean mBroadcastInProgress;
    private long mBroadcastStartTime;
    private boolean mUserActivityPending;
    private final BroadcastReceiver mScreeBrightnessBoostChangedDone = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            Notifier.this.mSuspendBlocker.release();
        }
    };
    private final BroadcastReceiver mWakeUpBroadcastDone = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            EventLog.writeEvent(2726, 1, SystemClock.uptimeMillis() - Notifier.this.mBroadcastStartTime, 1);
            Notifier.this.sendNextBroadcast();
        }
    };
    private final BroadcastReceiver mGoToSleepBroadcastDone = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            EventLog.writeEvent(2726, 0, SystemClock.uptimeMillis() - Notifier.this.mBroadcastStartTime, 1);
            Notifier.this.sendNextBroadcast();
        }
    };

    public Notifier(Looper looper, Context context, IBatteryStats batteryStats, IAppOpsService appOps, SuspendBlocker suspendBlocker, WindowManagerPolicy policy) {
        this.mContext = context;
        this.mBatteryStats = batteryStats;
        this.mAppOps = appOps;
        this.mSuspendBlocker = suspendBlocker;
        this.mPolicy = policy;
        this.mActivityManagerInternal = LocalServices.getService(ActivityManagerInternal.class);
        this.mInputManagerInternal = LocalServices.getService(InputManagerInternal.class);
        this.mInputMethodManagerInternal = LocalServices.getService(InputMethodManagerInternal.class);
        this.mStatusBarManagerInternal = LocalServices.getService(StatusBarManagerInternal.class);
        this.mTrustManager = this.mContext.getSystemService(TrustManager.class);
        this.mHandler = new NotifierHandler(looper);
        this.mScreenOnIntent = new Intent("android.intent.action.SCREEN_ON");
        this.mScreenOnIntent.addFlags(0x50200000);
        this.mScreenOffIntent = new Intent("android.intent.action.SCREEN_OFF");
        this.mScreenOffIntent.addFlags(0x50200000);
        this.mScreenBrightnessBoostIntent = new Intent("android.os.action.SCREEN_BRIGHTNESS_BOOST_CHANGED");
        this.mScreenBrightnessBoostIntent.addFlags(0x50000000);
        this.mSuspendWhenScreenOffDueToProximityConfig = context.getResources().getBoolean(17957038);
        try {
            this.mBatteryStats.noteInteractive(true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void onWakeLockAcquired(int flags, String tag, String packageName, int ownerUid, int ownerPid, WorkSource workSource, String historyTag) {
        int monitorType = this.getBatteryStatsWakeLockMonitorType(flags);
        if (monitorType >= 0) {
            try {
                boolean unimportantForLogging;
                boolean bl = unimportantForLogging = ownerUid == 1000 && (flags & 0x40000000) != 0;
                if (workSource != null) {
                    this.mBatteryStats.noteStartWakelockFromSource(workSource, ownerPid, tag, historyTag, monitorType, unimportantForLogging);
                } else {
                    this.mBatteryStats.noteStartWakelock(ownerUid, ownerPid, tag, historyTag, monitorType, unimportantForLogging);
                    this.mAppOps.startOperation(AppOpsManager.getToken(this.mAppOps), 40, ownerUid, packageName);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void onLongPartialWakeLockStart(String tag, int ownerUid, WorkSource workSource, String historyTag) {
        try {
            if (workSource != null) {
                this.mBatteryStats.noteLongPartialWakelockStartFromSource(tag, historyTag, workSource);
            } else {
                this.mBatteryStats.noteLongPartialWakelockStart(tag, historyTag, ownerUid);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void onLongPartialWakeLockFinish(String tag, int ownerUid, WorkSource workSource, String historyTag) {
        try {
            if (workSource != null) {
                this.mBatteryStats.noteLongPartialWakelockFinishFromSource(tag, historyTag, workSource);
            } else {
                this.mBatteryStats.noteLongPartialWakelockFinish(tag, historyTag, ownerUid);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void onWakeLockChanging(int flags, String tag, String packageName, int ownerUid, int ownerPid, WorkSource workSource, String historyTag, int newFlags, String newTag, String newPackageName, int newOwnerUid, int newOwnerPid, WorkSource newWorkSource, String newHistoryTag) {
        int monitorType = this.getBatteryStatsWakeLockMonitorType(flags);
        int newMonitorType = this.getBatteryStatsWakeLockMonitorType(newFlags);
        if (workSource != null && newWorkSource != null && monitorType >= 0 && newMonitorType >= 0) {
            boolean unimportantForLogging = newOwnerUid == 1000 && (newFlags & 0x40000000) != 0;
            try {
                this.mBatteryStats.noteChangeWakelockFromSource(workSource, ownerPid, tag, historyTag, monitorType, newWorkSource, newOwnerPid, newTag, newHistoryTag, newMonitorType, unimportantForLogging);
            }
            catch (RemoteException remoteException) {}
        } else {
            this.onWakeLockReleased(flags, tag, packageName, ownerUid, ownerPid, workSource, historyTag);
            this.onWakeLockAcquired(newFlags, newTag, newPackageName, newOwnerUid, newOwnerPid, newWorkSource, newHistoryTag);
        }
    }

    public void onWakeLockReleased(int flags, String tag, String packageName, int ownerUid, int ownerPid, WorkSource workSource, String historyTag) {
        int monitorType = this.getBatteryStatsWakeLockMonitorType(flags);
        if (monitorType >= 0) {
            try {
                if (workSource != null) {
                    this.mBatteryStats.noteStopWakelockFromSource(workSource, ownerPid, tag, historyTag, monitorType);
                } else {
                    this.mBatteryStats.noteStopWakelock(ownerUid, ownerPid, tag, historyTag, monitorType);
                    this.mAppOps.finishOperation(AppOpsManager.getToken(this.mAppOps), 40, ownerUid, packageName);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private int getBatteryStatsWakeLockMonitorType(int flags) {
        switch (flags & 0xFFFF) {
            case 1: {
                return 0;
            }
            case 6: 
            case 10: {
                return 1;
            }
            case 32: {
                if (this.mSuspendWhenScreenOffDueToProximityConfig) {
                    return -1;
                }
                return 0;
            }
            case 128: {
                return 18;
            }
            case 64: {
                return -1;
            }
        }
        return -1;
    }

    public void onWakefulnessChangeStarted(final int wakefulness, int reason) {
        boolean interactive = PowerManagerInternal.isInteractive(wakefulness);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                Notifier.this.mActivityManagerInternal.onWakefulnessChanged(wakefulness);
            }
        });
        if (this.mInteractive != interactive) {
            if (this.mInteractiveChanging) {
                this.handleLateInteractiveChange();
            }
            this.mInputManagerInternal.setInteractive(interactive);
            this.mInputMethodManagerInternal.setInteractive(interactive);
            try {
                this.mBatteryStats.noteInteractive(interactive);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mInteractive = interactive;
            this.mInteractiveChangeReason = reason;
            this.mInteractiveChanging = true;
            this.handleEarlyInteractiveChange();
        }
    }

    public void onWakefulnessChangeFinished() {
        if (this.mInteractiveChanging) {
            this.mInteractiveChanging = false;
            this.handleLateInteractiveChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEarlyInteractiveChange() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInteractive) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Notifier.this.mPolicy.startedWakingUp();
                    }
                });
                this.mPendingInteractiveState = 1;
                this.mPendingWakeUpBroadcast = true;
                this.updatePendingBroadcastLocked();
            } else {
                final int why = Notifier.translateOffReason(this.mInteractiveChangeReason);
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Notifier.this.mPolicy.startedGoingToSleep(why);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLateInteractiveChange() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInteractive) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Notifier.this.mPolicy.finishedWakingUp();
                    }
                });
            } else {
                if (this.mUserActivityPending) {
                    this.mUserActivityPending = false;
                    this.mHandler.removeMessages(1);
                }
                final int why = Notifier.translateOffReason(this.mInteractiveChangeReason);
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        LogMaker log = new LogMaker(198);
                        log.setType(2);
                        log.setSubtype(why);
                        MetricsLogger.action(log);
                        EventLogTags.writePowerScreenState(0, why, 0L, 0, 0);
                        Notifier.this.mPolicy.finishedGoingToSleep(why);
                    }
                });
                this.mPendingInteractiveState = 2;
                this.mPendingGoToSleepBroadcast = true;
                this.updatePendingBroadcastLocked();
            }
        }
    }

    private static int translateOffReason(int reason) {
        switch (reason) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
        }
        return 2;
    }

    public void onScreenBrightnessBoostChanged() {
        this.mSuspendBlocker.acquire();
        Message msg = this.mHandler.obtainMessage(4);
        msg.setAsynchronous(true);
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUserActivity(int event, int uid) {
        try {
            this.mBatteryStats.noteUserActivity(uid, event);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mUserActivityPending) {
                this.mUserActivityPending = true;
                Message msg = this.mHandler.obtainMessage(1);
                msg.setAsynchronous(true);
                this.mHandler.sendMessage(msg);
            }
        }
    }

    public void onWakeUp(String reason, int reasonUid, String opPackageName, int opUid) {
        try {
            this.mBatteryStats.noteWakeUp(reason, reasonUid);
            if (opPackageName != null) {
                this.mAppOps.noteOperation(61, opUid, opPackageName);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void onProfileTimeout(int userId) {
        Message msg = this.mHandler.obtainMessage(5);
        msg.setAsynchronous(true);
        msg.arg1 = userId;
        this.mHandler.sendMessage(msg);
    }

    public void onWirelessChargingStarted(int batteryLevel) {
        this.mSuspendBlocker.acquire();
        Message msg = this.mHandler.obtainMessage(3);
        msg.setAsynchronous(true);
        msg.arg1 = batteryLevel;
        this.mHandler.sendMessage(msg);
    }

    public void onWiredChargingStarted() {
        this.mSuspendBlocker.acquire();
        Message msg = this.mHandler.obtainMessage(6);
        msg.setAsynchronous(true);
        this.mHandler.sendMessage(msg);
    }

    private void updatePendingBroadcastLocked() {
        if (!this.mBroadcastInProgress && this.mPendingInteractiveState != 0 && (this.mPendingWakeUpBroadcast || this.mPendingGoToSleepBroadcast || this.mPendingInteractiveState != this.mBroadcastedInteractiveState)) {
            this.mBroadcastInProgress = true;
            this.mSuspendBlocker.acquire();
            Message msg = this.mHandler.obtainMessage(2);
            msg.setAsynchronous(true);
            this.mHandler.sendMessage(msg);
        }
    }

    private void finishPendingBroadcastLocked() {
        this.mBroadcastInProgress = false;
        this.mSuspendBlocker.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUserActivity() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mUserActivityPending) {
                return;
            }
            this.mUserActivityPending = false;
        }
        this.mPolicy.userActivity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendNextBroadcast() {
        int powerState;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mBroadcastedInteractiveState == 0) {
                this.mPendingWakeUpBroadcast = false;
                this.mBroadcastedInteractiveState = 1;
            } else if (this.mBroadcastedInteractiveState == 1) {
                if (!this.mPendingWakeUpBroadcast && !this.mPendingGoToSleepBroadcast && this.mPendingInteractiveState != 2) {
                    this.finishPendingBroadcastLocked();
                    return;
                }
                this.mPendingGoToSleepBroadcast = false;
                this.mBroadcastedInteractiveState = 2;
            } else {
                if (!this.mPendingWakeUpBroadcast && !this.mPendingGoToSleepBroadcast && this.mPendingInteractiveState != 1) {
                    this.finishPendingBroadcastLocked();
                    return;
                }
                this.mPendingWakeUpBroadcast = false;
                this.mBroadcastedInteractiveState = 1;
            }
            this.mBroadcastStartTime = SystemClock.uptimeMillis();
            powerState = this.mBroadcastedInteractiveState;
        }
        EventLog.writeEvent(2725, 1);
        if (powerState == 1) {
            this.sendWakeUpBroadcast();
            return;
        }
        this.sendGoToSleepBroadcast();
    }

    private void sendBrightnessBoostChangedBroadcast() {
        this.mContext.sendOrderedBroadcastAsUser(this.mScreenBrightnessBoostIntent, UserHandle.ALL, null, this.mScreeBrightnessBoostChangedDone, this.mHandler, 0, null, null);
    }

    private void sendWakeUpBroadcast() {
        if (this.mActivityManagerInternal.isSystemReady()) {
            this.mContext.sendOrderedBroadcastAsUser(this.mScreenOnIntent, UserHandle.ALL, null, this.mWakeUpBroadcastDone, this.mHandler, 0, null, null);
        } else {
            EventLog.writeEvent(2727, 2, 1);
            this.sendNextBroadcast();
        }
    }

    private void sendGoToSleepBroadcast() {
        if (this.mActivityManagerInternal.isSystemReady()) {
            this.mContext.sendOrderedBroadcastAsUser(this.mScreenOffIntent, UserHandle.ALL, null, this.mGoToSleepBroadcastDone, this.mHandler, 0, null, null);
        } else {
            EventLog.writeEvent(2727, 3, 1);
            this.sendNextBroadcast();
        }
    }

    private void playChargingStartedSound() {
        Ringtone sfx;
        Uri soundUri;
        boolean enabled = Settings.Global.getInt(this.mContext.getContentResolver(), "charging_sounds_enabled", 1) != 0;
        String soundPath = Settings.Global.getString(this.mContext.getContentResolver(), "wireless_charging_started_sound");
        if (enabled && soundPath != null && (soundUri = Uri.parse("file://" + soundPath)) != null && (sfx = RingtoneManager.getRingtone(this.mContext, soundUri)) != null) {
            sfx.setStreamType(1);
            sfx.play();
        }
    }

    private void showWirelessChargingStarted(int batteryLevel) {
        this.playChargingStartedSound();
        this.mStatusBarManagerInternal.showChargingAnimation(batteryLevel);
        this.mSuspendBlocker.release();
    }

    private void showWiredChargingStarted() {
        this.playChargingStartedSound();
        this.mSuspendBlocker.release();
    }

    private void lockProfile(int userId) {
        this.mTrustManager.setDeviceLockedForUser(userId, true);
    }

    private final class NotifierHandler
    extends Handler {
        public NotifierHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Notifier.this.sendUserActivity();
                    break;
                }
                case 2: {
                    Notifier.this.sendNextBroadcast();
                    break;
                }
                case 3: {
                    Notifier.this.showWirelessChargingStarted(msg.arg1);
                    break;
                }
                case 4: {
                    Notifier.this.sendBrightnessBoostChangedBroadcast();
                    break;
                }
                case 5: {
                    Notifier.this.lockProfile(msg.arg1);
                    break;
                }
                case 6: {
                    Notifier.this.showWiredChargingStarted();
                }
            }
        }
    }
}

