/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power.batterysaver;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.Notification;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.PowerSaveState;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import com.android.server.EventLogTags;
import com.android.server.LocalServices;
import com.android.server.power.BatterySaverPolicy;
import com.android.server.power.batterysaver.BatterySaverLocationPlugin;
import com.android.server.power.batterysaver.BatterySavingStats;
import com.android.server.power.batterysaver.FileUpdater;
import java.util.ArrayList;

public class BatterySaverController
implements BatterySaverPolicy.BatterySaverPolicyListener {
    static final String TAG = "BatterySaverController";
    static final boolean DEBUG = false;
    private final Object mLock = new Object();
    private final Context mContext;
    private final MyHandler mHandler;
    private final FileUpdater mFileUpdater;
    private PowerManager mPowerManager;
    private final BatterySaverPolicy mBatterySaverPolicy;
    private final BatterySavingStats mBatterySavingStats;
    private static final String WARNING_LINK_URL = "http://goto.google.com/extreme-battery-saver";
    @GuardedBy(value="mLock")
    private final ArrayList<PowerManagerInternal.LowPowerModeListener> mListeners = new ArrayList();
    @GuardedBy(value="mLock")
    private boolean mEnabled;
    @GuardedBy(value="mLock")
    private boolean mIsPluggedIn;
    private boolean mPreviouslyEnabled;
    @GuardedBy(value="mLock")
    private boolean mIsInteractive;
    private final Plugin[] mPlugins;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case "android.intent.action.SCREEN_ON": 
                case "android.intent.action.SCREEN_OFF": {
                    if (!BatterySaverController.this.isEnabled()) {
                        BatterySaverController.this.updateBatterySavingStats();
                        return;
                    }
                    BatterySaverController.this.mHandler.postStateChanged(false);
                    break;
                }
                case "android.intent.action.BATTERY_CHANGED": {
                    Object object = BatterySaverController.this.mLock;
                    synchronized (object) {
                        BatterySaverController.this.mIsPluggedIn = intent.getIntExtra("plugged", 0) != 0;
                    }
                }
                case "android.os.action.DEVICE_IDLE_MODE_CHANGED": 
                case "android.os.action.LIGHT_DEVICE_IDLE_MODE_CHANGED": {
                    BatterySaverController.this.updateBatterySavingStats();
                }
            }
        }
    };

    public BatterySaverController(Context context, Looper looper, BatterySaverPolicy policy) {
        this.mContext = context;
        this.mHandler = new MyHandler(looper);
        this.mBatterySaverPolicy = policy;
        this.mBatterySaverPolicy.addListener(this);
        this.mFileUpdater = new FileUpdater(context);
        this.mBatterySavingStats = BatterySavingStats.getInstance();
        ArrayList<BatterySaverLocationPlugin> plugins = new ArrayList<BatterySaverLocationPlugin>();
        plugins.add(new BatterySaverLocationPlugin(this.mContext));
        this.mPlugins = plugins.toArray(new Plugin[plugins.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PowerManagerInternal.LowPowerModeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListeners.add(listener);
        }
    }

    public void systemReady() {
        IntentFilter filter = new IntentFilter("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.BATTERY_CHANGED");
        filter.addAction("android.os.action.DEVICE_IDLE_MODE_CHANGED");
        filter.addAction("android.os.action.LIGHT_DEVICE_IDLE_MODE_CHANGED");
        this.mContext.registerReceiver(this.mReceiver, filter);
        this.mFileUpdater.systemReady(LocalServices.getService(ActivityManagerInternal.class).isRuntimeRestarted());
        this.mHandler.postSystemReady();
    }

    private PowerManager getPowerManager() {
        if (this.mPowerManager == null) {
            this.mPowerManager = Preconditions.checkNotNull(this.mContext.getSystemService(PowerManager.class));
        }
        return this.mPowerManager;
    }

    @Override
    public void onBatterySaverPolicyChanged(BatterySaverPolicy policy) {
        if (!this.isEnabled()) {
            return;
        }
        this.mHandler.postStateChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableBatterySaver(boolean enable) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabled == enable) {
                return;
            }
            this.mEnabled = enable;
            this.mHandler.postStateChanged(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInteractive() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIsInteractive;
        }
    }

    public BatterySaverPolicy getBatterySaverPolicy() {
        return this.mBatterySaverPolicy;
    }

    public boolean isLaunchBoostDisabled() {
        return this.isEnabled() && this.mBatterySaverPolicy.isLaunchBoostDisabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleBatterySaverStateChanged(boolean sendBroadcast) {
        ArrayMap<String, String> fileValues;
        boolean enabled;
        PowerManagerInternal.LowPowerModeListener[] listeners;
        boolean isInteractive = this.getPowerManager().isInteractive();
        Object object = this.mLock;
        synchronized (object) {
            EventLogTags.writeBatterySaverMode(this.mPreviouslyEnabled ? 1 : 0, this.mEnabled ? 1 : 0, isInteractive ? 1 : 0, this.mEnabled ? this.mBatterySaverPolicy.toEventLogString() : "");
            this.mPreviouslyEnabled = this.mEnabled;
            listeners = this.mListeners.toArray(new PowerManagerInternal.LowPowerModeListener[this.mListeners.size()]);
            enabled = this.mEnabled;
            this.mIsInteractive = isInteractive;
            fileValues = enabled ? this.mBatterySaverPolicy.getFileValues(isInteractive) : null;
        }
        PowerManagerInternal pmi = LocalServices.getService(PowerManagerInternal.class);
        if (pmi != null) {
            pmi.powerHint(5, enabled ? 1 : 0);
        }
        this.updateBatterySavingStats();
        if (ArrayUtils.isEmpty(fileValues)) {
            this.mFileUpdater.restoreDefault();
        } else {
            this.mFileUpdater.writeFiles(fileValues);
        }
        for (Plugin p : this.mPlugins) {
            p.onBatterySaverChanged(this);
        }
        if (sendBroadcast) {
            if (enabled) {
                this.postWarningNotification();
            } else {
                this.cancelWarningNotification();
            }
            Intent intent = new Intent("android.os.action.POWER_SAVE_MODE_CHANGING").putExtra("mode", enabled).addFlags(0x40000000);
            this.mContext.sendBroadcast(intent);
            intent = new Intent("android.os.action.POWER_SAVE_MODE_CHANGED");
            intent.addFlags(0x40000000);
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
            intent = new Intent("android.os.action.POWER_SAVE_MODE_CHANGED_INTERNAL");
            intent.addFlags(0x40000000);
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, "android.permission.DEVICE_POWER");
            for (PowerManagerInternal.LowPowerModeListener listener : listeners) {
                PowerSaveState result = this.mBatterySaverPolicy.getBatterySaverPolicy(listener.getServiceType(), enabled);
                listener.onLowPowerModeChanged(result);
            }
        }
    }

    private void postWarningNotification() {
        UserHandle foregroundUser = UserHandle.of(ActivityManager.getCurrentUser());
        String title = this.mContext.getString(17039574);
        String text = this.mContext.getString(17039573);
        Notification notification = new Notification.Builder(this.mContext, SystemNotificationChannels.ALERTS).setSmallIcon(17301624).setTicker(title).setWhen(System.currentTimeMillis()).setContentTitle(title).setContentText(text).setStyle(new Notification.BigTextStyle().bigText(text)).build();
        NotificationManager nm = this.mContext.getSystemService(NotificationManager.class);
        if (nm != null) {
            nm.notifyAsUser(title.toString(), 1200, notification, foregroundUser);
        }
    }

    private void cancelWarningNotification() {
        UserHandle foregroundUser = UserHandle.of(ActivityManager.getCurrentUser());
        String title = this.mContext.getString(17039574);
        NotificationManager nm = this.mContext.getSystemService(NotificationManager.class);
        if (nm != null) {
            nm.cancelAsUser(title.toString(), 1200, foregroundUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBatterySavingStats() {
        PowerManager pm = this.getPowerManager();
        if (pm == null) {
            Slog.wtf(TAG, "PowerManager not initialized");
            return;
        }
        boolean isInteractive = pm.isInteractive();
        int dozeMode = pm.isDeviceIdleMode() ? 2 : (pm.isLightDeviceIdleMode() ? 1 : 0);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsPluggedIn) {
                this.mBatterySavingStats.startCharging();
                return;
            }
            this.mBatterySavingStats.transitionState(this.mEnabled ? 1 : 0, isInteractive ? 1 : 0, dozeMode);
        }
    }

    private class MyHandler
    extends Handler {
        private static final int MSG_STATE_CHANGED = 1;
        private static final int ARG_DONT_SEND_BROADCAST = 0;
        private static final int ARG_SEND_BROADCAST = 1;
        private static final int MSG_SYSTEM_READY = 2;

        public MyHandler(Looper looper) {
            super(looper);
        }

        public void postStateChanged(boolean sendBroadcast) {
            this.obtainMessage(1, sendBroadcast ? 1 : 0, 0).sendToTarget();
        }

        public void postSystemReady() {
            this.obtainMessage(2, 0, 0).sendToTarget();
        }

        @Override
        public void dispatchMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    BatterySaverController.this.handleBatterySaverStateChanged(msg.arg1 == 1);
                    break;
                }
                case 2: {
                    for (Plugin p : BatterySaverController.this.mPlugins) {
                        p.onSystemReady(BatterySaverController.this);
                    }
                    break;
                }
            }
        }
    }

    public static interface Plugin {
        public void onSystemReady(BatterySaverController var1);

        public void onBatterySaverChanged(BatterySaverController var1);
    }
}

