/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power.batterysaver;

import android.os.BatteryManagerInternal;
import android.os.SystemClock;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import com.android.server.EventLogTags;
import com.android.server.LocalServices;
import java.io.PrintWriter;

public class BatterySavingStats {
    private static final String TAG = "BatterySavingStats";
    private static final boolean DEBUG = false;
    private final Object mLock = new Object();
    @VisibleForTesting
    static final String COUNTER_POWER_PERCENT_PREFIX = "battery_saver_stats_percent_";
    @VisibleForTesting
    static final String COUNTER_POWER_MILLIAMPS_PREFIX = "battery_saver_stats_milliamps_";
    @VisibleForTesting
    static final String COUNTER_TIME_SECONDS_PREFIX = "battery_saver_stats_seconds_";
    private static BatterySavingStats sInstance;
    private BatteryManagerInternal mBatteryManagerInternal;
    private final MetricsLogger mMetricsLogger;
    private static final int STATE_NOT_INITIALIZED = -1;
    private static final int STATE_CHARGING = -2;
    @GuardedBy(value="mLock")
    private int mCurrentState = -1;
    @VisibleForTesting
    @GuardedBy(value="mLock")
    final ArrayMap<Integer, Stat> mStats = new ArrayMap();
    private final MetricsLoggerHelper mMetricsLoggerHelper = new MetricsLoggerHelper();

    @VisibleForTesting
    BatterySavingStats(MetricsLogger metricsLogger) {
        this.mBatteryManagerInternal = LocalServices.getService(BatteryManagerInternal.class);
        this.mMetricsLogger = metricsLogger;
    }

    public static synchronized BatterySavingStats getInstance() {
        if (sInstance == null) {
            sInstance = new BatterySavingStats(new MetricsLogger());
        }
        return sInstance;
    }

    private BatteryManagerInternal getBatteryManagerInternal() {
        if (this.mBatteryManagerInternal == null) {
            this.mBatteryManagerInternal = LocalServices.getService(BatteryManagerInternal.class);
            if (this.mBatteryManagerInternal == null) {
                Slog.wtf(TAG, "BatteryManagerInternal not initialized");
            }
        }
        return this.mBatteryManagerInternal;
    }

    @VisibleForTesting
    static int statesToIndex(int batterySaverState, int interactiveState, int dozeState) {
        int ret = batterySaverState & 1;
        ret |= (interactiveState & 1) << 1;
        return ret |= (dozeState & 3) << 2;
    }

    @VisibleForTesting
    static String stateToString(int state) {
        switch (state) {
            case -1: {
                return "NotInitialized";
            }
            case -2: {
                return "Charging";
            }
        }
        return "BS=" + BatterySaverState.fromIndex(state) + ",I=" + InteractiveState.fromIndex(state) + ",D=" + DozeState.fromIndex(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Stat getStat(int stateIndex) {
        Object object = this.mLock;
        synchronized (object) {
            Stat stat = this.mStats.get(stateIndex);
            if (stat == null) {
                stat = new Stat();
                this.mStats.put(stateIndex, stat);
            }
            return stat;
        }
    }

    private Stat getStat(int batterySaverState, int interactiveState, int dozeState) {
        return this.getStat(BatterySavingStats.statesToIndex(batterySaverState, interactiveState, dozeState));
    }

    @VisibleForTesting
    long injectCurrentTime() {
        return SystemClock.elapsedRealtime();
    }

    @VisibleForTesting
    int injectBatteryLevel() {
        BatteryManagerInternal bmi = this.getBatteryManagerInternal();
        if (bmi == null) {
            return 0;
        }
        return bmi.getBatteryChargeCounter();
    }

    @VisibleForTesting
    int injectBatteryPercent() {
        BatteryManagerInternal bmi = this.getBatteryManagerInternal();
        if (bmi == null) {
            return 0;
        }
        return bmi.getBatteryLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transitionState(int batterySaverState, int interactiveState, int dozeState) {
        Object object = this.mLock;
        synchronized (object) {
            int newState = BatterySavingStats.statesToIndex(batterySaverState, interactiveState, dozeState);
            this.transitionStateLocked(newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCharging() {
        Object object = this.mLock;
        synchronized (object) {
            this.transitionStateLocked(-2);
        }
    }

    private void transitionStateLocked(int newState) {
        if (this.mCurrentState == newState) {
            return;
        }
        long now = this.injectCurrentTime();
        int batteryLevel = this.injectBatteryLevel();
        int batteryPercent = this.injectBatteryPercent();
        this.endLastStateLocked(now, batteryLevel, batteryPercent);
        this.startNewStateLocked(newState, now, batteryLevel, batteryPercent);
        this.mMetricsLoggerHelper.transitionState(newState, now, batteryLevel, batteryPercent);
    }

    private void endLastStateLocked(long now, int batteryLevel, int batteryPercent) {
        if (this.mCurrentState < 0) {
            return;
        }
        Stat stat = this.getStat(this.mCurrentState);
        stat.endBatteryLevel = batteryLevel;
        stat.endBatteryPercent = batteryPercent;
        stat.endTime = now;
        long deltaTime = stat.endTime - stat.startTime;
        int deltaDrain = stat.startBatteryLevel - stat.endBatteryLevel;
        int deltaPercent = stat.startBatteryPercent - stat.endBatteryPercent;
        stat.totalTimeMillis += deltaTime;
        stat.totalBatteryDrain += deltaDrain;
        stat.totalBatteryDrainPercent += deltaPercent;
        EventLogTags.writeBatterySavingStats(BatterySaverState.fromIndex(this.mCurrentState), InteractiveState.fromIndex(this.mCurrentState), DozeState.fromIndex(this.mCurrentState), deltaTime, deltaDrain, deltaPercent, stat.totalTimeMillis, stat.totalBatteryDrain, stat.totalBatteryDrainPercent);
    }

    private void startNewStateLocked(int newState, long now, int batteryLevel, int batteryPercent) {
        this.mCurrentState = newState;
        if (this.mCurrentState < 0) {
            return;
        }
        Stat stat = this.getStat(this.mCurrentState);
        stat.startBatteryLevel = batteryLevel;
        stat.startBatteryPercent = batteryPercent;
        stat.startTime = now;
        stat.endTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, String indent) {
        Object object = this.mLock;
        synchronized (object) {
            pw.print(indent);
            pw.println("Battery Saving Stats:");
            indent = indent + "  ";
            pw.print(indent);
            pw.println("Battery Saver:     w/Off                                      w/On");
            this.dumpLineLocked(pw, indent, 0, "NonIntr", 0, "NonDoze");
            this.dumpLineLocked(pw, indent, 1, "   Intr", 0, "       ");
            this.dumpLineLocked(pw, indent, 0, "NonIntr", 2, "Deep   ");
            this.dumpLineLocked(pw, indent, 1, "   Intr", 2, "       ");
            this.dumpLineLocked(pw, indent, 0, "NonIntr", 1, "Light  ");
            this.dumpLineLocked(pw, indent, 1, "   Intr", 1, "       ");
            pw.println();
        }
    }

    private void dumpLineLocked(PrintWriter pw, String indent, int interactiveState, String interactiveLabel, int dozeState, String dozeLabel) {
        pw.print(indent);
        pw.print(dozeLabel);
        pw.print(" ");
        pw.print(interactiveLabel);
        pw.print(": ");
        Stat offStat = this.getStat(0, interactiveState, dozeState);
        Stat onStat = this.getStat(1, interactiveState, dozeState);
        pw.println(String.format("%6dm %6dmA (%3d%%) %8.1fmA/h      %6dm %6dmA (%3d%%) %8.1fmA/h", offStat.totalMinutes(), offStat.totalBatteryDrain / 1000, offStat.totalBatteryDrainPercent, offStat.drainPerHour() / 1000.0, onStat.totalMinutes(), onStat.totalBatteryDrain / 1000, onStat.totalBatteryDrainPercent, onStat.drainPerHour() / 1000.0));
    }

    @VisibleForTesting
    class MetricsLoggerHelper {
        private int mLastState = -1;
        private long mStartTime;
        private int mStartBatteryLevel;
        private int mStartPercent;
        private static final int STATE_CHANGE_DETECT_MASK = 3;

        MetricsLoggerHelper() {
        }

        public void transitionState(int newState, long now, int batteryLevel, int batteryPercent) {
            boolean stateChanging;
            boolean bl = stateChanging = this.mLastState >= 0 ^ newState >= 0 || ((this.mLastState ^ newState) & 3) != 0;
            if (stateChanging) {
                if (this.mLastState >= 0) {
                    long deltaTime = now - this.mStartTime;
                    int deltaBattery = this.mStartBatteryLevel - batteryLevel;
                    int deltaPercent = this.mStartPercent - batteryPercent;
                    this.report(this.mLastState, deltaTime, deltaBattery, deltaPercent);
                }
                this.mStartTime = now;
                this.mStartBatteryLevel = batteryLevel;
                this.mStartPercent = batteryPercent;
            }
            this.mLastState = newState;
        }

        String getCounterSuffix(int state) {
            boolean interactive;
            boolean batterySaver = BatterySaverState.fromIndex(state) != 0;
            boolean bl = interactive = InteractiveState.fromIndex(state) != 0;
            if (batterySaver) {
                return interactive ? "11" : "10";
            }
            return interactive ? "01" : "00";
        }

        void report(int state, long deltaTimeMs, int deltaBatteryUa, int deltaPercent) {
            String suffix = this.getCounterSuffix(state);
            BatterySavingStats.this.mMetricsLogger.count(BatterySavingStats.COUNTER_POWER_MILLIAMPS_PREFIX + suffix, deltaBatteryUa / 1000);
            BatterySavingStats.this.mMetricsLogger.count(BatterySavingStats.COUNTER_POWER_PERCENT_PREFIX + suffix, deltaPercent);
            BatterySavingStats.this.mMetricsLogger.count(BatterySavingStats.COUNTER_TIME_SECONDS_PREFIX + suffix, (int)(deltaTimeMs / 1000L));
        }
    }

    static class Stat {
        public long startTime;
        public long endTime;
        public int startBatteryLevel;
        public int endBatteryLevel;
        public int startBatteryPercent;
        public int endBatteryPercent;
        public long totalTimeMillis;
        public int totalBatteryDrain;
        public int totalBatteryDrainPercent;

        Stat() {
        }

        public long totalMinutes() {
            return this.totalTimeMillis / 60000L;
        }

        public double drainPerHour() {
            if (this.totalTimeMillis == 0L) {
                return 0.0;
            }
            return (double)this.totalBatteryDrain / ((double)this.totalTimeMillis / 3600000.0);
        }

        public double drainPercentPerHour() {
            if (this.totalTimeMillis == 0L) {
                return 0.0;
            }
            return (double)this.totalBatteryDrainPercent / ((double)this.totalTimeMillis / 3600000.0);
        }

        @VisibleForTesting
        String toStringForTest() {
            return "{" + this.totalMinutes() + "m," + this.totalBatteryDrain + "," + String.format("%.2f", this.drainPerHour()) + "uA/H," + String.format("%.2f", this.drainPercentPerHour()) + "%}";
        }
    }

    static interface DozeState {
        public static final int NOT_DOZING = 0;
        public static final int LIGHT = 1;
        public static final int DEEP = 2;
        public static final int SHIFT = 2;
        public static final int BITS = 2;
        public static final int MASK = 3;

        public static int fromIndex(int index) {
            return index >> 2 & 3;
        }
    }

    static interface InteractiveState {
        public static final int NON_INTERACTIVE = 0;
        public static final int INTERACTIVE = 1;
        public static final int SHIFT = 1;
        public static final int BITS = 1;
        public static final int MASK = 1;

        public static int fromIndex(int index) {
            return index >> 1 & 1;
        }
    }

    static interface BatterySaverState {
        public static final int OFF = 0;
        public static final int ON = 1;
        public static final int SHIFT = 0;
        public static final int BITS = 1;
        public static final int MASK = 1;

        public static int fromIndex(int index) {
            return index >> 0 & 1;
        }
    }
}

