/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.security;

import android.os.SharedMemory;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.apk.ApkSignatureVerifier;
import android.util.apk.ByteBufferFactory;
import android.util.apk.SignatureNotFoundException;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public abstract class VerityUtils {
    private static final String TAG = "VerityUtils";
    private static final boolean DEBUG = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SetupResult generateApkVeritySetupData(String apkPath) {
        try (SharedMemory shm = null;){
            byte[] signedRootHash = ApkSignatureVerifier.getVerityRootHash(apkPath);
            if (signedRootHash == null) {
                SetupResult setupResult = SetupResult.skipped();
                return setupResult;
            }
            shm = VerityUtils.generateApkVerityIntoSharedMemory(apkPath, signedRootHash);
            FileDescriptor rfd = shm.getFileDescriptor();
            if (rfd == null || !rfd.valid()) {
                SetupResult setupResult = SetupResult.failed();
                return setupResult;
            }
            SetupResult setupResult = SetupResult.ok(Os.dup(rfd));
            return setupResult;
        }
    }

    public static byte[] generateFsverityRootHash(String apkPath) throws NoSuchAlgorithmException, DigestException, IOException {
        return ApkSignatureVerifier.generateFsverityRootHash(apkPath);
    }

    private static SharedMemory generateApkVerityIntoSharedMemory(String apkPath, byte[] expectedRootHash) throws IOException, SecurityException, DigestException, NoSuchAlgorithmException, SignatureNotFoundException {
        TrackedShmBufferFactory shmBufferFactory = new TrackedShmBufferFactory();
        byte[] generatedRootHash = ApkSignatureVerifier.generateApkVerity(apkPath, shmBufferFactory);
        if (!Arrays.equals(expectedRootHash, generatedRootHash)) {
            throw new SecurityException("Locally generated verity root hash does not match");
        }
        SharedMemory shm = shmBufferFactory.releaseSharedMemory();
        if (shm == null) {
            throw new IllegalStateException("Failed to generate verity tree into shared memory");
        }
        if (!shm.setProtect(OsConstants.PROT_READ)) {
            throw new SecurityException("Failed to set up shared memory correctly");
        }
        return shm;
    }

    private static class TrackedShmBufferFactory
    implements ByteBufferFactory {
        private SharedMemory mShm;
        private ByteBuffer mBuffer;

        private TrackedShmBufferFactory() {
        }

        @Override
        public ByteBuffer create(int capacity) throws SecurityException {
            try {
                if (this.mBuffer != null) {
                    throw new IllegalStateException("Multiple instantiation from this factory");
                }
                this.mShm = SharedMemory.create("apkverity", capacity);
                if (!this.mShm.setProtect(OsConstants.PROT_READ | OsConstants.PROT_WRITE)) {
                    throw new SecurityException("Failed to set protection");
                }
                this.mBuffer = this.mShm.mapReadWrite();
                return this.mBuffer;
            }
            catch (ErrnoException e) {
                throw new SecurityException("Failed to set protection", e);
            }
        }

        public SharedMemory releaseSharedMemory() {
            if (this.mBuffer != null) {
                SharedMemory.unmap(this.mBuffer);
                this.mBuffer = null;
            }
            SharedMemory tmp = this.mShm;
            this.mShm = null;
            return tmp;
        }
    }

    public static class SetupResult {
        private static final int RESULT_OK = 1;
        private static final int RESULT_SKIPPED = 2;
        private static final int RESULT_FAILED = 3;
        private final int mCode;
        private final FileDescriptor mFileDescriptor;

        public static SetupResult ok(FileDescriptor fileDescriptor) {
            return new SetupResult(1, fileDescriptor);
        }

        public static SetupResult skipped() {
            return new SetupResult(2, null);
        }

        public static SetupResult failed() {
            return new SetupResult(3, null);
        }

        private SetupResult(int code, FileDescriptor fileDescriptor) {
            this.mCode = code;
            this.mFileDescriptor = fileDescriptor;
        }

        public boolean isFailed() {
            return this.mCode == 3;
        }

        public boolean isOk() {
            return this.mCode == 1;
        }

        public FileDescriptor getUnownedFileDescriptor() {
            return this.mFileDescriptor;
        }
    }
}

