/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.slice;

import android.app.slice.ISliceListener;
import android.app.slice.Slice;
import android.app.slice.SliceSpec;
import android.content.ContentProviderClient;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.slice.SliceManagerService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class PinnedSliceState {
    private static final long SLICE_TIMEOUT = 5000L;
    private static final String TAG = "PinnedSliceState";
    private final Object mLock;
    private final SliceManagerService mService;
    private final Uri mUri;
    @GuardedBy(value="mLock")
    private final ArraySet<String> mPinnedPkgs = new ArraySet();
    @GuardedBy(value="mLock")
    private final ArrayMap<IBinder, ListenerInfo> mListeners = new ArrayMap();
    @GuardedBy(value="mLock")
    private SliceSpec[] mSupportedSpecs = null;
    private final IBinder.DeathRecipient mDeathRecipient = this::handleRecheckListeners;
    private boolean mSlicePinned;

    public PinnedSliceState(SliceManagerService service, Uri uri) {
        this.mService = service;
        this.mUri = uri;
        this.mLock = this.mService.getLock();
    }

    public SliceSpec[] getSpecs() {
        return this.mSupportedSpecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeSpecs(SliceSpec[] supportedSpecs) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSupportedSpecs == null) {
                this.mSupportedSpecs = supportedSpecs;
            } else {
                List<SliceSpec> specs = Arrays.asList(this.mSupportedSpecs);
                this.mSupportedSpecs = (SliceSpec[])specs.stream().map(s -> {
                    SliceSpec other = this.findSpec(supportedSpecs, s.getType());
                    if (other == null) {
                        return null;
                    }
                    if (other.getRevision() < s.getRevision()) {
                        return other;
                    }
                    return s;
                }).filter(s -> s != null).toArray(SliceSpec[]::new);
            }
        }
    }

    private SliceSpec findSpec(SliceSpec[] specs, String type) {
        for (SliceSpec spec : specs) {
            if (!Objects.equals(spec.getType(), type)) continue;
            return spec;
        }
        return null;
    }

    public Uri getUri() {
        return this.mUri;
    }

    public void destroy() {
        this.setSlicePinned(false);
    }

    public void onChange() {
        this.mService.getHandler().post(this::handleBind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSlicePinned(boolean pinned) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSlicePinned == pinned) {
                return;
            }
            this.mSlicePinned = pinned;
            if (pinned) {
                this.mService.getHandler().post(this::handleSendPinned);
            } else {
                this.mService.getHandler().post(this::handleSendUnpinned);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSliceListener(ISliceListener listener, String pkg, SliceSpec[] specs, boolean hasPermission) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mListeners.size() == 0) {
                this.mService.listen(this.mUri);
            }
            try {
                listener.asBinder().linkToDeath(this.mDeathRecipient, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mListeners.put(listener.asBinder(), new ListenerInfo(listener, pkg, hasPermission, Binder.getCallingUid(), Binder.getCallingPid()));
            this.mergeSpecs(specs);
            this.setSlicePinned(hasPermission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSliceListener(ISliceListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            listener.asBinder().unlinkToDeath(this.mDeathRecipient, 0);
            if (this.mListeners.containsKey(listener.asBinder()) && this.mListeners.size() == 1) {
                this.mService.unlisten(this.mUri);
            }
            this.mListeners.remove(listener.asBinder());
        }
        return !this.hasPinOrListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pin(String pkg, SliceSpec[] specs) {
        Object object = this.mLock;
        synchronized (object) {
            this.setSlicePinned(true);
            this.mPinnedPkgs.add(pkg);
            this.mergeSpecs(specs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unpin(String pkg) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPinnedPkgs.remove(pkg);
        }
        return !this.hasPinOrListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListening() {
        Object object = this.mLock;
        synchronized (object) {
            return !this.mListeners.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recheckPackage(String pkg) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mListeners.size(); ++i) {
                ListenerInfo info = this.mListeners.valueAt(i);
                if (info.hasPermission || !Objects.equals(info.pkg, pkg)) continue;
                this.mService.getHandler().post(() -> {
                    Slice s = this.doBind(info);
                    if (this.mService.checkAccess(info.pkg, this.mUri, info.callingUid, info.callingPid) == 0) {
                        info.hasPermission = true;
                        this.setSlicePinned(true);
                        try {
                            info.listener.onSliceUpdated(s);
                        }
                        catch (RemoteException e) {
                            this.checkSelfRemove();
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean hasPinOrListener() {
        Object object = this.mLock;
        synchronized (object) {
            return !this.mPinnedPkgs.isEmpty() || !this.mListeners.isEmpty();
        }
    }

    ContentProviderClient getClient() {
        ContentProviderClient client = this.mService.getContext().getContentResolver().acquireContentProviderClient(this.mUri);
        if (client == null) {
            return null;
        }
        client.setDetectNotResponding(5000L);
        return client;
    }

    private void checkSelfRemove() {
        if (!this.hasPinOrListener()) {
            this.mService.unlisten(this.mUri);
            this.mService.removePinnedSlice(this.mUri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecheckListeners() {
        if (!this.hasPinOrListener()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mListeners.size() - 1; i >= 0; --i) {
                ListenerInfo l = this.mListeners.valueAt(i);
                if (l.listener.asBinder().isBinderAlive()) continue;
                this.mListeners.removeAt(i);
            }
            this.checkSelfRemove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBind() {
        Slice cachedSlice = this.doBind(null);
        Object object = this.mLock;
        synchronized (object) {
            if (!this.hasPinOrListener()) {
                return;
            }
            for (int i = this.mListeners.size() - 1; i >= 0; --i) {
                ListenerInfo info = this.mListeners.valueAt(i);
                Slice s = cachedSlice;
                if (s == null || s.hasHint("caller_needed") || !info.hasPermission) {
                    s = this.doBind(info);
                }
                if (s == null) {
                    this.mListeners.removeAt(i);
                    continue;
                }
                try {
                    info.listener.onSliceUpdated(s);
                    continue;
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Unable to notify slice " + this.mUri, e);
                    this.mListeners.removeAt(i);
                }
            }
            this.checkSelfRemove();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Slice doBind(ListenerInfo info) {
        try (ContentProviderClient client = this.getClient();){
            Bundle res;
            if (client == null) {
                Slice slice = null;
                return slice;
            }
            Bundle extras = new Bundle();
            extras.putParcelable("slice_uri", this.mUri);
            extras.putParcelableArrayList("supported_specs", new ArrayList<SliceSpec>(Arrays.asList(this.mSupportedSpecs)));
            if (info != null) {
                extras.putString("override_pkg", info.pkg);
                extras.putInt("override_uid", info.callingUid);
                extras.putInt("override_pid", info.callingPid);
            }
            try {
                res = client.call("bind_slice", null, extras);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Unable to bind slice " + this.mUri, e);
                Slice slice = null;
                if (client == null) return slice;
                PinnedSliceState.$closeResource(var3_4, client);
                return slice;
            }
            if (res == null) {
                Slice slice = null;
                return slice;
            }
            Bundle.setDefusable(res, true);
            Slice slice = (Slice)res.getParcelable("slice");
            return slice;
        }
        catch (Throwable t) {
            Log.e(TAG, "Caught throwable while binding " + this.mUri, t);
            return null;
        }
    }

    private void handleSendPinned() {
        try (ContentProviderClient client = this.getClient();){
            if (client == null) {
                return;
            }
            Bundle b = new Bundle();
            b.putParcelable("slice_uri", this.mUri);
            try {
                client.call("pin", null, b);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Unable to contact " + this.mUri, e);
            }
        }
    }

    private void handleSendUnpinned() {
        try (ContentProviderClient client = this.getClient();){
            if (client == null) {
                return;
            }
            Bundle b = new Bundle();
            b.putParcelable("slice_uri", this.mUri);
            try {
                client.call("unpin", null, b);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Unable to contact " + this.mUri, e);
            }
        }
    }

    private class ListenerInfo {
        private ISliceListener listener;
        private String pkg;
        private boolean hasPermission;
        private int callingUid;
        private int callingPid;

        public ListenerInfo(ISliceListener listener, String pkg, boolean hasPermission, int callingUid, int callingPid) {
            this.listener = listener;
            this.pkg = pkg;
            this.hasPermission = hasPermission;
            this.callingUid = callingUid;
            this.callingPid = callingPid;
        }
    }
}

