/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.slice;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.ContentProviderHolder;
import android.app.IActivityManager;
import android.app.slice.ISliceListener;
import android.app.slice.ISliceManager;
import android.app.slice.SliceSpec;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ResolveInfo;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Log;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.AssistUtils;
import com.android.internal.util.Preconditions;
import com.android.server.LocalServices;
import com.android.server.ServiceThread;
import com.android.server.SystemService;
import com.android.server.slice.PinnedSliceState;
import com.android.server.slice.SliceFullAccessList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class SliceManagerService
extends ISliceManager.Stub {
    private static final String TAG = "SliceManagerService";
    private final Object mLock = new Object();
    private final Context mContext;
    private final PackageManagerInternal mPackageManagerInternal;
    private final AppOpsManager mAppOps;
    private final AssistUtils mAssistUtils;
    @GuardedBy(value="mLock")
    private final ArrayMap<Uri, PinnedSliceState> mPinnedSlicesByUri = new ArrayMap();
    @GuardedBy(value="mLock")
    private final ArraySet<SliceGrant> mUserGrants = new ArraySet();
    private final Handler mHandler;
    private final ContentObserver mObserver;
    @GuardedBy(value="mSliceAccessFile")
    private final AtomicFile mSliceAccessFile;
    @GuardedBy(value="mAccessList")
    private final SliceFullAccessList mAccessList;
    private final Runnable mSaveAccessList = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AtomicFile atomicFile = SliceManagerService.this.mSliceAccessFile;
            synchronized (atomicFile) {
                FileOutputStream stream;
                try {
                    stream = SliceManagerService.this.mSliceAccessFile.startWrite();
                }
                catch (IOException e) {
                    Slog.w(SliceManagerService.TAG, "Failed to save access file", e);
                    return;
                }
                try {
                    XmlSerializer out = XmlPullParserFactory.newInstance().newSerializer();
                    out.setOutput(stream, Xml.Encoding.UTF_8.name());
                    SliceFullAccessList sliceFullAccessList = SliceManagerService.this.mAccessList;
                    synchronized (sliceFullAccessList) {
                        SliceManagerService.this.mAccessList.writeXml(out, -1);
                    }
                    out.flush();
                    SliceManagerService.this.mSliceAccessFile.finishWrite(stream);
                }
                catch (IOException | XmlPullParserException e) {
                    Slog.w(SliceManagerService.TAG, "Failed to save access file, restoring backup", e);
                    SliceManagerService.this.mSliceAccessFile.failWrite(stream);
                }
            }
        }
    };
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String pkg;
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
            if (userId == -10000) {
                Slog.w(SliceManagerService.TAG, "Intent broadcast does not contain user handle: " + intent);
                return;
            }
            Uri data = intent.getData();
            String string2 = pkg = data != null ? data.getSchemeSpecificPart() : null;
            if (pkg == null) {
                Slog.w(SliceManagerService.TAG, "Intent broadcast does not contain package name: " + intent);
                return;
            }
            switch (intent.getAction()) {
                case "android.intent.action.PACKAGE_REMOVED": {
                    boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                    if (replacing) break;
                    SliceManagerService.this.removeFullAccess(pkg, userId);
                    break;
                }
                case "android.intent.action.PACKAGE_DATA_CLEARED": {
                    SliceManagerService.this.removeFullAccess(pkg, userId);
                }
            }
        }
    };

    public SliceManagerService(Context context) {
        this(context, SliceManagerService.createHandler().getLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    SliceManagerService(Context context, Looper looper) {
        this.mContext = context;
        this.mPackageManagerInternal = Preconditions.checkNotNull(LocalServices.getService(PackageManagerInternal.class));
        this.mAppOps = context.getSystemService(AppOpsManager.class);
        this.mAssistUtils = new AssistUtils(context);
        this.mHandler = new Handler(looper);
        this.mObserver = new ContentObserver(this.mHandler){

            @Override
            public void onChange(boolean selfChange, Uri uri, int userId) {
                try {
                    SliceManagerService.this.getPinnedSlice(ContentProvider.maybeAddUserId(uri, userId)).onChange();
                }
                catch (IllegalStateException e) {
                    Log.e(SliceManagerService.TAG, "Received change for unpinned slice " + uri, e);
                }
            }
        };
        File systemDir = new File(Environment.getDataDirectory(), "system");
        this.mSliceAccessFile = new AtomicFile(new File(systemDir, "slice_access.xml"));
        this.mAccessList = new SliceFullAccessList(this.mContext);
        AtomicFile atomicFile = this.mSliceAccessFile;
        synchronized (atomicFile) {
            if (!this.mSliceAccessFile.exists()) {
                return;
            }
            try {
                FileInputStream input = this.mSliceAccessFile.openRead();
                XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
                parser.setInput(input, Xml.Encoding.UTF_8.name());
                SliceFullAccessList sliceFullAccessList = this.mAccessList;
                synchronized (sliceFullAccessList) {
                    this.mAccessList.readXml(parser);
                }
            }
            catch (IOException | XmlPullParserException e) {
                Slog.d(TAG, "Can't read slice access file", e);
            }
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_DATA_CLEARED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addDataScheme("package");
        this.mContext.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, filter, null, this.mHandler);
    }

    private void systemReady() {
    }

    private void onUnlockUser(int userId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStopUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPinnedSlicesByUri.values().removeIf(s -> ContentProvider.getUserIdFromUri(s.getUri()) == userId);
        }
    }

    @Override
    public void addSliceListener(Uri uri, String pkg, ISliceListener listener, SliceSpec[] specs) throws RemoteException {
        this.verifyCaller(pkg);
        uri = ContentProvider.maybeAddUserId(uri, Binder.getCallingUserHandle().getIdentifier());
        this.enforceCrossUser(pkg, uri);
        this.getOrCreatePinnedSlice(uri).addSliceListener(listener, pkg, specs, this.checkAccess(pkg, uri, Binder.getCallingUid(), Binder.getCallingUid()) == 0);
    }

    @Override
    public void removeSliceListener(Uri uri, String pkg, ISliceListener listener) throws RemoteException {
        this.verifyCaller(pkg);
        uri = ContentProvider.maybeAddUserId(uri, Binder.getCallingUserHandle().getIdentifier());
        if (this.getPinnedSlice(uri).removeSliceListener(listener)) {
            this.removePinnedSlice(uri);
        }
    }

    @Override
    public void pinSlice(String pkg, Uri uri, SliceSpec[] specs) throws RemoteException {
        this.verifyCaller(pkg);
        this.enforceFullAccess(pkg, "pinSlice", uri);
        uri = ContentProvider.maybeAddUserId(uri, Binder.getCallingUserHandle().getIdentifier());
        this.getOrCreatePinnedSlice(uri).pin(pkg, specs);
    }

    @Override
    public void unpinSlice(String pkg, Uri uri) throws RemoteException {
        this.verifyCaller(pkg);
        this.enforceFullAccess(pkg, "unpinSlice", uri);
        uri = ContentProvider.maybeAddUserId(uri, Binder.getCallingUserHandle().getIdentifier());
        if (this.getPinnedSlice(uri).unpin(pkg)) {
            this.removePinnedSlice(uri);
        }
    }

    @Override
    public boolean hasSliceAccess(String pkg) throws RemoteException {
        this.verifyCaller(pkg);
        return this.hasFullSliceAccess(pkg, Binder.getCallingUserHandle().getIdentifier());
    }

    @Override
    public SliceSpec[] getPinnedSpecs(Uri uri, String pkg) throws RemoteException {
        this.verifyCaller(pkg);
        this.enforceAccess(pkg, uri);
        return this.getPinnedSlice(uri).getSpecs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkSlicePermission(Uri uri, String pkg, int pid, int uid) throws RemoteException {
        if (this.mContext.checkUriPermission(uri, pid, uid, 2) == 0) {
            return 0;
        }
        if (this.hasFullSliceAccess(pkg, UserHandle.getUserId(uid))) {
            return 0;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserGrants.contains(new SliceGrant(uri, pkg, UserHandle.getUserId(uid)))) {
                return 1;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantPermissionFromUser(Uri uri, String pkg, String callingPkg, boolean allSlices) {
        Object object;
        this.verifyCaller(callingPkg);
        this.getContext().enforceCallingOrSelfPermission("android.permission.MANAGE_SLICE_PERMISSIONS", "Slice granting requires MANAGE_SLICE_PERMISSIONS");
        if (allSlices) {
            object = this.mAccessList;
            synchronized (object) {
                this.mAccessList.grantFullAccess(pkg, Binder.getCallingUserHandle().getIdentifier());
            }
            this.mHandler.post(this.mSaveAccessList);
        } else {
            object = this.mLock;
            synchronized (object) {
                this.mUserGrants.add(new SliceGrant(uri, pkg, Binder.getCallingUserHandle().getIdentifier()));
            }
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.getContentResolver().notifyChange(uri, null);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        Object object2 = this.mLock;
        synchronized (object2) {
            for (PinnedSliceState p : this.mPinnedSlicesByUri.values()) {
                p.recheckPackage(pkg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBackupPayload(int user) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Caller must be system");
        }
        if (user != 0) {
            Slog.w(TAG, "getBackupPayload: cannot backup policy for user " + user);
            return null;
        }
        AtomicFile atomicFile = this.mSliceAccessFile;
        synchronized (atomicFile) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                XmlSerializer out = XmlPullParserFactory.newInstance().newSerializer();
                out.setOutput(baos, Xml.Encoding.UTF_8.name());
                SliceFullAccessList sliceFullAccessList = this.mAccessList;
                synchronized (sliceFullAccessList) {
                    this.mAccessList.writeXml(out, user);
                }
                out.flush();
                return baos.toByteArray();
            }
            catch (IOException | XmlPullParserException e) {
                Slog.w(TAG, "getBackupPayload: error writing payload for user " + user, e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyRestore(byte[] payload, int user) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Caller must be system");
        }
        if (payload == null) {
            Slog.w(TAG, "applyRestore: no payload to restore for user " + user);
            return;
        }
        if (user != 0) {
            Slog.w(TAG, "applyRestore: cannot restore policy for user " + user);
            return;
        }
        AtomicFile atomicFile = this.mSliceAccessFile;
        synchronized (atomicFile) {
            ByteArrayInputStream bais = new ByteArrayInputStream(payload);
            try {
                XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
                parser.setInput(bais, Xml.Encoding.UTF_8.name());
                SliceFullAccessList sliceFullAccessList = this.mAccessList;
                synchronized (sliceFullAccessList) {
                    this.mAccessList.readXml(parser);
                }
                this.mHandler.post(this.mSaveAccessList);
            }
            catch (IOException | NumberFormatException | XmlPullParserException e) {
                Slog.w(TAG, "applyRestore: error reading payload", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFullAccess(String pkg, int userId) {
        SliceFullAccessList sliceFullAccessList = this.mAccessList;
        synchronized (sliceFullAccessList) {
            this.mAccessList.removeGrant(pkg, userId);
        }
        this.mHandler.post(this.mSaveAccessList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePinnedSlice(Uri uri) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPinnedSlicesByUri.remove(uri).destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PinnedSliceState getPinnedSlice(Uri uri) {
        Object object = this.mLock;
        synchronized (object) {
            PinnedSliceState manager = this.mPinnedSlicesByUri.get(uri);
            if (manager == null) {
                throw new IllegalStateException(String.format("Slice %s not pinned", uri.toString()));
            }
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PinnedSliceState getOrCreatePinnedSlice(Uri uri) {
        Object object = this.mLock;
        synchronized (object) {
            PinnedSliceState manager = this.mPinnedSlicesByUri.get(uri);
            if (manager == null) {
                manager = this.createPinnedSlice(uri);
                this.mPinnedSlicesByUri.put(uri, manager);
            }
            return manager;
        }
    }

    @VisibleForTesting
    protected PinnedSliceState createPinnedSlice(Uri uri) {
        return new PinnedSliceState(this, uri);
    }

    public Object getLock() {
        return this.mLock;
    }

    public Context getContext() {
        return this.mContext;
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int checkAccess(String pkg, Uri uri, int uid, int pid) {
        int user = UserHandle.getUserId(uid);
        if (this.hasFullSliceAccess(pkg, user)) return 0;
        if (this.getContext().checkUriPermission(uri, pid, uid, 2) == 0) return 0;
        long ident = Binder.clearCallingIdentity();
        try {
            String providerName;
            ContentProviderHolder holder;
            IActivityManager activityManager;
            Binder token;
            block9: {
                token = new Binder();
                activityManager = ActivityManager.getService();
                holder = null;
                providerName = ContentProvider.getUriWithoutUserId(uri).getAuthority();
                try {
                    int n;
                    try {
                        holder = activityManager.getContentProviderExternal(providerName, ContentProvider.getUserIdFromUri(uri, user), token);
                        if (holder != null && holder.info != null && Objects.equals(holder.info.packageName, pkg)) break block9;
                        n = -1;
                        if (holder == null) return n;
                        if (holder.provider == null) return n;
                    }
                    catch (Throwable throwable) {
                        if (holder == null) throw throwable;
                        if (holder.provider == null) throw throwable;
                        activityManager.removeContentProviderExternal(providerName, token);
                        throw throwable;
                    }
                    activityManager.removeContentProviderExternal(providerName, token);
                    return n;
                }
                catch (RemoteException e) {
                    e.rethrowAsRuntimeException();
                    return 0;
                }
            }
            if (holder == null) return 0;
            if (holder.provider == null) return 0;
            activityManager.removeContentProviderExternal(providerName, token);
            return 0;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void enforceCrossUser(String pkg, Uri uri) {
        int user = Binder.getCallingUserHandle().getIdentifier();
        if (ContentProvider.getUserIdFromUri(uri, user) != user) {
            this.getContext().enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "Slice interaction across users requires INTERACT_ACROSS_USERS_FULL");
        }
    }

    private void enforceAccess(String pkg, Uri uri) throws RemoteException {
        if (this.checkAccess(pkg, uri, Binder.getCallingUid(), Binder.getCallingPid()) != 0) {
            throw new SecurityException("Access to slice " + uri + " is required");
        }
        this.enforceCrossUser(pkg, uri);
    }

    private void enforceFullAccess(String pkg, String name, Uri uri) {
        int user = Binder.getCallingUserHandle().getIdentifier();
        if (!this.hasFullSliceAccess(pkg, user)) {
            throw new SecurityException(String.format("Call %s requires full slice access", name));
        }
        this.enforceCrossUser(pkg, uri);
    }

    private void verifyCaller(String pkg) {
        this.mAppOps.checkPackage(Binder.getCallingUid(), pkg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasFullSliceAccess(String pkg, int userId) {
        long ident = Binder.clearCallingIdentity();
        try {
            boolean ret;
            boolean bl = ret = this.isDefaultHomeApp(pkg, userId) || this.isAssistant(pkg, userId) || this.isGrantedFullAccess(pkg, userId);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private boolean isAssistant(String pkg, int userId) {
        ComponentName cn = this.mAssistUtils.getAssistComponentForUser(userId);
        if (cn == null) {
            return false;
        }
        return cn.getPackageName().equals(pkg);
    }

    public void listen(Uri uri) {
        this.mContext.getContentResolver().registerContentObserver(uri, true, this.mObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlisten(Uri uri) {
        this.mContext.getContentResolver().unregisterContentObserver(this.mObserver);
        Object object = this.mLock;
        synchronized (object) {
            this.mPinnedSlicesByUri.forEach((u, s) -> {
                if (s.isListening()) {
                    this.listen((Uri)u);
                }
            });
        }
    }

    private boolean isDefaultHomeApp(String pkg, int userId) {
        String defaultHome = this.getDefaultHome(userId);
        return pkg != null && Objects.equals(pkg, defaultHome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected String getDefaultHome(int userId) {
        long token = Binder.clearCallingIdentity();
        try {
            ArrayList<ResolveInfo> allHomeCandidates = new ArrayList<ResolveInfo>();
            ComponentName defaultLauncher = this.mPackageManagerInternal.getHomeActivitiesAsUser(allHomeCandidates, userId);
            ComponentName detected = null;
            if (defaultLauncher != null) {
                detected = defaultLauncher;
            }
            if (detected == null) {
                int size = allHomeCandidates.size();
                int lastPriority = Integer.MIN_VALUE;
                for (int i = 0; i < size; ++i) {
                    ResolveInfo ri = (ResolveInfo)allHomeCandidates.get(i);
                    if (!ri.activityInfo.applicationInfo.isSystemApp() || ri.priority < lastPriority) continue;
                    detected = ri.activityInfo.getComponentName();
                    lastPriority = ri.priority;
                }
            }
            String string2 = detected != null ? detected.getPackageName() : null;
            return string2;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGrantedFullAccess(String pkg, int userId) {
        SliceFullAccessList sliceFullAccessList = this.mAccessList;
        synchronized (sliceFullAccessList) {
            return this.mAccessList.hasFullAccess(pkg, userId);
        }
    }

    private static ServiceThread createHandler() {
        ServiceThread handlerThread = new ServiceThread(TAG, 10, true);
        handlerThread.start();
        return handlerThread;
    }

    private class SliceGrant {
        private final Uri mUri;
        private final String mPkg;
        private final int mUserId;

        public SliceGrant(Uri uri, String pkg, int userId) {
            this.mUri = uri;
            this.mPkg = pkg;
            this.mUserId = userId;
        }

        public int hashCode() {
            return this.mUri.hashCode() + this.mPkg.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SliceGrant)) {
                return false;
            }
            SliceGrant other = (SliceGrant)obj;
            return Objects.equals(other.mUri, this.mUri) && Objects.equals(other.mPkg, this.mPkg) && other.mUserId == this.mUserId;
        }
    }

    public static class Lifecycle
    extends SystemService {
        private SliceManagerService mService;

        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            this.mService = new SliceManagerService(this.getContext());
            this.publishBinderService("slice", this.mService);
        }

        @Override
        public void onBootPhase(int phase) {
            if (phase == 550) {
                this.mService.systemReady();
            }
        }

        @Override
        public void onUnlockUser(int userHandle) {
            this.mService.onUnlockUser(userHandle);
        }

        @Override
        public void onStopUser(int userHandle) {
            this.mService.onStopUser(userHandle);
        }
    }
}

