/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.stats;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.UidTraffic;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.net.NetworkStats;
import android.net.wifi.IWifiManager;
import android.net.wifi.WifiActivityEnergyInfo;
import android.os.BatteryStatsInternal;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.IBinder;
import android.os.IStatsCompanionService;
import android.os.IStatsManager;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StatFs;
import android.os.StatsDimensionsValue;
import android.os.StatsLogEventWrapper;
import android.os.SynchronousResultReceiver;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.telephony.ModemActivityInfo;
import android.telephony.TelephonyManager;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.net.NetworkStatsFactory;
import com.android.internal.os.KernelCpuSpeedReader;
import com.android.internal.os.KernelWakelockReader;
import com.android.internal.os.KernelWakelockStats;
import com.android.internal.os.PowerProfile;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class StatsCompanionService
extends IStatsCompanionService.Stub {
    private static final long EXTERNAL_STATS_SYNC_TIMEOUT_MILLIS = 2000L;
    public static final String RESULT_RECEIVER_CONTROLLER_KEY = "controller_activity";
    static final String TAG = "StatsCompanionService";
    static final boolean DEBUG = true;
    public static final String ACTION_TRIGGER_COLLECTION = "com.android.server.stats.action.TRIGGER_COLLECTION";
    public static final int CODE_SUBSCRIBER_BROADCAST = 1;
    private final Context mContext;
    private final AlarmManager mAlarmManager;
    @GuardedBy(value="sStatsdLock")
    private static IStatsManager sStatsd;
    private static final Object sStatsdLock;
    private final PendingIntent mAnomalyAlarmIntent;
    private final PendingIntent mPullingAlarmIntent;
    private final BroadcastReceiver mAppUpdateReceiver;
    private final BroadcastReceiver mUserUpdateReceiver;
    private final ShutdownEventReceiver mShutdownEventReceiver;
    private final KernelWakelockReader mKernelWakelockReader = new KernelWakelockReader();
    private final KernelWakelockStats mTmpWakelockStats = new KernelWakelockStats();
    private final KernelCpuSpeedReader[] mKernelCpuSpeedReaders;
    private IWifiManager mWifiManager = null;
    private TelephonyManager mTelephony = null;
    private final StatFs mStatFsData = new StatFs(Environment.getDataDirectory().getAbsolutePath());
    private final StatFs mStatFsSystem = new StatFs(Environment.getRootDirectory().getAbsolutePath());
    private final StatFs mStatFsTemp = new StatFs(Environment.getDownloadCacheDirectory().getAbsolutePath());

    public StatsCompanionService(Context context) {
        this.mContext = context;
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        this.mAnomalyAlarmIntent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(this.mContext, AnomalyAlarmReceiver.class), 0);
        this.mPullingAlarmIntent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(this.mContext, PullingAlarmReceiver.class), 0);
        this.mAppUpdateReceiver = new AppUpdateReceiver();
        this.mUserUpdateReceiver = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                Object object = sStatsdLock;
                synchronized (object) {
                    sStatsd = StatsCompanionService.fetchStatsdService();
                    if (sStatsd == null) {
                        Slog.w(StatsCompanionService.TAG, "Could not access statsd");
                        return;
                    }
                    try {
                        StatsCompanionService.this.informAllUidsLocked(context);
                    }
                    catch (RemoteException e) {
                        Slog.e(StatsCompanionService.TAG, "Failed to inform statsd latest update of all apps", e);
                        StatsCompanionService.this.forgetEverything();
                    }
                }
            }
        };
        this.mShutdownEventReceiver = new ShutdownEventReceiver();
        Slog.w(TAG, "Registered receiver for ACTION_PACKAGE_REPLACE AND ADDED.");
        PowerProfile powerProfile = new PowerProfile(context);
        int numClusters = powerProfile.getNumCpuClusters();
        this.mKernelCpuSpeedReaders = new KernelCpuSpeedReader[numClusters];
        int firstCpuOfCluster = 0;
        for (int i = 0; i < numClusters; ++i) {
            int numSpeedSteps = powerProfile.getNumSpeedStepsInCpuCluster(i);
            this.mKernelCpuSpeedReaders[i] = new KernelCpuSpeedReader(firstCpuOfCluster, numSpeedSteps);
            firstCpuOfCluster += powerProfile.getNumCoresInCpuCluster(i);
        }
    }

    @Override
    public void sendBroadcast(String pkg, String cls) {
        this.enforceCallingPermission();
        this.mContext.sendBroadcastAsUser(new Intent(ACTION_TRIGGER_COLLECTION).setClassName(pkg, cls), UserHandle.SYSTEM);
    }

    @Override
    public void sendSubscriberBroadcast(IBinder intentSenderBinder, long configUid, long configKey, long subscriptionId, long subscriptionRuleId, StatsDimensionsValue dimensionsValue) {
        Slog.d(TAG, "Statsd requested to sendSubscriberBroadcast.");
        this.enforceCallingPermission();
        IntentSender intentSender = new IntentSender(intentSenderBinder);
        Intent intent = new Intent().putExtra("android.app.extra.STATS_CONFIG_UID", configUid).putExtra("android.app.extra.STATS_CONFIG_KEY", configKey).putExtra("android.app.extra.STATS_SUBSCRIPTION_ID", subscriptionId).putExtra("android.app.extra.STATS_SUBSCRIPTION_RULE_ID", subscriptionRuleId).putExtra("android.app.extra.STATS_DIMENSIONS_VALUE", dimensionsValue);
        try {
            intentSender.sendIntent(this.mContext, 1, intent, null, null);
        }
        catch (IntentSender.SendIntentException e) {
            Slog.w(TAG, "Unable to send using IntentSender from uid " + configUid + "; presumably it had been cancelled.");
            Slog.d(TAG, String.format("SubscriberBroadcast params {%d %d %d %d %s}", configUid, configKey, subscriptionId, subscriptionRuleId, dimensionsValue));
        }
    }

    private static final int[] toIntArray(List<Integer> list) {
        int[] ret = new int[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    private static final long[] toLongArray(List<Long> list) {
        long[] ret = new long[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    private final void informAllUidsLocked(Context context) throws RemoteException {
        UserManager um = (UserManager)context.getSystemService("user");
        PackageManager pm = context.getPackageManager();
        List<UserInfo> users = um.getUsers(true);
        Slog.w(TAG, "Iterating over " + users.size() + " profiles.");
        ArrayList<Integer> uids = new ArrayList<Integer>();
        ArrayList<Long> versions = new ArrayList<Long>();
        ArrayList<String> apps = new ArrayList<String>();
        for (UserInfo profile : users) {
            List<PackageInfo> pi = pm.getInstalledPackagesAsUser(0, profile.id);
            for (int j = 0; j < pi.size(); ++j) {
                if (pi.get((int)j).applicationInfo == null) continue;
                uids.add(pi.get((int)j).applicationInfo.uid);
                versions.add(pi.get(j).getLongVersionCode());
                apps.add(pi.get((int)j).packageName);
            }
        }
        sStatsd.informAllUidData(StatsCompanionService.toIntArray(uids), StatsCompanionService.toLongArray(versions), apps.toArray(new String[apps.size()]));
        Slog.w(TAG, "Sent data for " + uids.size() + " apps");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAnomalyAlarm(long timestampMs) {
        this.enforceCallingPermission();
        Slog.d(TAG, "Setting anomaly alarm for " + timestampMs);
        long callingToken = Binder.clearCallingIdentity();
        try {
            this.mAlarmManager.set(1, timestampMs, this.mAnomalyAlarmIntent);
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    @Override
    public void cancelAnomalyAlarm() {
        this.enforceCallingPermission();
        Slog.d(TAG, "Cancelling anomaly alarm");
        long callingToken = Binder.clearCallingIdentity();
        try {
            this.mAlarmManager.cancel(this.mAnomalyAlarmIntent);
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPullingAlarms(long timestampMs, long intervalMs) {
        this.enforceCallingPermission();
        Slog.d(TAG, "Setting pulling alarm for " + timestampMs + " every " + intervalMs + "ms");
        long callingToken = Binder.clearCallingIdentity();
        try {
            this.mAlarmManager.setRepeating(1, timestampMs, intervalMs, this.mPullingAlarmIntent);
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    @Override
    public void cancelPullingAlarms() {
        this.enforceCallingPermission();
        Slog.d(TAG, "Cancelling pulling alarm");
        long callingToken = Binder.clearCallingIdentity();
        try {
            this.mAlarmManager.cancel(this.mPullingAlarmIntent);
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    private void addNetworkStats(int tag, List<StatsLogEventWrapper> ret, NetworkStats stats, boolean withFGBG) {
        int size = stats.size();
        NetworkStats.Entry entry = new NetworkStats.Entry();
        for (int j = 0; j < size; ++j) {
            stats.getValues(j, entry);
            StatsLogEventWrapper e = new StatsLogEventWrapper(tag, withFGBG ? 6 : 5);
            e.writeInt(entry.uid);
            if (withFGBG) {
                e.writeInt(entry.set);
            }
            e.writeLong(entry.rxBytes);
            e.writeLong(entry.rxPackets);
            e.writeLong(entry.txBytes);
            e.writeLong(entry.txPackets);
            ret.add(e);
        }
    }

    private NetworkStats rollupNetworkStatsByFGBG(NetworkStats stats) {
        NetworkStats ret = new NetworkStats(stats.getElapsedRealtime(), 1);
        NetworkStats.Entry entry = new NetworkStats.Entry();
        entry.iface = NetworkStats.IFACE_ALL;
        entry.tag = 0;
        entry.metered = -1;
        entry.roaming = -1;
        int size = stats.size();
        NetworkStats.Entry recycle = new NetworkStats.Entry();
        for (int i = 0; i < size; ++i) {
            stats.getValues(i, recycle);
            if (recycle.tag != 0) continue;
            entry.set = recycle.set;
            entry.uid = recycle.uid;
            entry.rxBytes = recycle.rxBytes;
            entry.rxPackets = recycle.rxPackets;
            entry.txBytes = recycle.txBytes;
            entry.txPackets = recycle.txPackets;
            ret.combineValues(entry);
        }
        return ret;
    }

    private static <T extends Parcelable> T awaitControllerInfo(SynchronousResultReceiver receiver) {
        if (receiver == null) {
            return null;
        }
        try {
            SynchronousResultReceiver.Result result = receiver.awaitResult(2000L);
            if (result.bundle != null) {
                result.bundle.setDefusable(true);
                Object data = result.bundle.getParcelable(RESULT_RECEIVER_CONTROLLER_KEY);
                if (data != null) {
                    return data;
                }
            }
            Slog.e(TAG, "no controller energy info supplied for " + receiver.getName());
        }
        catch (TimeoutException e) {
            Slog.w(TAG, "timeout reading " + receiver.getName() + " stats");
        }
        return null;
    }

    private void pullKernelWakelock(int tagId, List<StatsLogEventWrapper> pulledData) {
        KernelWakelockStats wakelockStats = this.mKernelWakelockReader.readKernelWakelockStats(this.mTmpWakelockStats);
        for (Map.Entry ent : wakelockStats.entrySet()) {
            String name = (String)ent.getKey();
            KernelWakelockStats.Entry kws = (KernelWakelockStats.Entry)ent.getValue();
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, 4);
            e.writeString(name);
            e.writeInt(kws.mCount);
            e.writeInt(kws.mVersion);
            e.writeLong(kws.mTotalTime);
            pulledData.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullWifiBytesTransfer(int tagId, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        try {
            BatteryStatsInternal bs = LocalServices.getService(BatteryStatsInternal.class);
            String[] ifaces = bs.getWifiIfaces();
            if (ifaces.length == 0) {
                return;
            }
            NetworkStatsFactory nsf = new NetworkStatsFactory();
            NetworkStats stats = nsf.readNetworkStatsDetail(-1, ifaces, 0, null).groupedByUid();
            this.addNetworkStats(tagId, pulledData, stats, false);
        }
        catch (IOException e) {
            Slog.e(TAG, "Pulling netstats for wifi bytes has error", e);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullWifiBytesTransferByFgBg(int tagId, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        try {
            BatteryStatsInternal bs = LocalServices.getService(BatteryStatsInternal.class);
            String[] ifaces = bs.getWifiIfaces();
            if (ifaces.length == 0) {
                return;
            }
            NetworkStatsFactory nsf = new NetworkStatsFactory();
            NetworkStats stats = this.rollupNetworkStatsByFGBG(nsf.readNetworkStatsDetail(-1, ifaces, 0, null));
            this.addNetworkStats(tagId, pulledData, stats, true);
        }
        catch (IOException e) {
            Slog.e(TAG, "Pulling netstats for wifi bytes w/ fg/bg has error", e);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullMobileBytesTransfer(int tagId, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        try {
            BatteryStatsInternal bs = LocalServices.getService(BatteryStatsInternal.class);
            String[] ifaces = bs.getMobileIfaces();
            if (ifaces.length == 0) {
                return;
            }
            NetworkStatsFactory nsf = new NetworkStatsFactory();
            NetworkStats stats = nsf.readNetworkStatsDetail(-1, ifaces, 0, null).groupedByUid();
            this.addNetworkStats(tagId, pulledData, stats, false);
        }
        catch (IOException e) {
            Slog.e(TAG, "Pulling netstats for mobile bytes has error", e);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void pullBluetoothBytesTransfer(int tagId, List<StatsLogEventWrapper> pulledData) {
        BluetoothActivityEnergyInfo info = this.pullBluetoothData();
        for (UidTraffic traffic : info.getUidTraffic()) {
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, 3);
            e.writeInt(traffic.getUid());
            e.writeLong(traffic.getRxBytes());
            e.writeLong(traffic.getTxBytes());
            pulledData.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullMobileBytesTransferByFgBg(int tagId, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        try {
            BatteryStatsInternal bs = LocalServices.getService(BatteryStatsInternal.class);
            String[] ifaces = bs.getMobileIfaces();
            if (ifaces.length == 0) {
                return;
            }
            NetworkStatsFactory nsf = new NetworkStatsFactory();
            NetworkStats stats = this.rollupNetworkStatsByFGBG(nsf.readNetworkStatsDetail(-1, ifaces, 0, null));
            this.addNetworkStats(tagId, pulledData, stats, true);
        }
        catch (IOException e) {
            Slog.e(TAG, "Pulling netstats for mobile bytes w/ fg/bg has error", e);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void pullCpuTimePerFreq(int tagId, List<StatsLogEventWrapper> pulledData) {
        for (int cluster = 0; cluster < this.mKernelCpuSpeedReaders.length; ++cluster) {
            long[] clusterTimeMs = this.mKernelCpuSpeedReaders[cluster].readAbsolute();
            if (clusterTimeMs == null) continue;
            for (int speed = clusterTimeMs.length - 1; speed >= 0; --speed) {
                StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, 3);
                e.writeInt(cluster);
                e.writeInt(speed);
                e.writeLong(clusterTimeMs[speed]);
                pulledData.add(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullWifiActivityEnergyInfo(int tagId, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        if (this.mWifiManager == null) {
            this.mWifiManager = IWifiManager.Stub.asInterface(ServiceManager.getService("wifi"));
        }
        if (this.mWifiManager != null) {
            try {
                SynchronousResultReceiver wifiReceiver = new SynchronousResultReceiver("wifi");
                this.mWifiManager.requestActivityInfo(wifiReceiver);
                WifiActivityEnergyInfo wifiInfo = (WifiActivityEnergyInfo)StatsCompanionService.awaitControllerInfo(wifiReceiver);
                StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, 6);
                e.writeLong(wifiInfo.getTimeStamp());
                e.writeInt(wifiInfo.getStackState());
                e.writeLong(wifiInfo.getControllerTxTimeMillis());
                e.writeLong(wifiInfo.getControllerRxTimeMillis());
                e.writeLong(wifiInfo.getControllerIdleTimeMillis());
                e.writeLong(wifiInfo.getControllerEnergyUsed());
                pulledData.add(e);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Pulling wifiManager for wifi controller activity energy info has error", e);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    private void pullModemActivityInfo(int tagId, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        if (this.mTelephony == null) {
            this.mTelephony = TelephonyManager.from(this.mContext);
        }
        if (this.mTelephony != null) {
            SynchronousResultReceiver modemReceiver = new SynchronousResultReceiver("telephony");
            this.mTelephony.requestModemActivityInfo(modemReceiver);
            ModemActivityInfo modemInfo = (ModemActivityInfo)StatsCompanionService.awaitControllerInfo(modemReceiver);
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, 6);
            e.writeLong(modemInfo.getTimestamp());
            e.writeLong(modemInfo.getSleepTimeMillis());
            e.writeLong(modemInfo.getIdleTimeMillis());
            e.writeLong(modemInfo.getTxTimeMillis()[0]);
            e.writeLong(modemInfo.getTxTimeMillis()[1]);
            e.writeLong(modemInfo.getTxTimeMillis()[2]);
            e.writeLong(modemInfo.getTxTimeMillis()[3]);
            e.writeLong(modemInfo.getTxTimeMillis()[4]);
            e.writeLong(modemInfo.getRxTimeMillis());
            e.writeLong(modemInfo.getEnergyUsed());
            pulledData.add(e);
        }
    }

    private void pullBluetoothActivityInfo(int tagId, List<StatsLogEventWrapper> pulledData) {
        BluetoothActivityEnergyInfo info = this.pullBluetoothData();
        StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, 6);
        e.writeLong(info.getTimeStamp());
        e.writeInt(info.getBluetoothStackState());
        e.writeLong(info.getControllerTxTimeMillis());
        e.writeLong(info.getControllerRxTimeMillis());
        e.writeLong(info.getControllerIdleTimeMillis());
        e.writeLong(info.getControllerEnergyUsed());
        pulledData.add(e);
    }

    private synchronized BluetoothActivityEnergyInfo pullBluetoothData() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            SynchronousResultReceiver bluetoothReceiver = new SynchronousResultReceiver("bluetooth");
            adapter.requestControllerActivityEnergyInfo(bluetoothReceiver);
            return (BluetoothActivityEnergyInfo)StatsCompanionService.awaitControllerInfo(bluetoothReceiver);
        }
        Slog.e(TAG, "Failed to get bluetooth adapter!");
        return null;
    }

    private void pullSystemElapsedRealtime(int tagId, List<StatsLogEventWrapper> pulledData) {
        StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, 1);
        e.writeLong(SystemClock.elapsedRealtime());
        pulledData.add(e);
    }

    private void pullDiskSpace(int tagId, List<StatsLogEventWrapper> pulledData) {
        StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, 3);
        e.writeLong(this.mStatFsData.getAvailableBytes());
        e.writeLong(this.mStatFsSystem.getAvailableBytes());
        e.writeLong(this.mStatFsTemp.getAvailableBytes());
        pulledData.add(e);
    }

    private void pullSystemUpTime(int tagId, List<StatsLogEventWrapper> pulledData) {
        StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, 1);
        e.writeLong(SystemClock.uptimeMillis());
        pulledData.add(e);
    }

    @Override
    public StatsLogEventWrapper[] pullData(int tagId) {
        this.enforceCallingPermission();
        Slog.d(TAG, "Pulling " + tagId);
        ArrayList<StatsLogEventWrapper> ret = new ArrayList<StatsLogEventWrapper>();
        switch (tagId) {
            case 10000: {
                this.pullWifiBytesTransfer(tagId, ret);
                break;
            }
            case 10002: {
                this.pullMobileBytesTransfer(tagId, ret);
                break;
            }
            case 10001: {
                this.pullWifiBytesTransferByFgBg(tagId, ret);
                break;
            }
            case 10003: {
                this.pullMobileBytesTransferByFgBg(tagId, ret);
                break;
            }
            case 10006: {
                this.pullBluetoothBytesTransfer(tagId, ret);
                break;
            }
            case 10004: {
                this.pullKernelWakelock(tagId, ret);
                break;
            }
            case 10008: {
                this.pullCpuTimePerFreq(tagId, ret);
                break;
            }
            case 10011: {
                this.pullWifiActivityEnergyInfo(tagId, ret);
                break;
            }
            case 10012: {
                this.pullModemActivityInfo(tagId, ret);
                break;
            }
            case 10007: {
                this.pullBluetoothActivityInfo(tagId, ret);
                break;
            }
            case 10015: {
                this.pullSystemUpTime(tagId, ret);
                break;
            }
            case 10014: {
                this.pullSystemElapsedRealtime(tagId, ret);
                break;
            }
            case 10018: {
                this.pullDiskSpace(tagId, ret);
                break;
            }
            default: {
                Slog.w(TAG, "No such tagId data as " + tagId);
                return null;
            }
        }
        return ret.toArray(new StatsLogEventWrapper[ret.size()]);
    }

    @Override
    public void statsdReady() {
        this.enforceCallingPermission();
        Slog.d(TAG, "learned that statsdReady");
        this.sayHiToStatsd();
        this.mContext.sendBroadcastAsUser(new Intent("android.app.action.STATSD_STARTED"), UserHandle.SYSTEM, "android.permission.DUMP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerUidSnapshot() {
        this.enforceCallingPermission();
        Object object = sStatsdLock;
        synchronized (object) {
            try {
                this.informAllUidsLocked(this.mContext);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to trigger uid snapshot.", e);
            }
        }
    }

    private void enforceCallingPermission() {
        if (Binder.getCallingPid() == Process.myPid()) {
            return;
        }
        this.mContext.enforceCallingPermission("android.permission.STATSCOMPANION", null);
    }

    private static IStatsManager fetchStatsdService() {
        return IStatsManager.Stub.asInterface(ServiceManager.getService("stats"));
    }

    private void systemReady() {
        Slog.d(TAG, "Learned that systemReady");
        this.sayHiToStatsd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sayHiToStatsd() {
        Object object = sStatsdLock;
        synchronized (object) {
            if (sStatsd != null) {
                Slog.e(TAG, "Trying to fetch statsd, but it was already fetched", new IllegalStateException("sStatsd is not null when being fetched"));
                return;
            }
            sStatsd = StatsCompanionService.fetchStatsdService();
            if (sStatsd == null) {
                Slog.w(TAG, "Could not access statsd");
                return;
            }
            Slog.d(TAG, "Saying hi to statsd");
            try {
                sStatsd.statsCompanionReady();
                try {
                    sStatsd.asBinder().linkToDeath(new StatsdDeathRecipient(), 0);
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "linkToDeath(StatsdDeathRecipient) failed", e);
                    this.forgetEverything();
                }
                IntentFilter filter = new IntentFilter("android.intent.action.PACKAGE_REPLACED");
                filter.addAction("android.intent.action.PACKAGE_ADDED");
                filter.addAction("android.intent.action.PACKAGE_REMOVED");
                filter.addDataScheme("package");
                this.mContext.registerReceiverAsUser(this.mAppUpdateReceiver, UserHandle.ALL, filter, null, null);
                filter = new IntentFilter("android.intent.action.USER_INITIALIZE");
                filter.addAction("android.intent.action.USER_REMOVED");
                this.mContext.registerReceiverAsUser(this.mUserUpdateReceiver, UserHandle.ALL, filter, null, null);
                filter = new IntentFilter("android.intent.action.REBOOT");
                filter.addAction("android.intent.action.ACTION_SHUTDOWN");
                this.mContext.registerReceiverAsUser(this.mShutdownEventReceiver, UserHandle.ALL, filter, null, null);
                long token = Binder.clearCallingIdentity();
                try {
                    this.informAllUidsLocked(this.mContext);
                }
                finally {
                    StatsCompanionService.restoreCallingIdentity(token);
                }
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to inform statsd that statscompanion is ready", e);
                this.forgetEverything();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetEverything() {
        Object object = sStatsdLock;
        synchronized (object) {
            sStatsd = null;
            this.mContext.unregisterReceiver(this.mAppUpdateReceiver);
            this.mContext.unregisterReceiver(this.mUserUpdateReceiver);
            this.mContext.unregisterReceiver(this.mShutdownEventReceiver);
            this.cancelAnomalyAlarm();
            this.cancelPullingAlarms();
        }
    }

    static {
        sStatsdLock = new Object();
    }

    private class StatsdDeathRecipient
    implements IBinder.DeathRecipient {
        private StatsdDeathRecipient() {
        }

        @Override
        public void binderDied() {
            Slog.i(StatsCompanionService.TAG, "Statsd is dead - erase all my knowledge.");
            StatsCompanionService.this.forgetEverything();
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private StatsCompanionService mStatsCompanionService;

        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            this.mStatsCompanionService = new StatsCompanionService(this.getContext());
            try {
                this.publishBinderService("statscompanion", this.mStatsCompanionService);
                Slog.d(StatsCompanionService.TAG, "Published statscompanion");
            }
            catch (Exception e) {
                Slog.e(StatsCompanionService.TAG, "Failed to publishBinderService", e);
            }
        }

        @Override
        public void onBootPhase(int phase) {
            super.onBootPhase(phase);
            if (phase == 600) {
                this.mStatsCompanionService.systemReady();
            }
        }
    }

    private static final class ShutdownEventReceiver
    extends BroadcastReceiver {
        private ShutdownEventReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (!(intent.getAction().equals("android.intent.action.REBOOT") || intent.getAction().equals("android.intent.action.ACTION_SHUTDOWN") && (intent.getFlags() & 0x10000000) != 0)) {
                return;
            }
            Slog.i(StatsCompanionService.TAG, "StatsCompanionService noticed a shutdown.");
            Object object = sStatsdLock;
            synchronized (object) {
                if (sStatsd == null) {
                    Slog.w(StatsCompanionService.TAG, "Could not access statsd to inform it of a shutdown event.");
                    return;
                }
                try {
                    sStatsd.writeDataToDisk();
                }
                catch (Exception e) {
                    Slog.w(StatsCompanionService.TAG, "Failed to inform statsd of a shutdown event.", e);
                }
            }
        }
    }

    public static final class PullingAlarmReceiver
    extends BroadcastReceiver {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Slog.d(StatsCompanionService.TAG, "Time to poll something.");
            Object object = sStatsdLock;
            synchronized (object) {
                if (sStatsd == null) {
                    Slog.w(StatsCompanionService.TAG, "Could not access statsd to inform it of pulling alarm firing.");
                    return;
                }
                try {
                    sStatsd.informPollAlarmFired();
                }
                catch (RemoteException e) {
                    Slog.w(StatsCompanionService.TAG, "Failed to inform statsd of pulling alarm firing.", e);
                }
            }
        }
    }

    public static final class AnomalyAlarmReceiver
    extends BroadcastReceiver {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Slog.i(StatsCompanionService.TAG, "StatsCompanionService believes an anomaly has occurred.");
            Object object = sStatsdLock;
            synchronized (object) {
                if (sStatsd == null) {
                    Slog.w(StatsCompanionService.TAG, "Could not access statsd to inform it of anomaly alarm firing");
                    return;
                }
                try {
                    sStatsd.informAnomalyAlarmFired();
                }
                catch (RemoteException e) {
                    Slog.w(StatsCompanionService.TAG, "Failed to inform statsd of anomaly alarm firing", e);
                }
            }
        }
    }

    private static final class AppUpdateReceiver
    extends BroadcastReceiver {
        private AppUpdateReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (!intent.getAction().equals("android.intent.action.PACKAGE_REPLACED") && intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                return;
            }
            Slog.i(StatsCompanionService.TAG, "StatsCompanionService noticed an app was updated.");
            Object object = sStatsdLock;
            synchronized (object) {
                if (sStatsd == null) {
                    Slog.w(StatsCompanionService.TAG, "Could not access statsd to inform it of an app update");
                    return;
                }
                try {
                    if (intent.getAction().equals("android.intent.action.PACKAGE_REMOVED")) {
                        Bundle b = intent.getExtras();
                        int uid = b.getInt("android.intent.extra.UID");
                        boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                        if (!replacing) {
                            PackageManager pm = context.getPackageManager();
                            String app = intent.getData().getSchemeSpecificPart();
                            sStatsd.informOnePackageRemoved(app, uid);
                        }
                    } else {
                        PackageManager pm = context.getPackageManager();
                        Bundle b = intent.getExtras();
                        int uid = b.getInt("android.intent.extra.UID");
                        String app = intent.getData().getSchemeSpecificPart();
                        PackageInfo pi = pm.getPackageInfo(app, 0x400000);
                        sStatsd.informOnePackage(app, uid, pi.getLongVersionCode());
                    }
                }
                catch (Exception e) {
                    Slog.w(StatsCompanionService.TAG, "Failed to inform statsd of an app update", e);
                }
            }
        }
    }
}

