/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.textclassifier;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.service.textclassifier.ITextClassificationCallback;
import android.service.textclassifier.ITextClassifierService;
import android.service.textclassifier.ITextLinksCallback;
import android.service.textclassifier.ITextSelectionCallback;
import android.service.textclassifier.TextClassifierService;
import android.util.Slog;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.android.server.SystemService;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public final class TextClassificationManagerService
extends ITextClassifierService.Stub {
    private static final String LOG_TAG = "TextClassificationManagerService";
    private static final long TIMEOUT_IDLE_BIND_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    private final Context mContext;
    private final Handler mHandler;
    private final Intent mServiceIntent;
    private final ServiceConnection mConnection;
    private final Runnable mUnbind;
    private final Object mLock;
    @GuardedBy(value="mLock")
    private final Queue<PendingRequest> mPendingRequests;
    @GuardedBy(value="mLock")
    private ITextClassifierService mService;
    @GuardedBy(value="mLock")
    private boolean mBinding;

    private TextClassificationManagerService(Context context) {
        this.mContext = Preconditions.checkNotNull(context);
        this.mHandler = new Handler();
        this.mServiceIntent = new Intent("android.service.textclassifier.TextClassifierService").setComponent(TextClassifierService.getServiceComponentName(this.mContext));
        this.mConnection = new ServiceConnection(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServiceConnected(ComponentName name, IBinder service) {
                Object object = TextClassificationManagerService.this.mLock;
                synchronized (object) {
                    TextClassificationManagerService.this.mService = ITextClassifierService.Stub.asInterface(service);
                    TextClassificationManagerService.this.setBindingLocked(false);
                    TextClassificationManagerService.this.handlePendingRequestsLocked();
                }
            }

            @Override
            public void onServiceDisconnected(ComponentName name) {
                this.cleanupService();
            }

            @Override
            public void onBindingDied(ComponentName name) {
                this.cleanupService();
            }

            @Override
            public void onNullBinding(ComponentName name) {
                this.cleanupService();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void cleanupService() {
                Object object = TextClassificationManagerService.this.mLock;
                synchronized (object) {
                    TextClassificationManagerService.this.mService = null;
                    TextClassificationManagerService.this.setBindingLocked(false);
                    TextClassificationManagerService.this.handlePendingRequestsLocked();
                }
            }
        };
        this.mPendingRequests = new LinkedList<PendingRequest>();
        this.mUnbind = this::unbind;
        this.mLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuggestSelection(CharSequence text, int selectionStartIndex, int selectionEndIndex, TextSelection.Options options, ITextSelectionCallback callback) throws RemoteException {
        TextClassificationManagerService.validateInput(text, selectionStartIndex, selectionEndIndex, callback);
        if (!this.bind()) {
            callback.onFailure();
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.isBoundLocked()) {
                this.mService.onSuggestSelection(text, selectionStartIndex, selectionEndIndex, options, callback);
                this.scheduleUnbindLocked();
            } else {
                Callable<Void> request = () -> {
                    this.onSuggestSelection(text, selectionStartIndex, selectionEndIndex, options, callback);
                    return null;
                };
                Callable<Void> onServiceFailure = () -> {
                    callback.onFailure();
                    return null;
                };
                this.enqueueRequestLocked(request, onServiceFailure, callback.asBinder());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClassifyText(CharSequence text, int startIndex, int endIndex, TextClassification.Options options, ITextClassificationCallback callback) throws RemoteException {
        TextClassificationManagerService.validateInput(text, startIndex, endIndex, callback);
        if (!this.bind()) {
            callback.onFailure();
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.isBoundLocked()) {
                this.mService.onClassifyText(text, startIndex, endIndex, options, callback);
                this.scheduleUnbindLocked();
            } else {
                Callable<Void> request = () -> {
                    this.onClassifyText(text, startIndex, endIndex, options, callback);
                    return null;
                };
                Callable<Void> onServiceFailure = () -> {
                    callback.onFailure();
                    return null;
                };
                this.enqueueRequestLocked(request, onServiceFailure, callback.asBinder());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onGenerateLinks(CharSequence text, TextLinks.Options options, ITextLinksCallback callback) throws RemoteException {
        TextClassificationManagerService.validateInput(text, callback);
        if (!this.bind()) {
            callback.onFailure();
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.isBoundLocked()) {
                this.mService.onGenerateLinks(text, options, callback);
                this.scheduleUnbindLocked();
            } else {
                Callable<Void> request = () -> {
                    this.onGenerateLinks(text, options, callback);
                    return null;
                };
                Callable<Void> onServiceFailure = () -> {
                    callback.onFailure();
                    return null;
                };
                this.enqueueRequestLocked(request, onServiceFailure, callback.asBinder());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bind() {
        Object object = this.mLock;
        synchronized (object) {
            boolean willBind;
            if (this.isBoundLocked() || this.isBindingLocked()) {
                return true;
            }
            long identity = Binder.clearCallingIdentity();
            try {
                Slog.d(LOG_TAG, "Binding to " + this.mServiceIntent.getComponent());
                willBind = this.mContext.bindServiceAsUser(this.mServiceIntent, this.mConnection, 0x4000001, Binder.getCallingUserHandle());
                this.setBindingLocked(willBind);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
            return willBind;
        }
    }

    @GuardedBy(value="mLock")
    private boolean isBoundLocked() {
        return this.mService != null;
    }

    @GuardedBy(value="mLock")
    private boolean isBindingLocked() {
        return this.mBinding;
    }

    @GuardedBy(value="mLock")
    private void setBindingLocked(boolean binding) {
        this.mBinding = binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isBoundLocked()) {
                return;
            }
            Slog.d(LOG_TAG, "Unbinding from " + this.mServiceIntent.getComponent());
            this.mContext.unbindService(this.mConnection);
            Object object2 = this.mLock;
            synchronized (object2) {
                this.mService = null;
            }
        }
    }

    @GuardedBy(value="mLock")
    private void scheduleUnbindLocked() {
        this.mHandler.removeCallbacks(this.mUnbind);
        this.mHandler.postDelayed(this.mUnbind, TIMEOUT_IDLE_BIND_MILLIS);
    }

    @GuardedBy(value="mLock")
    private void enqueueRequestLocked(Callable<Void> request, Callable<Void> onServiceFailure, IBinder binder) {
        this.mPendingRequests.add(new PendingRequest(request, onServiceFailure, binder));
    }

    @GuardedBy(value="mLock")
    private void handlePendingRequestsLocked() {
        PendingRequest[] pendingRequests;
        for (PendingRequest pendingRequest : pendingRequests = this.mPendingRequests.toArray(new PendingRequest[this.mPendingRequests.size()])) {
            if (this.isBoundLocked()) {
                pendingRequest.executeLocked();
                continue;
            }
            pendingRequest.notifyServiceFailureLocked();
        }
    }

    private static void validateInput(CharSequence text, int startIndex, int endIndex, Object callback) throws RemoteException {
        try {
            TextClassifier.Utils.validate(text, startIndex, endIndex, true);
            Preconditions.checkNotNull(callback);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    private static void validateInput(CharSequence text, Object callback) throws RemoteException {
        try {
            TextClassifier.Utils.validate(text, true);
            Preconditions.checkNotNull(callback);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    private final class PendingRequest
    implements IBinder.DeathRecipient {
        private final Callable<Void> mRequest;
        private final Callable<Void> mOnServiceFailure;
        private final IBinder mBinder;

        PendingRequest(Callable<Void> request, Callable<Void> onServiceFailure, IBinder binder) {
            this.mRequest = Preconditions.checkNotNull(request);
            this.mOnServiceFailure = Preconditions.checkNotNull(onServiceFailure);
            this.mBinder = Preconditions.checkNotNull(binder);
            try {
                this.mBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }

        @GuardedBy(value="mLock")
        void executeLocked() {
            this.removeLocked();
            try {
                this.mRequest.call();
            }
            catch (Exception e) {
                Slog.d(TextClassificationManagerService.LOG_TAG, "Error handling pending request: " + e.getMessage());
            }
        }

        @GuardedBy(value="mLock")
        void notifyServiceFailureLocked() {
            this.removeLocked();
            try {
                this.mOnServiceFailure.call();
            }
            catch (Exception e) {
                Slog.d(TextClassificationManagerService.LOG_TAG, "Error notifying callback of service failure: " + e.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = TextClassificationManagerService.this.mLock;
            synchronized (object) {
                this.removeLocked();
            }
        }

        @GuardedBy(value="mLock")
        private void removeLocked() {
            TextClassificationManagerService.this.mPendingRequests.remove(this);
            this.mBinder.unlinkToDeath(this, 0);
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private final TextClassificationManagerService mManagerService;

        public Lifecycle(Context context) {
            super(context);
            this.mManagerService = new TextClassificationManagerService(context);
        }

        @Override
        public void onStart() {
            try {
                this.publishBinderService("textclassification", this.mManagerService);
            }
            catch (Throwable t) {
                Slog.e(TextClassificationManagerService.LOG_TAG, "Could not start the TextClassificationManagerService.", t);
            }
        }
    }
}

