/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.timezone;

import android.app.timezone.DistroFormatVersion;
import android.app.timezone.DistroRulesVersion;
import android.app.timezone.ICallback;
import android.app.timezone.IRulesManager;
import android.app.timezone.RulesState;
import android.content.Context;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.EventLogTags;
import com.android.server.SystemService;
import com.android.server.timezone.CheckToken;
import com.android.server.timezone.PackageTracker;
import com.android.server.timezone.PermissionHelper;
import com.android.server.timezone.RulesManagerServiceHelperImpl;
import com.android.timezone.distro.DistroException;
import com.android.timezone.distro.DistroVersion;
import com.android.timezone.distro.StagedDistroOperation;
import com.android.timezone.distro.TimeZoneDistro;
import com.android.timezone.distro.installer.TimeZoneDistroInstaller;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import libcore.icu.ICU;
import libcore.util.TimeZoneFinder;
import libcore.util.ZoneInfoDB;

public final class RulesManagerService
extends IRulesManager.Stub {
    private static final String TAG = "timezone.RulesManagerService";
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    static final DistroFormatVersion DISTRO_FORMAT_VERSION_SUPPORTED = new DistroFormatVersion(2, 1);
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    static final String REQUIRED_UPDATER_PERMISSION = "android.permission.UPDATE_TIME_ZONE_RULES";
    private static final File SYSTEM_TZ_DATA_FILE = new File("/system/usr/share/zoneinfo/tzdata");
    private static final File TZ_DATA_DIR = new File("/data/misc/zoneinfo");
    private final AtomicBoolean mOperationInProgress = new AtomicBoolean(false);
    private final PermissionHelper mPermissionHelper;
    private final PackageTracker mPackageTracker;
    private final Executor mExecutor;
    private final TimeZoneDistroInstaller mInstaller;

    private static RulesManagerService create(Context context) {
        RulesManagerServiceHelperImpl helper = new RulesManagerServiceHelperImpl(context);
        return new RulesManagerService(helper, helper, PackageTracker.create(context), new TimeZoneDistroInstaller(TAG, SYSTEM_TZ_DATA_FILE, TZ_DATA_DIR));
    }

    RulesManagerService(PermissionHelper permissionHelper, Executor executor, PackageTracker packageTracker, TimeZoneDistroInstaller timeZoneDistroInstaller) {
        this.mPermissionHelper = permissionHelper;
        this.mExecutor = executor;
        this.mPackageTracker = packageTracker;
        this.mInstaller = timeZoneDistroInstaller;
    }

    public void start() {
        this.mPackageTracker.start();
    }

    @Override
    public RulesState getRulesState() {
        this.mPermissionHelper.enforceCallerHasPermission(REQUIRED_UPDATER_PERMISSION);
        return this.getRulesStateInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RulesState getRulesStateInternal() {
        RulesManagerService rulesManagerService = this;
        synchronized (rulesManagerService) {
            String systemRulesVersion;
            try {
                systemRulesVersion = this.mInstaller.getSystemRulesVersion();
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed to read system rules", e);
                return null;
            }
            int distroStatus = 0;
            DistroRulesVersion installedDistroRulesVersion = null;
            try {
                DistroVersion installedDistroVersion = this.mInstaller.getInstalledDistroVersion();
                if (installedDistroVersion == null) {
                    distroStatus = 1;
                    installedDistroRulesVersion = null;
                } else {
                    distroStatus = 2;
                    installedDistroRulesVersion = new DistroRulesVersion(installedDistroVersion.rulesVersion, installedDistroVersion.revision);
                }
            }
            catch (DistroException | IOException e) {
                Slog.w(TAG, "Failed to read installed distro.", e);
            }
            boolean operationInProgress = this.mOperationInProgress.get();
            DistroRulesVersion stagedDistroRulesVersion = null;
            int stagedOperationStatus = 0;
            if (!operationInProgress) {
                try {
                    StagedDistroOperation stagedDistroOperation = this.mInstaller.getStagedDistroOperation();
                    if (stagedDistroOperation == null) {
                        stagedOperationStatus = 1;
                    } else if (stagedDistroOperation.isUninstall) {
                        stagedOperationStatus = 2;
                    } else {
                        stagedOperationStatus = 3;
                        DistroVersion stagedDistroVersion = stagedDistroOperation.distroVersion;
                        stagedDistroRulesVersion = new DistroRulesVersion(stagedDistroVersion.rulesVersion, stagedDistroVersion.revision);
                    }
                }
                catch (DistroException | IOException e) {
                    Slog.w(TAG, "Failed to read staged distro.", e);
                }
            }
            return new RulesState(systemRulesVersion, DISTRO_FORMAT_VERSION_SUPPORTED, operationInProgress, stagedOperationStatus, stagedDistroRulesVersion, distroStatus, installedDistroRulesVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int requestInstall(ParcelFileDescriptor distroParcelFileDescriptor, byte[] checkTokenBytes, ICallback callback) {
        CheckToken checkToken;
        boolean closeParcelFileDescriptorOnExit;
        block15: {
            int n;
            closeParcelFileDescriptorOnExit = true;
            try {
                this.mPermissionHelper.enforceCallerHasPermission(REQUIRED_UPDATER_PERMISSION);
                checkToken = null;
                if (checkTokenBytes != null) {
                    checkToken = RulesManagerService.createCheckTokenOrThrow(checkTokenBytes);
                }
                EventLogTags.writeTimezoneRequestInstall(RulesManagerService.toStringOrNull(checkToken));
                RulesManagerService rulesManagerService = this;
                // MONITORENTER : rulesManagerService
                if (distroParcelFileDescriptor == null) {
                    throw new NullPointerException("distroParcelFileDescriptor == null");
                }
                if (callback == null) {
                    throw new NullPointerException("observer == null");
                }
                if (!this.mOperationInProgress.get()) break block15;
                n = 1;
                // MONITOREXIT : rulesManagerService
                if (distroParcelFileDescriptor == null) return n;
                if (!closeParcelFileDescriptorOnExit) return n;
            }
            catch (Throwable throwable) {
                if (distroParcelFileDescriptor == null) throw throwable;
                if (!closeParcelFileDescriptorOnExit) throw throwable;
                try {
                    distroParcelFileDescriptor.close();
                    throw throwable;
                }
                catch (IOException e) {
                    Slog.w(TAG, "Failed to close distroParcelFileDescriptor", e);
                }
                throw throwable;
            }
            try {
                distroParcelFileDescriptor.close();
                return n;
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed to close distroParcelFileDescriptor", e);
            }
            return n;
        }
        this.mOperationInProgress.set(true);
        this.mExecutor.execute(new InstallRunnable(distroParcelFileDescriptor, checkToken, callback));
        closeParcelFileDescriptorOnExit = false;
        int n = 0;
        // MONITOREXIT : rulesManagerService
        if (distroParcelFileDescriptor == null) return n;
        if (!closeParcelFileDescriptorOnExit) return n;
        try {
            distroParcelFileDescriptor.close();
            return n;
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed to close distroParcelFileDescriptor", e);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int requestUninstall(byte[] checkTokenBytes, ICallback callback) {
        this.mPermissionHelper.enforceCallerHasPermission(REQUIRED_UPDATER_PERMISSION);
        CheckToken checkToken = null;
        if (checkTokenBytes != null) {
            checkToken = RulesManagerService.createCheckTokenOrThrow(checkTokenBytes);
        }
        EventLogTags.writeTimezoneRequestUninstall(RulesManagerService.toStringOrNull(checkToken));
        RulesManagerService rulesManagerService = this;
        synchronized (rulesManagerService) {
            if (callback == null) {
                throw new NullPointerException("callback == null");
            }
            if (this.mOperationInProgress.get()) {
                return 1;
            }
            this.mOperationInProgress.set(true);
            this.mExecutor.execute(new UninstallRunnable(checkToken, callback));
            return 0;
        }
    }

    private void sendFinishedStatus(ICallback callback, int resultCode) {
        try {
            callback.onFinished(resultCode);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Unable to notify observer of result", e);
        }
    }

    @Override
    public void requestNothing(byte[] checkTokenBytes, boolean success) {
        this.mPermissionHelper.enforceCallerHasPermission(REQUIRED_UPDATER_PERMISSION);
        CheckToken checkToken = null;
        if (checkTokenBytes != null) {
            checkToken = RulesManagerService.createCheckTokenOrThrow(checkTokenBytes);
        }
        EventLogTags.writeTimezoneRequestNothing(RulesManagerService.toStringOrNull(checkToken));
        this.mPackageTracker.recordCheckResult(checkToken, success);
        EventLogTags.writeTimezoneNothingComplete(RulesManagerService.toStringOrNull(checkToken));
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!this.mPermissionHelper.checkDumpPermission(TAG, pw)) {
            return;
        }
        RulesState rulesState = this.getRulesStateInternal();
        if (args != null && args.length == 2 && "-format_state".equals(args[0]) && args[1] != null) {
            block9: for (char c : args[1].toCharArray()) {
                switch (c) {
                    case 'p': {
                        String value = "Unknown";
                        if (rulesState != null) {
                            value = Boolean.toString(rulesState.isOperationInProgress());
                        }
                        pw.println("Operation in progress: " + value);
                        continue block9;
                    }
                    case 's': {
                        String value = "Unknown";
                        if (rulesState != null) {
                            value = rulesState.getSystemRulesVersion();
                        }
                        pw.println("System rules version: " + value);
                        continue block9;
                    }
                    case 'c': {
                        String value = "Unknown";
                        if (rulesState != null) {
                            value = RulesManagerService.distroStatusToString(rulesState.getDistroStatus());
                        }
                        pw.println("Current install state: " + value);
                        continue block9;
                    }
                    case 'i': {
                        String value = "Unknown";
                        if (rulesState != null) {
                            DistroRulesVersion installedRulesVersion = rulesState.getInstalledDistroRulesVersion();
                            value = installedRulesVersion == null ? "<None>" : installedRulesVersion.toDumpString();
                        }
                        pw.println("Installed rules version: " + value);
                        continue block9;
                    }
                    case 'o': {
                        String value = "Unknown";
                        if (rulesState != null) {
                            int stagedOperationType = rulesState.getStagedOperationType();
                            value = RulesManagerService.stagedOperationToString(stagedOperationType);
                        }
                        pw.println("Staged operation: " + value);
                        continue block9;
                    }
                    case 't': {
                        String value = "Unknown";
                        if (rulesState != null) {
                            DistroRulesVersion stagedDistroRulesVersion = rulesState.getStagedDistroRulesVersion();
                            value = stagedDistroRulesVersion == null ? "<None>" : stagedDistroRulesVersion.toDumpString();
                        }
                        pw.println("Staged rules version: " + value);
                        continue block9;
                    }
                    case 'a': {
                        pw.println("Active rules version (ICU, ZoneInfoDB, TimeZoneFinder): " + ICU.getTZDataVersion() + "," + ZoneInfoDB.getInstance().getVersion() + "," + TimeZoneFinder.getInstance().getIanaVersion());
                        continue block9;
                    }
                    default: {
                        pw.println("Unknown option: " + c);
                    }
                }
            }
            return;
        }
        pw.println("RulesManagerService state: " + this.toString());
        pw.println("Active rules version (ICU, ZoneInfoDB, TimeZoneFinder): " + ICU.getTZDataVersion() + "," + ZoneInfoDB.getInstance().getVersion() + "," + TimeZoneFinder.getInstance().getIanaVersion());
        pw.println("Distro state: " + rulesState.toString());
        this.mPackageTracker.dump(pw);
    }

    void notifyIdle() {
        boolean packageChanged = false;
        this.mPackageTracker.triggerUpdateIfNeeded(false);
    }

    public String toString() {
        return "RulesManagerService{mOperationInProgress=" + this.mOperationInProgress + '}';
    }

    private static CheckToken createCheckTokenOrThrow(byte[] checkTokenBytes) {
        CheckToken checkToken;
        try {
            checkToken = CheckToken.fromByteArray(checkTokenBytes);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read token bytes " + Arrays.toString(checkTokenBytes), e);
        }
        return checkToken;
    }

    private static String distroStatusToString(int distroStatus) {
        switch (distroStatus) {
            case 1: {
                return "None";
            }
            case 2: {
                return "Installed";
            }
        }
        return "Unknown";
    }

    private static String stagedOperationToString(int stagedOperationType) {
        switch (stagedOperationType) {
            case 1: {
                return "None";
            }
            case 2: {
                return "Uninstall";
            }
            case 3: {
                return "Install";
            }
        }
        return "Unknown";
    }

    private static String toStringOrNull(Object obj) {
        return obj == null ? null : obj.toString();
    }

    private class UninstallRunnable
    implements Runnable {
        private final CheckToken mCheckToken;
        private final ICallback mCallback;

        UninstallRunnable(CheckToken checkToken, ICallback callback) {
            this.mCheckToken = checkToken;
            this.mCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EventLogTags.writeTimezoneUninstallStarted(RulesManagerService.toStringOrNull(this.mCheckToken));
            boolean packageTrackerStatus = false;
            try {
                int uninstallResult = RulesManagerService.this.mInstaller.stageUninstall();
                packageTrackerStatus = uninstallResult == 0 || uninstallResult == 1;
                int callbackResultCode = packageTrackerStatus ? 0 : 1;
                EventLogTags.writeTimezoneUninstallComplete(RulesManagerService.toStringOrNull(this.mCheckToken), callbackResultCode);
                RulesManagerService.this.sendFinishedStatus(this.mCallback, callbackResultCode);
            }
            catch (Exception e) {
                EventLogTags.writeTimezoneUninstallComplete(RulesManagerService.toStringOrNull(this.mCheckToken), 1);
                Slog.w(RulesManagerService.TAG, "Failed to uninstall distro.", e);
                RulesManagerService.this.sendFinishedStatus(this.mCallback, 1);
            }
            finally {
                RulesManagerService.this.mPackageTracker.recordCheckResult(this.mCheckToken, packageTrackerStatus);
                RulesManagerService.this.mOperationInProgress.set(false);
            }
        }
    }

    private class InstallRunnable
    implements Runnable {
        private final ParcelFileDescriptor mDistroParcelFileDescriptor;
        private final CheckToken mCheckToken;
        private final ICallback mCallback;

        InstallRunnable(ParcelFileDescriptor distroParcelFileDescriptor, CheckToken checkToken, ICallback callback) {
            this.mDistroParcelFileDescriptor = distroParcelFileDescriptor;
            this.mCheckToken = checkToken;
            this.mCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EventLogTags.writeTimezoneInstallStarted(RulesManagerService.toStringOrNull(this.mCheckToken));
            boolean success = false;
            try (ParcelFileDescriptor pfd = this.mDistroParcelFileDescriptor;){
                boolean isFdOwner = false;
                FileInputStream is = new FileInputStream(pfd.getFileDescriptor(), false);
                TimeZoneDistro distro = new TimeZoneDistro(is);
                int installerResult = RulesManagerService.this.mInstaller.stageInstallWithErrorCode(distro);
                int resultCode = this.mapInstallerResultToApiCode(installerResult);
                EventLogTags.writeTimezoneInstallComplete(RulesManagerService.toStringOrNull(this.mCheckToken), resultCode);
                RulesManagerService.this.sendFinishedStatus(this.mCallback, resultCode);
                success = true;
            }
            catch (Exception e) {
                Slog.w(RulesManagerService.TAG, "Failed to install distro.", e);
                EventLogTags.writeTimezoneInstallComplete(RulesManagerService.toStringOrNull(this.mCheckToken), 1);
                RulesManagerService.this.sendFinishedStatus(this.mCallback, 1);
            }
            finally {
                RulesManagerService.this.mPackageTracker.recordCheckResult(this.mCheckToken, success);
                RulesManagerService.this.mOperationInProgress.set(false);
            }
        }

        private int mapInstallerResultToApiCode(int installerResult) {
            switch (installerResult) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 2;
                }
                case 3: {
                    return 4;
                }
                case 2: {
                    return 3;
                }
                case 4: {
                    return 5;
                }
            }
            return 1;
        }
    }

    public static class Lifecycle
    extends SystemService {
        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            RulesManagerService service = RulesManagerService.create(this.getContext());
            service.start();
            this.publishBinderService("timezone", service);
            this.publishLocalService(RulesManagerService.class, service);
        }
    }
}

