/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.trust;

import android.app.ActivityManager;
import android.app.admin.DevicePolicyManager;
import android.app.trust.ITrustListener;
import android.app.trust.ITrustManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Binder;
import android.os.Build;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Slog;
import android.util.SparseBooleanArray;
import android.util.Xml;
import android.view.IWindowManager;
import android.view.WindowManagerGlobal;
import com.android.internal.R;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.content.PackageMonitor;
import com.android.internal.util.DumpUtils;
import com.android.internal.widget.LockPatternUtils;
import com.android.server.SystemService;
import com.android.server.trust.TrustAgentWrapper;
import com.android.server.trust.TrustArchive;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class TrustManagerService
extends SystemService {
    private static final String TAG = "TrustManagerService";
    static final boolean DEBUG = Build.IS_DEBUGGABLE && Log.isLoggable("TrustManagerService", 2);
    private static final Intent TRUST_AGENT_INTENT = new Intent("android.service.trust.TrustAgentService");
    private static final String PERMISSION_PROVIDE_AGENT = "android.permission.PROVIDE_TRUST_AGENT";
    private static final int MSG_REGISTER_LISTENER = 1;
    private static final int MSG_UNREGISTER_LISTENER = 2;
    private static final int MSG_DISPATCH_UNLOCK_ATTEMPT = 3;
    private static final int MSG_ENABLED_AGENTS_CHANGED = 4;
    private static final int MSG_KEYGUARD_SHOWING_CHANGED = 6;
    private static final int MSG_START_USER = 7;
    private static final int MSG_CLEANUP_USER = 8;
    private static final int MSG_SWITCH_USER = 9;
    private static final int MSG_FLUSH_TRUST_USUALLY_MANAGED = 10;
    private static final int MSG_UNLOCK_USER = 11;
    private static final int MSG_STOP_USER = 12;
    private static final int MSG_DISPATCH_UNLOCK_LOCKOUT = 13;
    private static final int MSG_REFRESH_DEVICE_LOCKED_FOR_USER = 14;
    private static final int TRUST_USUALLY_MANAGED_FLUSH_DELAY = 120000;
    private final ArraySet<AgentInfo> mActiveAgents = new ArraySet();
    private final ArrayList<ITrustListener> mTrustListeners = new ArrayList();
    private final Receiver mReceiver = new Receiver();
    final TrustArchive mArchive = new TrustArchive();
    private final Context mContext;
    private final LockPatternUtils mLockPatternUtils;
    private final UserManager mUserManager;
    private final ActivityManager mActivityManager;
    @GuardedBy(value="mUserIsTrusted")
    private final SparseBooleanArray mUserIsTrusted = new SparseBooleanArray();
    @GuardedBy(value="mDeviceLockedForUser")
    private final SparseBooleanArray mDeviceLockedForUser = new SparseBooleanArray();
    @GuardedBy(value="mTrustUsuallyManagedForUser")
    private final SparseBooleanArray mTrustUsuallyManagedForUser = new SparseBooleanArray();
    @GuardedBy(value="mUsersUnlockedByFingerprint")
    private final SparseBooleanArray mUsersUnlockedByFingerprint = new SparseBooleanArray();
    private final StrongAuthTracker mStrongAuthTracker;
    private boolean mTrustAgentsCanRun = false;
    private int mCurrentUser = 0;
    private final IBinder mService = new ITrustManager.Stub(){

        @Override
        public void reportUnlockAttempt(boolean authenticated, int userId) throws RemoteException {
            this.enforceReportPermission();
            TrustManagerService.this.mHandler.obtainMessage(3, authenticated ? 1 : 0, userId).sendToTarget();
        }

        @Override
        public void reportUnlockLockout(int timeoutMs, int userId) throws RemoteException {
            this.enforceReportPermission();
            TrustManagerService.this.mHandler.obtainMessage(13, timeoutMs, userId).sendToTarget();
        }

        @Override
        public void reportEnabledTrustAgentsChanged(int userId) throws RemoteException {
            this.enforceReportPermission();
            TrustManagerService.this.mHandler.removeMessages(4);
            TrustManagerService.this.mHandler.sendEmptyMessage(4);
        }

        @Override
        public void reportKeyguardShowingChanged() throws RemoteException {
            this.enforceReportPermission();
            TrustManagerService.this.mHandler.removeMessages(6);
            TrustManagerService.this.mHandler.sendEmptyMessage(6);
            TrustManagerService.this.mHandler.runWithScissors(() -> {}, 0L);
        }

        @Override
        public void registerTrustListener(ITrustListener trustListener) throws RemoteException {
            this.enforceListenerPermission();
            TrustManagerService.this.mHandler.obtainMessage(1, trustListener).sendToTarget();
        }

        @Override
        public void unregisterTrustListener(ITrustListener trustListener) throws RemoteException {
            this.enforceListenerPermission();
            TrustManagerService.this.mHandler.obtainMessage(2, trustListener).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDeviceLocked(int userId) throws RemoteException {
            userId = ActivityManager.handleIncomingUser(1.getCallingPid(), 1.getCallingUid(), userId, false, true, "isDeviceLocked", null);
            long token = Binder.clearCallingIdentity();
            try {
                if (!TrustManagerService.this.mLockPatternUtils.isSeparateProfileChallengeEnabled(userId)) {
                    userId = TrustManagerService.this.resolveProfileParent(userId);
                }
                boolean bl = TrustManagerService.this.isDeviceLockedInner(userId);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDeviceSecure(int userId) throws RemoteException {
            userId = ActivityManager.handleIncomingUser(1.getCallingPid(), 1.getCallingUid(), userId, false, true, "isDeviceSecure", null);
            long token = Binder.clearCallingIdentity();
            try {
                if (!TrustManagerService.this.mLockPatternUtils.isSeparateProfileChallengeEnabled(userId)) {
                    userId = TrustManagerService.this.resolveProfileParent(userId);
                }
                boolean bl = TrustManagerService.this.mLockPatternUtils.isSecure(userId);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        private void enforceReportPermission() {
            TrustManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_KEYGUARD_SECURE_STORAGE", "reporting trust events");
        }

        private void enforceListenerPermission() {
            TrustManagerService.this.mContext.enforceCallingPermission("android.permission.TRUST_LISTENER", "register trust listener");
        }

        @Override
        protected void dump(FileDescriptor fd, final PrintWriter fout, String[] args) {
            if (!DumpUtils.checkDumpPermission(TrustManagerService.this.mContext, TrustManagerService.TAG, fout)) {
                return;
            }
            if (TrustManagerService.this.isSafeMode()) {
                fout.println("disabled because the system is in safe mode.");
                return;
            }
            if (!TrustManagerService.this.mTrustAgentsCanRun) {
                fout.println("disabled because the third-party apps can't run yet.");
                return;
            }
            final List<UserInfo> userInfos = TrustManagerService.this.mUserManager.getUsers(true);
            TrustManagerService.this.mHandler.runWithScissors(new Runnable(){

                @Override
                public void run() {
                    fout.println("Trust manager state:");
                    for (UserInfo user : userInfos) {
                        this.dumpUser(fout, user, user.id == TrustManagerService.this.mCurrentUser);
                    }
                }
            }, 1500L);
        }

        private void dumpUser(PrintWriter fout, UserInfo user, boolean isCurrent) {
            fout.printf(" User \"%s\" (id=%d, flags=%#x)", user.name, user.id, user.flags);
            if (!user.supportsSwitchToByUser()) {
                fout.println("(managed profile)");
                fout.println("   disabled because switching to this user is not possible.");
                return;
            }
            if (isCurrent) {
                fout.print(" (current)");
            }
            fout.print(": trusted=" + this.dumpBool(TrustManagerService.this.aggregateIsTrusted(user.id)));
            fout.print(", trustManaged=" + this.dumpBool(TrustManagerService.this.aggregateIsTrustManaged(user.id)));
            fout.print(", deviceLocked=" + this.dumpBool(TrustManagerService.this.isDeviceLockedInner(user.id)));
            fout.print(", strongAuthRequired=" + this.dumpHex(TrustManagerService.this.mStrongAuthTracker.getStrongAuthForUser(user.id)));
            fout.println();
            fout.println("   Enabled agents:");
            boolean duplicateSimpleNames = false;
            ArraySet<String> simpleNames = new ArraySet<String>();
            for (AgentInfo info : TrustManagerService.this.mActiveAgents) {
                if (info.userId != user.id) continue;
                boolean trusted = info.agent.isTrusted();
                fout.print("    ");
                fout.println(info.component.flattenToShortString());
                fout.print("     bound=" + this.dumpBool(info.agent.isBound()));
                fout.print(", connected=" + this.dumpBool(info.agent.isConnected()));
                fout.print(", managingTrust=" + this.dumpBool(info.agent.isManagingTrust()));
                fout.print(", trusted=" + this.dumpBool(trusted));
                fout.println();
                if (trusted) {
                    fout.println("      message=\"" + info.agent.getMessage() + "\"");
                }
                if (!info.agent.isConnected()) {
                    String restartTime = TrustArchive.formatDuration(info.agent.getScheduledRestartUptimeMillis() - SystemClock.uptimeMillis());
                    fout.println("      restartScheduledAt=" + restartTime);
                }
                if (simpleNames.add(TrustArchive.getSimpleName(info.component))) continue;
                duplicateSimpleNames = true;
            }
            fout.println("   Events:");
            TrustManagerService.this.mArchive.dump(fout, 50, user.id, "    ", duplicateSimpleNames);
            fout.println();
        }

        private String dumpBool(boolean b) {
            return b ? "1" : "0";
        }

        private String dumpHex(int i) {
            return "0x" + Integer.toHexString(i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDeviceLockedForUser(int userId, boolean locked) {
            block9: {
                this.enforceReportPermission();
                long identity = Binder.clearCallingIdentity();
                try {
                    if (!TrustManagerService.this.mLockPatternUtils.isSeparateProfileChallengeEnabled(userId)) break block9;
                    SparseBooleanArray sparseBooleanArray = TrustManagerService.this.mDeviceLockedForUser;
                    synchronized (sparseBooleanArray) {
                        TrustManagerService.this.mDeviceLockedForUser.put(userId, locked);
                    }
                    if (locked) {
                        try {
                            ActivityManager.getService().notifyLockedProfile(userId);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    Intent lockIntent = new Intent("android.intent.action.DEVICE_LOCKED_CHANGED");
                    lockIntent.addFlags(0x40000000);
                    lockIntent.putExtra("android.intent.extra.user_handle", userId);
                    TrustManagerService.this.mContext.sendBroadcastAsUser(lockIntent, UserHandle.SYSTEM, "android.permission.TRUST_LISTENER", null);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        @Override
        public boolean isTrustUsuallyManaged(int userId) {
            TrustManagerService.this.mContext.enforceCallingPermission("android.permission.TRUST_LISTENER", "query trust state");
            return TrustManagerService.this.isTrustUsuallyManagedInternal(userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlockedByFingerprintForUser(int userId) {
            this.enforceReportPermission();
            SparseBooleanArray sparseBooleanArray = TrustManagerService.this.mUsersUnlockedByFingerprint;
            synchronized (sparseBooleanArray) {
                TrustManagerService.this.mUsersUnlockedByFingerprint.put(userId, true);
            }
            TrustManagerService.this.mHandler.obtainMessage(14, userId, 0).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearAllFingerprints() {
            this.enforceReportPermission();
            SparseBooleanArray sparseBooleanArray = TrustManagerService.this.mUsersUnlockedByFingerprint;
            synchronized (sparseBooleanArray) {
                TrustManagerService.this.mUsersUnlockedByFingerprint.clear();
            }
            TrustManagerService.this.mHandler.obtainMessage(14, -1, 0).sendToTarget();
        }
    };
    private final Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    TrustManagerService.this.addListener((ITrustListener)msg.obj);
                    break;
                }
                case 2: {
                    TrustManagerService.this.removeListener((ITrustListener)msg.obj);
                    break;
                }
                case 3: {
                    TrustManagerService.this.dispatchUnlockAttempt(msg.arg1 != 0, msg.arg2);
                    break;
                }
                case 13: {
                    TrustManagerService.this.dispatchUnlockLockout(msg.arg1, msg.arg2);
                    break;
                }
                case 4: {
                    TrustManagerService.this.refreshAgentList(-1);
                    TrustManagerService.this.refreshDeviceLockedForUser(-1);
                    break;
                }
                case 6: {
                    TrustManagerService.this.refreshDeviceLockedForUser(TrustManagerService.this.mCurrentUser);
                    break;
                }
                case 7: 
                case 8: 
                case 11: {
                    TrustManagerService.this.refreshAgentList(msg.arg1);
                    break;
                }
                case 9: {
                    TrustManagerService.this.mCurrentUser = msg.arg1;
                    TrustManagerService.this.refreshDeviceLockedForUser(-1);
                    break;
                }
                case 12: {
                    TrustManagerService.this.setDeviceLockedForUser(msg.arg1, true);
                    break;
                }
                case 10: {
                    SparseBooleanArray usuallyManaged;
                    SparseBooleanArray sparseBooleanArray = TrustManagerService.this.mTrustUsuallyManagedForUser;
                    synchronized (sparseBooleanArray) {
                        usuallyManaged = TrustManagerService.this.mTrustUsuallyManagedForUser.clone();
                    }
                    for (int i = 0; i < usuallyManaged.size(); ++i) {
                        int userId = usuallyManaged.keyAt(i);
                        boolean value = usuallyManaged.valueAt(i);
                        if (value == TrustManagerService.this.mLockPatternUtils.isTrustUsuallyManaged(userId)) continue;
                        TrustManagerService.this.mLockPatternUtils.setTrustUsuallyManaged(value, userId);
                    }
                    break;
                }
                case 14: {
                    TrustManagerService.this.refreshDeviceLockedForUser(msg.arg1);
                }
            }
        }
    };
    private final PackageMonitor mPackageMonitor = new PackageMonitor(){

        @Override
        public void onSomePackagesChanged() {
            TrustManagerService.this.refreshAgentList(-1);
        }

        @Override
        public boolean onPackageChanged(String packageName, int uid, String[] components) {
            return true;
        }

        @Override
        public void onPackageDisappeared(String packageName, int reason) {
            TrustManagerService.this.removeAgentsOfPackage(packageName);
        }
    };

    public TrustManagerService(Context context) {
        super(context);
        this.mContext = context;
        this.mUserManager = (UserManager)this.mContext.getSystemService("user");
        this.mActivityManager = (ActivityManager)this.mContext.getSystemService("activity");
        this.mLockPatternUtils = new LockPatternUtils(context);
        this.mStrongAuthTracker = new StrongAuthTracker(context);
    }

    @Override
    public void onStart() {
        this.publishBinderService("trust", this.mService);
    }

    @Override
    public void onBootPhase(int phase) {
        if (this.isSafeMode()) {
            return;
        }
        if (phase == 500) {
            this.mPackageMonitor.register(this.mContext, this.mHandler.getLooper(), UserHandle.ALL, true);
            this.mReceiver.register(this.mContext);
            this.mLockPatternUtils.registerStrongAuthTracker(this.mStrongAuthTracker);
        } else if (phase == 600) {
            this.mTrustAgentsCanRun = true;
            this.refreshAgentList(-1);
            this.refreshDeviceLockedForUser(-1);
        } else if (phase == 1000) {
            this.maybeEnableFactoryTrustAgents(this.mLockPatternUtils, 0);
        }
    }

    private void updateTrustAll() {
        List<UserInfo> userInfos = this.mUserManager.getUsers(true);
        for (UserInfo userInfo : userInfos) {
            this.updateTrust(userInfo.id, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTrust(int userId, int flags) {
        boolean changed;
        boolean managed = this.aggregateIsTrustManaged(userId);
        this.dispatchOnTrustManagedChanged(managed, userId);
        if (this.mStrongAuthTracker.isTrustAllowedForUser(userId) && this.isTrustUsuallyManagedInternal(userId) != managed) {
            this.updateTrustUsuallyManaged(userId, managed);
        }
        boolean trusted = this.aggregateIsTrusted(userId);
        SparseBooleanArray sparseBooleanArray = this.mUserIsTrusted;
        synchronized (sparseBooleanArray) {
            changed = this.mUserIsTrusted.get(userId) != trusted;
            this.mUserIsTrusted.put(userId, trusted);
        }
        this.dispatchOnTrustChanged(trusted, userId, flags);
        if (changed) {
            this.refreshDeviceLockedForUser(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTrustUsuallyManaged(int userId, boolean managed) {
        SparseBooleanArray sparseBooleanArray = this.mTrustUsuallyManagedForUser;
        synchronized (sparseBooleanArray) {
            this.mTrustUsuallyManagedForUser.put(userId, managed);
        }
        this.mHandler.removeMessages(10);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(10), 120000L);
    }

    public long addEscrowToken(byte[] token, int userId) {
        return this.mLockPatternUtils.addEscrowToken(token, userId);
    }

    public boolean removeEscrowToken(long handle, int userId) {
        return this.mLockPatternUtils.removeEscrowToken(handle, userId);
    }

    public boolean isEscrowTokenActive(long handle, int userId) {
        return this.mLockPatternUtils.isEscrowTokenActive(handle, userId);
    }

    public void unlockUserWithToken(long handle, byte[] token, int userId) {
        this.mLockPatternUtils.unlockUserWithToken(handle, token, userId);
    }

    void showKeyguardErrorMessage(CharSequence message) {
        this.dispatchOnTrustError(message);
    }

    /*
     * WARNING - void declaration
     */
    void refreshAgentList(int userIdOrAll) {
        void var7_10;
        List<Object> userInfos;
        if (DEBUG) {
            Slog.d(TAG, "refreshAgentList(" + userIdOrAll + ")");
        }
        if (!this.mTrustAgentsCanRun) {
            return;
        }
        if (userIdOrAll != -1 && userIdOrAll < 0) {
            Log.e(TAG, "refreshAgentList(userId=" + userIdOrAll + "): Invalid user handle, must be USER_ALL or a specific user.", new Throwable("here"));
            userIdOrAll = -1;
        }
        PackageManager pm = this.mContext.getPackageManager();
        if (userIdOrAll == -1) {
            userInfos = this.mUserManager.getUsers(true);
        } else {
            userInfos = new ArrayList();
            userInfos.add(this.mUserManager.getUserInfo(userIdOrAll));
        }
        LockPatternUtils lockPatternUtils = this.mLockPatternUtils;
        ArraySet<AgentInfo> obsoleteAgents = new ArraySet<AgentInfo>();
        obsoleteAgents.addAll(this.mActiveAgents);
        for (UserInfo userInfo : userInfos) {
            if (userInfo == null || userInfo.partial || !userInfo.isEnabled() || userInfo.guestToRemove) continue;
            if (!userInfo.supportsSwitchToByUser()) {
                if (!DEBUG) continue;
                Slog.d(TAG, "refreshAgentList: skipping user " + userInfo.id + ": switchToByUser=false");
                continue;
            }
            if (!this.mActivityManager.isUserRunning(userInfo.id)) {
                if (!DEBUG) continue;
                Slog.d(TAG, "refreshAgentList: skipping user " + userInfo.id + ": user not started");
                continue;
            }
            if (!lockPatternUtils.isSecure(userInfo.id)) {
                if (!DEBUG) continue;
                Slog.d(TAG, "refreshAgentList: skipping user " + userInfo.id + ": no secure credential");
                continue;
            }
            DevicePolicyManager dpm = lockPatternUtils.getDevicePolicyManager();
            int disabledFeatures = dpm.getKeyguardDisabledFeatures(null, userInfo.id);
            boolean disableTrustAgents = (disabledFeatures & 0x10) != 0;
            List<ComponentName> enabledAgents = lockPatternUtils.getEnabledTrustAgents(userInfo.id);
            if (enabledAgents == null) {
                if (!DEBUG) continue;
                Slog.d(TAG, "refreshAgentList: skipping user " + userInfo.id + ": no agents enabled by user");
                continue;
            }
            List<ResolveInfo> resolveInfos = this.resolveAllowedTrustAgents(pm, userInfo.id);
            for (ResolveInfo resolveInfo : resolveInfos) {
                int flag;
                boolean directUnlock;
                List<PersistableBundle> config;
                ComponentName name = this.getComponentName(resolveInfo);
                if (!enabledAgents.contains(name)) {
                    if (!DEBUG) continue;
                    Slog.d(TAG, "refreshAgentList: skipping " + name.flattenToShortString() + " u" + userInfo.id + ": not enabled by user");
                    continue;
                }
                if (disableTrustAgents && ((config = dpm.getTrustAgentConfiguration(null, name, userInfo.id)) == null || config.isEmpty())) {
                    if (!DEBUG) continue;
                    Slog.d(TAG, "refreshAgentList: skipping " + name.flattenToShortString() + " u" + userInfo.id + ": not allowed by DPM");
                    continue;
                }
                AgentInfo agentInfo = new AgentInfo();
                agentInfo.component = name;
                agentInfo.userId = userInfo.id;
                if (!this.mActiveAgents.contains(agentInfo)) {
                    agentInfo.label = resolveInfo.loadLabel(pm);
                    agentInfo.icon = resolveInfo.loadIcon(pm);
                    agentInfo.settings = this.getSettingsAttrs(pm, resolveInfo);
                } else {
                    int index = this.mActiveAgents.indexOf(agentInfo);
                    agentInfo = this.mActiveAgents.valueAt(index);
                }
                boolean bl = directUnlock = resolveInfo.serviceInfo.directBootAware && agentInfo.settings.canUnlockProfile;
                if (directUnlock && DEBUG) {
                    Slog.d(TAG, "refreshAgentList: trustagent " + name + "of user " + userInfo.id + "can unlock user profile.");
                }
                if (!this.mUserManager.isUserUnlockingOrUnlocked(userInfo.id) && !directUnlock) {
                    if (!DEBUG) continue;
                    Slog.d(TAG, "refreshAgentList: skipping user " + userInfo.id + "'s trust agent " + name + ": FBE still locked and  the agent cannot unlock user profile.");
                    continue;
                }
                if (!(this.mStrongAuthTracker.canAgentsRunForUser(userInfo.id) || (flag = this.mStrongAuthTracker.getStrongAuthForUser(userInfo.id)) == 8 || flag == 1 && directUnlock)) {
                    if (!DEBUG) continue;
                    Slog.d(TAG, "refreshAgentList: skipping user " + userInfo.id + ": prevented by StrongAuthTracker = 0x" + Integer.toHexString(this.mStrongAuthTracker.getStrongAuthForUser(userInfo.id)));
                    continue;
                }
                if (agentInfo.agent == null) {
                    agentInfo.agent = new TrustAgentWrapper(this.mContext, this, new Intent().setComponent(name), userInfo.getUserHandle());
                }
                if (!this.mActiveAgents.contains(agentInfo)) {
                    this.mActiveAgents.add(agentInfo);
                    continue;
                }
                obsoleteAgents.remove(agentInfo);
            }
        }
        boolean trustMayHaveChanged = false;
        boolean bl = false;
        while (var7_10 < obsoleteAgents.size()) {
            AgentInfo info = (AgentInfo)obsoleteAgents.valueAt((int)var7_10);
            if (userIdOrAll == -1 || userIdOrAll == info.userId) {
                if (info.agent.isManagingTrust()) {
                    trustMayHaveChanged = true;
                }
                info.agent.destroy();
                this.mActiveAgents.remove(info);
            }
            ++var7_10;
        }
        if (trustMayHaveChanged) {
            if (userIdOrAll == -1) {
                this.updateTrustAll();
            } else {
                this.updateTrust(userIdOrAll, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDeviceLockedInner(int userId) {
        SparseBooleanArray sparseBooleanArray = this.mDeviceLockedForUser;
        synchronized (sparseBooleanArray) {
            return this.mDeviceLockedForUser.get(userId, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDeviceLockedForUser(int userId) {
        List<Object> userInfos;
        if (userId != -1 && userId < 0) {
            Log.e(TAG, "refreshDeviceLockedForUser(userId=" + userId + "): Invalid user handle, must be USER_ALL or a specific user.", new Throwable("here"));
            userId = -1;
        }
        if (userId == -1) {
            userInfos = this.mUserManager.getUsers(true);
        } else {
            userInfos = new ArrayList();
            userInfos.add(this.mUserManager.getUserInfo(userId));
        }
        IWindowManager wm = WindowManagerGlobal.getWindowManagerService();
        for (int i = 0; i < userInfos.size(); ++i) {
            UserInfo info = (UserInfo)userInfos.get(i);
            if (info == null || info.partial || !info.isEnabled() || info.guestToRemove || !info.supportsSwitchToByUser()) continue;
            int id2 = info.id;
            boolean secure = this.mLockPatternUtils.isSecure(id2);
            boolean trusted = this.aggregateIsTrusted(id2);
            boolean showingKeyguard = true;
            boolean fingerprintAuthenticated = false;
            if (this.mCurrentUser == id2) {
                SparseBooleanArray sparseBooleanArray = this.mUsersUnlockedByFingerprint;
                synchronized (sparseBooleanArray) {
                    fingerprintAuthenticated = this.mUsersUnlockedByFingerprint.get(id2, false);
                }
                try {
                    showingKeyguard = wm.isKeyguardLocked();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            boolean deviceLocked = secure && showingKeyguard && !trusted && !fingerprintAuthenticated;
            this.setDeviceLockedForUser(id2, deviceLocked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDeviceLockedForUser(int userId, boolean locked) {
        boolean changed;
        SparseBooleanArray sparseBooleanArray = this.mDeviceLockedForUser;
        synchronized (sparseBooleanArray) {
            changed = this.isDeviceLockedInner(userId) != locked;
            this.mDeviceLockedForUser.put(userId, locked);
        }
        if (changed) {
            this.dispatchDeviceLocked(userId, locked);
        }
    }

    private void dispatchDeviceLocked(int userId, boolean isLocked) {
        for (int i = 0; i < this.mActiveAgents.size(); ++i) {
            AgentInfo agent = this.mActiveAgents.valueAt(i);
            if (agent.userId != userId) continue;
            if (isLocked) {
                agent.agent.onDeviceLocked();
                continue;
            }
            agent.agent.onDeviceUnlocked();
        }
    }

    void updateDevicePolicyFeatures() {
        boolean changed = false;
        for (int i = 0; i < this.mActiveAgents.size(); ++i) {
            AgentInfo info = this.mActiveAgents.valueAt(i);
            if (!info.agent.isConnected()) continue;
            info.agent.updateDevicePolicyFeatures();
            changed = true;
        }
        if (changed) {
            this.mArchive.logDevicePolicyChanged();
        }
    }

    private void removeAgentsOfPackage(String packageName) {
        boolean trustMayHaveChanged = false;
        for (int i = this.mActiveAgents.size() - 1; i >= 0; --i) {
            AgentInfo info = this.mActiveAgents.valueAt(i);
            if (!packageName.equals(info.component.getPackageName())) continue;
            Log.i(TAG, "Resetting agent " + info.component.flattenToShortString());
            if (info.agent.isManagingTrust()) {
                trustMayHaveChanged = true;
            }
            info.agent.destroy();
            this.mActiveAgents.removeAt(i);
        }
        if (trustMayHaveChanged) {
            this.updateTrustAll();
        }
    }

    public void resetAgent(ComponentName name, int userId) {
        boolean trustMayHaveChanged = false;
        for (int i = this.mActiveAgents.size() - 1; i >= 0; --i) {
            AgentInfo info = this.mActiveAgents.valueAt(i);
            if (!name.equals(info.component) || userId != info.userId) continue;
            Log.i(TAG, "Resetting agent " + info.component.flattenToShortString());
            if (info.agent.isManagingTrust()) {
                trustMayHaveChanged = true;
            }
            info.agent.destroy();
            this.mActiveAgents.removeAt(i);
        }
        if (trustMayHaveChanged) {
            this.updateTrust(userId, 0);
        }
        this.refreshAgentList(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SettingsAttrs getSettingsAttrs(PackageManager pm, ResolveInfo resolveInfo) {
        if (resolveInfo == null || resolveInfo.serviceInfo == null || resolveInfo.serviceInfo.metaData == null) {
            return null;
        }
        String cn = null;
        boolean canUnlockProfile = false;
        Exception caughtException = null;
        try (XmlResourceParser parser = null;){
            int type;
            parser = resolveInfo.serviceInfo.loadXmlMetaData(pm, "android.service.trust.trustagent");
            if (parser == null) {
                Slog.w(TAG, "Can't find android.service.trust.trustagent meta-data");
                SettingsAttrs settingsAttrs = null;
                return settingsAttrs;
            }
            Resources res = pm.getResourcesForApplication(resolveInfo.serviceInfo.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"trust-agent".equals(nodeName)) {
                Slog.w(TAG, "Meta-data does not start with trust-agent tag");
                SettingsAttrs settingsAttrs = null;
                return settingsAttrs;
            }
            TypedArray sa = res.obtainAttributes(attrs, R.styleable.TrustAgent);
            cn = sa.getString(2);
            canUnlockProfile = sa.getBoolean(3, false);
            sa.recycle();
        }
        if (caughtException != null) {
            Slog.w(TAG, "Error parsing : " + resolveInfo.serviceInfo.packageName, caughtException);
            return null;
        }
        if (cn == null) {
            return null;
        }
        if (cn.indexOf(47) < 0) {
            cn = resolveInfo.serviceInfo.packageName + "/" + cn;
        }
        return new SettingsAttrs(ComponentName.unflattenFromString(cn), canUnlockProfile);
    }

    private ComponentName getComponentName(ResolveInfo resolveInfo) {
        if (resolveInfo == null || resolveInfo.serviceInfo == null) {
            return null;
        }
        return new ComponentName(resolveInfo.serviceInfo.packageName, resolveInfo.serviceInfo.name);
    }

    private void maybeEnableFactoryTrustAgents(LockPatternUtils utils, int userId) {
        if (0 != Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "trust_agents_initialized", 0, userId)) {
            return;
        }
        PackageManager pm = this.mContext.getPackageManager();
        List<ResolveInfo> resolveInfos = this.resolveAllowedTrustAgents(pm, userId);
        ComponentName defaultAgent = TrustManagerService.getDefaultFactoryTrustAgent(this.mContext);
        boolean shouldUseDefaultAgent = defaultAgent != null;
        ArraySet<ComponentName> discoveredAgents = new ArraySet<ComponentName>();
        if (shouldUseDefaultAgent) {
            discoveredAgents.add(defaultAgent);
            Log.i(TAG, "Enabling " + defaultAgent + " because it is a default agent.");
        } else {
            for (ResolveInfo resolveInfo : resolveInfos) {
                ComponentName componentName = this.getComponentName(resolveInfo);
                int applicationInfoFlags = resolveInfo.serviceInfo.applicationInfo.flags;
                if ((applicationInfoFlags & 1) == 0) {
                    Log.i(TAG, "Leaving agent " + componentName + " disabled because package is not a system package.");
                    continue;
                }
                discoveredAgents.add(componentName);
            }
        }
        List<ComponentName> previouslyEnabledAgents = utils.getEnabledTrustAgents(userId);
        if (previouslyEnabledAgents != null) {
            discoveredAgents.addAll(previouslyEnabledAgents);
        }
        utils.setEnabledTrustAgents(discoveredAgents, userId);
        Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "trust_agents_initialized", 1, userId);
    }

    private static ComponentName getDefaultFactoryTrustAgent(Context context) {
        String defaultTrustAgent = context.getResources().getString(17039654);
        if (TextUtils.isEmpty(defaultTrustAgent)) {
            return null;
        }
        return ComponentName.unflattenFromString(defaultTrustAgent);
    }

    private List<ResolveInfo> resolveAllowedTrustAgents(PackageManager pm, int userId) {
        List<ResolveInfo> resolveInfos = pm.queryIntentServicesAsUser(TRUST_AGENT_INTENT, 786560, userId);
        ArrayList<ResolveInfo> allowedAgents = new ArrayList<ResolveInfo>(resolveInfos.size());
        for (ResolveInfo resolveInfo : resolveInfos) {
            if (resolveInfo.serviceInfo == null || resolveInfo.serviceInfo.applicationInfo == null) continue;
            String packageName = resolveInfo.serviceInfo.packageName;
            if (pm.checkPermission(PERMISSION_PROVIDE_AGENT, packageName) != 0) {
                ComponentName name = this.getComponentName(resolveInfo);
                Log.w(TAG, "Skipping agent " + name + " because package does not have permission " + PERMISSION_PROVIDE_AGENT + ".");
                continue;
            }
            allowedAgents.add(resolveInfo);
        }
        return allowedAgents;
    }

    private boolean aggregateIsTrusted(int userId) {
        if (!this.mStrongAuthTracker.isTrustAllowedForUser(userId)) {
            return false;
        }
        for (int i = 0; i < this.mActiveAgents.size(); ++i) {
            AgentInfo info = this.mActiveAgents.valueAt(i);
            if (info.userId != userId || !info.agent.isTrusted()) continue;
            return true;
        }
        return false;
    }

    private boolean aggregateIsTrustManaged(int userId) {
        if (!this.mStrongAuthTracker.isTrustAllowedForUser(userId)) {
            return false;
        }
        for (int i = 0; i < this.mActiveAgents.size(); ++i) {
            AgentInfo info = this.mActiveAgents.valueAt(i);
            if (info.userId != userId || !info.agent.isManagingTrust()) continue;
            return true;
        }
        return false;
    }

    private void dispatchUnlockAttempt(boolean successful, int userId) {
        if (successful) {
            this.mStrongAuthTracker.allowTrustFromUnlock(userId);
        }
        for (int i = 0; i < this.mActiveAgents.size(); ++i) {
            AgentInfo info = this.mActiveAgents.valueAt(i);
            if (info.userId != userId) continue;
            info.agent.onUnlockAttempt(successful);
        }
    }

    private void dispatchUnlockLockout(int timeoutMs, int userId) {
        for (int i = 0; i < this.mActiveAgents.size(); ++i) {
            AgentInfo info = this.mActiveAgents.valueAt(i);
            if (info.userId != userId) continue;
            info.agent.onUnlockLockout(timeoutMs);
        }
    }

    private void addListener(ITrustListener listener) {
        for (int i = 0; i < this.mTrustListeners.size(); ++i) {
            if (this.mTrustListeners.get(i).asBinder() != listener.asBinder()) continue;
            return;
        }
        this.mTrustListeners.add(listener);
        this.updateTrustAll();
    }

    private void removeListener(ITrustListener listener) {
        for (int i = 0; i < this.mTrustListeners.size(); ++i) {
            if (this.mTrustListeners.get(i).asBinder() != listener.asBinder()) continue;
            this.mTrustListeners.remove(i);
            return;
        }
    }

    private void dispatchOnTrustChanged(boolean enabled, int userId, int flags) {
        if (DEBUG) {
            Log.i(TAG, "onTrustChanged(" + enabled + ", " + userId + ", 0x" + Integer.toHexString(flags) + ")");
        }
        if (!enabled) {
            flags = 0;
        }
        for (int i = 0; i < this.mTrustListeners.size(); ++i) {
            try {
                this.mTrustListeners.get(i).onTrustChanged(enabled, userId, flags);
                continue;
            }
            catch (DeadObjectException e) {
                Slog.d(TAG, "Removing dead TrustListener.");
                this.mTrustListeners.remove(i);
                --i;
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Exception while notifying TrustListener.", e);
            }
        }
    }

    private void dispatchOnTrustManagedChanged(boolean managed, int userId) {
        if (DEBUG) {
            Log.i(TAG, "onTrustManagedChanged(" + managed + ", " + userId + ")");
        }
        for (int i = 0; i < this.mTrustListeners.size(); ++i) {
            try {
                this.mTrustListeners.get(i).onTrustManagedChanged(managed, userId);
                continue;
            }
            catch (DeadObjectException e) {
                Slog.d(TAG, "Removing dead TrustListener.");
                this.mTrustListeners.remove(i);
                --i;
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Exception while notifying TrustListener.", e);
            }
        }
    }

    private void dispatchOnTrustError(CharSequence message) {
        if (DEBUG) {
            Log.i(TAG, "onTrustError(" + message + ")");
        }
        for (int i = 0; i < this.mTrustListeners.size(); ++i) {
            try {
                this.mTrustListeners.get(i).onTrustError(message);
                continue;
            }
            catch (DeadObjectException e) {
                Slog.d(TAG, "Removing dead TrustListener.");
                this.mTrustListeners.remove(i);
                --i;
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Exception while notifying TrustListener.", e);
            }
        }
    }

    @Override
    public void onStartUser(int userId) {
        this.mHandler.obtainMessage(7, userId, 0, null).sendToTarget();
    }

    @Override
    public void onCleanupUser(int userId) {
        this.mHandler.obtainMessage(8, userId, 0, null).sendToTarget();
    }

    @Override
    public void onSwitchUser(int userId) {
        this.mHandler.obtainMessage(9, userId, 0, null).sendToTarget();
    }

    @Override
    public void onUnlockUser(int userId) {
        this.mHandler.obtainMessage(11, userId, 0, null).sendToTarget();
    }

    @Override
    public void onStopUser(int userId) {
        this.mHandler.obtainMessage(12, userId, 0, null).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTrustUsuallyManagedInternal(int userId) {
        SparseBooleanArray sparseBooleanArray;
        boolean persistedValue;
        SparseBooleanArray sparseBooleanArray2 = this.mTrustUsuallyManagedForUser;
        synchronized (sparseBooleanArray2) {
            int i = this.mTrustUsuallyManagedForUser.indexOfKey(userId);
            if (i >= 0) {
                return this.mTrustUsuallyManagedForUser.valueAt(i);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
            persistedValue = this.mLockPatternUtils.isTrustUsuallyManaged(userId);
            sparseBooleanArray = this.mTrustUsuallyManagedForUser;
        }
        synchronized (sparseBooleanArray) {
            int i = this.mTrustUsuallyManagedForUser.indexOfKey(userId);
            if (i >= 0) {
                return this.mTrustUsuallyManagedForUser.valueAt(i);
            }
            this.mTrustUsuallyManagedForUser.put(userId, persistedValue);
            return persistedValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int resolveProfileParent(int userId) {
        long identity = Binder.clearCallingIdentity();
        try {
            UserInfo parent = this.mUserManager.getProfileParent(userId);
            if (parent != null) {
                int n = parent.getUserHandle().getIdentifier();
                return n;
            }
            int n = userId;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private class StrongAuthTracker
    extends LockPatternUtils.StrongAuthTracker {
        SparseBooleanArray mStartFromSuccessfulUnlock;

        public StrongAuthTracker(Context context) {
            super(context);
            this.mStartFromSuccessfulUnlock = new SparseBooleanArray();
        }

        @Override
        public void onStrongAuthRequiredChanged(int userId) {
            this.mStartFromSuccessfulUnlock.delete(userId);
            if (DEBUG) {
                Log.i(TrustManagerService.TAG, "onStrongAuthRequiredChanged(" + userId + ") -> trustAllowed=" + this.isTrustAllowedForUser(userId) + " agentsCanRun=" + this.canAgentsRunForUser(userId));
            }
            TrustManagerService.this.refreshAgentList(userId);
            TrustManagerService.this.updateTrust(userId, 0);
        }

        boolean canAgentsRunForUser(int userId) {
            return this.mStartFromSuccessfulUnlock.get(userId) || super.isTrustAllowedForUser(userId);
        }

        void allowTrustFromUnlock(int userId) {
            if (userId < 0) {
                throw new IllegalArgumentException("userId must be a valid user: " + userId);
            }
            boolean previous = this.canAgentsRunForUser(userId);
            this.mStartFromSuccessfulUnlock.put(userId, true);
            if (DEBUG) {
                Log.i(TrustManagerService.TAG, "allowTrustFromUnlock(" + userId + ") -> trustAllowed=" + this.isTrustAllowedForUser(userId) + " agentsCanRun=" + this.canAgentsRunForUser(userId));
            }
            if (this.canAgentsRunForUser(userId) != previous) {
                TrustManagerService.this.refreshAgentList(userId);
            }
        }
    }

    private class Receiver
    extends BroadcastReceiver {
        private Receiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            int userId;
            String action = intent.getAction();
            if ("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED".equals(action)) {
                TrustManagerService.this.refreshAgentList(this.getSendingUserId());
                TrustManagerService.this.updateDevicePolicyFeatures();
            } else if ("android.intent.action.USER_ADDED".equals(action)) {
                int userId2 = this.getUserId(intent);
                if (userId2 > 0) {
                    TrustManagerService.this.maybeEnableFactoryTrustAgents(TrustManagerService.this.mLockPatternUtils, userId2);
                }
            } else if ("android.intent.action.USER_REMOVED".equals(action) && (userId = this.getUserId(intent)) > 0) {
                SparseBooleanArray sparseBooleanArray = TrustManagerService.this.mUserIsTrusted;
                synchronized (sparseBooleanArray) {
                    TrustManagerService.this.mUserIsTrusted.delete(userId);
                }
                sparseBooleanArray = TrustManagerService.this.mDeviceLockedForUser;
                synchronized (sparseBooleanArray) {
                    TrustManagerService.this.mDeviceLockedForUser.delete(userId);
                }
                sparseBooleanArray = TrustManagerService.this.mTrustUsuallyManagedForUser;
                synchronized (sparseBooleanArray) {
                    TrustManagerService.this.mTrustUsuallyManagedForUser.delete(userId);
                }
                sparseBooleanArray = TrustManagerService.this.mUsersUnlockedByFingerprint;
                synchronized (sparseBooleanArray) {
                    TrustManagerService.this.mUsersUnlockedByFingerprint.delete(userId);
                }
                TrustManagerService.this.refreshAgentList(userId);
                TrustManagerService.this.refreshDeviceLockedForUser(userId);
            }
        }

        private int getUserId(Intent intent) {
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -100);
            if (userId > 0) {
                return userId;
            }
            Slog.wtf(TrustManagerService.TAG, "EXTRA_USER_HANDLE missing or invalid, value=" + userId);
            return -100;
        }

        public void register(Context context) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED");
            filter.addAction("android.intent.action.USER_ADDED");
            filter.addAction("android.intent.action.USER_REMOVED");
            context.registerReceiverAsUser(this, UserHandle.ALL, filter, null, null);
        }
    }

    private static class SettingsAttrs {
        public ComponentName componentName;
        public boolean canUnlockProfile;

        public SettingsAttrs(ComponentName componentName, boolean canUnlockProfile) {
            this.componentName = componentName;
            this.canUnlockProfile = canUnlockProfile;
        }
    }

    private static final class AgentInfo {
        CharSequence label;
        Drawable icon;
        ComponentName component;
        SettingsAttrs settings;
        TrustAgentWrapper agent;
        int userId;

        private AgentInfo() {
        }

        public boolean equals(Object other) {
            if (!(other instanceof AgentInfo)) {
                return false;
            }
            AgentInfo o = (AgentInfo)other;
            return this.component.equals(o.component) && this.userId == o.userId;
        }

        public int hashCode() {
            return this.component.hashCode() * 31 + this.userId;
        }
    }
}

