/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.updates;

import android.os.FileUtils;
import android.system.ErrnoException;
import android.system.Os;
import android.util.Base64;
import android.util.Slog;
import com.android.internal.util.HexDump;
import com.android.server.updates.ConfigUpdateInstallReceiver;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CertificateTransparencyLogInstallReceiver
extends ConfigUpdateInstallReceiver {
    private static final String TAG = "CTLogInstallReceiver";
    private static final String LOGDIR_PREFIX = "logs-";

    public CertificateTransparencyLogInstallReceiver() {
        super("/data/misc/keychain/trusted_ct_logs/", "ct_logs", "metadata/", "version");
    }

    @Override
    protected void install(byte[] content, int version) throws IOException {
        this.updateDir.mkdir();
        if (!this.updateDir.isDirectory()) {
            throw new IOException("Unable to make directory " + this.updateDir.getCanonicalPath());
        }
        if (!this.updateDir.setReadable(true, false)) {
            throw new IOException("Unable to set permissions on " + this.updateDir.getCanonicalPath());
        }
        File currentSymlink = new File(this.updateDir, "current");
        File newVersion = new File(this.updateDir, LOGDIR_PREFIX + String.valueOf(version));
        if (newVersion.exists()) {
            if (newVersion.getCanonicalPath().equals(currentSymlink.getCanonicalPath())) {
                this.writeUpdate(this.updateDir, this.updateVersion, Long.toString(version).getBytes());
                this.deleteOldLogDirectories();
                return;
            }
            FileUtils.deleteContentsAndDir(newVersion);
        }
        try {
            newVersion.mkdir();
            if (!newVersion.isDirectory()) {
                throw new IOException("Unable to make directory " + newVersion.getCanonicalPath());
            }
            if (!newVersion.setReadable(true, false)) {
                throw new IOException("Failed to set " + newVersion.getCanonicalPath() + " readable");
            }
            try {
                JSONObject json = new JSONObject(new String(content, StandardCharsets.UTF_8));
                JSONArray logs = json.getJSONArray("logs");
                for (int i = 0; i < logs.length(); ++i) {
                    JSONObject log = logs.getJSONObject(i);
                    this.installLog(newVersion, log);
                }
            }
            catch (JSONException e) {
                throw new IOException("Failed to parse logs", e);
            }
            File tempSymlink = new File(this.updateDir, "new_symlink");
            try {
                Os.symlink(newVersion.getCanonicalPath(), tempSymlink.getCanonicalPath());
            }
            catch (ErrnoException e) {
                throw new IOException("Failed to create symlink", e);
            }
            tempSymlink.renameTo(currentSymlink.getAbsoluteFile());
        }
        catch (IOException | RuntimeException e) {
            FileUtils.deleteContentsAndDir(newVersion);
            throw e;
        }
        Slog.i(TAG, "CT log directory updated to " + newVersion.getAbsolutePath());
        this.writeUpdate(this.updateDir, this.updateVersion, Long.toString(version).getBytes());
        this.deleteOldLogDirectories();
    }

    private void installLog(File directory, JSONObject logObject) throws IOException {
        try {
            String logFilename = this.getLogFileName(logObject.getString("key"));
            File file = new File(directory, logFilename);
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                this.writeLogEntry(out, "key", logObject.getString("key"));
                this.writeLogEntry(out, "url", logObject.getString("url"));
                this.writeLogEntry(out, "description", logObject.getString("description"));
            }
            if (!file.setReadable(true, false)) {
                throw new IOException("Failed to set permissions on " + file.getCanonicalPath());
            }
        }
        catch (JSONException e) {
            throw new IOException("Failed to parse log", e);
        }
    }

    private String getLogFileName(String base64PublicKey) {
        byte[] keyBytes = Base64.decode(base64PublicKey, 0);
        try {
            byte[] id2 = MessageDigest.getInstance("SHA-256").digest(keyBytes);
            return HexDump.toHexString(id2, false);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeLogEntry(OutputStreamWriter out, String key, String value) throws IOException {
        out.write(key + ":" + value + "\n");
    }

    private void deleteOldLogDirectories() throws IOException {
        if (!this.updateDir.exists()) {
            return;
        }
        final File currentTarget = new File(this.updateDir, "current").getCanonicalFile();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !currentTarget.equals(file) && file.getName().startsWith(CertificateTransparencyLogInstallReceiver.LOGDIR_PREFIX);
            }
        };
        for (File f : this.updateDir.listFiles(filter)) {
            FileUtils.deleteContentsAndDir(f);
        }
    }
}

