/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.os.SystemClock;
import android.util.ArrayMap;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import android.util.Xml;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.IndentingPrintWriter;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AppIdleHistory {
    private static final String TAG = "AppIdleHistory";
    private static final boolean DEBUG = false;
    private SparseArray<ArrayMap<String, AppUsageHistory>> mIdleHistory = new SparseArray();
    private static final long ONE_MINUTE = 60000L;
    @VisibleForTesting
    static final String APP_IDLE_FILENAME = "app_idle_stats.xml";
    private static final String TAG_PACKAGES = "packages";
    private static final String TAG_PACKAGE = "package";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SCREEN_IDLE = "screenIdleTime";
    private static final String ATTR_ELAPSED_IDLE = "elapsedIdleTime";
    private static final String ATTR_LAST_PREDICTED_TIME = "lastPredictedTime";
    private static final String ATTR_CURRENT_BUCKET = "appLimitBucket";
    private static final String ATTR_BUCKETING_REASON = "bucketReason";
    private static final String ATTR_LAST_RUN_JOB_TIME = "lastJobRunTime";
    private static final String ATTR_BUCKET_TIMEOUT_TIME = "bucketTimeoutTime";
    private long mElapsedSnapshot;
    private long mElapsedDuration;
    private long mScreenOnSnapshot;
    private long mScreenOnDuration;
    private final File mStorageDir;
    private boolean mScreenOn;

    AppIdleHistory(File storageDir, long elapsedRealtime) {
        this.mElapsedSnapshot = elapsedRealtime;
        this.mScreenOnSnapshot = elapsedRealtime;
        this.mStorageDir = storageDir;
        this.readScreenOnTime();
    }

    public void updateDisplay(boolean screenOn, long elapsedRealtime) {
        if (screenOn == this.mScreenOn) {
            return;
        }
        this.mScreenOn = screenOn;
        if (this.mScreenOn) {
            this.mScreenOnSnapshot = elapsedRealtime;
        } else {
            this.mScreenOnDuration += elapsedRealtime - this.mScreenOnSnapshot;
            this.mElapsedDuration += elapsedRealtime - this.mElapsedSnapshot;
            this.mElapsedSnapshot = elapsedRealtime;
        }
    }

    public long getScreenOnTime(long elapsedRealtime) {
        long screenOnTime = this.mScreenOnDuration;
        if (this.mScreenOn) {
            screenOnTime += elapsedRealtime - this.mScreenOnSnapshot;
        }
        return screenOnTime;
    }

    @VisibleForTesting
    File getScreenOnTimeFile() {
        return new File(this.mStorageDir, "screen_on_time");
    }

    private void readScreenOnTime() {
        File screenOnTimeFile = this.getScreenOnTimeFile();
        if (screenOnTimeFile.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(screenOnTimeFile));
                this.mScreenOnDuration = Long.parseLong(reader.readLine());
                this.mElapsedDuration = Long.parseLong(reader.readLine());
                reader.close();
            }
            catch (IOException | NumberFormatException exception) {}
        } else {
            this.writeScreenOnTime();
        }
    }

    private void writeScreenOnTime() {
        AtomicFile screenOnTimeFile = new AtomicFile(this.getScreenOnTimeFile());
        FileOutputStream fos = null;
        try {
            fos = screenOnTimeFile.startWrite();
            fos.write((Long.toString(this.mScreenOnDuration) + "\n" + Long.toString(this.mElapsedDuration) + "\n").getBytes());
            screenOnTimeFile.finishWrite(fos);
        }
        catch (IOException ioe) {
            screenOnTimeFile.failWrite(fos);
        }
    }

    public void writeAppIdleDurations() {
        long elapsedRealtime = SystemClock.elapsedRealtime();
        this.mElapsedDuration += elapsedRealtime - this.mElapsedSnapshot;
        this.mElapsedSnapshot = elapsedRealtime;
        this.writeScreenOnTime();
    }

    public AppUsageHistory reportUsage(AppUsageHistory appUsageHistory, String packageName, int newBucket, long elapsedRealtime, long timeout) {
        if (elapsedRealtime != 0L) {
            appUsageHistory.lastUsedElapsedTime = this.mElapsedDuration + (elapsedRealtime - this.mElapsedSnapshot);
            appUsageHistory.lastUsedScreenTime = this.getScreenOnTime(elapsedRealtime);
        }
        if (appUsageHistory.currentBucket > newBucket) {
            appUsageHistory.currentBucket = newBucket;
            if (timeout > elapsedRealtime) {
                appUsageHistory.bucketTimeoutTime = Math.max(appUsageHistory.bucketTimeoutTime, this.mElapsedDuration + (timeout - this.mElapsedSnapshot));
            }
        }
        appUsageHistory.bucketingReason = "usage";
        return appUsageHistory;
    }

    public AppUsageHistory reportUsage(String packageName, int userId, int newBucket, long nowElapsed, long timeout) {
        ArrayMap<String, AppUsageHistory> userHistory = this.getUserHistory(userId);
        AppUsageHistory history = this.getPackageHistory(userHistory, packageName, nowElapsed, true);
        return this.reportUsage(history, packageName, newBucket, nowElapsed, timeout);
    }

    private ArrayMap<String, AppUsageHistory> getUserHistory(int userId) {
        ArrayMap<String, AppUsageHistory> userHistory = this.mIdleHistory.get(userId);
        if (userHistory == null) {
            userHistory = new ArrayMap();
            this.mIdleHistory.put(userId, userHistory);
            this.readAppIdleTimes(userId, userHistory);
        }
        return userHistory;
    }

    private AppUsageHistory getPackageHistory(ArrayMap<String, AppUsageHistory> userHistory, String packageName, long elapsedRealtime, boolean create) {
        AppUsageHistory appUsageHistory = userHistory.get(packageName);
        if (appUsageHistory == null && create) {
            appUsageHistory = new AppUsageHistory();
            appUsageHistory.lastUsedElapsedTime = this.getElapsedTime(elapsedRealtime);
            appUsageHistory.lastUsedScreenTime = this.getScreenOnTime(elapsedRealtime);
            appUsageHistory.lastPredictedTime = this.getElapsedTime(0L);
            appUsageHistory.currentBucket = 50;
            appUsageHistory.bucketingReason = "default";
            appUsageHistory.lastInformedBucket = -1;
            appUsageHistory.lastJobRunTime = Long.MIN_VALUE;
            userHistory.put(packageName, appUsageHistory);
        }
        return appUsageHistory;
    }

    public void onUserRemoved(int userId) {
        this.mIdleHistory.remove(userId);
    }

    public boolean isIdle(String packageName, int userId, long elapsedRealtime) {
        ArrayMap<String, AppUsageHistory> userHistory = this.getUserHistory(userId);
        AppUsageHistory appUsageHistory = this.getPackageHistory(userHistory, packageName, elapsedRealtime, true);
        if (appUsageHistory == null) {
            return false;
        }
        return appUsageHistory.currentBucket >= 40;
    }

    public AppUsageHistory getAppUsageHistory(String packageName, int userId, long elapsedRealtime) {
        ArrayMap<String, AppUsageHistory> userHistory = this.getUserHistory(userId);
        AppUsageHistory appUsageHistory = this.getPackageHistory(userHistory, packageName, elapsedRealtime, true);
        return appUsageHistory;
    }

    public void setAppStandbyBucket(String packageName, int userId, long elapsedRealtime, int bucket, String reason) {
        ArrayMap<String, AppUsageHistory> userHistory = this.getUserHistory(userId);
        AppUsageHistory appUsageHistory = this.getPackageHistory(userHistory, packageName, elapsedRealtime, true);
        appUsageHistory.currentBucket = bucket;
        appUsageHistory.bucketingReason = reason;
        if (reason.startsWith("predicted")) {
            appUsageHistory.lastPredictedTime = this.getElapsedTime(elapsedRealtime);
        }
    }

    public void setLastJobRunTime(String packageName, int userId, long elapsedRealtime) {
        ArrayMap<String, AppUsageHistory> userHistory = this.getUserHistory(userId);
        AppUsageHistory appUsageHistory = this.getPackageHistory(userHistory, packageName, elapsedRealtime, true);
        appUsageHistory.lastJobRunTime = this.getElapsedTime(elapsedRealtime);
    }

    public long getTimeSinceLastJobRun(String packageName, int userId, long elapsedRealtime) {
        ArrayMap<String, AppUsageHistory> userHistory = this.getUserHistory(userId);
        AppUsageHistory appUsageHistory = this.getPackageHistory(userHistory, packageName, elapsedRealtime, true);
        if (appUsageHistory.lastJobRunTime == Long.MIN_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.getElapsedTime(elapsedRealtime) - appUsageHistory.lastJobRunTime;
    }

    public int getAppStandbyBucket(String packageName, int userId, long elapsedRealtime) {
        ArrayMap<String, AppUsageHistory> userHistory = this.getUserHistory(userId);
        AppUsageHistory appUsageHistory = this.getPackageHistory(userHistory, packageName, elapsedRealtime, true);
        return appUsageHistory.currentBucket;
    }

    public Map<String, Integer> getAppStandbyBuckets(int userId, long elapsedRealtime, boolean appIdleEnabled) {
        ArrayMap<String, AppUsageHistory> userHistory = this.getUserHistory(userId);
        int size = userHistory.size();
        HashMap<String, Integer> buckets = new HashMap<String, Integer>(size);
        for (int i = 0; i < size; ++i) {
            buckets.put(userHistory.keyAt(i), appIdleEnabled ? userHistory.valueAt((int)i).currentBucket : 10);
        }
        return buckets;
    }

    public String getAppStandbyReason(String packageName, int userId, long elapsedRealtime) {
        ArrayMap<String, AppUsageHistory> userHistory = this.getUserHistory(userId);
        AppUsageHistory appUsageHistory = this.getPackageHistory(userHistory, packageName, elapsedRealtime, false);
        return appUsageHistory != null ? appUsageHistory.bucketingReason : null;
    }

    public long getElapsedTime(long elapsedRealtime) {
        return elapsedRealtime - this.mElapsedSnapshot + this.mElapsedDuration;
    }

    public int setIdle(String packageName, int userId, boolean idle, long elapsedRealtime) {
        ArrayMap<String, AppUsageHistory> userHistory = this.getUserHistory(userId);
        AppUsageHistory appUsageHistory = this.getPackageHistory(userHistory, packageName, elapsedRealtime, true);
        if (idle) {
            appUsageHistory.currentBucket = 40;
            appUsageHistory.bucketingReason = "forced";
        } else {
            appUsageHistory.currentBucket = 10;
            appUsageHistory.bucketingReason = "usage";
        }
        return appUsageHistory.currentBucket;
    }

    public void clearUsage(String packageName, int userId) {
        ArrayMap<String, AppUsageHistory> userHistory = this.getUserHistory(userId);
        userHistory.remove(packageName);
    }

    boolean shouldInformListeners(String packageName, int userId, long elapsedRealtime, int bucket) {
        ArrayMap<String, AppUsageHistory> userHistory = this.getUserHistory(userId);
        AppUsageHistory appUsageHistory = this.getPackageHistory(userHistory, packageName, elapsedRealtime, true);
        if (appUsageHistory.lastInformedBucket != bucket) {
            appUsageHistory.lastInformedBucket = bucket;
            return true;
        }
        return false;
    }

    int getThresholdIndex(String packageName, int userId, long elapsedRealtime, long[] screenTimeThresholds, long[] elapsedTimeThresholds) {
        ArrayMap<String, AppUsageHistory> userHistory = this.getUserHistory(userId);
        AppUsageHistory appUsageHistory = this.getPackageHistory(userHistory, packageName, elapsedRealtime, false);
        if (appUsageHistory == null) {
            return screenTimeThresholds.length - 1;
        }
        long screenOnDelta = this.getScreenOnTime(elapsedRealtime) - appUsageHistory.lastUsedScreenTime;
        long elapsedDelta = this.getElapsedTime(elapsedRealtime) - appUsageHistory.lastUsedElapsedTime;
        for (int i = screenTimeThresholds.length - 1; i >= 0; --i) {
            if (screenOnDelta < screenTimeThresholds[i] || elapsedDelta < elapsedTimeThresholds[i]) continue;
            return i;
        }
        return 0;
    }

    @VisibleForTesting
    File getUserFile(int userId) {
        return new File(new File(new File(this.mStorageDir, "users"), Integer.toString(userId)), APP_IDLE_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAppIdleTimes(int userId, ArrayMap<String, AppUsageHistory> userHistory) {
        int type;
        XmlPullParser parser;
        FileInputStream fis;
        block10: {
            block9: {
                fis = null;
                AtomicFile appIdleFile = new AtomicFile(this.getUserFile(userId));
                fis = appIdleFile.openRead();
                parser = Xml.newPullParser();
                parser.setInput(fis, StandardCharsets.UTF_8.name());
                while ((type = parser.next()) != 2 && type != 1) {
                }
                if (type == 2) break block9;
                Slog.e(TAG, "Unable to read app idle file for user " + userId);
                IoUtils.closeQuietly(fis);
                return;
            }
            if (parser.getName().equals(TAG_PACKAGES)) break block10;
            IoUtils.closeQuietly(fis);
            return;
        }
        try {
            while ((type = parser.next()) != 1) {
                String name;
                if (type != 2 || !(name = parser.getName()).equals(TAG_PACKAGE)) continue;
                String packageName = parser.getAttributeValue(null, ATTR_NAME);
                AppUsageHistory appUsageHistory = new AppUsageHistory();
                appUsageHistory.lastUsedElapsedTime = Long.parseLong(parser.getAttributeValue(null, ATTR_ELAPSED_IDLE));
                appUsageHistory.lastUsedScreenTime = Long.parseLong(parser.getAttributeValue(null, ATTR_SCREEN_IDLE));
                appUsageHistory.lastPredictedTime = this.getLongValue(parser, ATTR_LAST_PREDICTED_TIME, 0L);
                String currentBucketString = parser.getAttributeValue(null, ATTR_CURRENT_BUCKET);
                appUsageHistory.currentBucket = currentBucketString == null ? 10 : Integer.parseInt(currentBucketString);
                appUsageHistory.bucketingReason = parser.getAttributeValue(null, ATTR_BUCKETING_REASON);
                appUsageHistory.lastJobRunTime = this.getLongValue(parser, ATTR_LAST_RUN_JOB_TIME, Long.MIN_VALUE);
                appUsageHistory.bucketTimeoutTime = this.getLongValue(parser, ATTR_BUCKET_TIMEOUT_TIME, 0L);
                if (appUsageHistory.bucketingReason == null) {
                    appUsageHistory.bucketingReason = "default";
                }
                appUsageHistory.lastInformedBucket = -1;
                userHistory.put(packageName, appUsageHistory);
            }
        }
        catch (IOException | XmlPullParserException e) {
            try {
                Slog.e(TAG, "Unable to read app idle file for user " + userId);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(fis);
                throw throwable;
            }
            IoUtils.closeQuietly(fis);
        }
        IoUtils.closeQuietly(fis);
    }

    private long getLongValue(XmlPullParser parser, String attrName, long defValue) {
        String value = parser.getAttributeValue(null, attrName);
        if (value == null) {
            return defValue;
        }
        return Long.parseLong(value);
    }

    public void writeAppIdleTimes(int userId) {
        FileOutputStream fos = null;
        AtomicFile appIdleFile = new AtomicFile(this.getUserFile(userId));
        try {
            fos = appIdleFile.startWrite();
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            FastXmlSerializer xml2 = new FastXmlSerializer();
            xml2.setOutput(bos, StandardCharsets.UTF_8.name());
            xml2.startDocument(null, true);
            xml2.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            xml2.startTag(null, TAG_PACKAGES);
            ArrayMap<String, AppUsageHistory> userHistory = this.getUserHistory(userId);
            int N = userHistory.size();
            for (int i = 0; i < N; ++i) {
                String packageName = userHistory.keyAt(i);
                AppUsageHistory history = userHistory.valueAt(i);
                xml2.startTag(null, TAG_PACKAGE);
                xml2.attribute(null, ATTR_NAME, packageName);
                xml2.attribute(null, ATTR_ELAPSED_IDLE, Long.toString(history.lastUsedElapsedTime));
                xml2.attribute(null, ATTR_SCREEN_IDLE, Long.toString(history.lastUsedScreenTime));
                xml2.attribute(null, ATTR_LAST_PREDICTED_TIME, Long.toString(history.lastPredictedTime));
                xml2.attribute(null, ATTR_CURRENT_BUCKET, Integer.toString(history.currentBucket));
                xml2.attribute(null, ATTR_BUCKETING_REASON, history.bucketingReason);
                if (history.bucketTimeoutTime > 0L) {
                    xml2.attribute(null, ATTR_BUCKET_TIMEOUT_TIME, Long.toString(history.bucketTimeoutTime));
                }
                if (history.lastJobRunTime != Long.MIN_VALUE) {
                    xml2.attribute(null, ATTR_LAST_RUN_JOB_TIME, Long.toString(history.lastJobRunTime));
                }
                xml2.endTag(null, TAG_PACKAGE);
            }
            xml2.endTag(null, TAG_PACKAGES);
            xml2.endDocument();
            appIdleFile.finishWrite(fos);
        }
        catch (Exception e) {
            appIdleFile.failWrite(fos);
            Slog.e(TAG, "Error writing app idle file for user " + userId);
        }
    }

    public void dump(IndentingPrintWriter idpw, int userId, String pkg) {
        idpw.println("Package idle stats:");
        idpw.increaseIndent();
        ArrayMap<String, AppUsageHistory> userHistory = this.mIdleHistory.get(userId);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long totalElapsedTime = this.getElapsedTime(elapsedRealtime);
        long screenOnTime = this.getScreenOnTime(elapsedRealtime);
        if (userHistory == null) {
            return;
        }
        int P = userHistory.size();
        for (int p = 0; p < P; ++p) {
            String packageName = userHistory.keyAt(p);
            AppUsageHistory appUsageHistory = userHistory.valueAt(p);
            if (pkg != null && !pkg.equals(packageName)) continue;
            idpw.print("package=" + packageName);
            idpw.print(" lastUsedElapsed=");
            TimeUtils.formatDuration(totalElapsedTime - appUsageHistory.lastUsedElapsedTime, idpw);
            idpw.print(" lastUsedScreenOn=");
            TimeUtils.formatDuration(screenOnTime - appUsageHistory.lastUsedScreenTime, idpw);
            idpw.print(" lastPredictedTime=");
            TimeUtils.formatDuration(totalElapsedTime - appUsageHistory.lastPredictedTime, idpw);
            idpw.print(" bucketTimeoutTime=");
            TimeUtils.formatDuration(totalElapsedTime - appUsageHistory.bucketTimeoutTime, idpw);
            idpw.print(" lastJobRunTime=");
            TimeUtils.formatDuration(totalElapsedTime - appUsageHistory.lastJobRunTime, idpw);
            idpw.print(" idle=" + (this.isIdle(packageName, userId, elapsedRealtime) ? "y" : "n"));
            idpw.print(" bucket=" + appUsageHistory.currentBucket + " reason=" + appUsageHistory.bucketingReason);
            idpw.println();
        }
        idpw.println();
        idpw.print("totalElapsedTime=");
        TimeUtils.formatDuration(this.getElapsedTime(elapsedRealtime), idpw);
        idpw.println();
        idpw.print("totalScreenOnTime=");
        TimeUtils.formatDuration(this.getScreenOnTime(elapsedRealtime), idpw);
        idpw.println();
        idpw.decreaseIndent();
    }

    static class AppUsageHistory {
        long lastUsedElapsedTime;
        long lastUsedScreenTime;
        long lastPredictedTime;
        int currentBucket;
        String bucketingReason;
        int lastInformedBucket;
        long lastJobRunTime;
        long bucketTimeoutTime;

        AppUsageHistory() {
        }
    }
}

