/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStatsManagerInternal;
import android.appwidget.AppWidgetManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ParceledListSlice;
import android.database.ContentObserver;
import android.hardware.display.DisplayManager;
import android.net.NetworkScoreManager;
import android.os.BatteryManager;
import android.os.Environment;
import android.os.Handler;
import android.os.IDeviceIdleController;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.ArraySet;
import android.util.KeyValueListParser;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TimeUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.ConcurrentUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.LocalServices;
import com.android.server.usage.AppIdleHistory;
import java.io.File;
import java.io.PrintWriter;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

public class AppStandbyController {
    private static final String TAG = "AppStandbyController";
    static final boolean DEBUG = false;
    static final boolean COMPRESS_TIME = false;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    static final long[] SCREEN_TIME_THRESHOLDS = new long[]{0L, 0L, 3600000L, 0x6DDD00L};
    static final long[] ELAPSED_TIME_THRESHOLDS = new long[]{0L, 43200000L, 86400000L, 172800000L};
    static final int[] THRESHOLD_BUCKETS = new int[]{10, 20, 30, 40};
    private static final long PREDICTION_TIMEOUT = 43200000L;
    private static final long WAIT_FOR_ADMIN_DATA_TIMEOUT_MS = 10000L;
    private final Object mAppIdleLock = new Lock();
    @GuardedBy(value="mAppIdleLock")
    private AppIdleHistory mAppIdleHistory;
    @GuardedBy(value="mPackageAccessListeners")
    private ArrayList<UsageStatsManagerInternal.AppIdleStateChangeListener> mPackageAccessListeners = new ArrayList();
    @GuardedBy(value="mAppIdleLock")
    private boolean mHaveCarrierPrivilegedApps;
    @GuardedBy(value="mAppIdleLock")
    private List<String> mCarrierPrivilegedApps;
    @GuardedBy(value="mActiveAdminApps")
    private final SparseArray<Set<String>> mActiveAdminApps = new SparseArray();
    private final CountDownLatch mAdminDataAvailableLatch = new CountDownLatch(1);
    static final int MSG_INFORM_LISTENERS = 3;
    static final int MSG_FORCE_IDLE_STATE = 4;
    static final int MSG_CHECK_IDLE_STATES = 5;
    static final int MSG_CHECK_PAROLE_TIMEOUT = 6;
    static final int MSG_PAROLE_END_TIMEOUT = 7;
    static final int MSG_REPORT_CONTENT_PROVIDER_USAGE = 8;
    static final int MSG_PAROLE_STATE_CHANGED = 9;
    static final int MSG_ONE_TIME_CHECK_IDLE_STATES = 10;
    long mCheckIdleIntervalMillis;
    long mAppIdleParoleIntervalMillis;
    long mAppIdleParoleDurationMillis;
    long[] mAppStandbyScreenThresholds = SCREEN_TIME_THRESHOLDS;
    long[] mAppStandbyElapsedThresholds = ELAPSED_TIME_THRESHOLDS;
    volatile boolean mAppIdleEnabled;
    boolean mAppIdleTempParoled;
    boolean mCharging;
    private long mLastAppIdleParoledTime;
    private boolean mSystemServicesReady = false;
    private boolean mPendingInitializeDefaults;
    private final DeviceStateReceiver mDeviceStateReceiver;
    private volatile boolean mPendingOneTimeCheckIdleStates;
    private final AppStandbyHandler mHandler;
    private final Context mContext;
    private AppWidgetManager mAppWidgetManager;
    private PowerManager mPowerManager;
    private PackageManager mPackageManager;
    Injector mInjector;
    static final ArrayList<StandbyUpdateRecord> sStandbyUpdatePool = new ArrayList(4);
    private final DisplayManager.DisplayListener mDisplayListener = new DisplayManager.DisplayListener(){

        @Override
        public void onDisplayAdded(int displayId) {
        }

        @Override
        public void onDisplayRemoved(int displayId) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisplayChanged(int displayId) {
            if (displayId == 0) {
                boolean displayOn = AppStandbyController.this.isDisplayOn();
                Object object = AppStandbyController.this.mAppIdleLock;
                synchronized (object) {
                    AppStandbyController.this.mAppIdleHistory.updateDisplay(displayOn, AppStandbyController.this.mInjector.elapsedRealtime());
                }
            }
        }
    };

    AppStandbyController(Context context, Looper looper) {
        this(new Injector(context, looper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AppStandbyController(Injector injector) {
        this.mInjector = injector;
        this.mContext = this.mInjector.getContext();
        this.mHandler = new AppStandbyHandler(this.mInjector.getLooper());
        this.mPackageManager = this.mContext.getPackageManager();
        this.mDeviceStateReceiver = new DeviceStateReceiver();
        IntentFilter deviceStates = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        deviceStates.addAction("android.os.action.DISCHARGING");
        deviceStates.addAction("android.os.action.DEVICE_IDLE_MODE_CHANGED");
        this.mContext.registerReceiver(this.mDeviceStateReceiver, deviceStates);
        Object object = this.mAppIdleLock;
        synchronized (object) {
            this.mAppIdleHistory = new AppIdleHistory(this.mInjector.getDataSystemDirectory(), this.mInjector.elapsedRealtime());
        }
        IntentFilter packageFilter = new IntentFilter();
        packageFilter.addAction("android.intent.action.PACKAGE_ADDED");
        packageFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        packageFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        packageFilter.addDataScheme("package");
        this.mContext.registerReceiverAsUser(new PackageReceiver(), UserHandle.ALL, packageFilter, null, this.mHandler);
    }

    void setAppIdleEnabled(boolean enabled) {
        this.mAppIdleEnabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBootPhase(int phase) {
        this.mInjector.onBootPhase(phase);
        if (phase == 500) {
            Slog.d(TAG, "Setting app idle enabled state");
            this.setAppIdleEnabled(this.mInjector.isAppIdleEnabled());
            SettingsObserver settingsObserver = new SettingsObserver(this.mHandler);
            settingsObserver.registerObserver();
            settingsObserver.updateSettings();
            this.mAppWidgetManager = this.mContext.getSystemService(AppWidgetManager.class);
            this.mPowerManager = this.mContext.getSystemService(PowerManager.class);
            this.mInjector.registerDisplayListener(this.mDisplayListener, this.mHandler);
            Object object = this.mAppIdleLock;
            synchronized (object) {
                this.mAppIdleHistory.updateDisplay(this.isDisplayOn(), this.mInjector.elapsedRealtime());
            }
            this.mSystemServicesReady = true;
            if (this.mPendingInitializeDefaults) {
                this.initializeDefaultsForSystemApps(0);
            }
            if (this.mPendingOneTimeCheckIdleStates) {
                this.postOneTimeCheckIdleStates();
            }
        } else if (phase == 1000) {
            this.setChargingState(this.mInjector.isCharging());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportContentProviderUsage(String authority, String providerPkgName, int userId) {
        if (!this.mAppIdleEnabled) {
            return;
        }
        String[] packages = ContentResolver.getSyncAdapterPackagesForAuthorityAsUser(authority, userId);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        for (String packageName : packages) {
            try {
                PackageInfo pi = this.mPackageManager.getPackageInfoAsUser(packageName, 0x100000, userId);
                if (pi == null || pi.applicationInfo == null || packageName.equals(providerPkgName)) continue;
                Object object = this.mAppIdleLock;
                synchronized (object) {
                    AppIdleHistory.AppUsageHistory appUsage = this.mAppIdleHistory.reportUsage(packageName, userId, 10, elapsedRealtime, elapsedRealtime + 0x6DDD00L);
                    this.maybeInformListeners(packageName, userId, elapsedRealtime, appUsage.currentBucket, false);
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setChargingState(boolean charging) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            if (this.mCharging != charging) {
                this.mCharging = charging;
                this.postParoleStateChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAppIdleParoled(boolean paroled) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            long now = this.mInjector.currentTimeMillis();
            if (this.mAppIdleTempParoled != paroled) {
                this.mAppIdleTempParoled = paroled;
                if (paroled) {
                    this.postParoleEndTimeout();
                } else {
                    this.mLastAppIdleParoledTime = now;
                    this.postNextParoleTimeout(now);
                }
                this.postParoleStateChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isParoledOrCharging() {
        if (!this.mAppIdleEnabled) {
            return true;
        }
        Object object = this.mAppIdleLock;
        synchronized (object) {
            return this.mAppIdleTempParoled || this.mCharging;
        }
    }

    private void postNextParoleTimeout(long now) {
        this.mHandler.removeMessages(6);
        long timeLeft = this.mLastAppIdleParoledTime + this.mAppIdleParoleIntervalMillis - now;
        if (timeLeft < 0L) {
            timeLeft = 0L;
        }
        this.mHandler.sendEmptyMessageDelayed(6, timeLeft);
    }

    private void postParoleEndTimeout() {
        this.mHandler.removeMessages(7);
        this.mHandler.sendEmptyMessageDelayed(7, this.mAppIdleParoleDurationMillis);
    }

    private void postParoleStateChanged() {
        this.mHandler.removeMessages(9);
        this.mHandler.sendEmptyMessage(9);
    }

    void postCheckIdleStates(int userId) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, userId, 0));
    }

    void postOneTimeCheckIdleStates() {
        if (this.mInjector.getBootPhase() < 500) {
            this.mPendingOneTimeCheckIdleStates = true;
        } else {
            this.mHandler.sendEmptyMessage(10);
            this.mPendingOneTimeCheckIdleStates = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkIdleStates(int checkUserId) {
        int[] runningUserIds;
        if (!this.mAppIdleEnabled) {
            return false;
        }
        try {
            runningUserIds = this.mInjector.getRunningUserIds();
            if (checkUserId != -1 && !ArrayUtils.contains(runningUserIds, checkUserId)) {
                return false;
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        long elapsedRealtime = this.mInjector.elapsedRealtime();
        for (int i = 0; i < runningUserIds.length; ++i) {
            int userId = runningUserIds[i];
            if (checkUserId != -1 && checkUserId != userId) continue;
            List<PackageInfo> packages = this.mPackageManager.getInstalledPackagesAsUser(512, userId);
            int packageCount = packages.size();
            for (int p = 0; p < packageCount; ++p) {
                Object object;
                PackageInfo pi = packages.get(p);
                String packageName = pi.packageName;
                boolean isSpecial = this.isAppSpecial(packageName, UserHandle.getAppId(pi.applicationInfo.uid), userId);
                if (isSpecial) {
                    object = this.mAppIdleLock;
                    synchronized (object) {
                        this.mAppIdleHistory.setAppStandbyBucket(packageName, userId, elapsedRealtime, 5, "default");
                    }
                    this.maybeInformListeners(packageName, userId, elapsedRealtime, 5, false);
                    continue;
                }
                object = this.mAppIdleLock;
                synchronized (object) {
                    int newBucket;
                    int oldBucket;
                    AppIdleHistory.AppUsageHistory app = this.mAppIdleHistory.getAppUsageHistory(packageName, userId, elapsedRealtime);
                    if ("forced".equals(app.bucketingReason) || !this.hasBucketTimeoutPassed(app, elapsedRealtime)) {
                        continue;
                    }
                    boolean predictionLate = false;
                    if (("default".equals(app.bucketingReason) || "usage".equals(app.bucketingReason) || "timeout".equals(app.bucketingReason) || (predictionLate = this.predictionTimedOut(app, elapsedRealtime))) && ((oldBucket = app.currentBucket) < (newBucket = this.getBucketForLocked(packageName, userId, elapsedRealtime)) || predictionLate)) {
                        this.mAppIdleHistory.setAppStandbyBucket(packageName, userId, elapsedRealtime, newBucket, "timeout");
                        this.maybeInformListeners(packageName, userId, elapsedRealtime, newBucket, false);
                    }
                    continue;
                }
            }
        }
        return true;
    }

    private boolean predictionTimedOut(AppIdleHistory.AppUsageHistory app, long elapsedRealtime) {
        return app.bucketingReason != null && app.bucketingReason.startsWith("predicted") && app.lastPredictedTime > 0L && this.mAppIdleHistory.getElapsedTime(elapsedRealtime) - app.lastPredictedTime > 43200000L;
    }

    private boolean hasBucketTimeoutPassed(AppIdleHistory.AppUsageHistory app, long elapsedRealtime) {
        return app.bucketTimeoutTime < this.mAppIdleHistory.getElapsedTime(elapsedRealtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeInformListeners(String packageName, int userId, long elapsedRealtime, int bucket, boolean userStartedInteracting) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            if (this.mAppIdleHistory.shouldInformListeners(packageName, userId, elapsedRealtime, bucket)) {
                StandbyUpdateRecord r = StandbyUpdateRecord.obtain(packageName, userId, bucket, userStartedInteracting);
                this.mHandler.sendMessage(this.mHandler.obtainMessage(3, StandbyUpdateRecord.obtain(packageName, userId, bucket, userStartedInteracting)));
            }
        }
    }

    int getBucketForLocked(String packageName, int userId, long elapsedRealtime) {
        int bucketIndex = this.mAppIdleHistory.getThresholdIndex(packageName, userId, elapsedRealtime, this.mAppStandbyScreenThresholds, this.mAppStandbyElapsedThresholds);
        return THRESHOLD_BUCKETS[bucketIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkParoleTimeout() {
        boolean setParoled = false;
        Object object = this.mAppIdleLock;
        synchronized (object) {
            long now = this.mInjector.currentTimeMillis();
            if (!this.mAppIdleTempParoled) {
                long timeSinceLastParole = now - this.mLastAppIdleParoledTime;
                if (timeSinceLastParole > this.mAppIdleParoleIntervalMillis) {
                    setParoled = true;
                } else {
                    this.postNextParoleTimeout(now);
                }
            }
        }
        if (setParoled) {
            this.setAppIdleParoled(true);
        }
    }

    private void notifyBatteryStats(String packageName, int userId, boolean idle) {
        try {
            int uid = this.mPackageManager.getPackageUidAsUser(packageName, 8192, userId);
            if (idle) {
                this.mInjector.noteEvent(15, packageName, uid);
            } else {
                this.mInjector.noteEvent(16, packageName, uid);
            }
        }
        catch (PackageManager.NameNotFoundException | RemoteException androidException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDeviceIdleModeChanged() {
        boolean deviceIdle = this.mPowerManager.isDeviceIdleMode();
        boolean paroled = false;
        Object object = this.mAppIdleLock;
        synchronized (object) {
            long timeSinceLastParole = this.mInjector.currentTimeMillis() - this.mLastAppIdleParoledTime;
            if (!deviceIdle && timeSinceLastParole >= this.mAppIdleParoleIntervalMillis) {
                paroled = true;
            } else if (deviceIdle) {
                paroled = false;
            } else {
                return;
            }
        }
        this.setAppIdleParoled(paroled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportEvent(UsageEvents.Event event, long elapsedRealtime, int userId) {
        if (!this.mAppIdleEnabled) {
            return;
        }
        Object object = this.mAppIdleLock;
        synchronized (object) {
            boolean previouslyIdle = this.mAppIdleHistory.isIdle(event.mPackage, userId, elapsedRealtime);
            if (event.mEventType == 1 || event.mEventType == 2 || event.mEventType == 6 || event.mEventType == 7 || event.mEventType == 10) {
                AppIdleHistory.AppUsageHistory appHistory = this.mAppIdleHistory.getAppUsageHistory(event.mPackage, userId, elapsedRealtime);
                int prevBucket = appHistory.currentBucket;
                String prevBucketReason = appHistory.bucketingReason;
                if (event.mEventType == 10) {
                    this.mAppIdleHistory.reportUsage(appHistory, event.mPackage, 20, elapsedRealtime, elapsedRealtime + 0x6DDD00L);
                } else {
                    this.mAppIdleHistory.reportUsage(event.mPackage, userId, 10, elapsedRealtime, elapsedRealtime + 0x6DDD00L);
                }
                boolean userStartedInteracting = appHistory.currentBucket == 10 && prevBucket != appHistory.currentBucket && prevBucketReason != "usage";
                this.maybeInformListeners(event.mPackage, userId, elapsedRealtime, appHistory.currentBucket, userStartedInteracting);
                if (previouslyIdle) {
                    this.notifyBatteryStats(event.mPackage, userId, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceIdleState(String packageName, int userId, boolean idle) {
        int standbyBucket;
        if (!this.mAppIdleEnabled) {
            return;
        }
        int appId = this.getAppId(packageName);
        if (appId < 0) {
            return;
        }
        long elapsedRealtime = this.mInjector.elapsedRealtime();
        boolean previouslyIdle = this.isAppIdleFiltered(packageName, appId, userId, elapsedRealtime);
        Object object = this.mAppIdleLock;
        synchronized (object) {
            standbyBucket = this.mAppIdleHistory.setIdle(packageName, userId, idle, elapsedRealtime);
        }
        boolean stillIdle = this.isAppIdleFiltered(packageName, appId, userId, elapsedRealtime);
        if (previouslyIdle != stillIdle) {
            this.maybeInformListeners(packageName, userId, elapsedRealtime, standbyBucket, false);
            if (!stillIdle) {
                this.notifyBatteryStats(packageName, userId, idle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastJobRunTime(String packageName, int userId, long elapsedRealtime) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            this.mAppIdleHistory.setLastJobRunTime(packageName, userId, elapsedRealtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeSinceLastJobRun(String packageName, int userId) {
        long elapsedRealtime = this.mInjector.elapsedRealtime();
        Object object = this.mAppIdleLock;
        synchronized (object) {
            return this.mAppIdleHistory.getTimeSinceLastJobRun(packageName, userId, elapsedRealtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUserRemoved(int userId) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            this.mAppIdleHistory.onUserRemoved(userId);
            SparseArray<Set<String>> sparseArray = this.mActiveAdminApps;
            synchronized (sparseArray) {
                this.mActiveAdminApps.remove(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAppIdleUnfiltered(String packageName, int userId, long elapsedRealtime) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            return this.mAppIdleHistory.isIdle(packageName, userId, elapsedRealtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(UsageStatsManagerInternal.AppIdleStateChangeListener listener) {
        ArrayList<UsageStatsManagerInternal.AppIdleStateChangeListener> arrayList = this.mPackageAccessListeners;
        synchronized (arrayList) {
            if (!this.mPackageAccessListeners.contains(listener)) {
                this.mPackageAccessListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(UsageStatsManagerInternal.AppIdleStateChangeListener listener) {
        ArrayList<UsageStatsManagerInternal.AppIdleStateChangeListener> arrayList = this.mPackageAccessListeners;
        synchronized (arrayList) {
            this.mPackageAccessListeners.remove(listener);
        }
    }

    int getAppId(String packageName) {
        try {
            ApplicationInfo ai = this.mPackageManager.getApplicationInfo(packageName, 0x400200);
            return ai.uid;
        }
        catch (PackageManager.NameNotFoundException re) {
            return -1;
        }
    }

    boolean isAppIdleFilteredOrParoled(String packageName, int userId, long elapsedRealtime, boolean shouldObfuscateInstantApps) {
        if (this.isParoledOrCharging()) {
            return false;
        }
        if (shouldObfuscateInstantApps && this.mInjector.isPackageEphemeral(userId, packageName)) {
            return false;
        }
        return this.isAppIdleFiltered(packageName, this.getAppId(packageName), userId, elapsedRealtime);
    }

    boolean isAppSpecial(String packageName, int appId, int userId) {
        if (packageName == null) {
            return false;
        }
        if (!this.mAppIdleEnabled) {
            return true;
        }
        if (appId < 10000) {
            return true;
        }
        if (packageName.equals("android")) {
            return true;
        }
        if (this.mSystemServicesReady) {
            try {
                if (this.mInjector.isPowerSaveWhitelistExceptIdleApp(packageName)) {
                    return true;
                }
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
            if (this.isActiveDeviceAdmin(packageName, userId)) {
                return true;
            }
            if (this.isActiveNetworkScorer(packageName)) {
                return true;
            }
            if (this.mAppWidgetManager != null && this.mInjector.isBoundWidgetPackage(this.mAppWidgetManager, packageName, userId)) {
                return true;
            }
            if (this.isDeviceProvisioningPackage(packageName)) {
                return true;
            }
        }
        return this.isCarrierApp(packageName);
    }

    boolean isAppIdleFiltered(String packageName, int appId, int userId, long elapsedRealtime) {
        if (this.isAppSpecial(packageName, appId, userId)) {
            return false;
        }
        return this.isAppIdleUnfiltered(packageName, userId, elapsedRealtime);
    }

    int[] getIdleUidsForUser(int userId) {
        List apps;
        if (!this.mAppIdleEnabled) {
            return new int[0];
        }
        long elapsedRealtime = this.mInjector.elapsedRealtime();
        try {
            ParceledListSlice slice = AppGlobals.getPackageManager().getInstalledApplications(0, userId);
            if (slice == null) {
                return new int[0];
            }
            apps = slice.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        SparseIntArray uidStates = new SparseIntArray();
        for (int i = apps.size() - 1; i >= 0; --i) {
            ApplicationInfo ai = (ApplicationInfo)apps.get(i);
            boolean idle = this.isAppIdleFiltered(ai.packageName, UserHandle.getAppId(ai.uid), userId, elapsedRealtime);
            int index = uidStates.indexOfKey(ai.uid);
            if (index < 0) {
                uidStates.put(ai.uid, 1 + (idle ? 65536 : 0));
                continue;
            }
            int value = uidStates.valueAt(index);
            uidStates.setValueAt(index, value + 1 + (idle ? 65536 : 0));
        }
        int numIdle = 0;
        for (int i = uidStates.size() - 1; i >= 0; --i) {
            int value = uidStates.valueAt(i);
            if ((value & Short.MAX_VALUE) != value >> 16) continue;
            ++numIdle;
        }
        int[] res = new int[numIdle];
        numIdle = 0;
        for (int i = uidStates.size() - 1; i >= 0; --i) {
            int value = uidStates.valueAt(i);
            if ((value & Short.MAX_VALUE) != value >> 16) continue;
            res[numIdle] = uidStates.keyAt(i);
            ++numIdle;
        }
        return res;
    }

    void setAppIdleAsync(String packageName, boolean idle, int userId) {
        if (packageName == null || !this.mAppIdleEnabled) {
            return;
        }
        this.mHandler.obtainMessage(4, userId, idle ? 1 : 0, packageName).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAppStandbyBucket(String packageName, int userId, long elapsedRealtime, boolean shouldObfuscateInstantApps) {
        if (!this.mAppIdleEnabled || shouldObfuscateInstantApps && this.mInjector.isPackageEphemeral(userId, packageName)) {
            return 10;
        }
        Object object = this.mAppIdleLock;
        synchronized (object) {
            return this.mAppIdleHistory.getAppStandbyBucket(packageName, userId, elapsedRealtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> getAppStandbyBuckets(int userId, long elapsedRealtime) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            return this.mAppIdleHistory.getAppStandbyBuckets(userId, elapsedRealtime, this.mAppIdleEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAppStandbyBucket(String packageName, int userId, int newBucket, String reason, long elapsedRealtime) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            boolean predicted;
            AppIdleHistory.AppUsageHistory app = this.mAppIdleHistory.getAppUsageHistory(packageName, userId, elapsedRealtime);
            boolean bl = predicted = reason != null && reason.startsWith("predicted");
            if (app.currentBucket < 10) {
                return;
            }
            if ((app.currentBucket == 50 || newBucket == 50) && predicted) {
                return;
            }
            if (app.bucketingReason.equals("forced") && predicted) {
                return;
            }
            if (predicted && app.currentBucket < newBucket && !this.hasBucketTimeoutPassed(app, elapsedRealtime)) {
                return;
            }
            this.mAppIdleHistory.setAppStandbyBucket(packageName, userId, elapsedRealtime, newBucket, reason);
        }
        this.maybeInformListeners(packageName, userId, elapsedRealtime, newBucket, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean isActiveDeviceAdmin(String packageName, int userId) {
        SparseArray<Set<String>> sparseArray = this.mActiveAdminApps;
        synchronized (sparseArray) {
            Set<String> adminPkgs = this.mActiveAdminApps.get(userId);
            return adminPkgs != null && adminPkgs.contains(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveDeviceAdmin(String adminPkg, int userId) {
        SparseArray<Set<String>> sparseArray = this.mActiveAdminApps;
        synchronized (sparseArray) {
            Set<String> adminPkgs = this.mActiveAdminApps.get(userId);
            if (adminPkgs == null) {
                adminPkgs = new ArraySet<String>();
                this.mActiveAdminApps.put(userId, adminPkgs);
            }
            adminPkgs.add(adminPkg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveAdminApps(Set<String> adminPkgs, int userId) {
        SparseArray<Set<String>> sparseArray = this.mActiveAdminApps;
        synchronized (sparseArray) {
            if (adminPkgs == null) {
                this.mActiveAdminApps.remove(userId);
            } else {
                this.mActiveAdminApps.put(userId, adminPkgs);
            }
        }
    }

    public void onAdminDataAvailable() {
        this.mAdminDataAvailableLatch.countDown();
    }

    private void waitForAdminData() {
        if (this.mContext.getPackageManager().hasSystemFeature("android.software.device_admin")) {
            ConcurrentUtils.waitForCountDownNoInterrupt(this.mAdminDataAvailableLatch, 10000L, "Wait for admin data");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getActiveAdminAppsForTest(int userId) {
        SparseArray<Set<String>> sparseArray = this.mActiveAdminApps;
        synchronized (sparseArray) {
            return this.mActiveAdminApps.get(userId);
        }
    }

    private boolean isDeviceProvisioningPackage(String packageName) {
        String deviceProvisioningPackage = this.mContext.getResources().getString(17039656);
        return deviceProvisioningPackage != null && deviceProvisioningPackage.equals(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCarrierApp(String packageName) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            if (!this.mHaveCarrierPrivilegedApps) {
                this.fetchCarrierPrivilegedAppsLocked();
            }
            if (this.mCarrierPrivilegedApps != null) {
                return this.mCarrierPrivilegedApps.contains(packageName);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCarrierPrivilegedApps() {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            this.mHaveCarrierPrivilegedApps = false;
            this.mCarrierPrivilegedApps = null;
        }
    }

    @GuardedBy(value="mAppIdleLock")
    private void fetchCarrierPrivilegedAppsLocked() {
        TelephonyManager telephonyManager = this.mContext.getSystemService(TelephonyManager.class);
        this.mCarrierPrivilegedApps = telephonyManager.getPackagesWithCarrierPrivileges();
        this.mHaveCarrierPrivilegedApps = true;
    }

    private boolean isActiveNetworkScorer(String packageName) {
        String activeScorer = this.mInjector.getActiveNetworkScorer();
        return packageName != null && packageName.equals(activeScorer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void informListeners(String packageName, int userId, int bucket, boolean userInteraction) {
        boolean idle = bucket >= 40;
        ArrayList<UsageStatsManagerInternal.AppIdleStateChangeListener> arrayList = this.mPackageAccessListeners;
        synchronized (arrayList) {
            for (UsageStatsManagerInternal.AppIdleStateChangeListener listener : this.mPackageAccessListeners) {
                listener.onAppIdleStateChanged(packageName, userId, idle, bucket);
                if (!userInteraction) continue;
                listener.onUserInteractionStarted(packageName, userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void informParoleStateChanged() {
        boolean paroled = this.isParoledOrCharging();
        ArrayList<UsageStatsManagerInternal.AppIdleStateChangeListener> arrayList = this.mPackageAccessListeners;
        synchronized (arrayList) {
            for (UsageStatsManagerInternal.AppIdleStateChangeListener listener : this.mPackageAccessListeners) {
                listener.onParoleStateChanged(paroled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushToDisk(int userId) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            this.mAppIdleHistory.writeAppIdleTimes(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushDurationsToDisk() {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            this.mAppIdleHistory.writeAppIdleDurations();
        }
    }

    boolean isDisplayOn() {
        return this.mInjector.isDefaultDisplayOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAppIdleForPackage(String packageName, int userId) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            this.mAppIdleHistory.clearUsage(packageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeDefaultsForSystemApps(int userId) {
        if (!this.mSystemServicesReady) {
            this.mPendingInitializeDefaults = true;
            return;
        }
        Slog.d(TAG, "Initializing defaults for system apps on user " + userId + ", appIdleEnabled=" + this.mAppIdleEnabled);
        long elapsedRealtime = this.mInjector.elapsedRealtime();
        List<PackageInfo> packages = this.mPackageManager.getInstalledPackagesAsUser(512, userId);
        int packageCount = packages.size();
        Object object = this.mAppIdleLock;
        synchronized (object) {
            for (int i = 0; i < packageCount; ++i) {
                PackageInfo pi = packages.get(i);
                String packageName = pi.packageName;
                if (pi.applicationInfo == null || !pi.applicationInfo.isSystemApp()) continue;
                this.mAppIdleHistory.reportUsage(packageName, userId, 10, 0L, elapsedRealtime + 14400000L);
            }
        }
    }

    void postReportContentProviderUsage(String name, String packageName, int userId) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = name;
        args.arg2 = packageName;
        args.arg3 = userId;
        this.mHandler.obtainMessage(8, args).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpUser(IndentingPrintWriter idpw, int userId, String pkg) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            this.mAppIdleHistory.dump(idpw, userId, pkg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpState(String[] args, PrintWriter pw) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            pw.println("Carrier privileged apps (have=" + this.mHaveCarrierPrivilegedApps + "): " + this.mCarrierPrivilegedApps);
        }
        pw.println();
        pw.println("Settings:");
        pw.print("  mCheckIdleIntervalMillis=");
        TimeUtils.formatDuration(this.mCheckIdleIntervalMillis, pw);
        pw.println();
        pw.print("  mAppIdleParoleIntervalMillis=");
        TimeUtils.formatDuration(this.mAppIdleParoleIntervalMillis, pw);
        pw.println();
        pw.print("  mAppIdleParoleDurationMillis=");
        TimeUtils.formatDuration(this.mAppIdleParoleDurationMillis, pw);
        pw.println();
        pw.println();
        pw.print("mAppIdleEnabled=");
        pw.print(this.mAppIdleEnabled);
        pw.print(" mAppIdleTempParoled=");
        pw.print(this.mAppIdleTempParoled);
        pw.print(" mCharging=");
        pw.print(this.mCharging);
        pw.print(" mLastAppIdleParoledTime=");
        TimeUtils.formatDuration(this.mLastAppIdleParoledTime, pw);
        pw.println();
        pw.print("mScreenThresholds=");
        pw.println(Arrays.toString(this.mAppStandbyScreenThresholds));
        pw.print("mElapsedThresholds=");
        pw.println(Arrays.toString(this.mAppStandbyElapsedThresholds));
    }

    private class SettingsObserver
    extends ContentObserver {
        @Deprecated
        private static final String KEY_IDLE_DURATION_OLD = "idle_duration";
        private static final String KEY_IDLE_DURATION = "idle_duration2";
        private static final String KEY_WALLCLOCK_THRESHOLD = "wallclock_threshold";
        private static final String KEY_PAROLE_INTERVAL = "parole_interval";
        private static final String KEY_PAROLE_DURATION = "parole_duration";
        private static final String KEY_SCREEN_TIME_THRESHOLDS = "screen_thresholds";
        private static final String KEY_ELAPSED_TIME_THRESHOLDS = "elapsed_thresholds";
        private final KeyValueListParser mParser;

        SettingsObserver(Handler handler) {
            super(handler);
            this.mParser = new KeyValueListParser(',');
        }

        void registerObserver() {
            AppStandbyController.this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("app_idle_constants"), false, this);
            AppStandbyController.this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("app_standby_enabled"), false, this);
        }

        @Override
        public void onChange(boolean selfChange) {
            this.updateSettings();
            AppStandbyController.this.postOneTimeCheckIdleStates();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateSettings() {
            AppStandbyController.this.setAppIdleEnabled(AppStandbyController.this.mInjector.isAppIdleEnabled());
            try {
                this.mParser.setString(AppStandbyController.this.mInjector.getAppIdleSettings());
            }
            catch (IllegalArgumentException e) {
                Slog.e(AppStandbyController.TAG, "Bad value for app idle settings: " + e.getMessage());
            }
            Object object = AppStandbyController.this.mAppIdleLock;
            synchronized (object) {
                AppStandbyController.this.mAppIdleParoleIntervalMillis = this.mParser.getDurationMillis(KEY_PAROLE_INTERVAL, 86400000L);
                AppStandbyController.this.mAppIdleParoleDurationMillis = this.mParser.getDurationMillis(KEY_PAROLE_DURATION, 600000L);
                String screenThresholdsValue = this.mParser.getString(KEY_SCREEN_TIME_THRESHOLDS, null);
                AppStandbyController.this.mAppStandbyScreenThresholds = this.parseLongArray(screenThresholdsValue, SCREEN_TIME_THRESHOLDS);
                String elapsedThresholdsValue = this.mParser.getString(KEY_ELAPSED_TIME_THRESHOLDS, null);
                AppStandbyController.this.mAppStandbyElapsedThresholds = this.parseLongArray(elapsedThresholdsValue, ELAPSED_TIME_THRESHOLDS);
                AppStandbyController.this.mCheckIdleIntervalMillis = Math.min(AppStandbyController.this.mAppStandbyElapsedThresholds[1] / 4L, 14400000L);
            }
        }

        long[] parseLongArray(String values, long[] defaults) {
            if (values == null) {
                return defaults;
            }
            if (values.isEmpty()) {
                return defaults;
            }
            String[] thresholds = values.split("/");
            if (thresholds.length == THRESHOLD_BUCKETS.length) {
                long[] array2 = new long[THRESHOLD_BUCKETS.length];
                for (int i = 0; i < THRESHOLD_BUCKETS.length; ++i) {
                    try {
                        if (thresholds[i].startsWith("P") || thresholds[i].startsWith("p")) {
                            array2[i] = Duration.parse(thresholds[i]).toMillis();
                            continue;
                        }
                        array2[i] = Long.parseLong(thresholds[i]);
                        continue;
                    }
                    catch (NumberFormatException | DateTimeParseException e) {
                        return defaults;
                    }
                }
                return array2;
            }
            return defaults;
        }
    }

    private class DeviceStateReceiver
    extends BroadcastReceiver {
        private DeviceStateReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.BATTERY_CHANGED".equals(action)) {
                AppStandbyController.this.setChargingState(intent.getIntExtra("plugged", 0) != 0);
            } else if ("android.os.action.DEVICE_IDLE_MODE_CHANGED".equals(action)) {
                AppStandbyController.this.onDeviceIdleModeChanged();
            }
        }
    }

    class AppStandbyHandler
    extends Handler {
        AppStandbyHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 3: {
                    StandbyUpdateRecord r = (StandbyUpdateRecord)msg.obj;
                    AppStandbyController.this.informListeners(r.packageName, r.userId, r.bucket, r.isUserInteraction);
                    r.recycle();
                    break;
                }
                case 4: {
                    AppStandbyController.this.forceIdleState((String)msg.obj, msg.arg1, msg.arg2 == 1);
                    break;
                }
                case 5: {
                    if (!AppStandbyController.this.checkIdleStates(msg.arg1) || !AppStandbyController.this.mAppIdleEnabled) break;
                    AppStandbyController.this.mHandler.sendMessageDelayed(AppStandbyController.this.mHandler.obtainMessage(5, msg.arg1, 0), AppStandbyController.this.mCheckIdleIntervalMillis);
                    break;
                }
                case 10: {
                    AppStandbyController.this.mHandler.removeMessages(10);
                    AppStandbyController.this.waitForAdminData();
                    AppStandbyController.this.checkIdleStates(-1);
                    break;
                }
                case 6: {
                    AppStandbyController.this.checkParoleTimeout();
                    break;
                }
                case 7: {
                    AppStandbyController.this.setAppIdleParoled(false);
                    break;
                }
                case 8: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    AppStandbyController.this.reportContentProviderUsage((String)args.arg1, (String)args.arg2, (Integer)args.arg3);
                    args.recycle();
                    break;
                }
                case 9: {
                    AppStandbyController.this.informParoleStateChanged();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }

    static class Injector {
        private final Context mContext;
        private final Looper mLooper;
        private IDeviceIdleController mDeviceIdleController;
        private IBatteryStats mBatteryStats;
        private PackageManagerInternal mPackageManagerInternal;
        private DisplayManager mDisplayManager;
        int mBootPhase;

        Injector(Context context, Looper looper) {
            this.mContext = context;
            this.mLooper = looper;
        }

        Context getContext() {
            return this.mContext;
        }

        Looper getLooper() {
            return this.mLooper;
        }

        void onBootPhase(int phase) {
            if (phase == 500) {
                this.mDeviceIdleController = IDeviceIdleController.Stub.asInterface(ServiceManager.getService("deviceidle"));
                this.mBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
                this.mPackageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
                this.mDisplayManager = (DisplayManager)this.mContext.getSystemService("display");
            }
            this.mBootPhase = phase;
        }

        int getBootPhase() {
            return this.mBootPhase;
        }

        long elapsedRealtime() {
            return SystemClock.elapsedRealtime();
        }

        long currentTimeMillis() {
            return System.currentTimeMillis();
        }

        boolean isAppIdleEnabled() {
            boolean buildFlag = this.mContext.getResources().getBoolean(17956947);
            boolean runtimeFlag = Settings.Global.getInt(this.mContext.getContentResolver(), "app_standby_enabled", 1) == 1;
            return buildFlag && runtimeFlag;
        }

        boolean isCharging() {
            return this.mContext.getSystemService(BatteryManager.class).isCharging();
        }

        boolean isPowerSaveWhitelistExceptIdleApp(String packageName) throws RemoteException {
            return this.mDeviceIdleController.isPowerSaveWhitelistExceptIdleApp(packageName);
        }

        File getDataSystemDirectory() {
            return Environment.getDataSystemDirectory();
        }

        void noteEvent(int event, String packageName, int uid) throws RemoteException {
            this.mBatteryStats.noteEvent(event, packageName, uid);
        }

        boolean isPackageEphemeral(int userId, String packageName) {
            return this.mPackageManagerInternal.isPackageEphemeral(userId, packageName);
        }

        int[] getRunningUserIds() throws RemoteException {
            return ActivityManager.getService().getRunningUserIds();
        }

        boolean isDefaultDisplayOn() {
            return this.mDisplayManager.getDisplay(0).getState() == 2;
        }

        void registerDisplayListener(DisplayManager.DisplayListener listener, Handler handler) {
            this.mDisplayManager.registerDisplayListener(listener, handler);
        }

        String getActiveNetworkScorer() {
            NetworkScoreManager nsm = (NetworkScoreManager)this.mContext.getSystemService("network_score");
            return nsm.getActiveScorerPackage();
        }

        public boolean isBoundWidgetPackage(AppWidgetManager appWidgetManager, String packageName, int userId) {
            return appWidgetManager.isBoundWidgetPackage(packageName, userId);
        }

        String getAppIdleSettings() {
            return Settings.Global.getString(this.mContext.getContentResolver(), "app_idle_constants");
        }
    }

    private class PackageReceiver
    extends BroadcastReceiver {
        private PackageReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.PACKAGE_ADDED".equals(action) || "android.intent.action.PACKAGE_CHANGED".equals(action)) {
                AppStandbyController.this.clearCarrierPrivilegedApps();
            }
            if (("android.intent.action.PACKAGE_REMOVED".equals(action) || "android.intent.action.PACKAGE_ADDED".equals(action)) && !intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                AppStandbyController.this.clearAppIdleForPackage(intent.getData().getSchemeSpecificPart(), this.getSendingUserId());
            }
        }
    }

    public static class StandbyUpdateRecord {
        String packageName;
        int userId;
        int bucket;
        boolean isUserInteraction;

        StandbyUpdateRecord(String pkgName, int userId, int bucket, boolean isInteraction) {
            this.packageName = pkgName;
            this.userId = userId;
            this.bucket = bucket;
            this.isUserInteraction = isInteraction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static StandbyUpdateRecord obtain(String pkgName, int userId, int bucket, boolean isInteraction) {
            ArrayList<StandbyUpdateRecord> arrayList = sStandbyUpdatePool;
            synchronized (arrayList) {
                int size = sStandbyUpdatePool.size();
                if (size < 1) {
                    return new StandbyUpdateRecord(pkgName, userId, bucket, isInteraction);
                }
                StandbyUpdateRecord r = sStandbyUpdatePool.remove(size - 1);
                r.packageName = pkgName;
                r.userId = userId;
                r.bucket = bucket;
                r.isUserInteraction = isInteraction;
                return r;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle() {
            ArrayList<StandbyUpdateRecord> arrayList = sStandbyUpdatePool;
            synchronized (arrayList) {
                sStandbyUpdatePool.add(this);
            }
        }
    }

    static class Lock {
        Lock() {
        }
    }
}

