/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import com.android.internal.util.dump.DualDumpOutputStream;

public final class UsbAlsaDevice {
    private static final String TAG = "UsbAlsaDevice";
    protected static final boolean DEBUG = false;
    private final int mCardNum;
    private final int mDeviceNum;
    private final boolean mHasPlayback;
    private final boolean mHasCapture;
    private final boolean mIsInputHeadset;
    private final boolean mIsOutputHeadset;
    private final String mDeviceAddress;
    private String mDeviceName = "";
    private String mDeviceDescription = "";

    public UsbAlsaDevice(int card, int device, String deviceAddress, boolean hasPlayback, boolean hasCapture, boolean isInputHeadset, boolean isOutputHeadset) {
        this.mCardNum = card;
        this.mDeviceNum = device;
        this.mDeviceAddress = deviceAddress;
        this.mHasPlayback = hasPlayback;
        this.mHasCapture = hasCapture;
        this.mIsInputHeadset = isInputHeadset;
        this.mIsOutputHeadset = isOutputHeadset;
    }

    public int getCardNum() {
        return this.mCardNum;
    }

    public int getDeviceNum() {
        return this.mDeviceNum;
    }

    public String getDeviceAddress() {
        return this.mDeviceAddress;
    }

    public boolean hasPlayback() {
        return this.mHasPlayback;
    }

    public boolean hasCapture() {
        return this.mHasCapture;
    }

    public boolean isInputHeadset() {
        return this.mIsInputHeadset;
    }

    public boolean isOutputHeadset() {
        return this.mIsOutputHeadset;
    }

    public String toString() {
        return "UsbAlsaDevice: [card: " + this.mCardNum + ", device: " + this.mDeviceNum + ", name: " + this.mDeviceName + ", hasPlayback: " + this.mHasPlayback + ", hasCapture: " + this.mHasCapture + "]";
    }

    public void dump(DualDumpOutputStream dump, String idName, long id2) {
        long token = dump.start(idName, id2);
        dump.write("card", 0x10500000001L, this.mCardNum);
        dump.write("device", 1120986464258L, this.mDeviceNum);
        dump.write("name", 1138166333443L, this.mDeviceName);
        dump.write("has_playback", 1133871366148L, this.mHasPlayback);
        dump.write("has_capture", 1133871366149L, this.mHasCapture);
        dump.write("address", 1138166333446L, this.mDeviceAddress);
        dump.end(token);
    }

    String toShortString() {
        return "[card:" + this.mCardNum + " device:" + this.mDeviceNum + " " + this.mDeviceName + "]";
    }

    String getDeviceName() {
        return this.mDeviceName;
    }

    void setDeviceNameAndDescription(String deviceName, String deviceDescription) {
        this.mDeviceName = deviceName;
        this.mDeviceDescription = deviceDescription;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UsbAlsaDevice)) {
            return false;
        }
        UsbAlsaDevice other = (UsbAlsaDevice)obj;
        return this.mCardNum == other.mCardNum && this.mDeviceNum == other.mDeviceNum && this.mHasPlayback == other.mHasPlayback && this.mHasCapture == other.mHasCapture && this.mIsInputHeadset == other.mIsInputHeadset && this.mIsOutputHeadset == other.mIsOutputHeadset;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mCardNum;
        result = 31 * result + this.mDeviceNum;
        result = 31 * result + (this.mHasPlayback ? 0 : 1);
        result = 31 * result + (this.mHasCapture ? 0 : 1);
        result = 31 * result + (this.mIsInputHeadset ? 0 : 1);
        result = 31 * result + (this.mIsOutputHeadset ? 0 : 1);
        return result;
    }
}

