/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors;

import com.android.server.usb.descriptors.ByteStream;
import com.android.server.usb.descriptors.UsbACMixerUnit;
import com.android.server.usb.descriptors.report.ReportCanvas;

public final class Usb10ACMixerUnit
extends UsbACMixerUnit {
    private static final String TAG = "Usb10ACMixerUnit";
    private int mChannelConfig;
    private byte mChanNameID;
    private byte[] mControls;
    private byte mNameID;

    public Usb10ACMixerUnit(int length, byte type, byte subtype, int subClass) {
        super(length, type, subtype, subClass);
    }

    public int getChannelConfig() {
        return this.mChannelConfig;
    }

    public byte getChanNameID() {
        return this.mChanNameID;
    }

    public byte[] getControls() {
        return this.mControls;
    }

    public byte getNameID() {
        return this.mNameID;
    }

    @Override
    public int parseRawDescriptors(ByteStream stream) {
        super.parseRawDescriptors(stream);
        this.mChannelConfig = stream.unpackUsbShort();
        this.mChanNameID = stream.getByte();
        int controlArraySize = Usb10ACMixerUnit.calcControlArraySize(this.mNumInputs, this.mNumOutputs);
        this.mControls = new byte[controlArraySize];
        for (int index = 0; index < controlArraySize; ++index) {
            this.mControls[index] = stream.getByte();
        }
        this.mNameID = stream.getByte();
        return this.mLength;
    }

    @Override
    public void report(ReportCanvas canvas) {
        super.report(canvas);
        canvas.writeParagraph("Mixer Unit", false);
        canvas.openList();
        canvas.writeListItem("Unit ID: " + ReportCanvas.getHexString(this.getUnitID()));
        int numInputs = this.getNumInputs();
        byte[] inputIDs = this.getInputIDs();
        canvas.openListItem();
        canvas.write("Num Inputs: " + numInputs + " [");
        for (int input = 0; input < numInputs; ++input) {
            canvas.write("" + ReportCanvas.getHexString(inputIDs[input]));
            if (input >= numInputs - 1) continue;
            canvas.write(" ");
        }
        canvas.write("]");
        canvas.closeListItem();
        canvas.writeListItem("Num Outputs: " + this.getNumOutputs());
        canvas.writeListItem("Channel Config: " + ReportCanvas.getHexString(this.getChannelConfig()));
        byte[] controls = this.getControls();
        canvas.openListItem();
        canvas.write("Controls: " + controls.length + " [");
        for (int ctrl = 0; ctrl < controls.length; ++ctrl) {
            canvas.write("" + controls[ctrl]);
            if (ctrl >= controls.length - 1) continue;
            canvas.write(" ");
        }
        canvas.write("]");
        canvas.closeListItem();
        canvas.closeList();
    }
}

