/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors;

import com.android.server.usb.descriptors.ByteStream;
import com.android.server.usb.descriptors.UsbASFormat;
import com.android.server.usb.descriptors.report.ReportCanvas;

public final class Usb10ASFormatI
extends UsbASFormat {
    private static final String TAG = "Usb10ASFormatI";
    private byte mNumChannels;
    private byte mSubframeSize;
    private byte mBitResolution;
    private byte mSampleFreqType;
    private int[] mSampleRates;

    public Usb10ASFormatI(int length, byte type, byte subtype, byte formatType, int subclass) {
        super(length, type, subtype, formatType, subclass);
    }

    public byte getNumChannels() {
        return this.mNumChannels;
    }

    public byte getSubframeSize() {
        return this.mSubframeSize;
    }

    public byte getBitResolution() {
        return this.mBitResolution;
    }

    public byte getSampleFreqType() {
        return this.mSampleFreqType;
    }

    @Override
    public int[] getSampleRates() {
        return this.mSampleRates;
    }

    @Override
    public int[] getBitDepths() {
        int[] depths = new int[]{this.mBitResolution};
        return depths;
    }

    @Override
    public int[] getChannelCounts() {
        int[] counts = new int[]{this.mNumChannels};
        return counts;
    }

    @Override
    public int parseRawDescriptors(ByteStream stream) {
        this.mNumChannels = stream.getByte();
        this.mSubframeSize = stream.getByte();
        this.mBitResolution = stream.getByte();
        this.mSampleFreqType = stream.getByte();
        if (this.mSampleFreqType == 0) {
            this.mSampleRates = new int[2];
            this.mSampleRates[0] = stream.unpackUsbTriple();
            this.mSampleRates[1] = stream.unpackUsbTriple();
        } else {
            this.mSampleRates = new int[this.mSampleFreqType];
            for (int index = 0; index < this.mSampleFreqType; ++index) {
                this.mSampleRates[index] = stream.unpackUsbTriple();
            }
        }
        return this.mLength;
    }

    @Override
    public void report(ReportCanvas canvas) {
        super.report(canvas);
        canvas.openList();
        canvas.writeListItem("" + this.getNumChannels() + " Channels.");
        canvas.writeListItem("Subframe Size: " + this.getSubframeSize());
        canvas.writeListItem("Bit Resolution: " + this.getBitResolution());
        int sampleFreqType = this.getSampleFreqType();
        int[] sampleRates = this.getSampleRates();
        canvas.writeListItem("Sample Freq Type: " + sampleFreqType);
        canvas.openList();
        if (sampleFreqType == 0) {
            canvas.writeListItem("min: " + sampleRates[0]);
            canvas.writeListItem("max: " + sampleRates[1]);
        } else {
            for (int index = 0; index < sampleFreqType; ++index) {
                canvas.writeListItem("" + sampleRates[index]);
            }
        }
        canvas.closeList();
        canvas.closeList();
    }
}

