/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors;

import android.hardware.usb.UsbConfiguration;
import android.hardware.usb.UsbDevice;
import android.os.Parcelable;
import android.util.Log;
import com.android.server.usb.descriptors.ByteStream;
import com.android.server.usb.descriptors.UsbConfigDescriptor;
import com.android.server.usb.descriptors.UsbDescriptor;
import com.android.server.usb.descriptors.UsbDescriptorParser;
import com.android.server.usb.descriptors.report.ReportCanvas;
import com.android.server.usb.descriptors.report.UsbStrings;
import java.util.ArrayList;

public final class UsbDeviceDescriptor
extends UsbDescriptor {
    private static final String TAG = "UsbDeviceDescriptor";
    private static final boolean DEBUG = false;
    public static final int USBSPEC_1_0 = 256;
    public static final int USBSPEC_1_1 = 272;
    public static final int USBSPEC_2_0 = 512;
    private int mSpec;
    private int mDevClass;
    private int mDevSubClass;
    private int mProtocol;
    private byte mPacketSize;
    private int mVendorID;
    private int mProductID;
    private int mDeviceRelease;
    private byte mMfgIndex;
    private byte mProductIndex;
    private byte mSerialNum;
    private byte mNumConfigs;
    private ArrayList<UsbConfigDescriptor> mConfigDescriptors = new ArrayList();

    UsbDeviceDescriptor(int length, byte type) {
        super(length, type);
        this.mHierarchyLevel = 1;
    }

    public int getSpec() {
        return this.mSpec;
    }

    public int getDevClass() {
        return this.mDevClass;
    }

    public int getDevSubClass() {
        return this.mDevSubClass;
    }

    public int getProtocol() {
        return this.mProtocol;
    }

    public byte getPacketSize() {
        return this.mPacketSize;
    }

    public int getVendorID() {
        return this.mVendorID;
    }

    public int getProductID() {
        return this.mProductID;
    }

    public int getDeviceRelease() {
        return this.mDeviceRelease;
    }

    public byte getMfgIndex() {
        return this.mMfgIndex;
    }

    public byte getProductIndex() {
        return this.mProductIndex;
    }

    public byte getSerialNum() {
        return this.mSerialNum;
    }

    public byte getNumConfigs() {
        return this.mNumConfigs;
    }

    void addConfigDescriptor(UsbConfigDescriptor config) {
        this.mConfigDescriptors.add(config);
    }

    public UsbDevice toAndroid(UsbDescriptorParser parser) {
        String mfgName = parser.getDescriptorString(this.mMfgIndex);
        String prodName = parser.getDescriptorString(this.mProductIndex);
        String versionString = Integer.toString(this.mDeviceRelease >> 8) + "." + (this.mDeviceRelease & 0xFF);
        String serialStr = parser.getDescriptorString(this.mSerialNum);
        UsbDevice device = new UsbDevice(parser.getDeviceAddr(), this.mVendorID, this.mProductID, this.mDevClass, this.mDevSubClass, this.mProtocol, mfgName, prodName, versionString, serialStr);
        Parcelable[] configs = new UsbConfiguration[this.mConfigDescriptors.size()];
        Log.d(TAG, "  " + configs.length + " configs");
        for (int index = 0; index < this.mConfigDescriptors.size(); ++index) {
            configs[index] = this.mConfigDescriptors.get(index).toAndroid(parser);
        }
        device.setConfigurations(configs);
        return device;
    }

    @Override
    public int parseRawDescriptors(ByteStream stream) {
        this.mSpec = stream.unpackUsbShort();
        this.mDevClass = stream.getUnsignedByte();
        this.mDevSubClass = stream.getUnsignedByte();
        this.mProtocol = stream.getUnsignedByte();
        this.mPacketSize = stream.getByte();
        this.mVendorID = stream.unpackUsbShort();
        this.mProductID = stream.unpackUsbShort();
        this.mDeviceRelease = stream.unpackUsbShort();
        this.mMfgIndex = stream.getByte();
        this.mProductIndex = stream.getByte();
        this.mSerialNum = stream.getByte();
        this.mNumConfigs = stream.getByte();
        return this.mLength;
    }

    @Override
    public void report(ReportCanvas canvas) {
        super.report(canvas);
        canvas.openList();
        int spec = this.getSpec();
        canvas.writeListItem("Spec: " + ReportCanvas.getBCDString(spec));
        int devClass = this.getDevClass();
        String classStr = UsbStrings.getClassName(devClass);
        int devSubClass = this.getDevSubClass();
        String subClasStr = UsbStrings.getClassName(devSubClass);
        canvas.writeListItem("Class " + devClass + ": " + classStr + " Subclass" + devSubClass + ": " + subClasStr);
        canvas.writeListItem("Vendor ID: " + ReportCanvas.getHexString(this.getVendorID()) + " Product ID: " + ReportCanvas.getHexString(this.getProductID()) + " Product Release: " + ReportCanvas.getBCDString(this.getDeviceRelease()));
        UsbDescriptorParser parser = canvas.getParser();
        byte mfgIndex = this.getMfgIndex();
        String manufacturer = parser.getDescriptorString(mfgIndex);
        byte productIndex = this.getProductIndex();
        String product = parser.getDescriptorString(productIndex);
        canvas.writeListItem("Manufacturer " + mfgIndex + ": " + manufacturer + " Product " + productIndex + ": " + product);
        canvas.closeList();
    }
}

