/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors;

import android.hardware.usb.UsbEndpoint;
import com.android.server.usb.descriptors.ByteStream;
import com.android.server.usb.descriptors.UsbDescriptor;
import com.android.server.usb.descriptors.UsbDescriptorParser;
import com.android.server.usb.descriptors.report.ReportCanvas;

public class UsbEndpointDescriptor
extends UsbDescriptor {
    private static final String TAG = "UsbEndpointDescriptor";
    private static final boolean DEBUG = false;
    public static final int MASK_ENDPOINT_ADDRESS = 15;
    public static final int MASK_ENDPOINT_DIRECTION = -128;
    public static final int DIRECTION_OUTPUT = 0;
    public static final int DIRECTION_INPUT = -128;
    public static final int MASK_ATTRIBS_TRANSTYPE = 3;
    public static final int TRANSTYPE_CONTROL = 0;
    public static final int TRANSTYPE_ISO = 1;
    public static final int TRANSTYPE_BULK = 2;
    public static final int TRANSTYPE_INTERRUPT = 3;
    public static final byte MASK_ATTRIBS_SYNCTYPE = 12;
    public static final byte SYNCTYPE_NONE = 0;
    public static final byte SYNCTYPE_ASYNC = 4;
    public static final byte SYNCTYPE_ADAPTSYNC = 8;
    public static final byte SYNCTYPE_RESERVED = 12;
    public static final int MASK_ATTRIBS_USEAGE = 48;
    public static final int USEAGE_DATA = 0;
    public static final int USEAGE_FEEDBACK = 16;
    public static final int USEAGE_EXPLICIT = 32;
    public static final int USEAGE_RESERVED = 48;
    private int mEndpointAddress;
    private int mAttributes;
    private int mPacketSize;
    private int mInterval;
    private byte mRefresh;
    private byte mSyncAddress;

    public UsbEndpointDescriptor(int length, byte type) {
        super(length, type);
        this.mHierarchyLevel = 4;
    }

    public int getEndpointAddress() {
        return this.mEndpointAddress;
    }

    public int getAttributes() {
        return this.mAttributes;
    }

    public int getPacketSize() {
        return this.mPacketSize;
    }

    public int getInterval() {
        return this.mInterval;
    }

    public byte getRefresh() {
        return this.mRefresh;
    }

    public byte getSyncAddress() {
        return this.mSyncAddress;
    }

    UsbEndpoint toAndroid(UsbDescriptorParser parser) {
        return new UsbEndpoint(this.mEndpointAddress, this.mAttributes, this.mPacketSize, this.mInterval);
    }

    @Override
    public int parseRawDescriptors(ByteStream stream) {
        this.mEndpointAddress = stream.getUnsignedByte();
        this.mAttributes = stream.getUnsignedByte();
        this.mPacketSize = stream.unpackUsbShort();
        this.mInterval = stream.getUnsignedByte();
        if (this.mLength == 9) {
            this.mRefresh = stream.getByte();
            this.mSyncAddress = stream.getByte();
        }
        return this.mLength;
    }

    @Override
    public void report(ReportCanvas canvas) {
        super.report(canvas);
        canvas.openList();
        int address = this.getEndpointAddress();
        canvas.writeListItem("Address: " + ReportCanvas.getHexString(address & 0xF) + ((address & 0xFFFFFF80) == 0 ? " [out]" : " [in]"));
        int attributes = this.getAttributes();
        canvas.openListItem();
        canvas.write("Attributes: " + ReportCanvas.getHexString(attributes) + " ");
        switch (attributes & 3) {
            case 0: {
                canvas.write("Control");
                break;
            }
            case 1: {
                canvas.write("Iso");
                break;
            }
            case 2: {
                canvas.write("Bulk");
                break;
            }
            case 3: {
                canvas.write("Interrupt");
            }
        }
        canvas.closeListItem();
        if ((attributes & 3) == 1) {
            canvas.openListItem();
            canvas.write("Aync: ");
            switch (attributes & 0xC) {
                case 0: {
                    canvas.write("NONE");
                    break;
                }
                case 4: {
                    canvas.write("ASYNC");
                    break;
                }
                case 8: {
                    canvas.write("ADAPTIVE ASYNC");
                }
            }
            canvas.closeListItem();
            canvas.openListItem();
            canvas.write("Useage: ");
            switch (attributes & 0x30) {
                case 0: {
                    canvas.write("DATA");
                    break;
                }
                case 16: {
                    canvas.write("FEEDBACK");
                    break;
                }
                case 32: {
                    canvas.write("EXPLICIT FEEDBACK");
                    break;
                }
                case 48: {
                    canvas.write("RESERVED");
                }
            }
            canvas.closeListItem();
        }
        canvas.writeListItem("Package Size: " + this.getPacketSize());
        canvas.writeListItem("Interval: " + this.getInterval());
        canvas.closeList();
    }
}

