/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors.report;

import com.android.server.usb.descriptors.UsbDescriptorParser;

public abstract class ReportCanvas {
    private static final String TAG = "ReportCanvas";
    private final UsbDescriptorParser mParser;

    public ReportCanvas(UsbDescriptorParser parser) {
        this.mParser = parser;
    }

    public UsbDescriptorParser getParser() {
        return this.mParser;
    }

    public abstract void write(String var1);

    public abstract void openHeader(int var1);

    public abstract void closeHeader(int var1);

    public void writeHeader(int level, String text) {
        this.openHeader(level);
        this.write(text);
        this.closeHeader(level);
    }

    public abstract void openParagraph(boolean var1);

    public abstract void closeParagraph();

    public abstract void writeParagraph(String var1, boolean var2);

    public abstract void openList();

    public abstract void closeList();

    public abstract void openListItem();

    public abstract void closeListItem();

    public void writeListItem(String text) {
        this.openListItem();
        this.write(text);
        this.closeListItem();
    }

    public static String getHexString(byte value) {
        return "0x" + Integer.toHexString(value & 0xFF).toUpperCase();
    }

    public static String getBCDString(int valueBCD) {
        int major = valueBCD >> 8 & 0xF;
        int minor = valueBCD >> 4 & 0xF;
        int subminor = valueBCD & 0xF;
        return "" + major + "." + minor + subminor;
    }

    public static String getHexString(int value) {
        int intValue = value & 0xFFFF;
        return "0x" + Integer.toHexString(intValue).toUpperCase();
    }

    public void dumpHexArray(byte[] rawData, StringBuilder builder) {
        if (rawData != null) {
            this.openParagraph(false);
            for (int index = 0; index < rawData.length; ++index) {
                builder.append(ReportCanvas.getHexString(rawData[index]) + " ");
            }
            this.closeParagraph();
        }
    }
}

