/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors.report;

import java.util.HashMap;

public final class UsbStrings {
    private static final String TAG = "UsbStrings";
    private static HashMap<Byte, String> sDescriptorNames;
    private static HashMap<Byte, String> sACControlInterfaceNames;
    private static HashMap<Byte, String> sACStreamingInterfaceNames;
    private static HashMap<Integer, String> sClassNames;
    private static HashMap<Integer, String> sAudioSubclassNames;
    private static HashMap<Integer, String> sAudioEncodingNames;
    private static HashMap<Integer, String> sTerminalNames;
    private static HashMap<Integer, String> sFormatNames;

    private static void initDescriptorNames() {
        sDescriptorNames = new HashMap();
        sDescriptorNames.put((byte)1, "Device");
        sDescriptorNames.put((byte)2, "Config");
        sDescriptorNames.put((byte)3, "String");
        sDescriptorNames.put((byte)4, "Interface");
        sDescriptorNames.put((byte)5, "Endpoint");
        sDescriptorNames.put((byte)15, "BOS (whatever that means)");
        sDescriptorNames.put((byte)11, "Interface Association");
        sDescriptorNames.put((byte)16, "Capability");
        sDescriptorNames.put((byte)33, "HID");
        sDescriptorNames.put((byte)34, "Report");
        sDescriptorNames.put((byte)35, "Physical");
        sDescriptorNames.put((byte)36, "Audio Class Interface");
        sDescriptorNames.put((byte)37, "Audio Class Endpoint");
        sDescriptorNames.put((byte)41, "Hub");
        sDescriptorNames.put((byte)42, "Superspeed Hub");
        sDescriptorNames.put((byte)48, "Endpoint Companion");
    }

    private static void initACControlInterfaceNames() {
        sACControlInterfaceNames = new HashMap();
        sACControlInterfaceNames.put((byte)0, "Undefined");
        sACControlInterfaceNames.put((byte)1, "Header");
        sACControlInterfaceNames.put((byte)2, "Input Terminal");
        sACControlInterfaceNames.put((byte)3, "Output Terminal");
        sACControlInterfaceNames.put((byte)4, "Mixer Unit");
        sACControlInterfaceNames.put((byte)5, "Selector Unit");
        sACControlInterfaceNames.put((byte)6, "Feature Unit");
        sACControlInterfaceNames.put((byte)7, "Processing Unit");
        sACControlInterfaceNames.put((byte)8, "Extension Unit");
        sACControlInterfaceNames.put((byte)10, "Clock Source");
        sACControlInterfaceNames.put((byte)11, "Clock Selector");
        sACControlInterfaceNames.put((byte)12, "Clock Multiplier");
        sACControlInterfaceNames.put((byte)13, "Sample Rate Converter");
    }

    private static void initACStreamingInterfaceNames() {
        sACStreamingInterfaceNames = new HashMap();
        sACStreamingInterfaceNames.put((byte)0, "Undefined");
        sACStreamingInterfaceNames.put((byte)1, "General");
        sACStreamingInterfaceNames.put((byte)2, "Format Type");
        sACStreamingInterfaceNames.put((byte)3, "Format Specific");
    }

    private static void initClassNames() {
        sClassNames = new HashMap();
        sClassNames.put(0, "Device");
        sClassNames.put(1, "Audio");
        sClassNames.put(2, "Communications");
        sClassNames.put(3, "HID");
        sClassNames.put(5, "Physical");
        sClassNames.put(6, "Image");
        sClassNames.put(7, "Printer");
        sClassNames.put(8, "Storage");
        sClassNames.put(9, "Hub");
        sClassNames.put(10, "CDC Control");
        sClassNames.put(11, "Smart Card");
        sClassNames.put(13, "Security");
        sClassNames.put(14, "Video");
        sClassNames.put(15, "Healthcare");
        sClassNames.put(16, "Audio/Video");
        sClassNames.put(17, "Billboard");
        sClassNames.put(18, "Type C Bridge");
        sClassNames.put(220, "Diagnostic");
        sClassNames.put(224, "Wireless");
        sClassNames.put(239, "Misc");
        sClassNames.put(254, "Application Specific");
        sClassNames.put(255, "Vendor Specific");
    }

    private static void initAudioSubclassNames() {
        sAudioSubclassNames = new HashMap();
        sAudioSubclassNames.put(0, "Undefinded");
        sAudioSubclassNames.put(1, "Audio Control");
        sAudioSubclassNames.put(2, "Audio Streaming");
        sAudioSubclassNames.put(3, "MIDI Streaming");
    }

    private static void initAudioEncodingNames() {
        sAudioEncodingNames = new HashMap();
        sAudioEncodingNames.put(0, "Format I Undefined");
        sAudioEncodingNames.put(1, "Format I PCM");
        sAudioEncodingNames.put(2, "Format I PCM8");
        sAudioEncodingNames.put(3, "Format I FLOAT");
        sAudioEncodingNames.put(4, "Format I ALAW");
        sAudioEncodingNames.put(5, "Format I MuLAW");
        sAudioEncodingNames.put(4096, "FORMAT_II Undefined");
        sAudioEncodingNames.put(4097, "FORMAT_II MPEG");
        sAudioEncodingNames.put(4098, "FORMAT_II AC3");
        sAudioEncodingNames.put(8192, "FORMAT_III Undefined");
        sAudioEncodingNames.put(8193, "FORMAT_III IEC1937 AC3");
        sAudioEncodingNames.put(8194, "FORMAT_III MPEG1 Layer 1");
        sAudioEncodingNames.put(8195, "FORMAT_III MPEG1 Layer 2");
        sAudioEncodingNames.put(8196, "FORMAT_III MPEG2 EXT");
        sAudioEncodingNames.put(8197, "FORMAT_III MPEG2 Layer1LS");
    }

    private static void initTerminalNames() {
        sTerminalNames = new HashMap();
        sTerminalNames.put(257, "USB Streaming");
        sTerminalNames.put(512, "Undefined");
        sTerminalNames.put(513, "Microphone");
        sTerminalNames.put(514, "Desktop Microphone");
        sTerminalNames.put(515, "Personal (headset) Microphone");
        sTerminalNames.put(516, "Omni Microphone");
        sTerminalNames.put(517, "Microphone Array");
        sTerminalNames.put(518, "Proecessing Microphone Array");
        sTerminalNames.put(768, "Undefined");
        sTerminalNames.put(769, "Speaker");
        sTerminalNames.put(770, "Headphones");
        sTerminalNames.put(771, "Head Mounted Speaker");
        sTerminalNames.put(772, "Desktop Speaker");
        sTerminalNames.put(773, "Room Speaker");
        sTerminalNames.put(774, "Communications Speaker");
        sTerminalNames.put(775, "Low Frequency Speaker");
        sTerminalNames.put(1024, "Undefined");
        sTerminalNames.put(1025, "Handset");
        sTerminalNames.put(1026, "Headset");
        sTerminalNames.put(1027, "Speaker Phone");
        sTerminalNames.put(1028, "Speaker Phone (echo supressing)");
        sTerminalNames.put(1029, "Speaker Phone (echo canceling)");
        sTerminalNames.put(1280, "Undefined");
        sTerminalNames.put(1281, "Phone Line");
        sTerminalNames.put(1282, "Telephone");
        sTerminalNames.put(1283, "Down Line Phone");
        sTerminalNames.put(1536, "Undefined");
        sTerminalNames.put(1537, "Analog Connector");
        sTerminalNames.put(1538, "Digital Connector");
        sTerminalNames.put(1539, "Line Connector");
        sTerminalNames.put(1540, "Legacy Audio Connector");
        sTerminalNames.put(1541, "S/PIDF Interface");
        sTerminalNames.put(1542, "1394 Audio");
        sTerminalNames.put(1543, "1394 Audio/Video");
        sTerminalNames.put(1792, "Undefined");
        sTerminalNames.put(1793, "Calibration Nose");
        sTerminalNames.put(1794, "EQ Noise");
        sTerminalNames.put(1795, "CD Player");
        sTerminalNames.put(1796, "DAT");
        sTerminalNames.put(1797, "DCC");
        sTerminalNames.put(1798, "Mini Disk");
        sTerminalNames.put(1799, "Analog Tap");
        sTerminalNames.put(1800, "Phonograph");
        sTerminalNames.put(1801, "VCR Audio");
        sTerminalNames.put(1802, "Video Disk Audio");
        sTerminalNames.put(1803, "DVD Audio");
        sTerminalNames.put(1804, "TV Audio");
        sTerminalNames.put(1805, "Satellite Audio");
        sTerminalNames.put(1806, "Cable Tuner Audio");
        sTerminalNames.put(1807, "DSS Audio");
        sTerminalNames.put(1809, "Radio Transmitter");
        sTerminalNames.put(1810, "Multitrack Recorder");
        sTerminalNames.put(1811, "Synthesizer");
    }

    public static String getTerminalName(int terminalType) {
        String name = sTerminalNames.get(terminalType);
        return name != null ? name : "Unknown Terminal Type 0x" + Integer.toHexString(terminalType);
    }

    private static void initFormatNames() {
        sFormatNames = new HashMap();
        sFormatNames.put(1, "FORMAT_TYPE_I");
        sFormatNames.put(2, "FORMAT_TYPE_II");
        sFormatNames.put(3, "FORMAT_TYPE_III");
        sFormatNames.put(4, "FORMAT_TYPE_IV");
        sFormatNames.put(-127, "EXT_FORMAT_TYPE_I");
        sFormatNames.put(-126, "EXT_FORMAT_TYPE_II");
        sFormatNames.put(-125, "EXT_FORMAT_TYPE_III");
    }

    public static String getFormatName(int format) {
        String name = sFormatNames.get(format);
        return name != null ? name : "Unknown Format Type 0x" + Integer.toHexString(format);
    }

    private static void allocUsbStrings() {
        UsbStrings.initDescriptorNames();
        UsbStrings.initACControlInterfaceNames();
        UsbStrings.initACStreamingInterfaceNames();
        UsbStrings.initClassNames();
        UsbStrings.initAudioSubclassNames();
        UsbStrings.initAudioEncodingNames();
        UsbStrings.initTerminalNames();
        UsbStrings.initFormatNames();
    }

    public static String getDescriptorName(byte descriptorID) {
        String name = sDescriptorNames.get(descriptorID);
        int iDescriptorID = descriptorID & 0xFF;
        return name != null ? name : "Unknown Descriptor [0x" + Integer.toHexString(iDescriptorID) + ":" + iDescriptorID + "]";
    }

    public static String getACControlInterfaceName(byte subtype) {
        String name = sACControlInterfaceNames.get(subtype);
        int iSubType = subtype & 0xFF;
        return name != null ? name : "Unknown subtype [0x" + Integer.toHexString(iSubType) + ":" + iSubType + "]";
    }

    public static String getACStreamingInterfaceName(byte subtype) {
        String name = sACStreamingInterfaceNames.get(subtype);
        int iSubType = subtype & 0xFF;
        return name != null ? name : "Unknown Subtype [0x" + Integer.toHexString(iSubType) + ":" + iSubType + "]";
    }

    public static String getClassName(int classID) {
        String name = sClassNames.get(classID);
        int iClassID = classID & 0xFF;
        return name != null ? name : "Unknown Class ID [0x" + Integer.toHexString(iClassID) + ":" + iClassID + "]";
    }

    public static String getAudioSubclassName(int subClassID) {
        String name = sAudioSubclassNames.get(subClassID);
        int iSubclassID = subClassID & 0xFF;
        return name != null ? name : "Unknown Audio Subclass [0x" + Integer.toHexString(iSubclassID) + ":" + iSubclassID + "]";
    }

    public static String getAudioFormatName(int formatID) {
        String name = sAudioEncodingNames.get(formatID);
        return name != null ? name : "Unknown Format (encoding) ID [0x" + Integer.toHexString(formatID) + ":" + formatID + "]";
    }

    public static String getACInterfaceSubclassName(int subClassID) {
        return subClassID == 1 ? "AC Control" : "AC Streaming";
    }

    static {
        UsbStrings.allocUsbStrings();
    }
}

