/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors.tree;

import com.android.server.usb.descriptors.UsbInterfaceDescriptor;
import com.android.server.usb.descriptors.report.ReportCanvas;
import com.android.server.usb.descriptors.tree.UsbDescriptorsACInterfaceNode;
import com.android.server.usb.descriptors.tree.UsbDescriptorsEndpointNode;
import com.android.server.usb.descriptors.tree.UsbDescriptorsTreeNode;
import java.util.ArrayList;

public final class UsbDescriptorsInterfaceNode
extends UsbDescriptorsTreeNode {
    private static final String TAG = "UsbDescriptorsInterfaceNode";
    private final UsbInterfaceDescriptor mInterfaceDescriptor;
    private final ArrayList<UsbDescriptorsEndpointNode> mEndpointNodes = new ArrayList();
    private final ArrayList<UsbDescriptorsACInterfaceNode> mACInterfaceNodes = new ArrayList();

    public UsbDescriptorsInterfaceNode(UsbInterfaceDescriptor interfaceDescriptor) {
        this.mInterfaceDescriptor = interfaceDescriptor;
    }

    public void addEndpointNode(UsbDescriptorsEndpointNode endpointNode) {
        this.mEndpointNodes.add(endpointNode);
    }

    public void addACInterfaceNode(UsbDescriptorsACInterfaceNode acInterfaceNode) {
        this.mACInterfaceNodes.add(acInterfaceNode);
    }

    @Override
    public void report(ReportCanvas canvas) {
        this.mInterfaceDescriptor.report(canvas);
        if (this.mACInterfaceNodes.size() > 0) {
            canvas.writeParagraph("Audio Class Interfaces", false);
            canvas.openList();
            for (UsbDescriptorsACInterfaceNode usbDescriptorsACInterfaceNode : this.mACInterfaceNodes) {
                usbDescriptorsACInterfaceNode.report(canvas);
            }
            canvas.closeList();
        }
        if (this.mEndpointNodes.size() > 0) {
            canvas.writeParagraph("Endpoints", false);
            canvas.openList();
            for (UsbDescriptorsEndpointNode usbDescriptorsEndpointNode : this.mEndpointNodes) {
                usbDescriptorsEndpointNode.report(canvas);
            }
            canvas.closeList();
        }
    }
}

