/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.utils;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.Slog;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

public class ManagedApplicationService {
    private final String TAG = this.getClass().getSimpleName();
    public static final int RETRY_FOREVER = 1;
    public static final int RETRY_NEVER = 2;
    public static final int RETRY_BEST_EFFORT = 3;
    private static final int MAX_RETRY_COUNT = 4;
    private static final long MAX_RETRY_DURATION_MS = 16000L;
    private static final long MIN_RETRY_DURATION_MS = 2000L;
    private static final long RETRY_RESET_TIME_MS = 64000L;
    private final Context mContext;
    private final int mUserId;
    private final ComponentName mComponent;
    private final int mClientLabel;
    private final String mSettingsAction;
    private final BinderChecker mChecker;
    private final boolean mIsImportant;
    private final int mRetryType;
    private final Handler mHandler;
    private final Runnable mRetryRunnable = this::doRetry;
    private final EventCallback mEventCb;
    private final Object mLock = new Object();
    private ServiceConnection mConnection;
    private IInterface mBoundInterface;
    private PendingEvent mPendingEvent;
    private int mRetryCount;
    private long mLastRetryTimeMs;
    private long mNextRetryDurationMs = 2000L;
    private boolean mRetrying;

    private ManagedApplicationService(Context context, ComponentName component, int userId, int clientLabel, String settingsAction, BinderChecker binderChecker, boolean isImportant, int retryType, Handler handler, EventCallback eventCallback) {
        this.mContext = context;
        this.mComponent = component;
        this.mUserId = userId;
        this.mClientLabel = clientLabel;
        this.mSettingsAction = settingsAction;
        this.mChecker = binderChecker;
        this.mIsImportant = isImportant;
        this.mRetryType = retryType;
        this.mHandler = handler;
        this.mEventCb = eventCallback;
    }

    public static ManagedApplicationService build(Context context, ComponentName component, int userId, int clientLabel, String settingsAction, BinderChecker binderChecker, boolean isImportant, int retryType, Handler handler, EventCallback eventCallback) {
        return new ManagedApplicationService(context, component, userId, clientLabel, settingsAction, binderChecker, isImportant, retryType, handler, eventCallback);
    }

    public int getUserId() {
        return this.mUserId;
    }

    public ComponentName getComponent() {
        return this.mComponent;
    }

    public boolean disconnectIfNotMatching(ComponentName componentName, int userId) {
        if (this.matches(componentName, userId)) {
            return false;
        }
        this.disconnect();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(PendingEvent event) {
        IInterface iface;
        Object object = this.mLock;
        synchronized (object) {
            iface = this.mBoundInterface;
            if (iface == null) {
                this.mPendingEvent = event;
            }
        }
        if (iface != null) {
            try {
                event.runEvent(iface);
            }
            catch (RemoteException | RuntimeException ex) {
                Slog.e(this.TAG, "Received exception from user service: ", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnection == null) {
                return;
            }
            this.mContext.unbindService(this.mConnection);
            this.mConnection = null;
            this.mBoundInterface = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnection != null) {
                return;
            }
            Intent intent = new Intent().setComponent(this.mComponent);
            if (this.mClientLabel != 0) {
                intent.putExtra("android.intent.extra.client_label", this.mClientLabel);
            }
            if (this.mSettingsAction != null) {
                intent.putExtra("android.intent.extra.client_intent", PendingIntent.getActivity(this.mContext, 0, new Intent(this.mSettingsAction), 0));
            }
            this.mConnection = new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onBindingDied(ComponentName componentName) {
                    long timestamp = System.currentTimeMillis();
                    Slog.w(ManagedApplicationService.this.TAG, "Service binding died: " + componentName);
                    Object object = ManagedApplicationService.this.mLock;
                    synchronized (object) {
                        if (ManagedApplicationService.this.mConnection != this) {
                            return;
                        }
                        ManagedApplicationService.this.mHandler.post(() -> ManagedApplicationService.this.mEventCb.onServiceEvent(new LogEvent(timestamp, ManagedApplicationService.this.mComponent, 3)));
                        ManagedApplicationService.this.mBoundInterface = null;
                        ManagedApplicationService.this.startRetriesLocked();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                    long timestamp = System.currentTimeMillis();
                    Slog.i(ManagedApplicationService.this.TAG, "Service connected: " + componentName);
                    IInterface iface = null;
                    PendingEvent pendingEvent = null;
                    Object object = ManagedApplicationService.this.mLock;
                    synchronized (object) {
                        if (ManagedApplicationService.this.mConnection != this) {
                            return;
                        }
                        ManagedApplicationService.this.mHandler.post(() -> ManagedApplicationService.this.mEventCb.onServiceEvent(new LogEvent(timestamp, ManagedApplicationService.this.mComponent, 1)));
                        ManagedApplicationService.this.stopRetriesLocked();
                        ManagedApplicationService.this.mBoundInterface = null;
                        if (ManagedApplicationService.this.mChecker != null) {
                            ManagedApplicationService.this.mBoundInterface = ManagedApplicationService.this.mChecker.asInterface(iBinder);
                            if (!ManagedApplicationService.this.mChecker.checkType(ManagedApplicationService.this.mBoundInterface)) {
                                ManagedApplicationService.this.mBoundInterface = null;
                                Slog.w(ManagedApplicationService.this.TAG, "Invalid binder from " + componentName);
                                ManagedApplicationService.this.startRetriesLocked();
                                return;
                            }
                            iface = ManagedApplicationService.this.mBoundInterface;
                            pendingEvent = ManagedApplicationService.this.mPendingEvent;
                            ManagedApplicationService.this.mPendingEvent = null;
                        }
                    }
                    if (iface != null && pendingEvent != null) {
                        try {
                            pendingEvent.runEvent(iface);
                        }
                        catch (RemoteException | RuntimeException ex) {
                            Slog.e(ManagedApplicationService.this.TAG, "Received exception from user service: ", ex);
                            ManagedApplicationService.this.startRetriesLocked();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onServiceDisconnected(ComponentName componentName) {
                    long timestamp = System.currentTimeMillis();
                    Slog.w(ManagedApplicationService.this.TAG, "Service disconnected: " + componentName);
                    Object object = ManagedApplicationService.this.mLock;
                    synchronized (object) {
                        if (ManagedApplicationService.this.mConnection != this) {
                            return;
                        }
                        ManagedApplicationService.this.mHandler.post(() -> ManagedApplicationService.this.mEventCb.onServiceEvent(new LogEvent(timestamp, ManagedApplicationService.this.mComponent, 2)));
                        ManagedApplicationService.this.mBoundInterface = null;
                        ManagedApplicationService.this.startRetriesLocked();
                    }
                }
            };
            int flags = 0x4000001;
            if (this.mIsImportant) {
                flags |= 0x40;
            }
            try {
                if (!this.mContext.bindServiceAsUser(intent, this.mConnection, flags, new UserHandle(this.mUserId))) {
                    Slog.w(this.TAG, "Unable to bind service: " + intent);
                    this.startRetriesLocked();
                }
            }
            catch (SecurityException e) {
                Slog.w(this.TAG, "Unable to bind service: " + intent, e);
                this.startRetriesLocked();
            }
        }
    }

    private boolean matches(ComponentName component, int userId) {
        return Objects.equals(this.mComponent, component) && this.mUserId == userId;
    }

    private void startRetriesLocked() {
        if (this.checkAndDeliverServiceDiedCbLocked()) {
            this.disconnect();
            return;
        }
        if (this.mRetrying) {
            return;
        }
        this.mRetrying = true;
        this.queueRetryLocked();
    }

    private void stopRetriesLocked() {
        this.mRetrying = false;
        this.mHandler.removeCallbacks(this.mRetryRunnable);
    }

    private void queueRetryLocked() {
        long now = SystemClock.uptimeMillis();
        if (now - this.mLastRetryTimeMs > 64000L) {
            this.mNextRetryDurationMs = 2000L;
            this.mRetryCount = 0;
        }
        this.mLastRetryTimeMs = now;
        this.mHandler.postDelayed(this.mRetryRunnable, this.mNextRetryDurationMs);
        this.mNextRetryDurationMs = Math.min(2L * this.mNextRetryDurationMs, 16000L);
        ++this.mRetryCount;
    }

    private boolean checkAndDeliverServiceDiedCbLocked() {
        if (this.mRetryType == 2 || this.mRetryType == 3 && this.mRetryCount >= 4) {
            Slog.e(this.TAG, "Service " + this.mComponent + " has died too much, not retrying.");
            if (this.mEventCb != null) {
                long timestamp = System.currentTimeMillis();
                this.mHandler.post(() -> this.mEventCb.onServiceEvent(new LogEvent(timestamp, this.mComponent, 4)));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRetry() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnection == null) {
                return;
            }
            if (!this.mRetrying) {
                return;
            }
            Slog.i(this.TAG, "Attempting to reconnect " + this.mComponent + "...");
            this.disconnect();
            if (this.checkAndDeliverServiceDiedCbLocked()) {
                return;
            }
            this.queueRetryLocked();
            this.connect();
        }
    }

    public static interface EventCallback {
        public void onServiceEvent(LogEvent var1);
    }

    public static interface PendingEvent {
        public void runEvent(IInterface var1) throws RemoteException;
    }

    public static interface BinderChecker {
        public IInterface asInterface(IBinder var1);

        public boolean checkType(IInterface var1);
    }

    public static class LogEvent
    implements LogFormattable {
        public static final int EVENT_CONNECTED = 1;
        public static final int EVENT_DISCONNECTED = 2;
        public static final int EVENT_BINDING_DIED = 3;
        public static final int EVENT_STOPPED_PERMANENTLY = 4;
        public final long timestamp;
        public final ComponentName component;
        public final int event;

        public LogEvent(long timestamp, ComponentName component, int event) {
            this.timestamp = timestamp;
            this.component = component;
            this.event = event;
        }

        @Override
        public String toLogString(SimpleDateFormat dateFormat) {
            return dateFormat.format(new Date(this.timestamp)) + "   " + LogEvent.eventToString(this.event) + " Managed Service: " + (this.component == null ? "None" : this.component.flattenToString());
        }

        public static String eventToString(int event) {
            switch (event) {
                case 1: {
                    return "Connected";
                }
                case 2: {
                    return "Disconnected";
                }
                case 3: {
                    return "Binding Died For";
                }
                case 4: {
                    return "Permanently Stopped";
                }
            }
            return "Unknown Event Occurred";
        }
    }

    public static interface LogFormattable {
        public String toLogString(SimpleDateFormat var1);
    }
}

