/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.webkit;

import android.os.RemoteException;
import android.os.ShellCommand;
import android.webkit.IWebViewUpdateService;
import java.io.PrintWriter;

class WebViewUpdateServiceShellCommand
extends ShellCommand {
    final IWebViewUpdateService mInterface;

    WebViewUpdateServiceShellCommand(IWebViewUpdateService service) {
        this.mInterface = service;
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        PrintWriter pw = this.getOutPrintWriter();
        try {
            switch (cmd) {
                case "enable-redundant-packages": {
                    return this.enableFallbackLogic(false);
                }
                case "disable-redundant-packages": {
                    return this.enableFallbackLogic(true);
                }
                case "set-webview-implementation": {
                    return this.setWebViewImplementation();
                }
                case "enable-multiprocess": {
                    return this.enableMultiProcess(true);
                }
                case "disable-multiprocess": {
                    return this.enableMultiProcess(false);
                }
            }
            return this.handleDefaultCommands(cmd);
        }
        catch (RemoteException e) {
            pw.println("Remote exception: " + e);
            return -1;
        }
    }

    private int enableFallbackLogic(boolean enable) throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        this.mInterface.enableFallbackLogic(enable);
        pw.println("Success");
        return 0;
    }

    private int setWebViewImplementation() throws RemoteException {
        String newPackage;
        PrintWriter pw = this.getOutPrintWriter();
        String shellChosenPackage = this.getNextArg();
        if (shellChosenPackage.equals(newPackage = this.mInterface.changeProviderAndSetting(shellChosenPackage))) {
            pw.println("Success");
            return 0;
        }
        pw.println(String.format("Failed to switch to %s, the WebView implementation is now provided by %s.", shellChosenPackage, newPackage));
        return 1;
    }

    private int enableMultiProcess(boolean enable) throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        this.mInterface.enableMultiProcess(enable);
        pw.println("Success");
        return 0;
    }

    @Override
    public void onHelp() {
        PrintWriter pw = this.getOutPrintWriter();
        pw.println("WebView updater commands:");
        pw.println("  help");
        pw.println("    Print this help text.");
        pw.println("");
        pw.println("  enable-redundant-packages");
        pw.println("    Allow a fallback package to be installed and enabled even when a");
        pw.println("    more-preferred package is available. This command is useful when testing");
        pw.println("    fallback packages.");
        pw.println("  disable-redundant-packages");
        pw.println("    Disallow installing and enabling fallback packages when a more-preferred");
        pw.println("    package is available.");
        pw.println("  set-webview-implementation PACKAGE");
        pw.println("    Set the WebView implementation to the specified package.");
        pw.println("  enable-multiprocess");
        pw.println("    Enable multi-process mode for WebView");
        pw.println("  disable-multiprocess");
        pw.println("    Disable multi-process mode for WebView");
        pw.println();
    }
}

