/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.GraphicBuffer;
import android.graphics.Point;
import android.os.Binder;
import android.util.proto.ProtoOutputStream;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.animation.Animation;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.LocalAnimationAdapter;
import com.android.server.wm.SurfaceAnimator;
import com.android.server.wm.WindowAnimationSpec;
import com.android.server.wm.WindowState;

class AppWindowThumbnail
implements SurfaceAnimator.Animatable {
    private static final String TAG = "WindowManager";
    private final AppWindowToken mAppToken;
    private final SurfaceControl mSurfaceControl;
    private final SurfaceAnimator mSurfaceAnimator;
    private final int mWidth;
    private final int mHeight;

    AppWindowThumbnail(SurfaceControl.Transaction t, AppWindowToken appToken, GraphicBuffer thumbnailHeader) {
        this.mAppToken = appToken;
        this.mSurfaceAnimator = new SurfaceAnimator(this, this::onAnimationFinished, appToken.mService.mAnimator::addAfterPrepareSurfacesRunnable, appToken.mService);
        this.mWidth = thumbnailHeader.getWidth();
        this.mHeight = thumbnailHeader.getHeight();
        WindowState window = appToken.findMainWindow();
        this.mSurfaceControl = appToken.makeSurface().setName("thumbnail anim: " + appToken.toString()).setSize(this.mWidth, this.mHeight).setFormat(-3).setMetadata(appToken.windowType, window != null ? window.mOwnerUid : Binder.getCallingUid()).build();
        Surface drawSurface = new Surface();
        drawSurface.copyFrom(this.mSurfaceControl);
        drawSurface.attachAndQueueBuffer(thumbnailHeader);
        drawSurface.release();
        t.show(this.mSurfaceControl);
        t.setLayer(this.mSurfaceControl, Integer.MAX_VALUE);
    }

    void startAnimation(SurfaceControl.Transaction t, Animation anim2) {
        this.startAnimation(t, anim2, null);
    }

    void startAnimation(SurfaceControl.Transaction t, Animation anim2, Point position) {
        anim2.restrictDuration(10000L);
        anim2.scaleCurrentDuration(this.mAppToken.mService.getTransitionAnimationScaleLocked());
        this.mSurfaceAnimator.startAnimation(t, new LocalAnimationAdapter(new WindowAnimationSpec(anim2, position, this.mAppToken.mService.mAppTransition.canSkipFirstFrame()), this.mAppToken.mService.mSurfaceAnimationRunner), false);
    }

    private void onAnimationFinished() {
    }

    void setShowing(SurfaceControl.Transaction pendingTransaction, boolean show) {
        if (show) {
            pendingTransaction.show(this.mSurfaceControl);
        } else {
            pendingTransaction.hide(this.mSurfaceControl);
        }
    }

    void destroy() {
        this.mSurfaceAnimator.cancelAnimation();
        this.mSurfaceControl.destroy();
    }

    void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10500000001L, this.mWidth);
        proto.write(1120986464258L, this.mHeight);
        this.mSurfaceAnimator.writeToProto(proto, 1146756268035L);
        proto.end(token);
    }

    @Override
    public SurfaceControl.Transaction getPendingTransaction() {
        return this.mAppToken.getPendingTransaction();
    }

    @Override
    public void commitPendingTransaction() {
        this.mAppToken.commitPendingTransaction();
    }

    @Override
    public void destroyAfterPendingTransaction(SurfaceControl surface) {
        this.mAppToken.destroyAfterPendingTransaction(surface);
    }

    @Override
    public void onAnimationLeashCreated(SurfaceControl.Transaction t, SurfaceControl leash) {
        t.setLayer(leash, Integer.MAX_VALUE);
    }

    @Override
    public void onAnimationLeashDestroyed(SurfaceControl.Transaction t) {
        t.hide(this.mSurfaceControl);
    }

    @Override
    public SurfaceControl.Builder makeAnimationLeash() {
        return this.mAppToken.makeSurface();
    }

    @Override
    public SurfaceControl getSurfaceControl() {
        return this.mSurfaceControl;
    }

    @Override
    public SurfaceControl getAnimationLeashParent() {
        return this.mAppToken.getAppAnimationLayer();
    }

    @Override
    public SurfaceControl getParentSurfaceControl() {
        return this.mAppToken.getParentSurfaceControl();
    }

    @Override
    public int getSurfaceWidth() {
        return this.mWidth;
    }

    @Override
    public int getSurfaceHeight() {
        return this.mHeight;
    }
}

