/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.res.Configuration;
import android.graphics.GraphicBuffer;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.Trace;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import android.view.DisplayInfo;
import android.view.IApplicationToken;
import android.view.RemoteAnimationDefinition;
import android.view.SurfaceControl;
import android.view.WindowManager;
import android.view.animation.Animation;
import com.android.internal.util.ToBooleanFunction;
import com.android.server.input.InputApplicationHandle;
import com.android.server.policy.WindowManagerPolicy;
import com.android.server.wm.AccessibilityController;
import com.android.server.wm.AnimationAdapter;
import com.android.server.wm.AppWindowContainerController;
import com.android.server.wm.AppWindowThumbnail;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.Letterbox;
import com.android.server.wm.LocalAnimationAdapter;
import com.android.server.wm.StartingData;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowAnimationSpec;
import com.android.server.wm.WindowContainerController;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;

class AppWindowToken
extends WindowToken
implements WindowManagerService.AppFreezeListener {
    private static final String TAG = "WindowManager";
    private static final int Z_BOOST_BASE = 800570000;
    final IApplicationToken appToken;
    final boolean mVoiceInteraction;
    private boolean mFillsParent;
    boolean layoutConfigChanges;
    boolean mShowForAllUsers;
    int mTargetSdk;
    private boolean mReparenting;
    private boolean mRemovingFromDisplay = false;
    long mInputDispatchingTimeoutNanos;
    private long mLastTransactionSequence = Long.MIN_VALUE;
    private int mNumInterestingWindows;
    private int mNumDrawnWindows;
    boolean inPendingTransaction;
    boolean allDrawn;
    private boolean mLastAllDrawn;
    boolean deferClearAllDrawn;
    boolean hiddenRequested;
    private boolean mClientHidden;
    boolean mDeferHidingClient;
    boolean reportedVisible;
    private boolean reportedDrawn;
    boolean removed;
    StartingData startingData;
    WindowState startingWindow;
    WindowManagerPolicy.StartingSurface startingSurface;
    boolean startingDisplayed;
    boolean startingMoved;
    private boolean mHiddenSetFromTransferredStartingWindow;
    boolean firstWindowDrawn;
    private final WindowState.UpdateReportedVisibilityResults mReportedVisibilityResults = new WindowState.UpdateReportedVisibilityResults();
    final InputApplicationHandle mInputApplicationHandle;
    boolean mIsExiting;
    boolean mLaunchTaskBehind;
    boolean mEnteringAnimation;
    private boolean mAlwaysFocusable;
    boolean mAppStopped;
    int mRotationAnimationHint;
    private int mPendingRelaunchCount;
    private boolean mLastContainsShowWhenLockedWindow;
    private boolean mLastContainsDismissKeyguardWindow;
    ArrayDeque<Rect> mFrozenBounds = new ArrayDeque();
    ArrayDeque<Configuration> mFrozenMergedConfig = new ArrayDeque();
    private boolean mDisablePreviewScreenshots;
    private Task mLastParent;
    private boolean mCanTurnScreenOn = true;
    private int mTransit;
    private int mTransitFlags;
    private boolean mLastSurfaceShowing = true;
    private AppWindowThumbnail mThumbnail;
    private boolean mFreezingScreen;
    private boolean mNeedsZBoost;
    private Letterbox mLetterbox;
    private final Point mTmpPoint = new Point();
    private final Rect mTmpRect = new Rect();
    private RemoteAnimationDefinition mRemoteAnimationDefinition;

    AppWindowToken(WindowManagerService service, IApplicationToken token, boolean voiceInteraction, DisplayContent dc, long inputDispatchingTimeoutNanos, boolean fullscreen, boolean showForAllUsers, int targetSdk, int orientation, int rotationAnimationHint, int configChanges, boolean launchTaskBehind, boolean alwaysFocusable, AppWindowContainerController controller) {
        this(service, token, voiceInteraction, dc, fullscreen);
        this.setController(controller);
        this.mInputDispatchingTimeoutNanos = inputDispatchingTimeoutNanos;
        this.mShowForAllUsers = showForAllUsers;
        this.mTargetSdk = targetSdk;
        this.mOrientation = orientation;
        this.layoutConfigChanges = (configChanges & 0x480) != 0;
        this.mLaunchTaskBehind = launchTaskBehind;
        this.mAlwaysFocusable = alwaysFocusable;
        this.mRotationAnimationHint = rotationAnimationHint;
        this.setHidden(true);
        this.hiddenRequested = true;
    }

    AppWindowToken(WindowManagerService service, IApplicationToken token, boolean voiceInteraction, DisplayContent dc, boolean fillsParent) {
        super(service, token != null ? token.asBinder() : null, 2, true, dc, false);
        this.appToken = token;
        this.mVoiceInteraction = voiceInteraction;
        this.mFillsParent = fillsParent;
        this.mInputApplicationHandle = new InputApplicationHandle(this);
    }

    void onFirstWindowDrawn(WindowState win, WindowStateAnimator winAnimator) {
        this.firstWindowDrawn = true;
        this.removeDeadWindows();
        if (this.startingWindow != null) {
            win.cancelAnimation();
            if (this.getController() != null) {
                this.getController().removeStartingWindow();
            }
        }
        this.updateReportedVisibilityLocked();
    }

    void updateReportedVisibilityLocked() {
        boolean nowVisible;
        if (this.appToken == null) {
            return;
        }
        int count = this.mChildren.size();
        this.mReportedVisibilityResults.reset();
        for (int i = 0; i < count; ++i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            win.updateReportedVisibility(this.mReportedVisibilityResults);
        }
        int numInteresting = this.mReportedVisibilityResults.numInteresting;
        int numVisible = this.mReportedVisibilityResults.numVisible;
        int numDrawn = this.mReportedVisibilityResults.numDrawn;
        boolean nowGone = this.mReportedVisibilityResults.nowGone;
        boolean nowDrawn = numInteresting > 0 && numDrawn >= numInteresting;
        boolean bl = nowVisible = numInteresting > 0 && numVisible >= numInteresting && !this.isHidden();
        if (!nowGone) {
            if (!nowDrawn) {
                nowDrawn = this.reportedDrawn;
            }
            if (!nowVisible) {
                nowVisible = this.reportedVisible;
            }
        }
        AppWindowContainerController controller = this.getController();
        if (nowDrawn != this.reportedDrawn) {
            if (nowDrawn && controller != null) {
                controller.reportWindowsDrawn();
            }
            this.reportedDrawn = nowDrawn;
        }
        if (nowVisible != this.reportedVisible) {
            this.reportedVisible = nowVisible;
            if (controller != null) {
                if (nowVisible) {
                    controller.reportWindowsVisible();
                } else {
                    controller.reportWindowsGone();
                }
            }
        }
    }

    boolean isClientHidden() {
        return this.mClientHidden;
    }

    void setClientHidden(boolean hideClient) {
        if (this.mClientHidden == hideClient || hideClient && this.mDeferHidingClient) {
            return;
        }
        this.mClientHidden = hideClient;
        this.sendAppVisibilityToClients();
    }

    boolean setVisibility(WindowManager.LayoutParams lp, boolean visible, int transit, boolean performLayout, boolean isVoiceInteraction) {
        int i;
        boolean delayed = false;
        this.inPendingTransaction = false;
        this.mHiddenSetFromTransferredStartingWindow = false;
        boolean visibilityChanged = false;
        if (this.isHidden() == visible || this.isHidden() && this.mIsExiting || visible && this.waitingForReplacement()) {
            AccessibilityController accessibilityController = this.mService.mAccessibilityController;
            boolean changed = false;
            boolean runningAppAnimation = false;
            if (transit != -1) {
                WindowState window;
                if (this.applyAnimationLocked(lp, transit, visible, isVoiceInteraction)) {
                    runningAppAnimation = true;
                    delayed = true;
                }
                if ((window = this.findMainWindow()) != null && accessibilityController != null && this.getDisplayContent().getDisplayId() == 0) {
                    accessibilityController.onAppWindowTransitionLocked(window, transit);
                }
                changed = true;
            }
            int windowsCount = this.mChildren.size();
            for (int i2 = 0; i2 < windowsCount; ++i2) {
                WindowState win = (WindowState)this.mChildren.get(i2);
                changed |= win.onAppVisibilityChanged(visible, runningAppAnimation);
            }
            this.setHidden(!visible);
            this.hiddenRequested = !visible;
            visibilityChanged = true;
            if (!visible) {
                this.stopFreezingScreen(true, true);
            } else {
                if (this.startingWindow != null && !this.startingWindow.isDrawnLw()) {
                    this.startingWindow.mPolicyVisibility = false;
                    this.startingWindow.mPolicyVisibilityAfterAnim = false;
                }
                this.forAllWindows(this.mService::makeWindowFreezingScreenIfNeededLocked, true);
            }
            if (changed) {
                this.mService.mInputMonitor.setUpdateInputWindowsNeededLw();
                if (performLayout) {
                    this.mService.updateFocusedWindowLocked(3, false);
                    this.mService.mWindowPlacerLocked.performSurfacePlacement();
                }
                this.mService.mInputMonitor.updateInputWindowsLw(false);
            }
        }
        if (this.isReallyAnimating()) {
            delayed = true;
        }
        for (i = this.mChildren.size() - 1; i >= 0 && !delayed; --i) {
            if (!((WindowState)this.mChildren.get(i)).isSelfOrChildAnimating()) continue;
            delayed = true;
        }
        if (visibilityChanged) {
            if (visible && !delayed) {
                this.mEnteringAnimation = true;
                this.mService.mActivityManagerAppTransitionNotifier.onAppTransitionFinishedLocked(this.token);
            }
            if (visible || !delayed) {
                this.setClientHidden(!visible);
            }
            if (this.isHidden() && !delayed && !this.mService.mAppTransition.isTransitionSet()) {
                SurfaceControl.openTransaction();
                for (i = this.mChildren.size() - 1; i >= 0; --i) {
                    ((WindowState)this.mChildren.get((int)i)).mWinAnimator.hide("immediately hidden");
                }
                SurfaceControl.closeTransaction();
            }
            if (!this.mService.mClosingApps.contains(this) && !this.mService.mOpeningApps.contains(this)) {
                this.mService.getDefaultDisplayContentLocked().getDockedDividerController().notifyAppVisibilityChanged();
                this.mService.mTaskSnapshotController.notifyAppVisibilityChanged(this, visible);
            }
        }
        return delayed;
    }

    WindowState getTopFullscreenWindow() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            if (win == null || !win.mAttrs.isFullscreen()) continue;
            return win;
        }
        return null;
    }

    WindowState findMainWindow() {
        return this.findMainWindow(true);
    }

    WindowState findMainWindow(boolean includeStartingApp) {
        WindowState candidate = null;
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            WindowState win = (WindowState)this.mChildren.get(j);
            int type = win.mAttrs.type;
            if (type != 1 && (!includeStartingApp || type != 3)) continue;
            if (win.mAnimatingExit) {
                candidate = win;
                continue;
            }
            return win;
        }
        return candidate;
    }

    boolean windowsAreFocusable() {
        return this.getWindowConfiguration().canReceiveKeys() || this.mAlwaysFocusable;
    }

    @Override
    AppWindowContainerController getController() {
        WindowContainerController controller = super.getController();
        return controller != null ? (AppWindowContainerController)controller : null;
    }

    @Override
    boolean isVisible() {
        return !this.isHidden();
    }

    @Override
    void removeImmediately() {
        this.onRemovedFromDisplay();
        super.removeImmediately();
    }

    @Override
    void removeIfPossible() {
        this.mIsExiting = false;
        this.removeAllWindowsIfPossible();
        this.removeImmediately();
    }

    @Override
    boolean checkCompleteDeferredRemoval() {
        if (this.mIsExiting) {
            this.removeIfPossible();
        }
        return super.checkCompleteDeferredRemoval();
    }

    void onRemovedFromDisplay() {
        if (this.mRemovingFromDisplay) {
            return;
        }
        this.mRemovingFromDisplay = true;
        boolean delayed = this.setVisibility(null, false, -1, true, this.mVoiceInteraction);
        this.mService.mOpeningApps.remove(this);
        this.mService.mUnknownAppVisibilityController.appRemovedOrHidden(this);
        this.mService.mTaskSnapshotController.onAppRemoved(this);
        this.waitingToShow = false;
        if (this.mService.mClosingApps.contains(this)) {
            delayed = true;
        } else if (this.mService.mAppTransition.isTransitionSet()) {
            this.mService.mClosingApps.add(this);
            delayed = true;
        }
        if (this.startingData != null && this.getController() != null) {
            this.getController().removeStartingWindow();
        }
        if (this.isSelfAnimating()) {
            this.mService.mNoAnimationNotifyOnTransitionFinished.add(this.token);
        }
        TaskStack stack = this.getStack();
        if (delayed && !this.isEmpty()) {
            if (stack != null) {
                stack.mExitingAppTokens.add(this);
            }
            this.mIsExiting = true;
        } else {
            this.cancelAnimation();
            if (stack != null) {
                stack.mExitingAppTokens.remove(this);
            }
            this.removeIfPossible();
        }
        this.removed = true;
        this.stopFreezingScreen(true, true);
        if (this.mService.mFocusedApp == this) {
            this.mService.mFocusedApp = null;
            this.mService.updateFocusedWindowLocked(0, true);
            this.mService.mInputMonitor.setFocusedAppLw(null);
        }
        if (!delayed) {
            this.updateReportedVisibilityLocked();
        }
        this.mRemovingFromDisplay = false;
    }

    void clearAnimatingFlags() {
        boolean wallpaperMightChange = false;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            wallpaperMightChange |= win.clearAnimatingFlags();
        }
        if (wallpaperMightChange) {
            this.requestUpdateWallpaperIfNeeded();
        }
    }

    void destroySurfaces() {
        this.destroySurfaces(false);
    }

    private void destroySurfaces(boolean cleanupOnResume) {
        boolean destroyedSomething = false;
        ArrayList children = new ArrayList(this.mChildren);
        for (int i = children.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)children.get(i);
            destroyedSomething |= win.destroySurface(cleanupOnResume, this.mAppStopped);
        }
        if (destroyedSomething) {
            DisplayContent dc = this.getDisplayContent();
            dc.assignWindowLayers(true);
            this.updateLetterbox(null);
        }
    }

    void notifyAppResumed(boolean wasStopped) {
        this.mAppStopped = false;
        this.setCanTurnScreenOn(true);
        if (!wasStopped) {
            this.destroySurfaces(true);
        }
    }

    void notifyAppStopped() {
        this.mAppStopped = true;
        this.destroySurfaces();
        if (this.getController() != null) {
            this.getController().removeStartingWindow();
        }
    }

    void clearAllDrawn() {
        this.allDrawn = false;
        this.deferClearAllDrawn = false;
    }

    Task getTask() {
        return (Task)this.getParent();
    }

    TaskStack getStack() {
        Task task = this.getTask();
        if (task != null) {
            return task.mStack;
        }
        return null;
    }

    @Override
    void onParentSet() {
        super.onParentSet();
        Task task = this.getTask();
        if (!this.mReparenting) {
            if (task == null) {
                this.mService.mClosingApps.remove(this);
            } else if (this.mLastParent != null && this.mLastParent.mStack != null) {
                task.mStack.mExitingAppTokens.remove(this);
            }
        }
        this.mLastParent = task;
    }

    void postWindowRemoveStartingWindowCleanup(WindowState win) {
        if (this.startingWindow == win) {
            if (this.getController() != null) {
                this.getController().removeStartingWindow();
            }
        } else if (this.mChildren.size() == 0) {
            this.startingData = null;
            if (this.mHiddenSetFromTransferredStartingWindow) {
                this.setHidden(true);
            }
        } else if (this.mChildren.size() == 1 && this.startingSurface != null && !this.isRelaunching() && this.getController() != null) {
            this.getController().removeStartingWindow();
        }
    }

    void removeDeadWindows() {
        for (int winNdx = this.mChildren.size() - 1; winNdx >= 0; --winNdx) {
            WindowState win = (WindowState)this.mChildren.get(winNdx);
            if (!win.mAppDied) continue;
            win.mDestroying = true;
            win.removeIfPossible();
        }
    }

    boolean hasWindowsAlive() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            if (((WindowState)this.mChildren.get((int)i)).mAppDied) continue;
            return true;
        }
        return false;
    }

    void setWillReplaceWindows(boolean animate) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            w.setWillReplaceWindow(animate);
        }
    }

    void setWillReplaceChildWindows() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            w.setWillReplaceChildWindows();
        }
    }

    void clearWillReplaceWindows() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            w.clearWillReplaceWindow();
        }
    }

    void requestUpdateWallpaperIfNeeded() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            w.requestUpdateWallpaperIfNeeded();
        }
    }

    boolean isRelaunching() {
        return this.mPendingRelaunchCount > 0;
    }

    boolean shouldFreezeBounds() {
        Task task = this.getTask();
        if (task == null || task.inFreeformWindowingMode()) {
            return false;
        }
        return this.getTask().isDragResizing();
    }

    void startRelaunching() {
        if (this.shouldFreezeBounds()) {
            this.freezeBounds();
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            w.mWinAnimator.detachChildren();
        }
        ++this.mPendingRelaunchCount;
    }

    void finishRelaunching() {
        this.unfreezeBounds();
        if (this.mPendingRelaunchCount > 0) {
            --this.mPendingRelaunchCount;
        } else {
            this.checkKeyguardFlagsChanged();
        }
    }

    void clearRelaunching() {
        if (this.mPendingRelaunchCount == 0) {
            return;
        }
        this.unfreezeBounds();
        this.mPendingRelaunchCount = 0;
    }

    @Override
    protected boolean isFirstChildWindowGreaterThanSecond(WindowState newWindow, WindowState existingWindow) {
        int type1 = newWindow.mAttrs.type;
        int type2 = existingWindow.mAttrs.type;
        if (type1 == 1 && type2 != 1) {
            return false;
        }
        if (type1 != 1 && type2 == 1) {
            return true;
        }
        if (type1 == 3 && type2 != 3) {
            return true;
        }
        return type1 == 3 || type2 != 3;
    }

    @Override
    void addWindow(WindowState w) {
        super.addWindow(w);
        boolean gotReplacementWindow = false;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState candidate = (WindowState)this.mChildren.get(i);
            gotReplacementWindow |= candidate.setReplacementWindowIfNeeded(w);
        }
        if (gotReplacementWindow) {
            this.mService.scheduleWindowReplacementTimeouts(this);
        }
        this.checkKeyguardFlagsChanged();
    }

    @Override
    void removeChild(WindowState child) {
        super.removeChild(child);
        this.checkKeyguardFlagsChanged();
        this.updateLetterbox(child);
    }

    private boolean waitingForReplacement() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState candidate = (WindowState)this.mChildren.get(i);
            if (!candidate.waitingForReplacement()) continue;
            return true;
        }
        return false;
    }

    void onWindowReplacementTimeout() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            ((WindowState)this.mChildren.get(i)).onWindowReplacementTimeout();
        }
    }

    void reparent(Task task, int position) {
        Task currentTask = this.getTask();
        if (task == currentTask) {
            throw new IllegalArgumentException("window token=" + this + " already child of task=" + currentTask);
        }
        if (currentTask.mStack != task.mStack) {
            throw new IllegalArgumentException("window token=" + this + " current task=" + currentTask + " belongs to a different stack than " + task);
        }
        DisplayContent prevDisplayContent = this.getDisplayContent();
        this.mReparenting = true;
        this.getParent().removeChild(this);
        task.addChild(this, position);
        this.mReparenting = false;
        DisplayContent displayContent = task.getDisplayContent();
        displayContent.setLayoutNeeded();
        if (prevDisplayContent != displayContent) {
            this.onDisplayChanged(displayContent);
            prevDisplayContent.setLayoutNeeded();
        }
    }

    private void freezeBounds() {
        Task task = this.getTask();
        this.mFrozenBounds.offer(new Rect(task.mPreparedFrozenBounds));
        if (task.mPreparedFrozenMergedConfig.equals(Configuration.EMPTY)) {
            this.mFrozenMergedConfig.offer(new Configuration(task.getConfiguration()));
        } else {
            this.mFrozenMergedConfig.offer(new Configuration(task.mPreparedFrozenMergedConfig));
        }
        task.mPreparedFrozenMergedConfig.unset();
    }

    private void unfreezeBounds() {
        if (this.mFrozenBounds.isEmpty()) {
            return;
        }
        this.mFrozenBounds.remove();
        if (!this.mFrozenMergedConfig.isEmpty()) {
            this.mFrozenMergedConfig.remove();
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            win.onUnfreezeBounds();
        }
        this.mService.mWindowPlacerLocked.performSurfacePlacement();
    }

    void setAppLayoutChanges(int changes, String reason) {
        if (!this.mChildren.isEmpty()) {
            DisplayContent dc = this.getDisplayContent();
            dc.pendingLayoutChanges |= changes;
        }
    }

    void removeReplacedWindowIfNeeded(WindowState replacement) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            if (!win.removeReplacedWindowIfNeeded(replacement)) continue;
            return;
        }
    }

    void startFreezingScreen() {
        if (!this.hiddenRequested) {
            if (!this.mFreezingScreen) {
                this.mFreezingScreen = true;
                this.mService.registerAppFreezeListener(this);
                ++this.mService.mAppsFreezingScreen;
                if (this.mService.mAppsFreezingScreen == 1) {
                    this.mService.startFreezingDisplayLocked(false, 0, 0, this.getDisplayContent());
                    this.mService.mH.removeMessages(17);
                    this.mService.mH.sendEmptyMessageDelayed(17, 2000L);
                }
            }
            int count = this.mChildren.size();
            for (int i = 0; i < count; ++i) {
                WindowState w = (WindowState)this.mChildren.get(i);
                w.onStartFreezingScreen();
            }
        }
    }

    void stopFreezingScreen(boolean unfreezeSurfaceNow, boolean force) {
        if (!this.mFreezingScreen) {
            return;
        }
        int count = this.mChildren.size();
        boolean unfrozeWindows = false;
        for (int i = 0; i < count; ++i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            unfrozeWindows |= w.onStopFreezingScreen();
        }
        if (force || unfrozeWindows) {
            this.mFreezingScreen = false;
            this.mService.unregisterAppFreezeListener(this);
            --this.mService.mAppsFreezingScreen;
            this.mService.mLastFinishedFreezeSource = this;
        }
        if (unfreezeSurfaceNow) {
            if (unfrozeWindows) {
                this.mService.mWindowPlacerLocked.performSurfacePlacement();
            }
            this.mService.stopFreezingDisplayLocked();
        }
    }

    @Override
    public void onAppFreezeTimeout() {
        Slog.w(TAG, "Force clearing freeze: " + this);
        this.stopFreezingScreen(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean transferStartingWindow(IBinder transferFrom) {
        AppWindowToken fromToken = this.getDisplayContent().getAppWindowToken(transferFrom);
        if (fromToken == null) {
            return false;
        }
        WindowState tStartingWindow = fromToken.startingWindow;
        if (tStartingWindow != null && fromToken.startingSurface != null) {
            this.mService.mSkipAppTransitionAnimation = true;
            long origId = Binder.clearCallingIdentity();
            try {
                this.startingData = fromToken.startingData;
                this.startingSurface = fromToken.startingSurface;
                this.startingDisplayed = fromToken.startingDisplayed;
                fromToken.startingDisplayed = false;
                this.startingWindow = tStartingWindow;
                this.reportedVisible = fromToken.reportedVisible;
                fromToken.startingData = null;
                fromToken.startingSurface = null;
                fromToken.startingWindow = null;
                fromToken.startingMoved = true;
                tStartingWindow.mToken = this;
                tStartingWindow.mAppToken = this;
                fromToken.removeChild(tStartingWindow);
                fromToken.postWindowRemoveStartingWindowCleanup(tStartingWindow);
                fromToken.mHiddenSetFromTransferredStartingWindow = false;
                this.addWindow(tStartingWindow);
                if (fromToken.allDrawn) {
                    this.allDrawn = true;
                    this.deferClearAllDrawn = fromToken.deferClearAllDrawn;
                }
                if (fromToken.firstWindowDrawn) {
                    this.firstWindowDrawn = true;
                }
                if (!fromToken.isHidden()) {
                    this.setHidden(false);
                    this.hiddenRequested = false;
                    this.mHiddenSetFromTransferredStartingWindow = true;
                }
                this.setClientHidden(fromToken.mClientHidden);
                this.transferAnimation(fromToken);
                this.mService.mOpeningApps.remove(this);
                this.mService.updateFocusedWindowLocked(3, true);
                this.getDisplayContent().setLayoutNeeded();
                this.mService.mWindowPlacerLocked.performSurfacePlacement();
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
            return true;
        }
        if (fromToken.startingData != null) {
            this.startingData = fromToken.startingData;
            fromToken.startingData = null;
            fromToken.startingMoved = true;
            if (this.getController() != null) {
                this.getController().scheduleAddStartingWindow();
            }
            return true;
        }
        return false;
    }

    boolean isLastWindow(WindowState win) {
        return this.mChildren.size() == 1 && this.mChildren.get(0) == win;
    }

    @Override
    void onAppTransitionDone() {
        this.sendingToBottom = false;
    }

    @Override
    int getOrientation(int candidate) {
        if (candidate == 3) {
            return this.mOrientation;
        }
        if (!this.sendingToBottom && !this.mService.mClosingApps.contains(this) && (this.isVisible() || this.mService.mOpeningApps.contains(this) || this.isOnTop())) {
            return this.mOrientation;
        }
        return -2;
    }

    int getOrientationIgnoreVisibility() {
        return this.mOrientation;
    }

    @Override
    public void onConfigurationChanged(Configuration newParentConfig) {
        TaskStack pinnedStack;
        int prevWinMode = this.getWindowingMode();
        super.onConfigurationChanged(newParentConfig);
        int winMode = this.getWindowingMode();
        if (prevWinMode == winMode) {
            return;
        }
        if (prevWinMode != 0 && winMode == 2) {
            this.mDisplayContent.mPinnedStackControllerLocked.resetReentrySnapFraction(this);
        } else if (prevWinMode == 2 && winMode != 0 && (pinnedStack = this.mDisplayContent.getPinnedStack()) != null) {
            this.mDisplayContent.mPinnedStackControllerLocked.saveReentrySnapFraction(this, pinnedStack.mPreAnimationBounds);
        }
    }

    @Override
    void checkAppWindowsReadyToShow() {
        if (this.allDrawn == this.mLastAllDrawn) {
            return;
        }
        this.mLastAllDrawn = this.allDrawn;
        if (!this.allDrawn) {
            return;
        }
        if (this.mFreezingScreen) {
            this.showAllWindowsLocked();
            this.stopFreezingScreen(false, true);
            this.setAppLayoutChanges(4, "checkAppWindowsReadyToShow: freezingScreen");
        } else {
            this.setAppLayoutChanges(8, "checkAppWindowsReadyToShow");
            if (!this.mService.mOpeningApps.contains(this)) {
                this.showAllWindowsLocked();
            }
        }
    }

    private boolean allDrawnStatesConsidered() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState child = (WindowState)this.mChildren.get(i);
            if (!child.mightAffectAllDrawn() || child.getDrawnStateEvaluated()) continue;
            return false;
        }
        return true;
    }

    void updateAllDrawn() {
        int numInteresting;
        if (!this.allDrawn && (numInteresting = this.mNumInterestingWindows) > 0 && this.allDrawnStatesConsidered() && this.mNumDrawnWindows >= numInteresting && !this.isRelaunching()) {
            this.allDrawn = true;
            if (this.mDisplayContent != null) {
                this.mDisplayContent.setLayoutNeeded();
            }
            this.mService.mH.obtainMessage(32, this.token).sendToTarget();
            TaskStack pinnedStack = this.mDisplayContent.getPinnedStack();
            if (pinnedStack != null) {
                pinnedStack.onAllWindowsDrawn();
            }
        }
    }

    boolean updateDrawnWindowStates(WindowState w) {
        w.setDrawnStateEvaluated(true);
        if (this.allDrawn && !this.mFreezingScreen) {
            return false;
        }
        if (this.mLastTransactionSequence != (long)this.mService.mTransactionSequence) {
            this.mLastTransactionSequence = this.mService.mTransactionSequence;
            this.mNumDrawnWindows = 0;
            this.startingDisplayed = false;
            this.mNumInterestingWindows = this.findMainWindow(false) != null ? 1 : 0;
        }
        WindowStateAnimator winAnimator = w.mWinAnimator;
        boolean isInterestingAndDrawn = false;
        if (!this.allDrawn && w.mightAffectAllDrawn()) {
            if (w != this.startingWindow) {
                if (w.isInteresting()) {
                    if (this.findMainWindow(false) != w) {
                        ++this.mNumInterestingWindows;
                    }
                    if (w.isDrawnLw()) {
                        ++this.mNumDrawnWindows;
                        isInterestingAndDrawn = true;
                    }
                }
            } else if (w.isDrawnLw()) {
                if (this.getController() != null) {
                    this.getController().reportStartingWindowDrawn();
                }
                this.startingDisplayed = true;
            }
        }
        return isInterestingAndDrawn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLetterbox(WindowState winHint) {
        boolean needsLetterbox;
        WindowState w = this.findMainWindow();
        if (w != winHint && winHint != null && w != null) {
            return;
        }
        boolean bl = needsLetterbox = w != null && w.isLetterboxedAppWindow() && this.fillsParent() && w.hasDrawnLw();
        if (needsLetterbox) {
            if (this.mLetterbox == null) {
                this.mLetterbox = new Letterbox(() -> this.makeChildSurface(null));
            }
            this.mLetterbox.setDimensions(this.mPendingTransaction, this.getParent().getBounds(), w.mFrame);
        } else if (this.mLetterbox != null) {
            SurfaceControl.Transaction t = new SurfaceControl.Transaction();
            SurfaceControl.openTransaction();
            try {
                this.mLetterbox.hide(t);
            }
            finally {
                SurfaceControl.mergeToGlobalTransaction(t);
                SurfaceControl.closeTransaction();
            }
        }
    }

    @Override
    boolean forAllWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        if (this.mIsExiting && !this.waitingForReplacement()) {
            return false;
        }
        return this.forAllWindowsUnchecked(callback, traverseTopToBottom);
    }

    boolean forAllWindowsUnchecked(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        return super.forAllWindows(callback, traverseTopToBottom);
    }

    @Override
    AppWindowToken asAppWindowToken() {
        return this;
    }

    @Override
    boolean fillsParent() {
        return this.mFillsParent;
    }

    void setFillsParent(boolean fillsParent) {
        this.mFillsParent = fillsParent;
    }

    boolean containsDismissKeyguardWindow() {
        if (this.isRelaunching()) {
            return this.mLastContainsDismissKeyguardWindow;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            if ((((WindowState)this.mChildren.get((int)i)).mAttrs.flags & 0x400000) == 0) continue;
            return true;
        }
        return false;
    }

    boolean containsShowWhenLockedWindow() {
        if (this.isRelaunching()) {
            return this.mLastContainsShowWhenLockedWindow;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            if ((((WindowState)this.mChildren.get((int)i)).mAttrs.flags & 0x80000) == 0) continue;
            return true;
        }
        return false;
    }

    void checkKeyguardFlagsChanged() {
        boolean containsDismissKeyguard = this.containsDismissKeyguardWindow();
        boolean containsShowWhenLocked = this.containsShowWhenLockedWindow();
        if (containsDismissKeyguard != this.mLastContainsDismissKeyguardWindow || containsShowWhenLocked != this.mLastContainsShowWhenLockedWindow) {
            this.mService.notifyKeyguardFlagsChanged(null);
        }
        this.mLastContainsDismissKeyguardWindow = containsDismissKeyguard;
        this.mLastContainsShowWhenLockedWindow = containsShowWhenLocked;
    }

    WindowState getImeTargetBelowWindow(WindowState w) {
        WindowState target;
        int index = this.mChildren.indexOf(w);
        if (index > 0 && (target = (WindowState)this.mChildren.get(index - 1)).canBeImeTarget()) {
            return target;
        }
        return null;
    }

    int getLowestAnimLayer() {
        for (int i = 0; i < this.mChildren.size(); ++i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            if (w.mRemoved) continue;
            return w.mWinAnimator.mAnimLayer;
        }
        return Integer.MAX_VALUE;
    }

    WindowState getHighestAnimLayerWindow(WindowState currentTarget) {
        WindowState candidate = null;
        for (int i = this.mChildren.indexOf(currentTarget); i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            if (w.mRemoved || candidate != null && w.mWinAnimator.mAnimLayer <= candidate.mWinAnimator.mAnimLayer) continue;
            candidate = w;
        }
        return candidate;
    }

    void setDisablePreviewScreenshots(boolean disable) {
        this.mDisablePreviewScreenshots = disable;
    }

    void setCanTurnScreenOn(boolean canTurnScreenOn) {
        this.mCanTurnScreenOn = canTurnScreenOn;
    }

    boolean canTurnScreenOn() {
        return this.mCanTurnScreenOn;
    }

    boolean shouldUseAppThemeSnapshot() {
        return this.mDisablePreviewScreenshots || this.forAllWindows((WindowState w) -> (w.mAttrs.flags & 0x2000) != 0, true);
    }

    @Override
    public SurfaceControl getAnimationLeashParent() {
        return this.getAppAnimationLayer();
    }

    boolean applyAnimationLocked(WindowManager.LayoutParams lp, int transit, boolean enter, boolean isVoiceInteraction) {
        if (this.mService.mDisableTransitionAnimation) {
            this.cancelAnimation();
            return false;
        }
        Trace.traceBegin(32L, "AWT#applyAnimationLocked");
        if (this.okToAnimate()) {
            AnimationAdapter adapter;
            TaskStack stack = this.getStack();
            this.mTmpPoint.set(0, 0);
            this.mTmpRect.setEmpty();
            if (stack != null) {
                stack.getRelativePosition(this.mTmpPoint);
                stack.getBounds(this.mTmpRect);
                this.mTmpRect.offsetTo(0, 0);
            }
            if (this.mService.mAppTransition.getRemoteAnimationController() != null) {
                adapter = this.mService.mAppTransition.getRemoteAnimationController().createAnimationAdapter(this, this.mTmpPoint, this.mTmpRect);
            } else {
                Animation a = this.loadAnimation(lp, transit, enter, isVoiceInteraction);
                if (a != null) {
                    adapter = new LocalAnimationAdapter(new WindowAnimationSpec(a, this.mTmpPoint, this.mTmpRect, this.mService.mAppTransition.canSkipFirstFrame(), this.mService.mAppTransition.getAppStackClipMode()), this.mService.mSurfaceAnimationRunner);
                    if (a.getZAdjustment() == 1) {
                        this.mNeedsZBoost = true;
                    }
                    this.mTransit = transit;
                    this.mTransitFlags = this.mService.mAppTransition.getTransitFlags();
                } else {
                    adapter = null;
                }
            }
            if (adapter != null) {
                this.startAnimation(this.getPendingTransaction(), adapter, !this.isVisible());
            }
        } else {
            this.cancelAnimation();
        }
        Trace.traceEnd(32L);
        return this.isReallyAnimating();
    }

    private Animation loadAnimation(WindowManager.LayoutParams lp, int transit, boolean enter, boolean isVoiceInteraction) {
        boolean freeform;
        DisplayContent displayContent = this.getTask().getDisplayContent();
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        int width = displayInfo.appWidth;
        int height = displayInfo.appHeight;
        WindowState win = this.findMainWindow();
        Rect frame = new Rect(0, 0, width, height);
        Rect displayFrame = new Rect(0, 0, displayInfo.logicalWidth, displayInfo.logicalHeight);
        Rect insets = new Rect();
        Rect stableInsets = new Rect();
        Rect surfaceInsets = null;
        boolean bl = freeform = win != null && win.inFreeformWindowingMode();
        if (win != null) {
            if (freeform) {
                frame.set(win.mFrame);
            } else if (win.isLetterboxedAppWindow()) {
                frame.set(this.getTask().getBounds());
            } else {
                frame.set(win.mContainingFrame);
            }
            surfaceInsets = win.getAttrs().surfaceInsets;
            insets.set(win.mContentInsets);
            stableInsets.set(win.mStableInsets);
        }
        if (this.mLaunchTaskBehind) {
            enter = false;
        }
        Configuration displayConfig = displayContent.getConfiguration();
        Animation a = this.mService.mAppTransition.loadAnimation(lp, transit, enter, displayConfig.uiMode, displayConfig.orientation, frame, displayFrame, insets, surfaceInsets, stableInsets, isVoiceInteraction, freeform, this.getTask().mTaskId);
        if (a != null) {
            int containingWidth = frame.width();
            int containingHeight = frame.height();
            a.initialize(containingWidth, containingHeight, width, height);
            a.scaleCurrentDuration(this.mService.getTransitionAnimationScaleLocked());
        }
        return a;
    }

    @Override
    protected void setLayer(SurfaceControl.Transaction t, int layer) {
        if (!this.mSurfaceAnimator.hasLeash()) {
            t.setLayer(this.mSurfaceControl, layer);
        }
    }

    @Override
    protected void setRelativeLayer(SurfaceControl.Transaction t, SurfaceControl relativeTo, int layer) {
        if (!this.mSurfaceAnimator.hasLeash()) {
            t.setRelativeLayer(this.mSurfaceControl, relativeTo, layer);
        }
    }

    @Override
    protected void reparentSurfaceControl(SurfaceControl.Transaction t, SurfaceControl newParent) {
        if (!this.mSurfaceAnimator.hasLeash()) {
            t.reparent(this.mSurfaceControl, newParent.getHandle());
        }
    }

    @Override
    public void onAnimationLeashCreated(SurfaceControl.Transaction t, SurfaceControl leash) {
        int layer = this.getPrefixOrderIndex();
        if (this.mNeedsZBoost) {
            layer += 800570000;
        }
        leash.setLayer(layer);
    }

    void showAllWindowsLocked() {
        this.forAllWindows((WindowState windowState) -> windowState.performShowLocked(), false);
    }

    @Override
    protected void onAnimationFinished() {
        super.onAnimationFinished();
        this.mTransit = -1;
        this.mTransitFlags = 0;
        this.mNeedsZBoost = false;
        this.setAppLayoutChanges(12, "AppWindowToken");
        this.clearThumbnail();
        this.setClientHidden(this.isHidden());
        if (this.mService.mInputMethodTarget != null && this.mService.mInputMethodTarget.mAppToken == this) {
            this.getDisplayContent().computeImeTarget(true);
        }
        ArrayList<WindowState> children = new ArrayList<WindowState>(this.mChildren);
        children.forEach(WindowState::onExitAnimationDone);
        this.mService.mAppTransition.notifyAppTransitionFinishedLocked(this.token);
        this.scheduleAnimation();
    }

    @Override
    boolean isAppAnimating() {
        return this.isSelfAnimating();
    }

    @Override
    boolean isSelfAnimating() {
        return this.isWaitingForTransitionStart() || this.isReallyAnimating();
    }

    private boolean isReallyAnimating() {
        return super.isSelfAnimating();
    }

    @Override
    void cancelAnimation() {
        super.cancelAnimation();
        this.clearThumbnail();
    }

    boolean isWaitingForTransitionStart() {
        return this.mService.mAppTransition.isTransitionSet() && (this.mService.mOpeningApps.contains(this) || this.mService.mClosingApps.contains(this));
    }

    public int getTransit() {
        return this.mTransit;
    }

    int getTransitFlags() {
        return this.mTransitFlags;
    }

    void attachThumbnailAnimation() {
        if (!this.isReallyAnimating()) {
            return;
        }
        int taskId = this.getTask().mTaskId;
        GraphicBuffer thumbnailHeader = this.mService.mAppTransition.getAppTransitionThumbnailHeader(taskId);
        if (thumbnailHeader == null) {
            return;
        }
        this.clearThumbnail();
        this.mThumbnail = new AppWindowThumbnail(this.getPendingTransaction(), this, thumbnailHeader);
        this.mThumbnail.startAnimation(this.getPendingTransaction(), this.loadThumbnailAnimation(thumbnailHeader));
    }

    void attachCrossProfileAppsThumbnailAnimation() {
        Rect frame;
        if (!this.isReallyAnimating()) {
            return;
        }
        this.clearThumbnail();
        WindowState win = this.findMainWindow();
        if (win == null) {
            return;
        }
        int thumbnailDrawableRes = this.getTask().mUserId == this.mService.mCurrentUserId ? 17302256 : 17302323;
        GraphicBuffer thumbnail = this.mService.mAppTransition.createCrossProfileAppsThumbnail(thumbnailDrawableRes, frame = win.mFrame);
        if (thumbnail == null) {
            return;
        }
        this.mThumbnail = new AppWindowThumbnail(this.getPendingTransaction(), this, thumbnail);
        Animation animation = this.mService.mAppTransition.createCrossProfileAppsThumbnailAnimationLocked(win.mFrame);
        this.mThumbnail.startAnimation(this.getPendingTransaction(), animation, new Point(frame.left, frame.top));
    }

    private Animation loadThumbnailAnimation(GraphicBuffer thumbnailHeader) {
        DisplayInfo displayInfo = this.mDisplayContent.getDisplayInfo();
        WindowState win = this.findMainWindow();
        Rect appRect = win != null ? win.getContentFrameLw() : new Rect(0, 0, displayInfo.appWidth, displayInfo.appHeight);
        Rect insets = win != null ? win.mContentInsets : null;
        Configuration displayConfig = this.mDisplayContent.getConfiguration();
        return this.mService.mAppTransition.createThumbnailAspectScaleAnimationLocked(appRect, insets, thumbnailHeader, this.getTask().mTaskId, displayConfig.uiMode, displayConfig.orientation);
    }

    private void clearThumbnail() {
        if (this.mThumbnail == null) {
            return;
        }
        this.mThumbnail.destroy();
        this.mThumbnail = null;
    }

    void registerRemoteAnimations(RemoteAnimationDefinition definition) {
        this.mRemoteAnimationDefinition = definition;
    }

    RemoteAnimationDefinition getRemoteAnimationDefinition() {
        return this.mRemoteAnimationDefinition;
    }

    @Override
    void dump(PrintWriter pw, String prefix, boolean dumpAll) {
        super.dump(pw, prefix, dumpAll);
        if (this.appToken != null) {
            pw.println(prefix + "app=true mVoiceInteraction=" + this.mVoiceInteraction);
        }
        pw.print(prefix);
        pw.print("task=");
        pw.println(this.getTask());
        pw.print(prefix);
        pw.print(" mFillsParent=");
        pw.print(this.mFillsParent);
        pw.print(" mOrientation=");
        pw.println(this.mOrientation);
        pw.println(prefix + "hiddenRequested=" + this.hiddenRequested + " mClientHidden=" + this.mClientHidden + (this.mDeferHidingClient ? " mDeferHidingClient=" + this.mDeferHidingClient : "") + " reportedDrawn=" + this.reportedDrawn + " reportedVisible=" + this.reportedVisible);
        if (this.paused) {
            pw.print(prefix);
            pw.print("paused=");
            pw.println(this.paused);
        }
        if (this.mAppStopped) {
            pw.print(prefix);
            pw.print("mAppStopped=");
            pw.println(this.mAppStopped);
        }
        if (this.mNumInterestingWindows != 0 || this.mNumDrawnWindows != 0 || this.allDrawn || this.mLastAllDrawn) {
            pw.print(prefix);
            pw.print("mNumInterestingWindows=");
            pw.print(this.mNumInterestingWindows);
            pw.print(" mNumDrawnWindows=");
            pw.print(this.mNumDrawnWindows);
            pw.print(" inPendingTransaction=");
            pw.print(this.inPendingTransaction);
            pw.print(" allDrawn=");
            pw.print(this.allDrawn);
            pw.print(" lastAllDrawn=");
            pw.print(this.mLastAllDrawn);
            pw.println(")");
        }
        if (this.inPendingTransaction) {
            pw.print(prefix);
            pw.print("inPendingTransaction=");
            pw.println(this.inPendingTransaction);
        }
        if (this.startingData != null || this.removed || this.firstWindowDrawn || this.mIsExiting) {
            pw.print(prefix);
            pw.print("startingData=");
            pw.print(this.startingData);
            pw.print(" removed=");
            pw.print(this.removed);
            pw.print(" firstWindowDrawn=");
            pw.print(this.firstWindowDrawn);
            pw.print(" mIsExiting=");
            pw.println(this.mIsExiting);
        }
        if (this.startingWindow != null || this.startingSurface != null || this.startingDisplayed || this.startingMoved || this.mHiddenSetFromTransferredStartingWindow) {
            pw.print(prefix);
            pw.print("startingWindow=");
            pw.print(this.startingWindow);
            pw.print(" startingSurface=");
            pw.print(this.startingSurface);
            pw.print(" startingDisplayed=");
            pw.print(this.startingDisplayed);
            pw.print(" startingMoved=");
            pw.print(this.startingMoved);
            pw.println(" mHiddenSetFromTransferredStartingWindow=" + this.mHiddenSetFromTransferredStartingWindow);
        }
        if (!this.mFrozenBounds.isEmpty()) {
            pw.print(prefix);
            pw.print("mFrozenBounds=");
            pw.println(this.mFrozenBounds);
            pw.print(prefix);
            pw.print("mFrozenMergedConfig=");
            pw.println(this.mFrozenMergedConfig);
        }
        if (this.mPendingRelaunchCount != 0) {
            pw.print(prefix);
            pw.print("mPendingRelaunchCount=");
            pw.println(this.mPendingRelaunchCount);
        }
        if (this.getController() != null) {
            pw.print(prefix);
            pw.print("controller=");
            pw.println(this.getController());
        }
        if (this.mRemovingFromDisplay) {
            pw.println(prefix + "mRemovingFromDisplay=" + this.mRemovingFromDisplay);
        }
    }

    @Override
    void setHidden(boolean hidden) {
        super.setHidden(hidden);
        if (hidden) {
            this.mDisplayContent.mPinnedStackControllerLocked.resetReentrySnapFraction(this);
        }
        this.scheduleAnimation();
    }

    @Override
    void prepareSurfaces() {
        boolean show;
        boolean reallyAnimating = super.isSelfAnimating();
        boolean bl = show = !this.isHidden() || reallyAnimating;
        if (show && !this.mLastSurfaceShowing) {
            this.mPendingTransaction.show(this.mSurfaceControl);
        } else if (!show && this.mLastSurfaceShowing) {
            this.mPendingTransaction.hide(this.mSurfaceControl);
        }
        if (this.mThumbnail != null) {
            this.mThumbnail.setShowing(this.mPendingTransaction, show);
        }
        this.mLastSurfaceShowing = show;
        super.prepareSurfaces();
    }

    boolean isFreezingScreen() {
        return this.mFreezingScreen;
    }

    @Override
    boolean needsZBoost() {
        return this.mNeedsZBoost || super.needsZBoost();
    }

    @Override
    public void writeToProto(ProtoOutputStream proto, long fieldId, boolean trim) {
        long token = proto.start(fieldId);
        this.writeNameToProto(proto, 0x10900000001L);
        super.writeToProto(proto, 1146756268034L, trim);
        proto.write(1133871366147L, this.mLastSurfaceShowing);
        proto.write(1133871366148L, this.isWaitingForTransitionStart());
        proto.write(1133871366149L, this.isReallyAnimating());
        if (this.mThumbnail != null) {
            this.mThumbnail.writeToProto(proto, 1146756268038L);
        }
        proto.write(1133871366151L, this.mFillsParent);
        proto.write(0x10800000008L, this.mAppStopped);
        proto.write(1133871366153L, this.hiddenRequested);
        proto.write(1133871366154L, this.mClientHidden);
        proto.write(1133871366155L, this.mDeferHidingClient);
        proto.write(1133871366156L, this.reportedDrawn);
        proto.write(1133871366157L, this.reportedVisible);
        proto.write(1120986464270L, this.mNumInterestingWindows);
        proto.write(1120986464271L, this.mNumDrawnWindows);
        proto.write(0x10800000010L, this.allDrawn);
        proto.write(0x10800000011L, this.mLastAllDrawn);
        proto.write(1133871366162L, this.removed);
        if (this.startingWindow != null) {
            this.startingWindow.writeIdentifierToProto(proto, 1146756268051L);
        }
        proto.write(1133871366164L, this.startingDisplayed);
        proto.write(1133871366165L, this.startingMoved);
        proto.write(1133871366166L, this.mHiddenSetFromTransferredStartingWindow);
        for (Rect bounds : this.mFrozenBounds) {
            bounds.writeToProto(proto, 2246267895831L);
        }
        proto.end(token);
    }

    void writeNameToProto(ProtoOutputStream proto, long fieldId) {
        if (this.appToken == null) {
            return;
        }
        try {
            proto.write(fieldId, this.appToken.getName());
        }
        catch (RemoteException e) {
            Slog.e(TAG, e.toString());
        }
    }

    @Override
    public String toString() {
        if (this.stringName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("AppWindowToken{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(" token=");
            sb.append(this.token);
            sb.append('}');
            this.stringName = sb.toString();
        }
        return this.stringName + (this.mIsExiting ? " mIsExiting=" : "");
    }
}

