/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.WindowConfiguration;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.util.proto.ProtoOutputStream;
import com.android.server.wm.ConfigurationContainerListener;
import java.io.PrintWriter;
import java.util.ArrayList;

public abstract class ConfigurationContainer<E extends ConfigurationContainer> {
    private Rect mReturnBounds = new Rect();
    private Configuration mOverrideConfiguration = new Configuration();
    private boolean mHasOverrideConfiguration;
    private Configuration mFullConfiguration = new Configuration();
    private Configuration mMergedOverrideConfiguration = new Configuration();
    private ArrayList<ConfigurationContainerListener> mChangeListeners = new ArrayList();
    private final Configuration mTmpConfig = new Configuration();
    private final Rect mTmpRect = new Rect();
    static final int BOUNDS_CHANGE_NONE = 0;
    static final int BOUNDS_CHANGE_POSITION = 1;
    static final int BOUNDS_CHANGE_SIZE = 2;

    public Configuration getConfiguration() {
        return this.mFullConfiguration;
    }

    public void onConfigurationChanged(Configuration newParentConfig) {
        this.mFullConfiguration.setTo(newParentConfig);
        this.mFullConfiguration.updateFrom(this.mOverrideConfiguration);
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            E child = this.getChildAt(i);
            ((ConfigurationContainer)child).onConfigurationChanged(this.mFullConfiguration);
        }
    }

    public Configuration getOverrideConfiguration() {
        return this.mOverrideConfiguration;
    }

    public void onOverrideConfigurationChanged(Configuration overrideConfiguration) {
        this.mHasOverrideConfiguration = !Configuration.EMPTY.equals(overrideConfiguration);
        this.mOverrideConfiguration.setTo(overrideConfiguration);
        ConfigurationContainer parent = this.getParent();
        this.onConfigurationChanged(parent != null ? parent.getConfiguration() : Configuration.EMPTY);
        this.onMergedOverrideConfigurationChanged();
        for (int i = this.mChangeListeners.size() - 1; i >= 0; --i) {
            this.mChangeListeners.get(i).onOverrideConfigurationChanged(overrideConfiguration);
        }
    }

    public Configuration getMergedOverrideConfiguration() {
        return this.mMergedOverrideConfiguration;
    }

    void onMergedOverrideConfigurationChanged() {
        ConfigurationContainer parent = this.getParent();
        if (parent != null) {
            this.mMergedOverrideConfiguration.setTo(parent.getMergedOverrideConfiguration());
            this.mMergedOverrideConfiguration.updateFrom(this.mOverrideConfiguration);
        } else {
            this.mMergedOverrideConfiguration.setTo(this.mOverrideConfiguration);
        }
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            E child = this.getChildAt(i);
            ((ConfigurationContainer)child).onMergedOverrideConfigurationChanged();
        }
    }

    public boolean matchParentBounds() {
        return this.getOverrideBounds().isEmpty();
    }

    public boolean equivalentOverrideBounds(Rect bounds) {
        return ConfigurationContainer.equivalentBounds(this.getOverrideBounds(), bounds);
    }

    public static boolean equivalentBounds(Rect bounds, Rect other) {
        return bounds == other || bounds != null && (bounds.equals(other) || bounds.isEmpty() && other == null) || other != null && other.isEmpty() && bounds == null;
    }

    public Rect getBounds() {
        this.mReturnBounds.set(this.getConfiguration().windowConfiguration.getBounds());
        return this.mReturnBounds;
    }

    public void getBounds(Rect outBounds) {
        outBounds.set(this.getBounds());
    }

    public Rect getOverrideBounds() {
        this.mReturnBounds.set(this.getOverrideConfiguration().windowConfiguration.getBounds());
        return this.mReturnBounds;
    }

    public boolean hasOverrideBounds() {
        return !this.getOverrideBounds().isEmpty();
    }

    public void getOverrideBounds(Rect outBounds) {
        outBounds.set(this.getOverrideBounds());
    }

    public int setBounds(Rect bounds) {
        int boundsChange = this.diffOverrideBounds(bounds);
        if (boundsChange == 0) {
            return boundsChange;
        }
        this.mTmpConfig.setTo(this.getOverrideConfiguration());
        this.mTmpConfig.windowConfiguration.setBounds(bounds);
        this.onOverrideConfigurationChanged(this.mTmpConfig);
        return boundsChange;
    }

    public int setBounds(int left, int top, int right, int bottom) {
        this.mTmpRect.set(left, top, right, bottom);
        return this.setBounds(this.mTmpRect);
    }

    int diffOverrideBounds(Rect bounds) {
        if (this.equivalentOverrideBounds(bounds)) {
            return 0;
        }
        int boundsChange = 0;
        Rect existingBounds = this.getOverrideBounds();
        if (bounds == null || existingBounds.left != bounds.left || existingBounds.top != bounds.top) {
            boundsChange |= 1;
        }
        if (bounds == null || existingBounds.width() != bounds.width() || existingBounds.height() != bounds.height()) {
            boundsChange |= 2;
        }
        return boundsChange;
    }

    public WindowConfiguration getWindowConfiguration() {
        return this.mFullConfiguration.windowConfiguration;
    }

    public int getWindowingMode() {
        return this.mFullConfiguration.windowConfiguration.getWindowingMode();
    }

    public void setWindowingMode(int windowingMode) {
        this.mTmpConfig.setTo(this.getOverrideConfiguration());
        this.mTmpConfig.windowConfiguration.setWindowingMode(windowingMode);
        this.onOverrideConfigurationChanged(this.mTmpConfig);
    }

    public boolean inMultiWindowMode() {
        int windowingMode = this.mFullConfiguration.windowConfiguration.getWindowingMode();
        return windowingMode != 1 && windowingMode != 0;
    }

    public boolean inSplitScreenWindowingMode() {
        int windowingMode = this.mFullConfiguration.windowConfiguration.getWindowingMode();
        return windowingMode == 3 || windowingMode == 4;
    }

    public boolean inSplitScreenSecondaryWindowingMode() {
        int windowingMode = this.mFullConfiguration.windowConfiguration.getWindowingMode();
        return windowingMode == 4;
    }

    public boolean inSplitScreenPrimaryWindowingMode() {
        return this.mFullConfiguration.windowConfiguration.getWindowingMode() == 3;
    }

    public boolean supportsSplitScreenWindowingMode() {
        return this.mFullConfiguration.windowConfiguration.supportSplitScreenWindowingMode();
    }

    public boolean inPinnedWindowingMode() {
        return this.mFullConfiguration.windowConfiguration.getWindowingMode() == 2;
    }

    public boolean inFreeformWindowingMode() {
        return this.mFullConfiguration.windowConfiguration.getWindowingMode() == 5;
    }

    public int getActivityType() {
        return this.mFullConfiguration.windowConfiguration.getActivityType();
    }

    public void setActivityType(int activityType) {
        int currentActivityType = this.getActivityType();
        if (currentActivityType == activityType) {
            return;
        }
        if (currentActivityType != 0) {
            throw new IllegalStateException("Can't change activity type once set: " + this + " activityType=" + WindowConfiguration.activityTypeToString(activityType));
        }
        this.mTmpConfig.setTo(this.getOverrideConfiguration());
        this.mTmpConfig.windowConfiguration.setActivityType(activityType);
        this.onOverrideConfigurationChanged(this.mTmpConfig);
    }

    public boolean isActivityTypeHome() {
        return this.getActivityType() == 2;
    }

    public boolean isActivityTypeRecents() {
        return this.getActivityType() == 3;
    }

    public boolean isActivityTypeAssistant() {
        return this.getActivityType() == 4;
    }

    public boolean isActivityTypeStandard() {
        return this.getActivityType() == 1;
    }

    public boolean isActivityTypeStandardOrUndefined() {
        int activityType = this.getActivityType();
        return activityType == 1 || activityType == 0;
    }

    public boolean hasCompatibleActivityType(ConfigurationContainer other) {
        int otherType;
        int thisType = this.getActivityType();
        if (thisType == (otherType = other.getActivityType())) {
            return true;
        }
        if (thisType == 4) {
            return false;
        }
        return thisType == 0 || otherType == 0;
    }

    public boolean isCompatible(int windowingMode, int activityType) {
        boolean sameWindowingMode;
        int thisActivityType = this.getActivityType();
        int thisWindowingMode = this.getWindowingMode();
        boolean sameActivityType = thisActivityType == activityType;
        boolean bl = sameWindowingMode = thisWindowingMode == windowingMode;
        if (sameActivityType && sameWindowingMode) {
            return true;
        }
        if (activityType != 0 && activityType != 1 || !this.isActivityTypeStandardOrUndefined()) {
            return sameActivityType;
        }
        return sameWindowingMode;
    }

    public void registerConfigurationChangeListener(ConfigurationContainerListener listener) {
        if (this.mChangeListeners.contains(listener)) {
            return;
        }
        this.mChangeListeners.add(listener);
        listener.onOverrideConfigurationChanged(this.mOverrideConfiguration);
    }

    public void unregisterConfigurationChangeListener(ConfigurationContainerListener listener) {
        this.mChangeListeners.remove(listener);
    }

    protected void onParentChanged() {
        ConfigurationContainer parent = this.getParent();
        if (parent != null) {
            this.onConfigurationChanged(parent.mFullConfiguration);
            this.onMergedOverrideConfigurationChanged();
        }
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId, boolean trim) {
        long token = proto.start(fieldId);
        if (!trim || this.mHasOverrideConfiguration) {
            this.mOverrideConfiguration.writeToProto(proto, 0x10B00000001L);
        }
        if (!trim) {
            this.mFullConfiguration.writeToProto(proto, 1146756268034L);
            this.mMergedOverrideConfiguration.writeToProto(proto, 1146756268035L);
        }
        proto.end(token);
    }

    public void dumpChildrenNames(PrintWriter pw, String prefix) {
        String childPrefix = prefix + " ";
        pw.println(this.getName() + " type=" + WindowConfiguration.activityTypeToString(this.getActivityType()) + " mode=" + WindowConfiguration.windowingModeToString(this.getWindowingMode()));
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            E cc = this.getChildAt(i);
            pw.print(childPrefix + "#" + i + " ");
            ((ConfigurationContainer)cc).dumpChildrenNames(pw, childPrefix);
        }
    }

    String getName() {
        return this.toString();
    }

    boolean isAlwaysOnTop() {
        return this.mFullConfiguration.windowConfiguration.isAlwaysOnTop();
    }

    protected abstract int getChildCount();

    protected abstract E getChildAt(int var1);

    protected abstract ConfigurationContainer getParent();
}

