/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Rect;
import android.view.SurfaceControl;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.wm.AnimationAdapter;
import com.android.server.wm.LocalAnimationAdapter;
import com.android.server.wm.SurfaceAnimator;
import com.android.server.wm.WindowContainer;

class Dimmer {
    private static final String TAG = "WindowManager";
    private static final int DEFAULT_DIM_ANIM_DURATION = 200;
    private WindowContainer mHost;
    private WindowContainer mLastRequestedDimContainer;
    @VisibleForTesting
    DimState mDimState;
    private final SurfaceAnimatorStarter mSurfaceAnimatorStarter;

    Dimmer(WindowContainer host) {
        this(host, SurfaceAnimator::startAnimation);
    }

    Dimmer(WindowContainer host, SurfaceAnimatorStarter surfaceAnimatorStarter) {
        this.mHost = host;
        this.mSurfaceAnimatorStarter = surfaceAnimatorStarter;
    }

    private SurfaceControl makeDimLayer() {
        return this.mHost.makeChildSurface(null).setParent(this.mHost.getSurfaceControl()).setColorLayer(true).setName("Dim Layer for - " + this.mHost.getName()).build();
    }

    private DimState getDimState(WindowContainer container) {
        if (this.mDimState == null) {
            SurfaceControl ctl = this.makeDimLayer();
            this.mDimState = new DimState(ctl);
            if (container == null) {
                this.mDimState.mDontReset = true;
            }
        }
        this.mLastRequestedDimContainer = container;
        return this.mDimState;
    }

    private void dim(SurfaceControl.Transaction t, WindowContainer container, int relativeLayer, float alpha) {
        DimState d = this.getDimState(container);
        if (container != null) {
            t.setRelativeLayer(d.mDimLayer, container.getSurfaceControl(), relativeLayer);
        } else {
            t.setLayer(d.mDimLayer, Integer.MAX_VALUE);
        }
        t.setAlpha(d.mDimLayer, alpha);
        d.mDimming = true;
    }

    void stopDim(SurfaceControl.Transaction t) {
        DimState d = this.getDimState(null);
        t.hide(d.mDimLayer);
        d.isVisible = false;
        d.mDontReset = false;
    }

    void dimAbove(SurfaceControl.Transaction t, float alpha) {
        this.dim(t, null, 1, alpha);
    }

    void dimAbove(SurfaceControl.Transaction t, WindowContainer container, float alpha) {
        this.dim(t, container, 1, alpha);
    }

    void dimBelow(SurfaceControl.Transaction t, WindowContainer container, float alpha) {
        this.dim(t, container, -1, alpha);
    }

    void resetDimStates() {
        if (this.mDimState != null && !this.mDimState.mDontReset) {
            this.mDimState.mDimming = false;
        }
    }

    boolean updateDims(SurfaceControl.Transaction t, Rect bounds) {
        if (this.mDimState == null) {
            return false;
        }
        if (!this.mDimState.mDimming) {
            this.startDimExit(this.mLastRequestedDimContainer, this.mDimState.mSurfaceAnimator, t);
            this.mDimState = null;
            return false;
        }
        t.setSize(this.mDimState.mDimLayer, bounds.width(), bounds.height());
        t.setPosition(this.mDimState.mDimLayer, bounds.left, bounds.top);
        if (!this.mDimState.isVisible) {
            this.mDimState.isVisible = true;
            t.show(this.mDimState.mDimLayer);
            this.startDimEnter(this.mLastRequestedDimContainer, this.mDimState.mSurfaceAnimator, t);
        }
        return true;
    }

    private void startDimEnter(WindowContainer container, SurfaceAnimator animator2, SurfaceControl.Transaction t) {
        this.startAnim(container, animator2, t, 0.0f, 1.0f);
    }

    private void startDimExit(WindowContainer container, SurfaceAnimator animator2, SurfaceControl.Transaction t) {
        this.startAnim(container, animator2, t, 1.0f, 0.0f);
    }

    private void startAnim(WindowContainer container, SurfaceAnimator animator2, SurfaceControl.Transaction t, float startAlpha, float endAlpha) {
        this.mSurfaceAnimatorStarter.startAnimation(animator2, t, new LocalAnimationAdapter(new AlphaAnimationSpec(startAlpha, endAlpha, this.getDimDuration(container)), this.mHost.mService.mSurfaceAnimationRunner), false);
    }

    private long getDimDuration(WindowContainer container) {
        if (container == null) {
            return 0L;
        }
        AnimationAdapter animationAdapter = container.mSurfaceAnimator.getAnimation();
        return animationAdapter == null ? 200L : animationAdapter.getDurationHint();
    }

    private static class AlphaAnimationSpec
    implements LocalAnimationAdapter.AnimationSpec {
        private final long mDuration;
        private final float mFromAlpha;
        private final float mToAlpha;

        AlphaAnimationSpec(float fromAlpha, float toAlpha, long duration) {
            this.mFromAlpha = fromAlpha;
            this.mToAlpha = toAlpha;
            this.mDuration = duration;
        }

        @Override
        public long getDuration() {
            return this.mDuration;
        }

        @Override
        public void apply(SurfaceControl.Transaction t, SurfaceControl sc, long currentPlayTime) {
            float alpha = (float)currentPlayTime / (float)this.getDuration() * (this.mToAlpha - this.mFromAlpha) + this.mFromAlpha;
            t.setAlpha(sc, alpha);
        }
    }

    @VisibleForTesting
    static interface SurfaceAnimatorStarter {
        public void startAnimation(SurfaceAnimator var1, SurfaceControl.Transaction var2, AnimationAdapter var3, boolean var4);
    }

    @VisibleForTesting
    class DimState {
        SurfaceControl mDimLayer;
        boolean mDimming;
        boolean isVisible;
        SurfaceAnimator mSurfaceAnimator;
        boolean mDontReset;

        DimState(SurfaceControl dimLayer) {
            this.mDimLayer = dimLayer;
            this.mDimming = true;
            this.mSurfaceAnimator = new SurfaceAnimator(new DimAnimatable(dimLayer), () -> {
                if (!this.mDimming) {
                    this.mDimLayer.destroy();
                }
            }, ((Dimmer)Dimmer.this).mHost.mService.mAnimator::addAfterPrepareSurfacesRunnable, ((Dimmer)Dimmer.this).mHost.mService);
        }
    }

    private class DimAnimatable
    implements SurfaceAnimator.Animatable {
        private final SurfaceControl mDimLayer;

        private DimAnimatable(SurfaceControl dimLayer) {
            this.mDimLayer = dimLayer;
        }

        @Override
        public SurfaceControl.Transaction getPendingTransaction() {
            return Dimmer.this.mHost.getPendingTransaction();
        }

        @Override
        public void commitPendingTransaction() {
            Dimmer.this.mHost.commitPendingTransaction();
        }

        @Override
        public void onAnimationLeashCreated(SurfaceControl.Transaction t, SurfaceControl leash) {
        }

        @Override
        public void onAnimationLeashDestroyed(SurfaceControl.Transaction t) {
        }

        @Override
        public void destroyAfterPendingTransaction(SurfaceControl surface) {
            Dimmer.this.mHost.destroyAfterPendingTransaction(surface);
        }

        @Override
        public SurfaceControl.Builder makeAnimationLeash() {
            return Dimmer.this.mHost.makeAnimationLeash();
        }

        @Override
        public SurfaceControl getAnimationLeashParent() {
            return Dimmer.this.mHost.getSurfaceControl();
        }

        @Override
        public SurfaceControl getSurfaceControl() {
            return this.mDimLayer;
        }

        @Override
        public SurfaceControl getParentSurfaceControl() {
            return Dimmer.this.mHost.getSurfaceControl();
        }

        @Override
        public int getSurfaceWidth() {
            return Dimmer.this.mHost.getSurfaceWidth();
        }

        @Override
        public int getSurfaceHeight() {
            return Dimmer.this.mHost.getSurfaceHeight();
        }
    }
}

