/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Rect;
import android.view.SurfaceControl;
import java.util.function.Supplier;

public class Letterbox {
    private static final Rect EMPTY_RECT = new Rect();
    private final Supplier<SurfaceControl.Builder> mFactory;
    private final Rect mOuter = new Rect();
    private final Rect mInner = new Rect();
    private final LetterboxSurface mTop = new LetterboxSurface("top");
    private final LetterboxSurface mLeft = new LetterboxSurface("left");
    private final LetterboxSurface mBottom = new LetterboxSurface("bottom");
    private final LetterboxSurface mRight = new LetterboxSurface("right");

    public Letterbox(Supplier<SurfaceControl.Builder> surfaceControlFactory) {
        this.mFactory = surfaceControlFactory;
    }

    public void setDimensions(SurfaceControl.Transaction t, Rect outer, Rect inner) {
        this.mOuter.set(outer);
        this.mInner.set(inner);
        this.mTop.setRect(t, outer.left, outer.top, inner.right, inner.top);
        this.mLeft.setRect(t, outer.left, inner.top, inner.left, outer.bottom);
        this.mBottom.setRect(t, inner.left, inner.bottom, outer.right, outer.bottom);
        this.mRight.setRect(t, inner.right, outer.top, outer.right, inner.bottom);
    }

    public void hide(SurfaceControl.Transaction t) {
        this.setDimensions(t, EMPTY_RECT, EMPTY_RECT);
    }

    public void destroy() {
        this.mOuter.setEmpty();
        this.mInner.setEmpty();
        this.mTop.destroy();
        this.mLeft.destroy();
        this.mBottom.destroy();
        this.mRight.destroy();
    }

    private class LetterboxSurface {
        private final String mType;
        private SurfaceControl mSurface;
        private int mLastLeft = 0;
        private int mLastTop = 0;
        private int mLastRight = 0;
        private int mLastBottom = 0;

        public LetterboxSurface(String type) {
            this.mType = type;
        }

        public void setRect(SurfaceControl.Transaction t, int left, int top, int right, int bottom) {
            if (this.mLastLeft == left && this.mLastTop == top && this.mLastRight == right && this.mLastBottom == bottom) {
                return;
            }
            if (left < right && top < bottom) {
                if (this.mSurface == null) {
                    this.createSurface();
                }
                t.setPosition(this.mSurface, left, top);
                t.setSize(this.mSurface, right - left, bottom - top);
                t.show(this.mSurface);
            } else if (this.mSurface != null) {
                t.hide(this.mSurface);
            }
            this.mLastLeft = left;
            this.mLastTop = top;
            this.mLastRight = right;
            this.mLastBottom = bottom;
        }

        private void createSurface() {
            this.mSurface = ((SurfaceControl.Builder)Letterbox.this.mFactory.get()).setName("Letterbox - " + this.mType).setFlags(4).setColorLayer(true).build();
            this.mSurface.setLayer(-1);
            this.mSurface.setColor(new float[]{0.0f, 0.0f, 0.0f});
        }

        public void destroy() {
            if (this.mSurface != null) {
                this.mSurface.destroy();
                this.mSurface = null;
            }
        }
    }
}

