/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.RemoteAction;
import android.graphics.Rect;
import com.android.server.wm.BoundsAnimationTarget;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.PinnedStackController;
import com.android.server.wm.PinnedStackWindowListener;
import com.android.server.wm.StackWindowController;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import java.util.List;

public class PinnedStackWindowController
extends StackWindowController {
    private Rect mTmpFromBounds = new Rect();
    private Rect mTmpToBounds = new Rect();

    public PinnedStackWindowController(int stackId, PinnedStackWindowListener listener, int displayId, boolean onTop, Rect outBounds, WindowManagerService service) {
        super(stackId, listener, displayId, onTop, outBounds, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Rect getPictureInPictureBounds(float aspectRatio, Rect stackBounds) {
        block9: {
            DisplayContent displayContent;
            block8: {
                block7: {
                    Rect rect;
                    WindowHashMap windowHashMap = this.mWindowMap;
                    // MONITORENTER : windowHashMap
                    try {
                        WindowManagerService.boostPriorityForLockedSection();
                        if (this.mService.mSupportsPictureInPicture && this.mContainer != null) break block7;
                        rect = null;
                        // MONITOREXIT : windowHashMap
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT : windowHashMap
                        WindowManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return rect;
                }
                displayContent = ((TaskStack)this.mContainer).getDisplayContent();
                if (displayContent != null) break block8;
                Rect rect = null;
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                return rect;
            }
            PinnedStackController pinnedStackController = displayContent.getPinnedStackController();
            if (stackBounds == null) {
                stackBounds = pinnedStackController.getDefaultOrLastSavedBounds();
            }
            if (!pinnedStackController.isValidPictureInPictureAspectRatio(aspectRatio)) break block9;
            Rect rect = pinnedStackController.transformBoundsToAspectRatio(stackBounds, aspectRatio, true);
            // MONITOREXIT : windowHashMap
            WindowManagerService.resetPriorityAfterLockedSection();
            return rect;
        }
        Rect rect = stackBounds;
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
        return rect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animateResizePinnedStack(Rect toBounds, Rect sourceHintBounds, int animationDuration, boolean fromFullscreen) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                boolean toFullscreen;
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) {
                    throw new IllegalArgumentException("Pinned stack container not found :(");
                }
                Rect fromBounds = new Rect();
                ((TaskStack)this.mContainer).getBounds(fromBounds);
                int schedulePipModeChangedState = 0;
                boolean bl = toFullscreen = toBounds == null;
                if (toFullscreen) {
                    if (fromFullscreen) {
                        throw new IllegalArgumentException("Should not defer scheduling PiP mode change on animation to fullscreen.");
                    }
                    schedulePipModeChangedState = 1;
                    this.mService.getStackBounds(1, 1, this.mTmpToBounds);
                    if (!this.mTmpToBounds.isEmpty()) {
                        toBounds = new Rect(this.mTmpToBounds);
                    } else {
                        toBounds = new Rect();
                        ((TaskStack)this.mContainer).getDisplayContent().getBounds(toBounds);
                    }
                } else if (fromFullscreen) {
                    schedulePipModeChangedState = 2;
                }
                ((TaskStack)this.mContainer).setAnimationFinalBounds(sourceHintBounds, toBounds, toFullscreen);
                Rect finalToBounds = toBounds;
                int finalSchedulePipModeChangedState = schedulePipModeChangedState;
                this.mService.mBoundsAnimationController.getHandler().post(() -> {
                    if (this.mContainer == null) {
                        return;
                    }
                    this.mService.mBoundsAnimationController.animateBounds((BoundsAnimationTarget)((Object)this.mContainer), fromBounds, finalToBounds, animationDuration, finalSchedulePipModeChangedState, fromFullscreen, toFullscreen);
                });
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl32 : MonitorExitStatement: MONITOREXIT : var5_5
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setPictureInPictureAspectRatio(float aspectRatio) {
        block6: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mService.mSupportsPictureInPicture && this.mContainer != null) break block6;
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        PinnedStackController pinnedStackController = ((TaskStack)this.mContainer).getDisplayContent().getPinnedStackController();
        if (Float.compare(aspectRatio, pinnedStackController.getAspectRatio()) != 0) {
            ((TaskStack)this.mContainer).getAnimationOrCurrentBounds(this.mTmpFromBounds);
            this.mTmpToBounds.set(this.mTmpFromBounds);
            this.getPictureInPictureBounds(aspectRatio, this.mTmpToBounds);
            if (!this.mTmpToBounds.equals(this.mTmpFromBounds)) {
                this.animateResizePinnedStack(this.mTmpToBounds, null, -1, false);
            }
            pinnedStackController.setAspectRatio(pinnedStackController.isValidPictureInPictureAspectRatio(aspectRatio) ? aspectRatio : -1.0f);
        }
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setPictureInPictureActions(List<RemoteAction> actions) {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mService.mSupportsPictureInPicture && this.mContainer != null) break block4;
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ((TaskStack)this.mContainer).getDisplayContent().getPinnedStackController().setActions(actions);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deferScheduleMultiWindowModeChanged() {
        boolean bl;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                bl = ((TaskStack)this.mContainer).deferScheduleMultiWindowModeChanged();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAnimatingBoundsToFullscreen() {
        boolean bl;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                bl = ((TaskStack)this.mContainer).isAnimatingBoundsToFullscreen();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean pinnedStackResizeDisallowed() {
        boolean bl;
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                bl = ((TaskStack)this.mContainer).pinnedStackResizeDisallowed();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    public void updatePictureInPictureModeForPinnedStackAnimation(Rect targetStackBounds, boolean forceUpdate) {
        if (this.mListener != null) {
            PinnedStackWindowListener listener = (PinnedStackWindowListener)this.mListener;
            listener.updatePictureInPictureModeForPinnedStackAnimation(targetStackBounds, forceUpdate);
        }
    }
}

