/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.app.WindowConfiguration;
import android.graphics.GraphicBuffer;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Binder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Slog;
import android.view.IRecentsAnimationController;
import android.view.IRecentsAnimationRunner;
import android.view.RemoteAnimationTarget;
import android.view.SurfaceControl;
import com.android.server.wm.AnimationAdapter;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.InputConsumerImpl;
import com.android.server.wm.SurfaceAnimator;
import com.android.server.wm.Task;
import com.android.server.wm.WallpaperController;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.io.PrintWriter;
import java.util.ArrayList;

public class RecentsAnimationController {
    private static final String TAG = "WindowManager";
    private static final boolean DEBUG = false;
    private final WindowManagerService mService;
    private final IRecentsAnimationRunner mRunner;
    private final RecentsAnimationCallbacks mCallbacks;
    private final ArrayList<TaskAnimationAdapter> mPendingAnimations = new ArrayList();
    private AppWindowToken mHomeAppToken;
    private boolean mPendingStart = true;
    private boolean mCanceled = false;
    private boolean mInputConsumerEnabled;
    private Rect mTmpRect = new Rect();
    private final IRecentsAnimationController mController = new IRecentsAnimationController.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public ActivityManager.TaskSnapshot screenshotTask(int taskId) {
            long token;
            block10: {
                ActivityManager.TaskSnapshot taskSnapshot;
                token = Binder.clearCallingIdentity();
                try {
                    Object object = RecentsAnimationController.this.mService.getWindowManagerLock();
                    // MONITORENTER : object
                    if (!RecentsAnimationController.this.mCanceled) break block10;
                    taskSnapshot = null;
                    // MONITOREXIT : object
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(token);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(token);
                return taskSnapshot;
            }
            int i = RecentsAnimationController.this.mPendingAnimations.size() - 1;
            while (true) {
                if (i < 0) {
                    ActivityManager.TaskSnapshot taskSnapshot = null;
                    // MONITOREXIT : object
                    Binder.restoreCallingIdentity(token);
                    return taskSnapshot;
                }
                TaskAnimationAdapter adapter = (TaskAnimationAdapter)RecentsAnimationController.this.mPendingAnimations.get(i);
                Task task = adapter.mTask;
                if (task.mTaskId == taskId) {
                    Rect taskFrame = new Rect();
                    task.getBounds(taskFrame);
                    GraphicBuffer buffer = SurfaceControl.captureLayers(task.getSurfaceControl().getHandle(), taskFrame, 1.0f);
                    AppWindowToken topChild = (AppWindowToken)task.getTopChild();
                    WindowState mainWindow = topChild.findMainWindow();
                    ActivityManager.TaskSnapshot taskSnapshot = new ActivityManager.TaskSnapshot(buffer, topChild.getConfiguration().orientation, mainWindow.mStableInsets, ActivityManager.isLowRamDeviceStatic(), 1.0f);
                    // MONITOREXIT : object
                    Binder.restoreCallingIdentity(token);
                    return taskSnapshot;
                }
                --i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void finish(boolean moveHomeToTop) {
            long token = Binder.clearCallingIdentity();
            try {
                Object object = RecentsAnimationController.this.mService.getWindowManagerLock();
                synchronized (object) {
                    if (RecentsAnimationController.this.mCanceled) {
                        return;
                    }
                }
                RecentsAnimationController.this.mCallbacks.onAnimationFinished(moveHomeToTop);
                return;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setInputConsumerEnabled(boolean enabled) {
            long token = Binder.clearCallingIdentity();
            try {
                Object object = RecentsAnimationController.this.mService.getWindowManagerLock();
                synchronized (object) {
                    block8: {
                        if (!RecentsAnimationController.this.mCanceled) break block8;
                        return;
                    }
                    RecentsAnimationController.this.mInputConsumerEnabled = enabled;
                    ((RecentsAnimationController)RecentsAnimationController.this).mService.mInputMonitor.updateInputWindowsLw(true);
                    RecentsAnimationController.this.mService.scheduleAnimationLocked();
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    };

    RecentsAnimationController(WindowManagerService service, IRecentsAnimationRunner remoteAnimationRunner, RecentsAnimationCallbacks callbacks, int displayId) {
        this.mService = service;
        this.mRunner = remoteAnimationRunner;
        this.mCallbacks = callbacks;
        DisplayContent dc = this.mService.mRoot.getDisplayContent(displayId);
        ArrayList<Task> visibleTasks = dc.getVisibleTasks();
        if (visibleTasks.isEmpty()) {
            this.cancelAnimation();
            return;
        }
        int taskCount = visibleTasks.size();
        for (int i = 0; i < taskCount; ++i) {
            Task task = visibleTasks.get(i);
            WindowConfiguration config = task.getWindowConfiguration();
            if (config.tasksAreFloating() || config.getWindowingMode() == 3 || config.getActivityType() == 2) continue;
            this.addAnimation(task);
        }
        AppWindowToken recentsComponentAppToken = ((Task)dc.getHomeStack().getTopChild()).getTopFullscreenAppToken();
        if (recentsComponentAppToken != null) {
            this.mHomeAppToken = recentsComponentAppToken;
            WallpaperController wc = dc.mWallpaperController;
            if (recentsComponentAppToken.windowsCanBeWallpaperTarget()) {
                dc.pendingLayoutChanges |= 4;
                dc.setLayoutNeeded();
            }
        }
        this.mService.mWindowPlacerLocked.performSurfacePlacement();
    }

    private void addAnimation(Task task) {
        SurfaceAnimator anim2 = new SurfaceAnimator(task, null, this.mService.mAnimator::addAfterPrepareSurfacesRunnable, this.mService);
        TaskAnimationAdapter taskAdapter = new TaskAnimationAdapter(task);
        anim2.startAnimation(task.getPendingTransaction(), taskAdapter, false);
        task.commitPendingTransaction();
        this.mPendingAnimations.add(taskAdapter);
    }

    void startAnimation() {
        if (!this.mPendingStart) {
            return;
        }
        try {
            RemoteAnimationTarget[] appAnimations = new RemoteAnimationTarget[this.mPendingAnimations.size()];
            for (int i = this.mPendingAnimations.size() - 1; i >= 0; --i) {
                appAnimations[i] = this.mPendingAnimations.get(i).createRemoteAnimationApp();
            }
            this.mPendingStart = false;
            this.mRunner.onAnimationStart(this.mController, appAnimations);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failed to start recents animation", e);
        }
    }

    void cancelAnimation() {
        if (this.mCanceled) {
            return;
        }
        this.mCanceled = true;
        try {
            this.mRunner.onAnimationCanceled();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failed to cancel recents animation", e);
        }
        this.mCallbacks.onAnimationFinished(false);
    }

    void cleanupAnimation() {
        for (int i = this.mPendingAnimations.size() - 1; i >= 0; --i) {
            TaskAnimationAdapter adapter = this.mPendingAnimations.get(i);
            adapter.mCapturedFinishCallback.onAnimationFinished(adapter);
        }
        this.mPendingAnimations.clear();
        this.mService.mInputMonitor.updateInputWindowsLw(true);
        this.mService.destroyInputConsumer("recents_animation_input_consumer");
    }

    void checkAnimationReady(WallpaperController wallpaperController) {
        if (this.mPendingStart) {
            boolean wallpaperReady;
            boolean bl = wallpaperReady = !this.isHomeAppOverWallpaper() || wallpaperController.getWallpaperTarget() != null && wallpaperController.wallpaperTransitionReady();
            if (wallpaperReady) {
                this.mService.getRecentsAnimationController().startAnimation();
            }
        }
    }

    boolean isWallpaperVisible(WindowState w) {
        return w != null && w.mAppToken != null && this.mHomeAppToken == w.mAppToken && this.isHomeAppOverWallpaper();
    }

    boolean hasInputConsumerForApp(AppWindowToken appToken) {
        return this.mInputConsumerEnabled && this.isAnimatingApp(appToken);
    }

    boolean updateInputConsumerForApp(InputConsumerImpl recentsAnimationInputConsumer, boolean hasFocus) {
        WindowState homeAppMainWindow;
        WindowState windowState = homeAppMainWindow = this.mHomeAppToken != null ? this.mHomeAppToken.findMainWindow() : null;
        if (homeAppMainWindow != null) {
            homeAppMainWindow.getBounds(this.mTmpRect);
            recentsAnimationInputConsumer.mWindowHandle.hasFocus = hasFocus;
            recentsAnimationInputConsumer.mWindowHandle.touchableRegion.set(this.mTmpRect);
            return true;
        }
        return false;
    }

    private boolean isHomeAppOverWallpaper() {
        if (this.mHomeAppToken == null) {
            return false;
        }
        return this.mHomeAppToken.windowsCanBeWallpaperTarget();
    }

    private boolean isAnimatingApp(AppWindowToken appToken) {
        for (int i = this.mPendingAnimations.size() - 1; i >= 0; --i) {
            Task task = this.mPendingAnimations.get(i).mTask;
            for (int j = task.getChildCount() - 1; j >= 0; --j) {
                AppWindowToken app = (AppWindowToken)task.getChildAt(j);
                if (app != appToken) continue;
                return true;
            }
        }
        return false;
    }

    public void dump(PrintWriter pw, String prefix) {
        String innerPrefix = prefix + "  ";
        pw.print(prefix);
        pw.println(RecentsAnimationController.class.getSimpleName() + ":");
        pw.print(innerPrefix);
        pw.println("mPendingStart=" + this.mPendingStart);
        pw.print(innerPrefix);
        pw.println("mHomeAppToken=" + this.mHomeAppToken);
    }

    private class TaskAnimationAdapter
    implements AnimationAdapter {
        private Task mTask;
        private SurfaceControl mCapturedLeash;
        private SurfaceAnimator.OnAnimationFinishedCallback mCapturedFinishCallback;

        TaskAnimationAdapter(Task task) {
            this.mTask = task;
        }

        RemoteAnimationTarget createRemoteAnimationApp() {
            return new RemoteAnimationTarget(this.mTask.mTaskId, 1, this.mCapturedLeash, !this.mTask.fillsParent(), this.mTask.getTopVisibleAppMainWindow().mWinAnimator.mLastClipRect, this.mTask.getPrefixOrderIndex(), new Point(), new Rect(), this.mTask.getWindowConfiguration());
        }

        @Override
        public boolean getDetachWallpaper() {
            return false;
        }

        @Override
        public int getBackgroundColor() {
            return 0;
        }

        @Override
        public void startAnimation(SurfaceControl animationLeash, SurfaceControl.Transaction t, SurfaceAnimator.OnAnimationFinishedCallback finishCallback) {
            this.mCapturedLeash = animationLeash;
            this.mCapturedFinishCallback = finishCallback;
        }

        @Override
        public void onAnimationCancelled(SurfaceControl animationLeash) {
            RecentsAnimationController.this.cancelAnimation();
        }

        @Override
        public long getDurationHint() {
            return 0L;
        }

        @Override
        public long getStatusBarTransitionsStartTime() {
            return SystemClock.uptimeMillis();
        }
    }

    public static interface RecentsAnimationCallbacks {
        public void onAnimationFinished(boolean var1);
    }
}

