/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.Handler;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Slog;
import android.view.IRemoteAnimationFinishedCallback;
import android.view.RemoteAnimationAdapter;
import android.view.RemoteAnimationTarget;
import android.view.SurfaceControl;
import com.android.server.wm.AnimationAdapter;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.SurfaceAnimator;
import com.android.server.wm.Task;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.util.ArrayList;

class RemoteAnimationController {
    private static final String TAG = "WindowManager";
    private static final long TIMEOUT_MS = 2000L;
    private final WindowManagerService mService;
    private final RemoteAnimationAdapter mRemoteAnimationAdapter;
    private final ArrayList<RemoteAnimationAdapterWrapper> mPendingAnimations = new ArrayList();
    private final Rect mTmpRect = new Rect();
    private final Handler mHandler;
    private final IRemoteAnimationFinishedCallback mFinishedCallback = new IRemoteAnimationFinishedCallback.Stub(){

        @Override
        public void onAnimationFinished() throws RemoteException {
            RemoteAnimationController.this.onAnimationFinished();
        }
    };
    private final Runnable mTimeoutRunnable = () -> {
        this.onAnimationFinished();
        this.invokeAnimationCancelled();
    };

    RemoteAnimationController(WindowManagerService service, RemoteAnimationAdapter remoteAnimationAdapter, Handler handler) {
        this.mService = service;
        this.mRemoteAnimationAdapter = remoteAnimationAdapter;
        this.mHandler = handler;
    }

    AnimationAdapter createAnimationAdapter(AppWindowToken appWindowToken, Point position, Rect stackBounds) {
        RemoteAnimationAdapterWrapper adapter = new RemoteAnimationAdapterWrapper(appWindowToken, position, stackBounds);
        this.mPendingAnimations.add(adapter);
        return adapter;
    }

    void goodToGo() {
        if (this.mPendingAnimations.isEmpty()) {
            this.onAnimationFinished();
            return;
        }
        this.mHandler.postDelayed(this.mTimeoutRunnable, (long)(2000.0f * this.mService.getCurrentAnimatorScale()));
        try {
            this.mRemoteAnimationAdapter.getRunner().onAnimationStart(this.createAnimations(), this.mFinishedCallback);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failed to start remote animation", e);
            this.onAnimationFinished();
        }
    }

    private RemoteAnimationTarget[] createAnimations() {
        ArrayList<RemoteAnimationTarget> targets = new ArrayList<RemoteAnimationTarget>();
        for (int i = this.mPendingAnimations.size() - 1; i >= 0; --i) {
            RemoteAnimationTarget target = this.mPendingAnimations.get(i).createRemoteAppAnimation();
            if (target == null) continue;
            targets.add(target);
        }
        return targets.toArray(new RemoteAnimationTarget[targets.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAnimationFinished() {
        this.mHandler.removeCallbacks(this.mTimeoutRunnable);
        WindowHashMap windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mService.openSurfaceTransaction();
                try {
                    for (int i = this.mPendingAnimations.size() - 1; i >= 0; --i) {
                        RemoteAnimationAdapterWrapper adapter = this.mPendingAnimations.get(i);
                        adapter.mCapturedFinishCallback.onAnimationFinished(adapter);
                    }
                }
                finally {
                    this.mService.closeSurfaceTransaction("RemoteAnimationController#finished");
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl19 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    private void invokeAnimationCancelled() {
        try {
            this.mRemoteAnimationAdapter.getRunner().onAnimationCancelled();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failed to notify cancel", e);
        }
    }

    private class RemoteAnimationAdapterWrapper
    implements AnimationAdapter {
        private final AppWindowToken mAppWindowToken;
        private SurfaceControl mCapturedLeash;
        private SurfaceAnimator.OnAnimationFinishedCallback mCapturedFinishCallback;
        private final Point mPosition = new Point();
        private final Rect mStackBounds = new Rect();

        RemoteAnimationAdapterWrapper(AppWindowToken appWindowToken, Point position, Rect stackBounds) {
            this.mAppWindowToken = appWindowToken;
            this.mPosition.set(position.x, position.y);
            this.mStackBounds.set(stackBounds);
        }

        RemoteAnimationTarget createRemoteAppAnimation() {
            Task task = this.mAppWindowToken.getTask();
            WindowState mainWindow = this.mAppWindowToken.findMainWindow();
            if (task == null) {
                return null;
            }
            if (mainWindow == null) {
                return null;
            }
            return new RemoteAnimationTarget(task.mTaskId, this.getMode(), this.mCapturedLeash, !this.mAppWindowToken.fillsParent(), mainWindow.mWinAnimator.mLastClipRect, this.mAppWindowToken.getPrefixOrderIndex(), this.mPosition, this.mStackBounds, task.getWindowConfiguration());
        }

        private int getMode() {
            if (((RemoteAnimationController)RemoteAnimationController.this).mService.mOpeningApps.contains(this.mAppWindowToken)) {
                return 0;
            }
            return 1;
        }

        @Override
        public boolean getDetachWallpaper() {
            return false;
        }

        @Override
        public int getBackgroundColor() {
            return 0;
        }

        @Override
        public void startAnimation(SurfaceControl animationLeash, SurfaceControl.Transaction t, SurfaceAnimator.OnAnimationFinishedCallback finishCallback) {
            t.setLayer(animationLeash, this.mAppWindowToken.getPrefixOrderIndex());
            t.setPosition(animationLeash, this.mPosition.x, this.mPosition.y);
            RemoteAnimationController.this.mTmpRect.set(this.mStackBounds);
            RemoteAnimationController.this.mTmpRect.offsetTo(0, 0);
            t.setWindowCrop(animationLeash, RemoteAnimationController.this.mTmpRect);
            this.mCapturedLeash = animationLeash;
            this.mCapturedFinishCallback = finishCallback;
        }

        @Override
        public void onAnimationCancelled(SurfaceControl animationLeash) {
            RemoteAnimationController.this.mPendingAnimations.remove(this);
            if (RemoteAnimationController.this.mPendingAnimations.isEmpty()) {
                RemoteAnimationController.this.mHandler.removeCallbacks(RemoteAnimationController.this.mTimeoutRunnable);
                RemoteAnimationController.this.invokeAnimationCancelled();
            }
        }

        @Override
        public long getDurationHint() {
            return RemoteAnimationController.this.mRemoteAnimationAdapter.getDuration();
        }

        @Override
        public long getStatusBarTransitionsStartTime() {
            return SystemClock.uptimeMillis() + RemoteAnimationController.this.mRemoteAnimationAdapter.getStatusBarTransitionDelay();
        }
    }
}

